/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisBreakSymbolConstants;

public abstract class SGAxisBreakSymbol
extends SGDrawingElement
implements SGIAxisBreakSymbolConstants,
SGIDrawingElementConstants {
    protected SGTuple2f mLocation = new SGTuple2f();
    protected float mLength;
    protected float mInterval;
    protected float mLineWidth;
    protected float mAngle;
    protected float mDistortion;
    protected Color mLineColor;
    protected boolean mForHorizontalAxisFlag;

    public SGAxisBreakSymbol() {
    }

    protected SGAxisBreakSymbol(float f, float f2, float f3, float f4, boolean bl) {
        this.setLength(f);
        this.setInterval(f2);
        this.setDistortion(f3);
        this.setAngle(f4);
        this.setForHorizontalAxisFlag(bl);
    }

    public void dispose() {
        super.dispose();
        this.mLineColor = null;
        this.mLocation = null;
    }

    public SGTuple2f getLocation() {
        return this.mLocation;
    }

    public float getX() {
        return this.getLocation().x;
    }

    public float getY() {
        return this.getLocation().y;
    }

    public float getLength() {
        return this.mLength;
    }

    public float getInterval() {
        return this.mInterval;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public float getDistortion() {
        return this.mDistortion;
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public boolean isForHorizontalAxis() {
        return this.mForHorizontalAxisFlag;
    }

    public void setLocation(float f, float f2) {
        this.mLocation.setValues(f, f2);
    }

    public void setLocation(SGTuple2f sGTuple2f) {
        this.mLocation = sGTuple2f;
    }

    public void setLength(float f) {
        if (f < 0.0f) {
            new IllegalArgumentException("value<0.0f");
        }
        this.mLength = f;
    }

    public void setInterval(float f) {
        if (f < 0.0f) {
            new IllegalArgumentException("value<0.0f");
        }
        this.mInterval = f;
    }

    public void setLineWidth(float f) {
        if (f < 0.0f) {
            new IllegalArgumentException("value<0.0f");
        }
        this.mLineWidth = f;
    }

    public void setAngle(float f) {
        float f2 = f;
        if (f2 < -1.0471976f) {
            f2 = -1.0471976f;
        }
        if (1.0471976f < f2) {
            f2 = 1.0471976f;
        }
        this.mAngle = f2;
    }

    public void setDistortion(float f) {
        this.mDistortion = f;
    }

    public void setLineColor(Color color) {
        if (color == null) {
            new IllegalArgumentException("color==null");
        }
        this.mLineColor = color;
    }

    public void setForHorizontalAxisFlag(boolean bl) {
        this.mForHorizontalAxisFlag = bl;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGAxisBreakSymbol)) {
            return false;
        }
        super.setProperty(sGDrawingElement);
        SGAxisBreakSymbol sGAxisBreakSymbol = (SGAxisBreakSymbol)sGDrawingElement;
        this.setLength(sGAxisBreakSymbol.getLength());
        this.setInterval(sGAxisBreakSymbol.getInterval());
        this.setDistortion(sGAxisBreakSymbol.getDistortion());
        this.setAngle(sGAxisBreakSymbol.getAngle());
        this.setForHorizontalAxisFlag(sGAxisBreakSymbol.isForHorizontalAxis());
        this.setLineWidth(sGAxisBreakSymbol.getLineWidth());
        this.setLineColor(sGAxisBreakSymbol.getLineColor());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisBreakSymbolProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        AxisBreakSymbolProperties axisBreakSymbolProperties = (AxisBreakSymbolProperties)sGProperties;
        Float f = axisBreakSymbolProperties.getLength();
        if (f == null) {
            return false;
        }
        this.mLength = f.floatValue();
        Float f2 = axisBreakSymbolProperties.getInterval();
        if (f2 == null) {
            return false;
        }
        this.mInterval = f2.floatValue();
        Float f3 = axisBreakSymbolProperties.getDistortion();
        if (f3 == null) {
            return false;
        }
        this.mDistortion = f3.floatValue();
        Float f4 = axisBreakSymbolProperties.getAngle();
        if (f4 == null) {
            return false;
        }
        this.mAngle = f4.floatValue();
        Boolean bl = axisBreakSymbolProperties.isHorizontal();
        if (bl == null) {
            return false;
        }
        this.mForHorizontalAxisFlag = bl;
        Float f5 = axisBreakSymbolProperties.getLineWidth();
        if (f5 == null) {
            return false;
        }
        this.mLineWidth = f5.floatValue();
        Color color = axisBreakSymbolProperties.getLineColor();
        if (color == null) {
            return false;
        }
        this.mLineColor = color;
        return true;
    }

    public SGProperties getProperties() {
        AxisBreakSymbolProperties axisBreakSymbolProperties = new AxisBreakSymbolProperties();
        if (!this.getProperties(axisBreakSymbolProperties)) {
            return null;
        }
        return axisBreakSymbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisBreakSymbolProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        AxisBreakSymbolProperties axisBreakSymbolProperties = (AxisBreakSymbolProperties)sGProperties;
        axisBreakSymbolProperties.setLength(this.mLength);
        axisBreakSymbolProperties.setInterval(this.mInterval);
        axisBreakSymbolProperties.setDistortion(this.mDistortion);
        axisBreakSymbolProperties.setAngle(this.mAngle);
        axisBreakSymbolProperties.setHorizontal(this.mForHorizontalAxisFlag);
        axisBreakSymbolProperties.setLineWidth(this.mLineWidth);
        axisBreakSymbolProperties.setLineColor(this.mLineColor);
        return true;
    }

    public static class AxisBreakSymbolProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mX = 0.0f;
        private float mY = 0.0f;
        private float mLength = 0.0f;
        private float mInterval = 0.0f;
        private float mDistortion = 0.0f;
        private float mAngle = 0.0f;
        private float mLineWidth = 0.0f;
        private Color mLineColor = null;
        private boolean mHorizontal = true;

        public boolean equals(Object object) {
            if (!(object instanceof AxisBreakSymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            AxisBreakSymbolProperties axisBreakSymbolProperties = (AxisBreakSymbolProperties)object;
            if (this.mX != axisBreakSymbolProperties.mX) {
                return false;
            }
            if (this.mY != axisBreakSymbolProperties.mY) {
                return false;
            }
            if (this.mLength != axisBreakSymbolProperties.mLength) {
                return false;
            }
            if (this.mInterval != axisBreakSymbolProperties.mInterval) {
                return false;
            }
            if (this.mDistortion != axisBreakSymbolProperties.mDistortion) {
                return false;
            }
            if (this.mAngle != axisBreakSymbolProperties.mAngle) {
                return false;
            }
            if (this.mLineWidth != axisBreakSymbolProperties.mLineWidth) {
                return false;
            }
            if (!this.mLineColor.equals(axisBreakSymbolProperties.mLineColor)) {
                return false;
            }
            return this.mHorizontal == axisBreakSymbolProperties.mHorizontal;
        }

        public Float getX() {
            return new Float(this.mX);
        }

        public Float getY() {
            return new Float(this.mY);
        }

        public Float getLength() {
            return new Float(this.mLength);
        }

        public Float getInterval() {
            return new Float(this.mInterval);
        }

        public Float getDistortion() {
            return new Float(this.mDistortion);
        }

        public Float getAngle() {
            return new Float(this.mAngle);
        }

        public Boolean isHorizontal() {
            return this.mHorizontal;
        }

        public Float getLineWidth() {
            return new Float(this.mLineWidth);
        }

        public Color getLineColor() {
            return this.mLineColor;
        }

        public boolean setX(float f) {
            this.mX = f;
            return true;
        }

        public boolean setY(float f) {
            this.mY = f;
            return true;
        }

        public boolean setLength(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.mLength = f;
            return true;
        }

        public boolean setInterval(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.mInterval = f;
            return true;
        }

        public boolean setDistortion(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.mDistortion = f;
            return true;
        }

        public boolean setAngle(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.mAngle = f;
            return true;
        }

        public boolean setHorizontal(boolean bl) {
            this.mHorizontal = bl;
            return true;
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.mLineWidth = f;
            return true;
        }

        public boolean setLineColor(Color color) {
            String string;
            if (color == null) {
                new IllegalArgumentException("cl==null");
            }
            if ((string = SGUtilityText.getColorString(color)) == null) {
                new IllegalArgumentException("str==null");
            }
            this.mLineColor = color;
            return true;
        }
    }
}

