
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;

/**
 * Constants for drawing elements in figure.
 */
public interface SGIFigureDrawingElementConstants extends SGIDrawingElementConstants
{

	// line
	public static final float LINE_WIDTH_MIN = LINE_WIDTH_MIN_VALUE;
	public static final float LINE_WIDTH_MAX = LINE_WIDTH_MAX_VALUE;


	// symbol
	public static final float SYMBOL_SIZE_MIN = 0.05f/CM_POINT_RATIO;
	public static final float SYMBOL_SIZE_MAX = 2.0f/CM_POINT_RATIO;
	public static final float SYMBOL_LINE_WIDTH_MIN = LINE_WIDTH_MIN_VALUE;
	public static final float SYMBOL_LINE_WIDTH_MAX = LINE_WIDTH_MAX_VALUE;


	// bar
	public static final float BAR_WIDTH_MIN = 0.05f/CM_POINT_RATIO;
	public static final float BAR_WIDTH_MAX = 5.0f/CM_POINT_RATIO;
	public static final float BAR_EDGE_LINE_WIDTH_MIN = LINE_WIDTH_MIN_VALUE;
	public static final float BAR_EDGE_LINE_WIDTH_MAX = LINE_WIDTH_MAX_VALUE;


	// error bar
	public static final float ERROR_BAR_LINE_WIDTH_MIN = LINE_WIDTH_MIN_VALUE;
	public static final float ERROR_BAR_LINE_WIDTH_MAX = LINE_WIDTH_MAX_VALUE;
	public static final float ERROR_BAR_HEAD_SIZE_MIN = SYMBOL_SIZE_MIN;
	public static final float ERROR_BAR_HEAD_SIZE_MAX = SYMBOL_SIZE_MAX;


	// tick label
	public static final float TICK_LABEL_FONT_SIZE_MIN = FONT_SIZE_MIN_VALUE;
	public static final float TICK_LABEL_FONT_SIZE_MAX = FONT_SIZE_MAX_VALUE;


}

