
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;

/**
 *
 *
 */
public interface SGIAxisDialogObserver extends SGIPropertyDialogObserver
{

	/**
	 * 
	 * @return
	 */
	public String getFontName();



	/**
	 *
	 */
	public float getFontSize();



	/**
	 *
	 */
	public int getFontStyle();


	/**
	 * 
	 * @return
	 */
	public Color getStringColor();


	/**
	 * 
	 * @return
	 */
	public boolean isFrameLineVisible();


	/**
	 * 
	 * @return
	 */
	public float getFrameLineWidth();


	/**
	 * 
	 * @return
	 */
	public Color getFrameLineColor();


	/**
	 * 
	 * @return
	 */
	public float getAxisLineWidth();


	/**
	 * 
	 * @return
	 */
	public float getTickMarkWidth();


	/**
	 * 
	 * @return
	 */
	public float getTickMarkLength();


	/**
	 * 
	 * @return
	 */
	public Color getLineColor();


	/**
	 * 
	 * @param name
	 * @return
	 */
	public boolean setFontName( final String name );


	/**
	 * 
	 * @param style
	 * @return
	 */
	public boolean setFontStyle( final int style );


	/**
	 * 
	 * @param size
	 * @return
	 */
	public boolean setFontSize( final float size );


	/**
	 * 
	 * @param cl
	 */
	public boolean setStringColor( final Color cl );


	/**
	 * 
	 * @param b
	 */
	public boolean setFrameVisible( final boolean b );


	/**
	 * 
	 * @param width
	 */
	public boolean setFrameLineWidth( final float width );


	/**
	 * 
	 * @param cl
	 */
	public boolean setFrameLineColor( final Color cl );


	/**
	 * 
	 * @param width
	 * @return
	 */
	public boolean setAxisLineWidth( final float width );


	/**
	 * 
	 * @param width
	 * @return
	 */
	public boolean setTickMarkWidth( final float width );


	/**
	 * 
	 * @param len
	 * @return
	 */
	public boolean setTickMarkLength( final float len );


	/**
	 * 
	 * @param cl
	 * @return
	 */
	public boolean setLineColor( final Color cl );


	/**
	 * 
	 * @param config - configuration in plane
	 * @return
	 */
	public SGIAxisPanelObserver getAxisPanelObserverInPlane( final int config );


	/**
	 * Returns the axis configuration of the selected tab.
	 * @return
	 */
	public int getAxisConfigurationForSelectedTab();


}


