
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;

import org.w3c.dom.Element;


/**
 * 
 */
public abstract class SGElementGroupArrow extends SGElementGroupVXY
	implements SGIArrowConstants, SGIElementGroupConstants
{

	/**
	 *
	 */
	protected int mLineType;


	/**
	 * {100%̂Ƃ̐
	 */
	protected float mLineWidth;


	/**
	 * Ŝ̒ł̖K̒
	 */
	protected float mHeadSize;


	/**
	 * K̊Jpx
	 */
	protected float mHeadOpenAngle;


	/**
	 * K̕px
	 */
	protected float mHeadCloseAngle;


	/**
	 * 
	 */
	protected float mHeadLineWidth;


//	/**
//	 * 
//	 */
//	protected Color mHeadLineColor;


	/**
	 * 
	 */
	protected int mStartHeadType;


	/**
	 * 
	 */
	protected int mEndHeadType;


	/**
	 *
	 */
	public SGElementGroupArrow()
	{
		super();
	}



	/**
	 * 
	 */
	public int getLineType()
	{
		return this.mLineType;
	}
	
	
	/**
	 * 
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}


	/**
	 * 
	 */
	public float getHeadSize()
	{
		return this.mHeadSize;
	}


	/**
	 * 
	 */
	public float getHeadOpenAngle()
	{
		return this.mHeadOpenAngle;
	}


	/**
	 * 
	 */
	public float getHeadCloseAngle()
	{
		return this.mHeadCloseAngle;
	}


//	/**
//	 * 
//	 */
//	public float getHeadLineWidth()
//	{
//		return this.mHeadLineWidth;
//	}


//	/**
//	 * 
//	 */
//	public Color getHeadLineColor()
//	{
//		return this.mHeadLineColor;
//	}


	/**
	 * 
	 */
	public int getStartHeadType()
	{
		return this.mStartHeadType;
	}


	/**
	 * 
	 */
	public int getEndHeadType()
	{
		return this.mEndHeadType;
	}


	/**
	 * 
	 */
	public boolean setLineType( final int type )
	{
		this.mLineType = type;
		SGDrawingElement[] array = this.mDrawingElementArray;
		if( array!=null )
		{
			for( int ii=0; ii<array.length; ii++ )
			{
				SGDrawingElementArrow el = (SGDrawingElementArrow)array[ii];
				el.setLineType(type);
			}
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float width )
	{
		this.mLineWidth = width;
		SGDrawingElement[] array = this.mDrawingElementArray;
		if( array!=null )
		{
			for( int ii=0; ii<array.length; ii++ )
			{
				SGDrawingElementArrow el = (SGDrawingElementArrow)array[ii];
				el.setLineWidth(width);
			}
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setHeadSize( final float size )
	{
		this.mHeadSize = size;
		SGDrawingElement[] array = this.mDrawingElementArray;
		if( array!=null )
		{
			for( int ii=0; ii<array.length; ii++ )
			{
				SGDrawingElementArrow el = (SGDrawingElementArrow)array[ii];
				el.setHeadSize(mHeadSize);
			}
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setHeadOpenAngle( final float angle )
	{
		this.mHeadOpenAngle = angle;
		SGDrawingElement[] array = this.mDrawingElementArray;
		if( array!=null )
		{
			for( int ii=0; ii<array.length; ii++ )
			{
				SGDrawingElementArrow el = (SGDrawingElementArrow)array[ii];
				el.setHeadOpenAngle(angle);
			}
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setHeadCloseAngle( final float angle )
	{
		this.mHeadCloseAngle = angle;
		SGDrawingElement[] array = this.mDrawingElementArray;
		if( array!=null )
		{
			for( int ii=0; ii<array.length; ii++ )
			{
				SGDrawingElementArrow el = (SGDrawingElementArrow)array[ii];
				el.setHeadCloseAngle(angle);
			}
		}
		return true;
	}



//	/**
//	 * 
//	 */
//	public boolean setHeadLineWidth( final float width )
//	{
//		this.mHeadLineWidth = width;
//		SGDrawingElement[] array = this.mDrawingElementArray;
//		if( array!=null )
//		{
//			for( int ii=0; ii<array.length; ii++ )
//			{
//				SGDrawingElementArrow el = (SGDrawingElementArrow)array[ii];
//				el.setHeadLineWidth(width);
//			}
//		}
//		return true;
//	}



	/**
	 * 
	 */
	public boolean setColor( final Color cl )
	{
		super.setColor( cl );
		SGDrawingElement[] array = this.mDrawingElementArray;
		if( array!=null )
		{
			for( int ii=0; ii<array.length; ii++ )
			{
				SGDrawingElementArrow el = (SGDrawingElementArrow)array[ii];
				el.setColor( cl );
			}
		}
		return true;
	}



	/**
	 * 
	 */
//	public boolean setHeadLineColor( final Color color )
//	{
//		this.mHeadLineColor = color;
//		SGDrawingElement[] array = this.mDrawingElementArray;
//		if( array!=null )
//		{
//			for( int ii=0; ii<array.length; ii++ )
//			{
//				SGDrawingElementArrow el = (SGDrawingElementArrow)array[ii];
//				el.setHeadLineColor(color);
//			}
//		}
//		return true;
//	}


	/**
	 * 
	 */
	public boolean setStartHeadType( final int type )
	{
		this.mStartHeadType = type;
		SGDrawingElement[] array = this.mDrawingElementArray;
		if( array!=null )
		{
			for( int ii=0; ii<array.length; ii++ )
			{
				SGDrawingElementArrow el = (SGDrawingElementArrow)array[ii];
				el.setStartHeadType(type);
			}
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setEndHeadType( final int type )
	{
		this.mEndHeadType = type;
		SGDrawingElement[] array = this.mDrawingElementArray;
		if( array!=null )
		{
			for( int ii=0; ii<array.length; ii++ )
			{
				SGDrawingElementArrow el = (SGDrawingElementArrow)array[ii];
				el.setEndHeadType(type);
			}
		}
		return true;
	}


	/**
	 * 
	 */
	public SGDrawingElement getDrawingElement()
	{
		SGDrawingElementArrow arrow = new SGDrawingElementArrow2D();
		arrow.setVisible( this.isVisible() );
		arrow.setLineType( this.getLineType() );
		arrow.setLineWidth( this.getLineWidth() );
		arrow.setColor( this.getColorList() );
		arrow.setHeadSize( this.getHeadSize() );
		arrow.setHeadOpenAngle( this.getHeadOpenAngle() );
		arrow.setHeadCloseAngle( this.getHeadCloseAngle() );
//		arrow.setHeadLineWidth( this.getHeadLineWidth() );
//		arrow.setHeadLineColor( this.getHeadLineColor() );
		arrow.setStartHeadType( this.getStartHeadType() );
		arrow.setEndHeadType( this.getEndHeadType() );

		return arrow;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementArrow) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementArrow arrow = (SGDrawingElementArrow)element;

		this.setLineType( arrow.getLineType() );
		this.setLineWidth( arrow.getLineWidth() );
		this.setHeadSize( arrow.getHeadSize() );
		this.setHeadOpenAngle( arrow.getHeadOpenAngle() );
		this.setHeadCloseAngle( arrow.getHeadCloseAngle() );
//		this.setHeadLineWidth( arrow.getHeadLineWidth() );
//		this.setHeadLineColor( arrow.getHeadLineColor() );
		this.setStartHeadType( arrow.getStartHeadType() );
		this.setEndHeadType( arrow.getEndHeadType() );

		return true;
	}

	/**
	 * 
	 */
	protected int mCap = BasicStroke.CAP_BUTT;


	/**
	 * 
	 */
	protected int mJoin = BasicStroke.JOIN_ROUND;


	/**
	 * 
	 */
	protected float mMiterLimit = 1.0f;


	/**
	 * 
	 */
	protected float mDashPhase = 0.0f;


	/**
	 * 
	 */
	public boolean paintElement(
		final Graphics2D g2d, final Rectangle2D clipRect )
	{
		SGDrawingElement[] array = this.mDrawingElementArray;
		if( array==null )
		{
			return true;
		}


		for( int ii=0; ii<array.length; ii++ )
		{
			SGDrawingElementArrow2D el
				= (SGDrawingElementArrow2D)array[ii];

			if( el.isVisible() == false )
			{
				continue;
			}

			el.paint( g2d, clipRect );
		}

		return true;
	}



	/**
	 * 
	 */
	public static String getSymbolTypeName( final int type )
	{
//System.out.println("type="+type);

		String typeName = null;
		switch( type )
		{
			case SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE :
			{
				typeName = SYMBOL_NAME_CIRCLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_SQUARE :
			{
				typeName = SYMBOL_NAME_SQUARE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRIANGLE :
			{
				typeName = SYMBOL_NAME_TRIANGLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_CROSS :
			{
				typeName = SYMBOL_NAME_CROSS;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE :
			{
				typeName = SYMBOL_NAME_TRANSVERSE_LINE;
				break;
			}

			case SGDrawingElementArrow.SYMBOL_TYPE_ARROW_HEAD :
			{
				typeName = SYMBOL_NAME_ARROW_HEAD;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_VOID :
			{
				typeName = NO_SYMBOL;
				break;
			}

			default :
			{
				
			}
		}

		return typeName;
	}






	/**
	 * 
	 * @return
	 */
	public String getTagName()
	{
		return TAG_NAME_ARROW;
	}


	/**
	 * 
	 */
	public boolean writeProperty( final Element el )
	{
		String cm = SGUtilityNumber.cm;
		String pt = SGUtilityNumber.pt;
		String degree = SGUtilityNumber.degree;

		el.setAttribute( KEY_VISIBLE, Boolean.toString( this.mVisibleFlag ) );
		el.setAttribute( KEY_LINE_WIDTH, Float.toString( this.mLineWidth ) + pt );
		el.setAttribute( KEY_LINE_TYPE, Integer.toString( this.mLineType ) );
		el.setAttribute( KEY_HEAD_SIZE, Float.toString( this.mHeadSize*SGIConstants.CM_POINT_RATIO ) + cm );
		el.setAttribute( KEY_START_HEAD_TYPE, Integer.toString( this.mStartHeadType ) );
		el.setAttribute( KEY_END_HEAD_TYPE, Integer.toString( this.mEndHeadType ) );
//		el.setAttribute( KEY_HEAD_LINE_WIDTH, Float.toString( this.mHeadLineWidth ) + pt );
//		el.setAttribute( KEY_HEAD_LINE_COLOR, SGUtilityText.getColorString( this.mHeadLineColor ) );
		el.setAttribute( KEY_HEAD_OPEN_ANGLE, Double.toString( this.mHeadOpenAngle ) + degree );
		el.setAttribute( KEY_HEAD_CLOSE_ANGLE, Double.toString( this.mHeadCloseAngle ) + degree );
		el.setAttribute( KEY_COLOR_LIST, SGUtilityText.getColorListString( this.mColorList ) );
		return true;
	}


	
	/**
	 * 
	 * @param el
	 * @return
	 */
	public SGProperties readProperties( final Element el )
	{
		return null;
	}

	

	/**
	 * 
	 * @return
	 */
	protected boolean initDrawingElement( final int num )
	{
		SGDrawingElementArrow[] array = new SGDrawingElementArrow2D[num];
		for( int ii=0; ii<num; ii++ )
		{
			array[ii] = new SGDrawingElementArrow2D();
		}
		this.mDrawingElementArray = array;
		return true;
	}



	/**
	 * 
	 */
	public boolean setLocation(
		final SGTuple2f[] startArray,
		final SGTuple2f[] endArray )
	{

		if( startArray==null || endArray==null )
		{
			throw new IllegalArgumentException("startArray==null || endArray==null");
		}

		if( startArray.length != endArray.length )
		{
			throw new IllegalArgumentException("startArray.length != endArray.length");
		}

		if( startArray.length != this.mDrawingElementArray.length )
		{
			throw new IllegalArgumentException("startArray.length != this.mDrawingElementArray.length");
		}


		SGDrawingElementArrow2D[] array = (SGDrawingElementArrow2D[])this.mDrawingElementArray;
		for( int ii=0; ii<array.length; ii++ )
		{
			final boolean eff = !(
				startArray[ii].isInfinite() || startArray[ii].isNaN() ||
				endArray[ii].isInfinite() || endArray[ii].isNaN() );
			array[ii].setVisible( eff );
			if( eff )
			{
				array[ii].setTermPoints( startArray[ii], endArray[ii] );
			}
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean setPropertiesOfDrawingElements()
	{
		SGDrawingElementArrow2D[] array
			= (SGDrawingElementArrow2D[])this.mDrawingElementArray;
		for( int ii=0; ii<array.length; ii++ )
		{
			SGDrawingElementArrow2D arrow = array[ii];

			arrow.setMagnification( mMagnification );
			arrow.setColor( this.mColorList );

			arrow.setLineWidth( this.mLineWidth );
			arrow.setLineType( this.mLineType );

			arrow.setHeadSize( this.mHeadSize );
			arrow.setStartHeadType( this.mStartHeadType );
			arrow.setEndHeadType( this.mEndHeadType );
			arrow.setHeadOpenAngle( this.mHeadOpenAngle );
			arrow.setHeadCloseAngle( this.mHeadCloseAngle );
		}
		return true;
	}


	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		ArrowProperties p = new ArrowProperties();
		this.getProperties(p);

		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof ArrowProperties ) == false ) return false;

		super.getProperties(p);

		ArrowProperties ap = (ArrowProperties)p;
		ap.setLineWidth( this.getLineWidth() );
		ap.setLineType( this.getLineType() );
		ap.setHeadSize( this.getHeadSize() );
//		ap.setHeadLineWidth( this.getHeadLineWidth() );
//		ap.setHeadLineColor( this.getHeadLineColor() );
		ap.setStartHeadType( this.getStartHeadType() );
		ap.setEndHeadType( this.getEndHeadType() );
		ap.setHeadOpenAngle( this.getHeadOpenAngle() );
		ap.setHeadCloseAngle( this.getHeadCloseAngle() );

		return true;
	}


	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof ArrowProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		ArrowProperties ap = (ArrowProperties)p;

		final Float lineWidth = ap.getLineWidth();
		if( lineWidth==null )
		{
			return false;
		}
		this.setLineWidth( lineWidth.floatValue() );

		final Integer lineType = ap.getLineType();
		if( lineType==null )
		{
			return false;
		}
		this.setLineType( lineType.intValue() );

		final Float headSize = ap.getHeadSize();
		if( headSize==null )
		{
			return false;
		}
		this.setHeadSize( headSize.floatValue() );

//		final Float headLineWidth = ap.getHeadLineWidth();
//		if( headLineWidth==null )
//		{
//			return false;
//		}
//		this.setHeadLineWidth( headLineWidth.floatValue() );

//		Color headLineColor = ap.getHeadLineColor();
//		if( headLineColor==null )
//		{
//			return false;
//		}
//		this.setHeadLineColor( headLineColor );

		final Integer startHeadType = ap.getStartHeadType();
		if( startHeadType==null )
		{
			return false;
		}
		this.setStartHeadType( startHeadType.intValue() );

		final Integer endHeadType = ap.getEndHeadType();
		if( endHeadType==null )
		{
			return false;
		}
		this.setEndHeadType( endHeadType.intValue() );

		final Float headOpenAngle = ap.getHeadOpenAngle();
		if( headOpenAngle==null )
		{
			return false;
		}
		this.setHeadOpenAngle( headOpenAngle.floatValue() );

		final Float headCloseAngle = ap.getHeadCloseAngle();
		if( headCloseAngle==null )
		{
			return false;
		}
		this.setHeadCloseAngle( headCloseAngle.floatValue() );

		return true;
	}





	/**
	 * 
	 */
	public static class ArrowProperties extends ElementGroupProperties
	{

		private SGDrawingElementArrow.ArrowProperties mArrowProperties
			= new SGDrawingElementArrow.ArrowProperties();


		/**
		 * 
		 *
		 */
		public ArrowProperties()
		{
			super();
		}



		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{

			if( ( obj instanceof ArrowProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			ArrowProperties p = (ArrowProperties)obj;
			if( this.mArrowProperties.equals( p.mArrowProperties ) == false ) return false;

			return true;
		}



		public Float getLineWidth()
		{
			return this.mArrowProperties.getLineWidth();
		}

		public Integer getLineType()
		{
			return this.mArrowProperties.getLineType();
		}

		public Float getHeadLineWidth()
		{
			return this.mArrowProperties.getLineWidth();
		}

		public Float getHeadSize()
		{
			return this.mArrowProperties.getHeadSize();
		}

//		public Color getHeadLineColor()
//		{
//			return this.mArrowProperties.getHeadLineColor();
//		}

		public Integer getStartHeadType()
		{
			return this.mArrowProperties.getStartHeadType();
		}

		public Integer getEndHeadType()
		{
			return this.mArrowProperties.getEndHeadType();
		}

		public Float getHeadOpenAngle()
		{
			return this.mArrowProperties.getHeadOpenAngle();
		}

		public Float getHeadCloseAngle()
		{
			return this.mArrowProperties.getHeadCloseAngle();
		}


		public void setLineWidth( final float width )
		{
			this.mArrowProperties.setLineWidth( width );
		}

		public void setLineType( final int num )
		{
			this.mArrowProperties.setLineType( num );
		}

//		public void setHeadLineWidth( final float width )
//		{
//			this.mArrowProperties.setHeadLineWidth( width );
//		}

		public void setStartHeadType( final int num )
		{
			this.mArrowProperties.setStartHeadType( num );
		}

		public void setEndHeadType( final int num )
		{
			this.mArrowProperties.setEndHeadType( num );
		}

		public void setHeadSize( final float size )
		{
			this.mArrowProperties.setHeadSize( size );
		}

//		public void setHeadLineColor( final Color cl )
//		{
//			this.mArrowProperties.setHeadLineColor( cl );
//		}

		public void setHeadOpenAngle( final float value )
		{
			this.mArrowProperties.setHeadOpenAngle( value );
		}

		public void setHeadCloseAngle( final float value )
		{
			this.mArrowProperties.setHeadCloseAngle( value );
		}



	}



}
