
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;

/**
 *
 *
 */
public abstract class SGXYFigure extends SGFigure
	implements SGIXYFigureDialogObserver
{
	/**
	 * 
	 */
	public SGXYFigure()
	{
		super();
	}

	/**
	 * @param wnd
	 */
	public SGXYFigure(SGDrawingWindow wnd)
	{
		super(wnd);
	}


	/**
	 * 
	 * @return
	 */
	public SGIGridElement getGridElement()
	{
		return (SGIGridElement)this.getIFigureElement( SGIGridElement.class );
	}


	/**
	 * 
	 */
	public int getXAxisConfiguration()
	{
		return this.getGridElement().getXAxisConfiguration();
	}


	/**
	 * 
	 */
	public int getYAxisConfiguration()
	{
		return this.getGridElement().getYAxisConfiguration();
	}


	/**
	 * 
	 */
	public void setXAxisConfiguration( final int config )
	{
		this.getGridElement().setXAxisConfiguration( config );
	}

	/**
	 * 
	 */
	public void setYAxisConfiguration( final int config )
	{
		this.getGridElement().setYAxisConfiguration( config );
	}


	public boolean setGridVisible( final boolean b )
	{
		return this.getGridElement().setGridVisible(b);
	}

	public boolean setAutoRangeFlag( final boolean b )
	{
		return this.getGridElement().setAutoRangeFlag(b);
	}

	public boolean setStepValueX( final double value )
	{
		return this.getGridElement().setStepValueX(value);
	}

	public boolean setStepValueY( final double value )
	{
		return this.getGridElement().setStepValueY(value);
	}

	public boolean setBaselineValueX( final double value )
	{
		return this.getGridElement().setBaselineValueX(value);
	}

	public boolean setBaselineValueY( final double value )
	{
		return this.getGridElement().setBaselineValueY(value);
	}
	
	public boolean setLineWidth( final float width )
	{
		return this.getGridElement().setLineWidth(width);
	}

	public boolean setLineType( final int type )
	{
		return this.getGridElement().setLineType(type);
	}

	public boolean setColor( final Color cl )
	{
		return this.getGridElement().setColor(cl);
	}


	public boolean isGridVisible()
	{
		return this.getGridElement().isGridVisible();
	}
	
	public boolean isAutoRange()
	{
		return this.getGridElement().isAutoRange();
	}

	public double getStepValueX()
	{
		return this.getGridElement().getStepValueX();
	}

	public double getStepValueY()
	{
		return this.getGridElement().getStepValueY();
	}

	public double getBaselineValueX()
	{
		return this.getGridElement().getBaselineValueX();
	}
	public double getBaselineValueY()
	{
		return this.getGridElement().getBaselineValueY();
	}

	public float getLineWidth()
	{
		return this.getGridElement().getLineWidth();
	}

	public int getLineType()
	{
		return this.getGridElement().getLineType();
	}

	public Color getColor()
	{
		return this.getGridElement().getColor();
	}


	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		XYFigureProperties p = new XYFigureProperties();
		if( this.getProperties(p) == false ) return null;
		return p;
	}


	/**
	 * 
	 * @param p
	 * @return
	 */
	public boolean getProperties( SGProperties p )
	{
		if( ( p instanceof XYFigureProperties ) == false ) return false;

		if( super.getProperties(p) == false ) return false;

		XYFigureProperties fp = (XYFigureProperties)p;

		SGIGridElement el = this.getGridElement();
		fp.mXAxisConfiguration = el.getXAxisConfiguration();
		fp.mYAxisConfiguration = el.getYAxisConfiguration();
		fp.mBaselineValueX = el.getBaselineValueX();
		fp.mBaselineValueY = el.getBaselineValueY();
		fp.mStepValueX = el.getStepValueX();
		fp.mStepValueY = el.getStepValueY();
		fp.mVisibleFlag = el.isGridVisible();
		fp.mAutoRangeFlag = el.isAutoRange();
		fp.mLineWidth = el.getLineWidth();
		fp.mLineType = el.getLineType();
		fp.mColor = el.getColor();

		return true;
	}



	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof XYFigureProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		XYFigureProperties fp = (XYFigureProperties)p;

		SGIGridElement el = this.getGridElement();
		el.setXAxisConfiguration( fp.mXAxisConfiguration );
		el.setYAxisConfiguration( fp.mYAxisConfiguration );
		el.setBaselineValueX( fp.mBaselineValueX );
		el.setBaselineValueY( fp.mBaselineValueY );
		el.setStepValueX( fp.mStepValueX );
		el.setStepValueY( fp.mStepValueY );
		el.setGridVisible( fp.mVisibleFlag );
		el.setAutoRangeFlag( fp.mAutoRangeFlag );
		el.setLineWidth( fp.mLineWidth );
		el.setLineType( fp.mLineType );
		el.setColor( fp.mColor );

		return true;
	}



	/**
	 * 
	 * @author kuromaru
	 *
	 * ̐ꂽRg̑}ev[gύX邽
	 * EBhE > ݒ > Java > R[h > R[hƃRg
	 */
	public static class XYFigureProperties extends FigureProperties
	{
		private int mXAxisConfiguration;
		private int mYAxisConfiguration;
		private double mStepValueX;
		private double mBaselineValueX;
		private double mStepValueY;
		private double mBaselineValueY;
		private boolean mVisibleFlag;
		private boolean mAutoRangeFlag;
		private float mLineWidth;
		private int mLineType;
		private Color mColor;

		/**
		 * 
		 *
		 */
		public XYFigureProperties()
		{
			super();
		}

		/**
		 * 
		 */
		public boolean equals( Object obj )
		{
			if( ( obj instanceof XYFigureProperties ) == false ) return false;
			
			if( super.equals(obj) == false ) return false;
			
			XYFigureProperties p = (XYFigureProperties)obj;

			if( this.mXAxisConfiguration!=p.mXAxisConfiguration ) return false;
			if( this.mYAxisConfiguration!=p.mYAxisConfiguration ) return false;
			if( this.mBaselineValueX!=p.mBaselineValueX ) return false;
			if( this.mStepValueX!=p.mStepValueX ) return false;
			if( this.mBaselineValueY!=p.mBaselineValueY ) return false;
			if( this.mStepValueY!=p.mStepValueY ) return false;
			if( this.mVisibleFlag!=p.mVisibleFlag ) return false;
			if( this.mAutoRangeFlag!=p.mAutoRangeFlag ) return false;
			if( this.mLineWidth!=p.mLineWidth ) return false;
			if( this.mLineType!=p.mLineType ) return false;
			if( this.mColor.equals(p.mColor) == false ) return false;
			
			return true;
		}


	}


}
