
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;


/**
 *
 */
public abstract class SGDrawingElementSymbol extends SGDrawingElement
	implements SGISymbolConstants, SGIDrawingElementConstants
{

	/**
	 * 
	 */
	protected SGTuple2f mLocation = new SGTuple2f();
	
	
	/**
	 * 
	 */
	protected float mSize;


	/**
	 * 
	 */
	protected int mType;


	/**
	 * 
	 */
	protected float mAngle;


	/**
	 * 
	 */
	protected Color mLineColor;


	/**
	 * 
	 */
	protected float mLineWidth;




	/**
	 * 
	 */
	public SGDrawingElementSymbol()
	{
		super();
	}


	/**
	 * 
	 * @param x
	 * @return
	 */
	public boolean setX( final float x )
	{
		this.mLocation.setX(x);
		return true;
	}


	/**
	 * 
	 * @param y
	 * @return
	 */
	public boolean setY( final float y )
	{
		this.mLocation.setY(y);
		return true;
	}


	/**
	 * 
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.mLocation.setValues(x,y);
		return true;
	}


	/**
	 * 
	 */
	public boolean setLocation( final SGTuple2f point )
	{
		this.mLocation = point;
		return true;
	}


	/**
	 * 
	 */
	public boolean setSize( final float size )
	{
		this.mSize = size;
		return true;
	}


	/**
	 * 
	 */
	public boolean setType( final int type )
	{
		this.mType = type;
		return true;
	}


	/**
	 * 
	 */
	public boolean setAngle( final float angle )
	{
		this.mAngle = angle;
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineColor( final Color color )
	{
		this.mLineColor = color;
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float lineWidth )
	{
		this.mLineWidth = lineWidth;
		return true;
	}


	/**
	 * 
	 */
	public SGTuple2f getLocation()
	{
		return new SGTuple2f( this.mLocation );
	}

	/**
	 * 
	 */
	public float getX()
	{
		return this.mLocation.x;
	}


	/**
	 * 
	 */
	public float getY()
	{
		return this.mLocation.y;
	}



	/**
	 * 
	 */
	public float getSize()
	{
		return this.mSize;
	}


	/**
	 * 
	 */
	public int getType()
	{
		return this.mType;
	}


	/**
	 * 
	 */
	public float getAngle()
	{
		return this.mAngle;
	}


	/**
	 * 
	 */
	public Color getLineColor()
	{
		return this.mLineColor;
	}


	/**
	 * 
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}



	/**
	 * 
	 */
	public static Integer getSymbolTypeFromName( final String name )
	{

		if( name==null )
		{
			return null;
		}
		
		int type;
		if( name.equals( SGDrawingElementSymbol.SYMBOL_NAME_VOID ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_VOID;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_NAME_CIRCLE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_NAME_SQUARE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_SQUARE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_NAME_DIAMOND ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_DIAMOND;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_NAME_TRIANGLE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_TRIANGLE;
		}
		else if(
			name.equals( SGDrawingElementSymbol.SYMBOL_NAME_INVERTED_TRIANGLE ) |
			name.equals( SGDrawingElementSymbol.SYMBOL_NAME_INVERTED_TRIANGLE_OLD )
			// to maintain downward compatibility with the old releases
		)
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_INVERTEDTRIANGLE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_NAME_CROSS ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_CROSS;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_NAME_PLUS ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_PLUS;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_NAME_TRANSVERSE_LINE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE;
		}
		else
		{
			return null;
		}

		return new Integer(type);
	}



	/**
	 * 
	 */
	public static String getSymbolTypeName( final int type )
	{
		
		String name = null;
		switch( type )
		{
			case SGDrawingElementSymbol.SYMBOL_TYPE_VOID :
			{
				name = SGDrawingElementSymbol.SYMBOL_NAME_VOID;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE :
			{
				name = SGDrawingElementSymbol.SYMBOL_NAME_CIRCLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_SQUARE :
			{
				name = SGDrawingElementSymbol.SYMBOL_NAME_SQUARE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_DIAMOND :
			{
				name = SGDrawingElementSymbol.SYMBOL_NAME_DIAMOND;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRIANGLE :
			{
				name = SGDrawingElementSymbol.SYMBOL_NAME_TRIANGLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_INVERTEDTRIANGLE :
			{
				name = SGDrawingElementSymbol.SYMBOL_NAME_INVERTED_TRIANGLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_CROSS :
			{
				name = SGDrawingElementSymbol.SYMBOL_NAME_CROSS;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_PLUS :
			{
				name = SGDrawingElementSymbol.SYMBOL_NAME_PLUS;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE :
			{
				name = SGDrawingElementSymbol.SYMBOL_NAME_TRANSVERSE_LINE;
				break;
			}

			default :
			{
				
			}
		}
		
		return name;
	}



	/**
	 * 
	 * @return
	 */
	public static boolean isLineTypeSymbol( final int type )
	{
		return ( (type==SYMBOL_TYPE_CROSS) | (type==SYMBOL_TYPE_PLUS) | (type==SYMBOL_TYPE_TRANSVERSELINE) );
	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		SymbolProperties p = new SymbolProperties();
		this.getProperties(p);
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof SymbolProperties ) == false ) return false;

		super.getProperties(p);

		SymbolProperties sp = (SymbolProperties)p;
		sp.setSize( this.getSize() );
		sp.setSymbolType( this.getType() );
		sp.setLineWidth( this.getLineWidth() );
		sp.setLineColor( this.getLineColor() );

		return true;
	}




	/**
	 * 
	 */
	public static class SymbolProperties extends DrawingElementProperties
	{

		private int mType = -1;
		private float mSize = 0.0f;
		private float mLineWidth = 0.0f;
		private Color mLineColor = null;


		/**
		 * 
		 *
		 */
		public SymbolProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof SymbolProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			SymbolProperties p = (SymbolProperties)obj;
			if( p.mType!=this.mType ) return false;
			if( p.mSize!=this.mSize ) return false;
			if( p.mLineWidth!=this.mLineWidth ) return false;
			if( p.mLineColor.equals(this.mLineColor) == false ) return false;

			return true;
		}


		public Float getSize()
		{
			return new Float( this.mSize );
		}

		public Integer getSymbolType()
		{
			return new Integer( this.mType );
		}

		public Float getLineWidth()
		{
			return new Float( this.mLineWidth );
		}

		public Color getLineColor()
		{
			return this.mLineColor;
		}


		public boolean setSize( final float size )
		{
			if( size<0.0f )
			{
				return false;
			}
			this.mSize = size;
			return true;
		}


		public boolean setSymbolType( final int type )
		{
			this.mType = type;
			return true;
		}


		public boolean setLineWidth( final float width )
		{
			if( width<0.0f )
			{
				return false;
			}
			this.mLineWidth = width;
			return true;
		}

		public boolean setLineColor( final Color cl )
		{
			if( cl==null )
			{
				return false;
			}
			this.mLineColor = cl;
			return true;
		}

	}


}

