/*
 * SGDataAdditionWizardFrame.java
 *
 * Created on 2004/06/18, 14:44
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;

import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataTypeConstants;


/**
 *
 * @author  kuromaru
 */
public class SGXYDataTypeSelectionWizardDialog extends SGWizardDialog
	implements SGIApplicationTextConstants
{
	
	/**
	 * 
	 */
	public static final String TITLE = "Data Type";
    

	/**
	 * 
	 */
	public SGXYDataTypeSelectionWizardDialog()
	{
		super();
		this.initComponents();
		this.initProperty();
	}

    
	/**
	 * 
	 * @param title
	 */
	public SGXYDataTypeSelectionWizardDialog( final Frame owner, final boolean modal )
	{
		super(owner,modal);
		this.initComponents();
		this.initProperty();
	}

   
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mScalarXYRadioButton = new javax.swing.JRadioButton();
        mMultipleXYRadioButton = new javax.swing.JRadioButton();
        mSamplingXYRadioButton = new javax.swing.JRadioButton();
        mSamplingRateField = new javax.swing.JTextField();
        mVectorXYRadioButton = new javax.swing.JRadioButton();
        mSamplingUnitLabel = new javax.swing.JLabel();
        mDateXYRadioButton = new javax.swing.JRadioButton();
        mButtonPanel = new javax.swing.JPanel();
        mPreviousButton = new javax.swing.JButton();
        mNextButton = new javax.swing.JButton();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.TitledBorder(null, "Select the Data Type", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12)));
        mScalarXYRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mScalarXYRadioButton.setText("Scalar-XY");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 0);
        mPanel.add(mScalarXYRadioButton, gridBagConstraints);

        mMultipleXYRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mMultipleXYRadioButton.setText("Multiple-XY");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mPanel.add(mMultipleXYRadioButton, gridBagConstraints);

        mSamplingXYRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mSamplingXYRadioButton.setText("Sampling-XY");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mPanel.add(mSamplingXYRadioButton, gridBagConstraints);

        mSamplingRateField.setColumns(3);
        mSamplingRateField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        mPanel.add(mSamplingRateField, gridBagConstraints);

        mVectorXYRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mVectorXYRadioButton.setText("Vector-XY");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        mPanel.add(mVectorXYRadioButton, gridBagConstraints);

        mSamplingUnitLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSamplingUnitLabel.setText("Hz");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 10);
        mPanel.add(mSamplingUnitLabel, gridBagConstraints);

        mDateXYRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mDateXYRadioButton.setText("Date-XY");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mPanel.add(mDateXYRadioButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        getContentPane().add(mPanel, gridBagConstraints);

        mPreviousButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviousButton.setText("<Prev");
        mButtonPanel.add(mPreviousButton);

        mNextButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    protected javax.swing.JButton mCancelButton;
    private javax.swing.JRadioButton mDateXYRadioButton;
    private javax.swing.JRadioButton mMultipleXYRadioButton;
    protected javax.swing.JButton mNextButton;
    protected javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    protected javax.swing.JButton mPreviousButton;
    private javax.swing.JTextField mSamplingRateField;
    private javax.swing.JLabel mSamplingUnitLabel;
    private javax.swing.JRadioButton mSamplingXYRadioButton;
    private javax.swing.JRadioButton mScalarXYRadioButton;
    private javax.swing.JRadioButton mVectorXYRadioButton;
    // ϐ錾̏I//GEN-END:variables


	/**
	 * Map of the data types and buttons.
	 */
	private final Map mDataTypeButtonMap = new HashMap();


	/**
	 * Initialization method.
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGXYDataTypeSelectionWizardDialog.TITLE );

		// create a button-group
		ButtonGroup group = new ButtonGroup();
		group.add( this.mScalarXYRadioButton );
		group.add( this.mDateXYRadioButton );
		group.add( this.mVectorXYRadioButton );
		group.add( this.mMultipleXYRadioButton );
		group.add( this.mSamplingXYRadioButton );


		// initialize components
		this.mScalarXYRadioButton.setSelected(true);
		this.mSamplingRateField.setEnabled(false);
		this.mSamplingRateField.setText( Double.toString(1.0) );


		// add itself as an action lister
		this.mScalarXYRadioButton.addActionListener(this);
		this.mVectorXYRadioButton.addActionListener(this);
		this.mDateXYRadioButton.addActionListener(this);
		this.mMultipleXYRadioButton.addActionListener(this);
		this.mSamplingXYRadioButton.addActionListener(this);


		// initialize the map
		this.mDataTypeButtonMap.put( SGDataTypeConstants.SXY_DATA, this.mScalarXYRadioButton );
		this.mDataTypeButtonMap.put( SGDataTypeConstants.VXY_DATA, this.mVectorXYRadioButton );
		this.mDataTypeButtonMap.put( SGDataTypeConstants.SXY_MULTIPLE_DATA, this.mMultipleXYRadioButton );
		this.mDataTypeButtonMap.put( SGDataTypeConstants.SXY_SAMPLING_DATA, this.mSamplingXYRadioButton );
		this.mDataTypeButtonMap.put( SGDataTypeConstants.SXY_DATE_DATA, this.mDateXYRadioButton );


// hide a button temporarily
this.mVectorXYRadioButton.setVisible(false);
this.pack();


		// add as an action event listener
		this.getPreviousButton().addActionListener(this);
		this.getNextButton().addActionListener(this);
		this.getOKButton().addActionListener(this);
		this.getCancelButton().addActionListener(this);

		this.mSamplingRateField.addActionListener(this);

		return true;
	}


	// an array of data types
	private static final String[] DATA_TYPE_ARRAY = {
		SGDataTypeConstants.SXY_DATA,
//		SGDataTypeConstants.VXY_DATA,
		SGDataTypeConstants.SXY_MULTIPLE_DATA,
		SGDataTypeConstants.SXY_SAMPLING_DATA,
		SGDataTypeConstants.SXY_DATE_DATA
	};


	/**
	 * Returns the selected data type.
	 */
	public String getSelectedDataType()
	{
		String str = null;

		Map map = this.mDataTypeButtonMap;
		Iterator itr = map.keySet().iterator();
		while( itr.hasNext() )
		{
			Object key = itr.next();
			JRadioButton btn = (JRadioButton)map.get(key);
			if( btn.isSelected() )
			{
				str = (String)key;
				break;
			}
		}

		return str;

	}


	/**
	 * Set available radio buttons.
	 * @param list - a list of available data types.
	 * @return
	 */
	public boolean setEffectiveDataType( final ArrayList list )
	{
		if( list==null )
		{
			return false;
		}

		if( list.size()==0 )
		{
			return false;
		}

		final Map map = this.mDataTypeButtonMap;
		final String[] strArray = DATA_TYPE_ARRAY;

		// set available buttons
		for( int ii=0; ii<strArray.length; ii++ )
		{
			String key = strArray[ii];
			final JRadioButton btn = (JRadioButton)map.get(key);
			final boolean enable = list.contains(key);
			btn.setEnabled( enable );
		}

		// avoid the selection of unavailable button
		for( int ii=0; ii<strArray.length; ii++ )
		{
			String key = strArray[ii];
			final JRadioButton btn = (JRadioButton)map.get(key);
			if( btn.isEnabled() )
			{
				btn.setSelected(true);
				break;
			}
		}
		
		return true;
	}


	/**
	 * Returns the sampling rate.
	 * @return Sampling rate. If input value is illegal, returns null.
	 */
	public Double getSamplingRate()
	{
		String str = this.mSamplingRateField.getText();
		return SGUtilityText.getDouble( str );
	}


	/**
	 * Overrode to set availability of the text field.
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();
		if( source instanceof JRadioButton )
		{
			this.mSamplingRateField.setEnabled( this.mSamplingXYRadioButton.isSelected() );
		}
		
		if( source.equals( this.mSamplingRateField ) )
		{
			this.onOK();
		}
	}



	/**
	 * Overrode to check validity of the input value.
	 */
	protected boolean onOK()
	{
		// check the sampling rate
		if( this.mSamplingXYRadioButton.isSelected() )
		{
			final Double d = this.getSamplingRate();
			if( d==null )
			{
				SGUtility.showMessageDialog(
					this,
					MSG_INVALID_INPUT_VALUE,
					TITLE_ERROR,
					JOptionPane.ERROR_MESSAGE
				);
				return false;
			}
		}

		return super.onOK();
	}


	/**
	 * Overrode to set availability of the text field.
	 */
	public void setVisible( final boolean b )
	{
		// update the text field
		this.mSamplingRateField.setEnabled( this.mSamplingXYRadioButton.isSelected() );
		
		super.setVisible(b);
	}


	protected JButton getPreviousButton()
	{
		return this.mPreviousButton;
	}


	protected JButton getNextButton()
	{
		return this.mNextButton;
	}


	protected JButton getOKButton()
	{
		return this.mOKButton;
	}
	
	
	protected JButton getCancelButton()
	{
		return this.mCancelButton;
	}


}
