/*
 * 쐬: 2004/11/08
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;

import javax.swing.JScrollBar;
import javax.swing.JViewport;

import jp.riken.brain.ni.samuraigraph.base.SGDialog;


/**
 * @author kuromaru
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class SGScrollPaneDialog extends SGDialog implements AdjustmentListener
{

	/** Creates new form SGUpgradeConfirmDialog */
	public SGScrollPaneDialog()
	{
		super();
		initComponents();
		this.initProperty();
	}


	/** Creates new form SGUpgradeConfirmDialog */
	public SGScrollPaneDialog(java.awt.Frame parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
		this.initProperty();
	}

	/** Creates new form SGUpgradeConfirmDialog */
	public SGScrollPaneDialog(java.awt.Dialog parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
		this.initProperty();
	}


	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mMessageEditorPane = new javax.swing.JEditorPane();
        mDetailScrollPane = new javax.swing.JScrollPane();
        mDetailEditorPane = new javax.swing.JEditorPane();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mPanel.setLayout(new java.awt.GridBagLayout());

        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(9, 6, 4, 6);
        mPanel.add(mButtonPanel, gridBagConstraints);

        mMessageEditorPane.setEditable(false);
        mMessageEditorPane.setPreferredSize(new java.awt.Dimension(304, 48));
        mMessageEditorPane.setOpaque(false);
        mPanel.add(mMessageEditorPane, new java.awt.GridBagConstraints());

        mDetailScrollPane.setPreferredSize(new java.awt.Dimension(304, 104));
        mDetailEditorPane.setEditable(false);
        mDetailScrollPane.setViewportView(mDetailEditorPane);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        mPanel.add(mDetailScrollPane, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    protected javax.swing.JPanel mButtonPanel;
    protected javax.swing.JButton mCancelButton;
    protected javax.swing.JScrollPane mDetailScrollPane;
    protected javax.swing.JEditorPane mDetailEditorPane;
    protected javax.swing.JEditorPane mMessageEditorPane;
    protected javax.swing.JButton mOKButton;
    protected javax.swing.JPanel mPanel;
    // ϐ錾̏I//GEN-END:variables



	private boolean mCanceledFlag = false;



	private boolean initProperty()
	{
//		this.mDetailEditorPane.setContentType("text/html");

		//
		this.mOKButton.addActionListener(this);
		this.mCancelButton.addActionListener(this);

		this.getHorizontalScrollBar().addAdjustmentListener(this);
		this.getVerticalScrollBar().addAdjustmentListener(this);

		return true;
	}



	/**
	 * 
	 */
	public boolean setMessage( String msg )
	{
		this.mMessageEditorPane.setText(msg);
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public String getMessage()
	{
		return this.mMessageEditorPane.getText();
	}


	/**
	 * 
	 * @param t
	 * @return
	 */
	public boolean setDetailText( String t )
	{
		this.mDetailEditorPane.setText(t);
		return true;
	}


	/**
	 * 
	 * @param url
	 * @return
	 */
	public boolean setPage( URL url )
	{
		try
		{
			this.mDetailEditorPane.setPage( url );
		}
		catch( IOException ex )
		{
			return false;
		}
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public String getDetailText()
	{
		return this.mDetailEditorPane.getText();
	}


	/**
	 * 
	 * @return
	 */
	public JScrollBar getVerticalScrollBar()
	{
		return this.mDetailScrollPane.getVerticalScrollBar();
	}


	/**
	 * 
	 * @return
	 */
	public JScrollBar getHorizontalScrollBar()
	{
		return this.mDetailScrollPane.getHorizontalScrollBar();
	}


	/**
	 * 
	 * @return
	 */
	public JViewport getViewport()
	{
		return this.mDetailScrollPane.getViewport();
	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		Object source = e.getSource();
		String command = e.getActionCommand();
		
		if( command.equals( SGDialog.OK_BUTTON_TEXT ) )
		{
			this.onOK();
		}
		else if( command.equals( SGDialog.CANCEL_BUTTON_TEXT ) )
		{
			this.onCanceled();
		}
	}


	/**
	 * 
	 */
	public void windowClosing(final WindowEvent e)
	{
		super.windowClosing(e);
		this.onCanceled();
	}


	/**
	 * 
	 */
	protected boolean onOK()
	{
		this.mCanceledFlag = false;
		this.setVisible(false);
		this.notifyToListener( OK_BUTTON_TEXT );
		return true;
	}


	/**
	 * 
	 */
	protected boolean onCanceled()
	{
		this.mCanceledFlag = true;
		this.setVisible(false);
		this.notifyToListener( CANCEL_BUTTON_TEXT );
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean isCanceled()
	{
		return this.mCanceledFlag;
	}


	/**
	 * 
	 * @param e
	 */
	public void adjustmentValueChanged( AdjustmentEvent e )
	{
//		Point pos = this.getViewport().getViewPosition();
//		if( this.mTempFlag==false & pos.y!=0 )
//		{
//			this.getViewport().setViewPosition( new Point() );
//			this.mTempFlag = true;
//		}

//		if( this.mTempFlag )
//		{
//			JViewport vp = this.getViewport();
//			vp.setViewPosition( new Point() );
//			this.mTempFlag = false;
//		}
	}

//	private boolean mTempFlag = false;


	/**
	 * 
	 */
//	public void setVisible( boolean b )
//	{
//		this.mTempFlag = true;
//
//		super.setVisible(b);
//	}


}

