package org.freehep.jaco.rtti.cpp;

import java.util.Vector;

/**
 * Temporary storage for a type
 *
 * @author Mark Donszelmann
 * @version $Id: Type.java,v 1.1.1.1 2004/05/31 05:08:51 kuromaru Exp $
 */

class Type
{
    String name;
    boolean isPrimitive = false;
    boolean isReference = false;
    int dimension = 0;

    // for the typedef
    int pointer = 0;

    Type(String name) {
        this.name = name;
    }

    Type() {
        this.name = "int";
        this.isPrimitive = true;
    }

    public String toString() {
        return ((isPrimitive) ? "#" : "") + name + " " + dimension;
    }
}
