/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSingleAxisSelectionPanel;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGITimingLineDialogObserver;

public class SGTimingLineDialog
extends SGPropertyDialog {
    public static final String TITLE = "Timing Line Properties";
    private SGSingleAxisSelectionPanel mAxisPanel;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mColorLabel;
    private JLabel mEndValueLabel;
    private SGTextField mEndValueTextField;
    private JLabel mLeftSpaceLabel;
    private SGColorSelectionButton mLineColorButton;
    private JComboBox mLineTypeComboBox;
    private JLabel mLineTypeLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mStartValueLabel;
    private SGTextField mStartValueTextField;
    private JPanel mTimingLinePanel;
    private JLabel mTimingValueLabel;
    private SGTextField mTimingValueTextField;

    public SGTimingLineDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mStartValueLabel = new JLabel();
        this.mStartValueTextField = new SGTextField();
        this.mEndValueLabel = new JLabel();
        this.mEndValueTextField = new SGTextField();
        this.mAxisPanel = new SGSingleAxisSelectionPanel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mTimingLinePanel = new JPanel();
        this.mTimingValueLabel = new JLabel();
        this.mLineTypeLabel = new JLabel();
        this.mLineWidthLabel = new JLabel();
        this.mColorLabel = new JLabel();
        this.mTimingValueTextField = new SGTextField();
        this.mLineWidthSpinner = new SGSpinner();
        this.mLineColorButton = new SGColorSelectionButton();
        this.mLineTypeComboBox = new JComboBox();
        this.mRightSpaceLabel = new JLabel();
        this.mLeftSpaceLabel = new JLabel();
        this.mStartValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mStartValueLabel.setText("Start");
        this.mStartValueTextField.setColumns(6);
        this.mStartValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mEndValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mEndValueLabel.setText("End");
        this.mEndValueTextField.setColumns(6);
        this.mEndValueTextField.setFont(new Font("Dialog", 0, 12));
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.getContentPane().add((Component)this.mAxisPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mTimingLinePanel.setLayout(new GridBagLayout());
        this.mTimingLinePanel.setBorder(new BevelBorder(0));
        this.mTimingLinePanel.setFont(new Font("MS Sans Serif", 0, 10));
        this.mTimingValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mTimingValueLabel.setText("Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTimingLinePanel.add((Component)this.mTimingValueLabel, gridBagConstraints);
        this.mLineTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeLabel.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 20, 5, 5);
        this.mTimingLinePanel.add((Component)this.mLineTypeLabel, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTimingLinePanel.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTimingLinePanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mTimingValueTextField.setColumns(6);
        this.mTimingValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTimingLinePanel.add((Component)this.mTimingValueTextField, gridBagConstraints);
        this.mLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTimingLinePanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTimingLinePanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mLineTypeComboBox.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeComboBox.setPreferredSize(new Dimension(140, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTimingLinePanel.add((Component)this.mLineTypeComboBox, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTimingLinePanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTimingLinePanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.mTimingLinePanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = new String[]{"Solid", "Broken", "Dotted", "Dashed", "Double Dashed"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.mLineTypeComboBox.addItem(stringArray[i]);
        }
        this.pack();
        this.mLineWidthSpinner.initProperties(SGTimingLineDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mFocusedColorSetButton = this.mLineColorButton;
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        return true;
    }

    public String getTimingValueString() {
        return this.mTimingValueTextField.getText();
    }

    public Number getTimingValue() {
        String string = this.getTimingValueString();
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public boolean setValue(Object object) {
        return this.setValue(this.mTimingValueTextField, object);
    }

    public boolean setLineType(Integer n) {
        if (n != null) {
            String string = SGDrawingElementLine.getLineTypeName(n);
            this.mLineTypeComboBox.setSelectedItem(string);
        } else {
            this.mLineTypeComboBox.setSelectedItem(null);
        }
        return true;
    }

    public int getLineType() {
        String string = (String)this.mLineTypeComboBox.getSelectedItem();
        if (string == null) {
            return -1;
        }
        Integer n = SGDrawingElementLine.getLineTypeFromName(string);
        return n;
    }

    public boolean setLineWidth(Object object) {
        return this.setValue(this.mLineWidthSpinner, object);
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public boolean setColor(Color color) {
        this.mLineColorButton.setColor(color);
        return true;
    }

    public Color getColor() {
        return this.mLineColorButton.getColor();
    }

    public ArrayList getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mLineColorButton);
        return arrayList;
    }

    public ArrayList getTextFieldComponentsList() {
        ArrayList arrayList = this.getFormattedTextFieldsListFromSpinners();
        arrayList.addAll(this.getNumberTextFieldList());
        return arrayList;
    }

    public ArrayList getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mTimingValueTextField);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        SGITimingLineDialogObserver sGITimingLineDialogObserver = (SGITimingLineDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxisPanel.getAxisConfiguration();
        Number number = this.getTimingValue();
        int n2 = this.getLineType();
        Number number2 = this.getLineWidth();
        Color color = this.getColor();
        if (!sGITimingLineDialogObserver.hasValidValue(n, number)) {
            return false;
        }
        if (n != -1) {
            sGITimingLineDialogObserver.setAxisConfiguration(n);
        }
        if (number != null) {
            sGITimingLineDialogObserver.setValue(number.doubleValue());
        }
        if (n2 != -1) {
            sGITimingLineDialogObserver.setLineType(n2);
        }
        if (number2 != null) {
            sGITimingLineDialogObserver.setLineWidth(number2.floatValue());
        }
        if (color != null) {
            sGITimingLineDialogObserver.setColor(color);
        }
        return true;
    }

    public boolean setDialogProperty() {
        SGTimingLineDialog sGTimingLineDialog = this;
        ArrayList arrayList = this.mPropertyDialogObserverList;
        if (!this.mAxisPanel.setSelected(arrayList)) {
            return false;
        }
        SGITimingLineDialogObserver sGITimingLineDialogObserver = (SGITimingLineDialogObserver)arrayList.get(0);
        double d = sGITimingLineDialogObserver.getValue();
        float f = sGITimingLineDialogObserver.getLineWidth();
        int n = sGITimingLineDialogObserver.getLineType();
        Color color = sGITimingLineDialogObserver.getColor();
        Double d2 = new Double(d);
        Float f2 = new Float(f);
        Integer n2 = new Integer(n);
        Color color2 = color;
        if (arrayList.size() > 1) {
            SGITimingLineDialogObserver sGITimingLineDialogObserver2;
            int n3;
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGITimingLineDialogObserver2 = (SGITimingLineDialogObserver)arrayList.get(n3);
                double d3 = sGITimingLineDialogObserver2.getValue();
                if (d == d3) continue;
                d2 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGITimingLineDialogObserver2 = (SGITimingLineDialogObserver)arrayList.get(n3);
                float f3 = sGITimingLineDialogObserver2.getLineWidth();
                if (f == f3) continue;
                f2 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGITimingLineDialogObserver2 = (SGITimingLineDialogObserver)arrayList.get(n3);
                int n4 = sGITimingLineDialogObserver2.getLineType();
                if (n == n4) continue;
                n2 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGITimingLineDialogObserver2 = (SGITimingLineDialogObserver)arrayList.get(n3);
                Color color3 = sGITimingLineDialogObserver2.getColor();
                if (color.equals(color3)) continue;
                color2 = null;
                break;
            }
        }
        this.setValue(d2);
        this.setLineWidth(f2);
        this.setLineType(n2);
        this.setColor(color2);
        this.setColorButtonBorder(true);
        return true;
    }
}

