/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;

public abstract class SGDrawingElementRectangle
extends SGDrawingElement {
    protected float mX;
    protected float mY;
    protected float mWidth;
    protected float mHeight;
    protected float mEdgeLineWidth;
    protected int mEdgeLineType;
    protected Color mEdgeLineColor;
    protected boolean mTransparentFlag;
    protected int mCap = 0;
    protected int mJoin = 1;
    protected float mMiterLimit = 1.0f;
    protected float mDashPhase = 0.0f;

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public SGTuple2f getLocation() {
        return new SGTuple2f(this.getX(), this.getY());
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public float getEdgeLineWidth() {
        return this.mEdgeLineWidth;
    }

    public Color getEdgeLineColor() {
        return this.mEdgeLineColor;
    }

    public int getEdgeLineType() {
        return this.mEdgeLineType;
    }

    public boolean isTransparent() {
        return this.mTransparentFlag;
    }

    public boolean setEdgeLineWidth(float f) {
        this.mEdgeLineWidth = f;
        return true;
    }

    public boolean setEdgeLineType(int n) {
        this.mEdgeLineType = n;
        return true;
    }

    public boolean setEdgeLineColor(Color color) {
        this.mEdgeLineColor = color;
        return true;
    }

    public boolean setTransparent(boolean bl) {
        this.mTransparentFlag = bl;
        return true;
    }

    public boolean setX(float f) {
        this.mX = f;
        return true;
    }

    public boolean setY(float f) {
        this.mY = f;
        return true;
    }

    public boolean setLocation(float f, float f2) {
        this.setX(f);
        this.setY(f2);
        return true;
    }

    public boolean setLocation(SGTuple2f sGTuple2f) {
        this.setLocation(sGTuple2f.x, sGTuple2f.y);
        return true;
    }

    public boolean setWidth(float f) {
        this.mWidth = f;
        return true;
    }

    public boolean setHeight(float f) {
        this.mHeight = f;
        return true;
    }

    public boolean setSize(float f, float f2) {
        this.setWidth(f);
        this.setHeight(f2);
        return true;
    }

    public boolean setBounds(float f, float f2, float f3, float f4) {
        this.setLocation(f, f2);
        this.setSize(f3, f4);
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementRectangle)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementRectangle sGDrawingElementRectangle = (SGDrawingElementRectangle)sGDrawingElement;
        this.setWidth(sGDrawingElementRectangle.getWidth());
        this.setHeight(sGDrawingElementRectangle.getHeight());
        this.setEdgeLineWidth(sGDrawingElementRectangle.getEdgeLineWidth());
        this.setEdgeLineType(sGDrawingElementRectangle.getEdgeLineType());
        this.setEdgeLineColor(sGDrawingElementRectangle.getEdgeLineColor());
        this.setTransparent(sGDrawingElementRectangle.isTransparent());
        return true;
    }

    public SGProperties getProperties() {
        RectangleProperties rectangleProperties = new RectangleProperties();
        if (!this.getProperties(rectangleProperties)) {
            return null;
        }
        return rectangleProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof RectangleProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        RectangleProperties rectangleProperties = (RectangleProperties)sGProperties;
        rectangleProperties.setHeight(this.getHeight());
        rectangleProperties.setWidth(this.getWidth());
        rectangleProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        rectangleProperties.setEdgeLineType(this.getEdgeLineType());
        rectangleProperties.setEdgeLineColor(this.getEdgeLineColor());
        rectangleProperties.setTransparent(this.isTransparent());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof RectangleProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        RectangleProperties rectangleProperties = (RectangleProperties)sGProperties;
        Float f = rectangleProperties.getWidth();
        if (f == null) {
            return false;
        }
        this.setWidth(f.floatValue());
        Float f2 = rectangleProperties.getHeight();
        if (f2 == null) {
            return false;
        }
        this.setHeight(f2.floatValue());
        Float f3 = rectangleProperties.getEdgeLineWidth();
        if (f3 == null) {
            return false;
        }
        this.setEdgeLineWidth(f3.floatValue());
        int n = rectangleProperties.getEdgeLineType();
        if (n == -1) {
            return false;
        }
        this.setEdgeLineType(n);
        Color color = rectangleProperties.getEdgeLineColor();
        if (color == null) {
            return false;
        }
        this.setEdgeLineColor(color);
        this.setTransparent(rectangleProperties.isTransparent());
        return true;
    }

    public static class RectangleProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mWidth = 0.0f;
        private float mHeight = 0.0f;
        private float mEdgeLineWidth = 0.0f;
        private int mEdgeLineType = -1;
        private Color mEdgeLineColor = null;
        private boolean mTransparent = false;

        public boolean equals(Object object) {
            if (!(object instanceof RectangleProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            RectangleProperties rectangleProperties = (RectangleProperties)object;
            if (this.mWidth != rectangleProperties.mWidth) {
                return false;
            }
            if (this.mHeight != rectangleProperties.mHeight) {
                return false;
            }
            if (this.mEdgeLineWidth != rectangleProperties.mEdgeLineWidth) {
                return false;
            }
            if (this.mEdgeLineType != rectangleProperties.mEdgeLineType) {
                return false;
            }
            if (!this.mEdgeLineColor.equals(rectangleProperties.mEdgeLineColor)) {
                return false;
            }
            return this.mTransparent == rectangleProperties.mTransparent;
        }

        public Float getWidth() {
            return new Float(this.mWidth);
        }

        public Float getHeight() {
            return new Float(this.mHeight);
        }

        public Float getEdgeLineWidth() {
            return new Float(this.mEdgeLineWidth);
        }

        public int getEdgeLineType() {
            return this.mEdgeLineType;
        }

        public Color getEdgeLineColor() {
            return this.mEdgeLineColor;
        }

        public boolean isTransparent() {
            return this.mTransparent;
        }

        public boolean setWidth(float f) {
            this.mWidth = f;
            return true;
        }

        public boolean setHeight(float f) {
            this.mHeight = f;
            return true;
        }

        public boolean setEdgeLineWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("width<0.0f");
            }
            this.mEdgeLineWidth = f;
            return true;
        }

        public boolean setEdgeLineType(int n) {
            this.mEdgeLineType = n;
            return true;
        }

        public boolean setEdgeLineColor(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("cl==null");
            }
            this.mEdgeLineColor = color;
            return true;
        }

        public boolean setTransparent(boolean bl) {
            this.mTransparent = bl;
            return true;
        }
    }
}

