/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGButtonGroup;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObject;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGZoomComboBox;

public class SGToolBar
extends JToolBar
implements ActionListener,
ComponentListener,
MouseListener,
SGIRootObjectConstants {
    private static final String[] ICON_FILENAME_ARRAY = new String[]{"NewGraph.png", "DrawGraph.png", "LoadProperty.png", "SaveGraph.png", "ExportImage.png", "Print.png", "Undo.png", "Redo.png", "Cut.png", "Copy.png", "Paste.png", "InsertString.png", "InsertSig.png", "InsertBreak.png", "InsertTiming.png", "BoundingBox.png", "LockFigure.png", "UnlockFigure.png", "Help.png"};
    private static final String[] COMMANDS_ARRAY = new String[]{"Create New Window", "Draw Graph", "Load Property", "Save Property", "Export as Image", "Print", "Undo", "Redo", "Cut", "Copy", "Paste", "Label", "Significant Difference", "Axis Break", "Timing Line", "Bounding Box", "Lock", "Lock", "Help"};
    private ToolBarButton mCreateNewWindowButton;
    private ToolBarButton mDrawGraphButton;
    private ToolBarButton mLoadPropertyButton;
    private ToolBarButton mSavePropertyButton;
    private ToolBarButton mExportFormatButton;
    private ToolBarButton mPrintButton;
    private ToolBarButton mUndoButton;
    private ToolBarButton mRedoButton;
    private ToolBarButton mCutButton;
    private ToolBarButton mCopyButton;
    private ToolBarButton mPasteButton;
    private ToolBarToggleButton mInsertBreakButton;
    private ToolBarButton mBoundingBoxButton;
    private ToolBarToggleButton mInsertLabelButton;
    private ToolBarToggleButton mInsertTimingLineButton;
    private ToolBarToggleButton mInsertSignificantDifferenceSymbolButton;
    private ToolBarToggleButton mLockFigureButton;
    private ToolBarButton mHelpButton;
    private JToolBar mFileToolBar;
    private JToolBar mEditToolBar;
    private JToolBar mInsertToolBar;
    private JToolBar mLayoutToolBar;
    private JToolBar mZoomToolBar;
    private static final String FILE_TOOLBAR_TITLE = "File";
    private static final String EDIT_TOOLBAR_TITLE = "Edit";
    private static final String INSERT_TOOLBAR_TITLE = "Insert";
    private static final String LAYOUT_TOOLBAR_TITLE = "Layout";
    private static final String HELP_TOOLBAR_TITLE = "Help";
    private static final String ZOOM_TOOLBAR_TITLE = "Zoom";
    private SGZoomComboBox mZoomComboBox;
    private SGIRootObject mRoot;
    private JPopupMenu mPopupMenu = new JPopupMenu();
    private AbstractButton mButton;
    private static final String TOOL_BARS_VISIBLE = "Visible";
    private ArrayList mActionListenerList = new ArrayList();
    private Map mToolBarMap;

    public SGToolBar() {
        this.create();
    }

    public SGToolBar(SGIRootObject sGIRootObject) {
        this.setRoot(sGIRootObject);
        this.create();
    }

    private boolean create() {
        String[] stringArray = ICON_FILENAME_ARRAY;
        int n = stringArray.length;
        ImageIcon[] imageIconArray = new ImageIcon[n];
        for (int i = 0; i < n; ++i) {
            imageIconArray[i] = this.createIcon(stringArray[i]);
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        for (int i = 0; i < n; ++i) {
            mediaTracker.addImage(imageIconArray[i].getImage(), i);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        HashMap<String, ImageIcon> hashMap = new HashMap<String, ImageIcon>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray[i], imageIconArray[i]);
        }
        this.mCreateNewWindowButton = this.createButton(hashMap, "NewGraph.png", "Create New Window");
        this.mDrawGraphButton = this.createButton(hashMap, "DrawGraph.png", "Draw Graph");
        this.mLoadPropertyButton = this.createButton(hashMap, "LoadProperty.png", "Load Property");
        this.mSavePropertyButton = this.createButton(hashMap, "SaveGraph.png", "Save Property");
        this.mExportFormatButton = this.createButton(hashMap, "ExportImage.png", "Export as Image");
        this.mPrintButton = this.createButton(hashMap, "Print.png", "Print");
        this.mUndoButton = this.createButton(hashMap, "Undo.png", "Undo");
        this.mRedoButton = this.createButton(hashMap, "Redo.png", "Redo");
        this.mCutButton = this.createButton(hashMap, "Cut.png", "Cut");
        this.mCopyButton = this.createButton(hashMap, "Copy.png", "Copy");
        this.mPasteButton = this.createButton(hashMap, "Paste.png", "Paste");
        this.mInsertLabelButton = this.createToggleButton(hashMap, "InsertString.png", "Insert Label");
        this.mInsertSignificantDifferenceSymbolButton = this.createToggleButton(hashMap, "InsertSig.png", "Insert Significant Difference Symbol");
        this.mInsertBreakButton = this.createToggleButton(hashMap, "InsertBreak.png", "Insert Axis Break Symbol");
        this.mInsertTimingLineButton = this.createToggleButton(hashMap, "InsertTiming.png", "Insert Timing Line");
        this.mBoundingBoxButton = this.createButton(hashMap, "BoundingBox.png", "Bounding Box");
        this.mLockFigureButton = this.createToggleButton(hashMap, "UnlockFigure.png", "Lock");
        this.mHelpButton = this.createButton(hashMap, "Help.png", HELP_TOOLBAR_TITLE);
        SGButtonGroup sGButtonGroup = new SGButtonGroup();
        sGButtonGroup.add(this.mInsertBreakButton);
        sGButtonGroup.add(this.mInsertLabelButton);
        sGButtonGroup.add(this.mInsertSignificantDifferenceSymbolButton);
        sGButtonGroup.add(this.mInsertTimingLineButton);
        sGButtonGroup.add(new JToggleButton());
        this.mZoomComboBox = new SGZoomComboBox();
        String string = SGUtility.getLookAndFeelID();
        if ("Windows".equals(string)) {
            this.setRollover(true);
        }
        this.setLayout(new BoxLayout(this, 0));
        this.setOrientation(0);
        this.setFloatable(false);
        JToolBar jToolBar = new JToolBar(FILE_TOOLBAR_TITLE);
        jToolBar.add(this.mCreateNewWindowButton);
        jToolBar.add(this.mDrawGraphButton);
        jToolBar.add(this.mLoadPropertyButton);
        jToolBar.add(this.mSavePropertyButton);
        jToolBar.add(this.mExportFormatButton);
        jToolBar.add(this.mPrintButton);
        this.mFileToolBar = jToolBar;
        JToolBar jToolBar2 = new JToolBar(EDIT_TOOLBAR_TITLE);
        jToolBar2.add(this.mUndoButton);
        jToolBar2.add(this.mRedoButton);
        jToolBar2.add(this.mCutButton);
        jToolBar2.add(this.mCopyButton);
        jToolBar2.add(this.mPasteButton);
        this.mEditToolBar = jToolBar2;
        JToolBar jToolBar3 = new JToolBar(INSERT_TOOLBAR_TITLE);
        jToolBar3.add(this.mInsertLabelButton);
        jToolBar3.add(this.mInsertSignificantDifferenceSymbolButton);
        jToolBar3.add(this.mInsertBreakButton);
        jToolBar3.add(this.mInsertTimingLineButton);
        this.mInsertToolBar = jToolBar3;
        JToolBar jToolBar4 = new JToolBar(LAYOUT_TOOLBAR_TITLE);
        jToolBar4.add(this.mBoundingBoxButton);
        jToolBar4.add(this.mLockFigureButton);
        this.mLayoutToolBar = jToolBar4;
        JToolBar jToolBar5 = new JToolBar(HELP_TOOLBAR_TITLE);
        jToolBar5.add(this.mHelpButton);
        JToolBar jToolBar6 = new JToolBar(ZOOM_TOOLBAR_TITLE);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(132, this.mBoundingBoxButton.getPreferredSize().height));
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.add((Component)this.mZoomComboBox, "Center");
        jToolBar6.add(jPanel);
        this.mZoomToolBar = jToolBar6;
        if ("Windows".equals(string)) {
            jToolBar.setRollover(true);
            jToolBar2.setRollover(true);
            jToolBar3.setRollover(true);
            jToolBar4.setRollover(true);
            jToolBar5.setRollover(true);
            jToolBar6.setRollover(true);
        }
        JToggleButton jToggleButton = new JToggleButton("..");
        jToggleButton.addActionListener(this);
        this.mButton = jToggleButton;
        this.add(jToolBar);
        this.add(jToolBar2);
        this.add(jToolBar3);
        this.add(jToolBar4);
        this.add(jToolBar6);
        this.createButtonMap();
        this.createToolBarMap();
        this.addMouseListener(this);
        this.createPopupMenu();
        return true;
    }

    private void createPopupMenu() {
        JPopupMenu jPopupMenu = this.mPopupMenu;
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Tool Bar --"));
        jPopupMenu.addSeparator();
        String[] stringArray = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(stringArray[i]);
            jCheckBoxMenuItem.addActionListener(this);
            jPopupMenu.add(jCheckBoxMenuItem);
        }
    }

    private ToolBarButton createButton(Map map, String string, String string2) {
        ImageIcon imageIcon = (ImageIcon)map.get(string);
        ToolBarButton toolBarButton = new ToolBarButton((Icon)imageIcon);
        toolBarButton.setToolTipText(string2);
        toolBarButton.addActionListener(this);
        return toolBarButton;
    }

    private ToolBarToggleButton createToggleButton(Map map, String string, String string2) {
        ImageIcon imageIcon = (ImageIcon)map.get(string);
        ToolBarToggleButton toolBarToggleButton = new ToolBarToggleButton((Icon)imageIcon);
        toolBarToggleButton.setToolTipText(string2);
        toolBarToggleButton.addActionListener(this);
        return toolBarToggleButton;
    }

    private ImageIcon createIcon(String string) {
        URL uRL = this.getClass().getResource("/resources/" + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon;
    }

    public void setRoot(SGIRootObject sGIRootObject) {
        this.mRoot = sGIRootObject;
        this.mZoomComboBox.addZoomable(sGIRootObject);
    }

    public void addActionListener(ActionListener actionListener) {
        this.mActionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.mActionListenerList.remove(actionListener);
    }

    public void notifyToListener(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 0, string);
        this.notifyToListener(actionEvent);
    }

    public void notifyToListener(ActionEvent actionEvent) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener = (ActionListener)arrayList.get(i);
            actionListener.actionPerformed(actionEvent);
        }
    }

    private IToolBarButton[] getButtonArray() {
        IToolBarButton[] iToolBarButtonArray = new IToolBarButton[]{this.mCreateNewWindowButton, this.mDrawGraphButton, this.mLoadPropertyButton, this.mSavePropertyButton, this.mExportFormatButton, this.mPrintButton, this.mUndoButton, this.mRedoButton, this.mCutButton, this.mCopyButton, this.mPasteButton, this.mInsertLabelButton, this.mInsertSignificantDifferenceSymbolButton, this.mInsertBreakButton, this.mInsertTimingLineButton, this.mBoundingBoxButton, this.mLockFigureButton, this.mLockFigureButton, this.mHelpButton};
        return iToolBarButtonArray;
    }

    private IToolBarButton getButton(String string) {
        IToolBarButton[] iToolBarButtonArray = this.getButtonArray();
        for (int i = 0; i < iToolBarButtonArray.length; ++i) {
            String string2 = iToolBarButtonArray[i].getCommand();
            if (!string2.equals(string)) continue;
            return iToolBarButtonArray[i];
        }
        return null;
    }

    private void createButtonMap() {
        String[] stringArray = COMMANDS_ARRAY;
        IToolBarButton[] iToolBarButtonArray = this.getButtonArray();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            iToolBarButtonArray[i].setCommand(stringArray[i]);
        }
    }

    private void createToolBarMap() {
        String[] stringArray = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
        JToolBar[] jToolBarArray = new JToolBar[]{this.mFileToolBar, this.mEditToolBar, this.mInsertToolBar, this.mLayoutToolBar, this.mZoomToolBar};
        int n = stringArray.length;
        HashMap<String, JToolBar> hashMap = new HashMap<String, JToolBar>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray[i], jToolBarArray[i]);
        }
        this.mToolBarMap = hashMap;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        Object object3 = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (Arrays.asList(SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY).contains(string)) {
            this.setToolBarVisible(string, !this.isToolBarVisible(string));
            this.mButton.setSelected(false);
        }
        if (object3.equals(this.mLockFigureButton)) {
            this.setButtonSelected("Lock", this.mLockFigureButton.isSelected());
        }
        if (object3 instanceof IToolBarButton) {
            object2 = (IToolBarButton)object3;
            String string2 = object2.getCommand();
            object = this.getButtonArray();
            for (int i = 0; i < ((IToolBarButton[])object).length; ++i) {
                String string3 = object[i].getCommand();
                if (!string3.equals(string2)) continue;
                this.notifyToListener(string2);
                break;
            }
        }
        object2 = this.mActionListenerList;
        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
            object = (ActionListener)((ArrayList)object2).get(i);
            object.actionPerformed(new ActionEvent(this, actionEvent.getID(), string, actionEvent.getModifiers()));
        }
        SGUtility.clearGlobalFocusOwner();
    }

    public boolean isButtonEnabled(String string) {
        IToolBarButton iToolBarButton = this.getButton(string);
        if (iToolBarButton == null) {
            throw new IllegalArgumentException("obj==null");
        }
        AbstractButton abstractButton = (AbstractButton)((Object)iToolBarButton);
        return abstractButton.isEnabled();
    }

    public void setButtonEnabled(String string, boolean bl) {
        IToolBarButton iToolBarButton = this.getButton(string);
        if (iToolBarButton == null) {
            throw new IllegalArgumentException("obj==null");
        }
        AbstractButton abstractButton = (AbstractButton)((Object)iToolBarButton);
        abstractButton.setEnabled(bl);
    }

    public boolean isButtonSelected(String string) {
        IToolBarButton iToolBarButton = this.getButton(string);
        if (iToolBarButton == null) {
            throw new IllegalArgumentException("obj==null");
        }
        AbstractButton abstractButton = (AbstractButton)((Object)iToolBarButton);
        return abstractButton.isSelected();
    }

    public void setButtonSelected(String string, boolean bl) {
        IToolBarButton iToolBarButton = this.getButton(string);
        if (iToolBarButton == null) {
            throw new IllegalArgumentException("obj==null");
        }
        AbstractButton abstractButton = (AbstractButton)((Object)iToolBarButton);
        abstractButton.setSelected(bl);
        if (string.equals("Lock")) {
            this.setLockButtonIcon(bl);
        }
    }

    public boolean isInsertToggleButtonSelected() {
        ArrayList arrayList = this.getInsertToggleButtonList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            if (!abstractButton.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void setInsertToggleButtonsEnabled(boolean bl) {
        ArrayList arrayList = this.getInsertToggleButtonList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            abstractButton.setEnabled(bl);
        }
    }

    public void setInsertToggleItemsUnSelected() {
        ArrayList arrayList = this.getInsertToggleButtonList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            abstractButton.setSelected(false);
        }
    }

    private ArrayList getInsertToggleButtonList() {
        ArrayList<JToggleButton> arrayList = new ArrayList<JToggleButton>(Arrays.asList(this.getInsertToggleButtonArray()));
        return arrayList;
    }

    private JToggleButton[] getInsertToggleButtonArray() {
        JToggleButton[] jToggleButtonArray = new JToggleButton[]{this.mInsertLabelButton, this.mInsertSignificantDifferenceSymbolButton, this.mInsertBreakButton, this.mInsertTimingLineButton};
        return jToggleButtonArray;
    }

    public boolean hasButton(String string) {
        IToolBarButton iToolBarButton = this.getButton(string);
        return iToolBarButton != null;
    }

    public void setInsertTogglebuttonSelected(String string, boolean bl) {
        IToolBarButton iToolBarButton = this.getButton(string);
        if (iToolBarButton == null) {
            throw new IllegalArgumentException();
        }
        AbstractButton abstractButton = (AbstractButton)((Object)iToolBarButton);
        abstractButton.setSelected(bl);
    }

    public boolean isInsertTogglebuttonSelected(String string) {
        IToolBarButton iToolBarButton = this.getButton(string);
        if (iToolBarButton != null) {
            AbstractButton abstractButton = (AbstractButton)((Object)iToolBarButton);
            return abstractButton.isSelected();
        }
        throw new IllegalArgumentException();
    }

    private void setLockButtonIcon(boolean bl) {
        ImageIcon imageIcon = bl ? this.createIcon("LockFigure.png") : this.createIcon("UnlockFigure.png");
        this.mLockFigureButton.setIcon(imageIcon);
    }

    public void setToolBarVisible(String string, boolean bl) {
        Object v = this.mToolBarMap.get(string);
        if (v == null) {
            throw new IllegalArgumentException("obj==null");
        }
        JToolBar jToolBar = (JToolBar)v;
        jToolBar.setVisible(bl);
        this.updateBounds();
        this.updatePopupMenu();
    }

    public boolean isToolBarVisible(String string) {
        Object v = this.mToolBarMap.get(string);
        if (v == null) {
            throw new IllegalArgumentException("obj==null");
        }
        JToolBar jToolBar = (JToolBar)v;
        return jToolBar.isVisible();
    }

    private JToolBar[] getToolBarArray() {
        Component[] componentArray = this.getComponents();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JToolBar)) continue;
            arrayList.add(componentArray[i]);
        }
        JToolBar[] jToolBarArray = new JToolBar[arrayList.size()];
        for (int i = 0; i < jToolBarArray.length; ++i) {
            jToolBarArray[i] = (JToolBar)arrayList.get(i);
        }
        return jToolBarArray;
    }

    public String[] getToolBarPattern() {
        int n;
        JToolBar[] jToolBarArray = this.getToolBarArray();
        String[] stringArray = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
        Map map = this.mToolBarMap;
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (int i = 0; i < jToolBarArray.length; ++i) {
            if (!jToolBarArray[i].isVisible()) continue;
            n = 0;
            while (i < stringArray.length) {
                Object v = map.get(stringArray[n]);
                if (jToolBarArray[i].equals(v)) {
                    arrayList.add(stringArray[n]);
                    continue block0;
                }
                ++n;
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = (String)arrayList.get(n);
        }
        return stringArray2;
    }

    public void setToolBarPattern(String[] stringArray) {
        String[] stringArray2;
        if (stringArray == null) {
            throw new IllegalArgumentException("pattern==null");
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2 = stringArray[i];
            arrayList.add(stringArray2);
        }
        Map map = this.mToolBarMap;
        stringArray2 = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
        for (int i = 0; i < stringArray2.length; ++i) {
            boolean bl = arrayList.contains(stringArray2[i]);
            JToolBar jToolBar = (JToolBar)map.get(stringArray2[i]);
            jToolBar.setVisible(bl);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.updateBounds();
    }

    private void updateBounds() {
        int n;
        JToolBar[] jToolBarArray = this.getToolBarArray();
        ArrayList<JToolBar> arrayList = new ArrayList<JToolBar>();
        ArrayList<JToolBar> arrayList2 = new ArrayList<JToolBar>();
        int n2 = jToolBarArray.length;
        int n3 = 0;
        for (n = 0; n < jToolBarArray.length; ++n) {
            int n4;
            if (!jToolBarArray[n].isVisible() || (n3 += (n4 = jToolBarArray[n].getPreferredSize().width)) <= this.getWidth()) continue;
            n2 = n;
            break;
        }
        for (n = 0; n < n2; ++n) {
            if (!jToolBarArray[n].isVisible()) continue;
            arrayList.add(jToolBarArray[n]);
        }
        for (n = n2; n < jToolBarArray.length; ++n) {
            if (!jToolBarArray[n].isVisible()) continue;
            arrayList2.add(jToolBarArray[n]);
        }
    }

    public void setZoomValue(Number number) {
        if (number == null) {
            return;
        }
        this.mZoomComboBox.setZoomValue(number);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.showPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.mButton.setSelected(false);
            }
        }
    }

    private void showPopupMenu(int n, int n2) {
        this.mPopupMenu.show(this, n, n2);
    }

    private void updatePopupMenu() {
        Map map = this.mToolBarMap;
        Component[] componentArray = this.mPopupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)componentArray[i];
            String string = jMenuItem.getActionCommand();
            JToolBar jToolBar = (JToolBar)map.get(string);
            jMenuItem.setSelected(jToolBar.isVisible());
        }
    }

    private void addToolBarToPopupMenu(JToolBar jToolBar) {
        JPopupMenu jPopupMenu = this.mPopupMenu;
        int n = 1;
        Component[] componentArray = jPopupMenu.getComponents();
        for (int i = componentArray.length - 1; i >= 0; --i) {
            if (!(componentArray[i] instanceof JToolBar)) continue;
            n = i;
            break;
        }
        jPopupMenu.add((Component)jToolBar, n);
        this.remove(jToolBar);
        this.validate();
        jPopupMenu.validate();
    }

    private void removeToolBarFromPopupMenu(JToolBar jToolBar) {
        JPopupMenu jPopupMenu = this.mPopupMenu;
        jPopupMenu.remove(jToolBar);
        this.add(jToolBar);
        this.validate();
        jPopupMenu.validate();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        SGUtility.clearGlobalFocusOwner();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private class ToolBarToggleButton
    extends JToggleButton
    implements IToolBarButton {
        private String mCommand;

        ToolBarToggleButton(Icon icon) {
            super(icon);
        }

        public void setCommand(String string) {
            this.mCommand = string;
        }

        public String getCommand() {
            return this.mCommand;
        }
    }

    private class ToolBarButton
    extends JButton
    implements IToolBarButton {
        private String mCommand;

        ToolBarButton(Icon icon) {
            super(icon);
        }

        public void setCommand(String string) {
            this.mCommand = string;
        }

        public String getCommand() {
            return this.mCommand;
        }
    }

    private static interface IToolBarButton {
        public void setCommand(String var1);

        public String getCommand();
    }
}

