/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.base.SGColorDialog;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;

public abstract class SGPropertyDialog
extends SGDialog
implements ChangeListener,
SGIDrawingElementConstants {
    protected ArrayList mPropertyDialogObserverList = new ArrayList();
    private Icon mColorSelectionButtonEmphasisIcon = null;
    protected SGColorDialog mColorDialog = null;
    protected SGColorSelectionButton mFocusedColorSetButton = null;
    private String mErrorMessageString;
    protected static final String DEFAULT_INPUT_ERROR_MESSAGE = "The input value is illegal.";

    public SGPropertyDialog() {
    }

    public SGPropertyDialog(Dialog dialog) {
        super(dialog);
    }

    public SGPropertyDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
    }

    public SGPropertyDialog(Dialog dialog, String string) {
        super(dialog, string);
    }

    public SGPropertyDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
    }

    public SGPropertyDialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(dialog, string, bl, graphicsConfiguration);
    }

    public SGPropertyDialog(Frame frame) {
        super(frame);
    }

    public SGPropertyDialog(Frame frame, boolean bl) {
        super(frame, bl);
    }

    public SGPropertyDialog(Frame frame, String string) {
        super(frame, string);
    }

    public SGPropertyDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    public SGPropertyDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, string, bl, graphicsConfiguration);
    }

    protected boolean initialize() {
        JButton jButton;
        this.mColorDialog = new SGColorDialog(this, "Color Dialog", false);
        this.mColorDialog.pack();
        this.mColorDialog.setResizable(false);
        JColorChooser jColorChooser = this.mColorDialog.getColorChooser();
        ColorSelectionModel colorSelectionModel = jColorChooser.getSelectionModel();
        colorSelectionModel.addChangeListener(this);
        this.mColorSelectionButtonEmphasisIcon = this.createIcon("/resources/Lines.gif");
        ArrayList arrayList = this.getColorSelectionButtonsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SGColorSelectionButton)) continue;
            jButton = (JButton)e;
            jButton.addActionListener(this);
        }
        ArrayList arrayList2 = this.getTextFieldComponentsList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            jButton = arrayList2.get(i);
            if (!(jButton instanceof JTextComponent)) continue;
            JTextField jTextField = (JTextField)((Object)jButton);
            jTextField.addActionListener(this);
        }
        return true;
    }

    private ImageIcon createIcon(String string) {
        if (string == null) {
            return null;
        }
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource(string);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    protected String getString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("res", Locale.JAPAN);
        String string2 = resourceBundle.getString(string);
        return string2;
    }

    public SGColorDialog getColorDialog() {
        return this.mColorDialog;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (this.mFocusedColorSetButton != null && object instanceof ColorSelectionModel) {
            Color color = this.mColorDialog.getColorChooser().getColor();
            this.mFocusedColorSetButton.setColor(color);
            this.mColorDialog.getColorChooser().getSelectionModel().setSelectedColor(null);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.mColorDialog.setVisible(false);
        }
        SGUtility.clearGlobalFocusOwner();
    }

    public abstract ArrayList getColorSelectionButtonsList();

    public abstract ArrayList getTextFieldComponentsList();

    public abstract ArrayList getNumberTextFieldList();

    public abstract ArrayList getSpinnerList();

    protected ArrayList getFormattedTextFieldsListFromSpinners() {
        ArrayList<JFormattedTextField> arrayList = new ArrayList<JFormattedTextField>();
        ArrayList arrayList2 = this.getSpinnerList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList2.get(i);
            arrayList.add(sGSpinner.getFormattedTextField());
        }
        return arrayList;
    }

    public boolean setColorButtonBorder(JButton jButton, boolean bl) {
        ArrayList arrayList = this.getColorSelectionButtonsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            JComponent jComponent = (JComponent)arrayList.get(i);
            if (jComponent.equals(jButton) && bl) {
                MatteBorder matteBorder = new MatteBorder(this.mColorSelectionButtonEmphasisIcon);
                jButton.setBorder(matteBorder);
                continue;
            }
            jComponent.setBorder(new LineBorder(Color.BLACK, 1));
        }
        return true;
    }

    public boolean setColorButtonBorder(boolean bl) {
        this.setColorButtonBorder(this.mFocusedColorSetButton, bl);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (this.getColorSelectionButtonsList().contains(object)) {
            serializable = (SGColorSelectionButton)object;
            this.mFocusedColorSetButton = serializable;
            this.setColorButtonBorder(true);
            this.mColorDialog.setVisible(true);
        }
        serializable = this.getTextFieldComponentsList();
        if (string.equals("OK") || ((ArrayList)serializable).contains(object)) {
            this.onOK();
        } else if (string.equals("Cancel")) {
            this.onCanceled();
        } else if (string.equals("Preview")) {
            this.onPreviewed();
        }
    }

    public static SpinnerNumberModel getLineWidthSpinnerNumberModel() {
        return new SpinnerNumberModel(0.25, 0.25, 6.0, 0.25);
    }

    public static SpinnerNumberModel getFontSizeSpinnerNumberModel() {
        return new SpinnerNumberModel(8.0, 8.0, 96.0, 1.0);
    }

    public boolean addPropertyDialogObserver(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        this.mPropertyDialogObserverList.add(sGIPropertyDialogObserver);
        return true;
    }

    public boolean removePropertyDialogObserver(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        return this.mPropertyDialogObserverList.remove(sGIPropertyDialogObserver);
    }

    public boolean removeAllPropertyDialogObserver() {
        this.mPropertyDialogObserverList.clear();
        return true;
    }

    private boolean onOK() {
        if (!this.commit()) {
            return false;
        }
        this.setCloseOption(0);
        this.setVisible(false);
        this.clearAllSpinners();
        return true;
    }

    private boolean onCanceled() {
        if (!this.cancel()) {
            return false;
        }
        this.setCloseOption(1);
        this.setVisible(false);
        this.clearAllSpinners();
        return true;
    }

    private boolean onPreviewed() {
        return this.preview();
    }

    protected void clearAllSpinners() {
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.clearTemporaryValues();
        }
    }

    protected boolean commit() {
        if (!this.checkInputValues()) {
            return false;
        }
        ArrayList arrayList = this.mPropertyDialogObserverList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)arrayList.get(i);
            if (!this.setPropertiesToListeners(sGIPropertyDialogObserver)) {
                SGUtility.showIllegalInputErrorMessageDialog(this, DEFAULT_INPUT_ERROR_MESSAGE);
                return false;
            }
            if (sGIPropertyDialogObserver.commit()) continue;
            return false;
        }
        this.setVisible(false);
        return true;
    }

    protected boolean cancel() {
        ArrayList arrayList = this.mPropertyDialogObserverList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)arrayList.get(i);
            if (sGIPropertyDialogObserver.cancel()) continue;
            return false;
        }
        return true;
    }

    protected boolean preview() {
        if (!this.checkInputValues()) {
            return false;
        }
        ArrayList arrayList = this.mPropertyDialogObserverList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)arrayList.get(i);
            if (!this.setPropertiesToListeners(sGIPropertyDialogObserver)) {
                SGUtility.showIllegalInputErrorMessageDialog(this, DEFAULT_INPUT_ERROR_MESSAGE);
                return false;
            }
            if (sGIPropertyDialogObserver.preview()) continue;
            return false;
        }
        return true;
    }

    private boolean checkInputValues() {
        if (!this.hasValidInputValues()) {
            String string = this.getInputErrorMessage();
            SGUtility.showIllegalInputErrorMessageDialog(this, string);
            return false;
        }
        return true;
    }

    protected boolean hasValidInputValues() {
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            if (sGSpinner.hasValidValue()) continue;
            this.setInputErrorMessage(DEFAULT_INPUT_ERROR_MESSAGE);
            return false;
        }
        ArrayList arrayList2 = this.getNumberTextFieldList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGTextField sGTextField = (SGTextField)arrayList2.get(i);
            if (this.getNumber(sGTextField) != null || sGTextField.isIndeterminate()) continue;
            this.setInputErrorMessage(DEFAULT_INPUT_ERROR_MESSAGE);
            return false;
        }
        return true;
    }

    protected String getInputErrorMessage() {
        return this.mErrorMessageString;
    }

    protected boolean setInputErrorMessage(String string) {
        this.mErrorMessageString = string;
        return true;
    }

    public abstract boolean setPropertiesToListeners(SGIPropertyDialogObserver var1);

    public abstract boolean setDialogProperty();

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.onCanceled();
    }

    protected boolean setValue(SGTextField sGTextField, Object object) {
        return SGUtility.setValue(sGTextField, object);
    }

    protected boolean setValue(SGSpinner sGSpinner, Object object) {
        return SGUtility.setValue(sGSpinner, object);
    }
}

