/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.event.MouseInputListener;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGImagePanel;

public abstract class SGAxisSelectionPanel
extends JPanel
implements ActionListener {
    protected JRadioButton mBottomButton;
    private JPanel mFormPanel;
    protected JRadioButton mLeftButton;
    protected JRadioButton mRightButton;
    private JLabel mScaleReferenceLabel1;
    private JLabel mScaleReferenceLabel2;
    protected JRadioButton mTopButton;
    private static final int RECTANGLE_WIDTH = 45;
    private static final int RECTANGLE_HEIGHT = 30;
    private static final int LINE_WIDTH = 2;
    protected AxisImagePanel mAxisImagePanel = new AxisImagePanel();
    private boolean mTopFlag;
    private boolean mBottomFlag;
    private boolean mLeftFlag;
    private boolean mRightFlag;
    protected Line mTopLine;
    protected Line mBottomLine;
    protected Line mLeftLine;
    protected Line mRightLine;
    private static final int MARGIN = 3;

    public SGAxisSelectionPanel() {
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mScaleReferenceLabel2 = new JLabel();
        this.mScaleReferenceLabel1 = new JLabel();
        this.mFormPanel = new JPanel();
        this.mTopButton = new JRadioButton();
        this.mBottomButton = new JRadioButton();
        this.mLeftButton = new JRadioButton();
        this.mRightButton = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.mScaleReferenceLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleReferenceLabel2.setText("(Value <-> Scale)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.mScaleReferenceLabel2, gridBagConstraints);
        this.mScaleReferenceLabel1.setFont(new Font("Dialog", 1, 12));
        this.mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.mScaleReferenceLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.mFormPanel, gridBagConstraints);
        this.mTopButton.setFont(new Font("Dialog", 0, 12));
        this.mTopButton.setText("Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mTopButton, gridBagConstraints);
        this.mBottomButton.setFont(new Font("Dialog", 0, 12));
        this.mBottomButton.setText("Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mBottomButton, gridBagConstraints);
        this.mLeftButton.setFont(new Font("Dialog", 0, 12));
        this.mLeftButton.setText("Left");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mLeftButton, gridBagConstraints);
        this.mRightButton.setFont(new Font("Dialog", 0, 12));
        this.mRightButton.setText("Right");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mRightButton, gridBagConstraints);
    }

    private void initProperty() {
        this.mFormPanel.add(this.mAxisImagePanel);
        this.mTopButton.addActionListener(this);
        this.mBottomButton.addActionListener(this);
        this.mLeftButton.addActionListener(this);
        this.mRightButton.addActionListener(this);
        this.mAxisImagePanel.addActionListener(this);
        URL uRL = this.getClass().getResource("/resources/GraphImage.png");
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mAxisImagePanel.setImage(image);
        this.mAxisImagePanel.setImageLocation(3, 3);
        this.mAxisImagePanel.setImageSize(45, 30);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mAxisImagePanel)) {
            this.setTopSelected(this.mAxisImagePanel.isTopSelected());
            this.setBottomSelected(this.mAxisImagePanel.isBottomSelected());
            this.setLeftSelected(this.mAxisImagePanel.isLeftSelected());
            this.setRightSelected(this.mAxisImagePanel.isRightSelected());
            this.updateButtons();
        } else if (object instanceof JToggleButton) {
            this.setTopSelected(this.mTopButton.isSelected());
            this.setBottomSelected(this.mBottomButton.isSelected());
            this.setLeftSelected(this.mLeftButton.isSelected());
            this.setRightSelected(this.mRightButton.isSelected());
            this.updateImage();
        }
    }

    public boolean isTopSelected() {
        return this.mTopFlag;
    }

    public boolean isBottomSelected() {
        return this.mBottomFlag;
    }

    public boolean isLeftSelected() {
        return this.mLeftFlag;
    }

    public boolean isRightSelected() {
        return this.mRightFlag;
    }

    public void setTopSelected(boolean bl) {
        this.mTopFlag = bl;
    }

    public void setBottomSelected(boolean bl) {
        this.mBottomFlag = bl;
    }

    public void setLeftSelected(boolean bl) {
        this.mLeftFlag = bl;
    }

    public void setRightSelected(boolean bl) {
        this.mRightFlag = bl;
    }

    protected void clearAll() {
        this.setTopSelected(false);
        this.setBottomSelected(false);
        this.setLeftSelected(false);
        this.setRightSelected(false);
    }

    protected abstract void updateImage();

    protected abstract void updateButtons();

    protected abstract void selectLine(Line var1);

    protected static class Line
    extends Line2D.Float
    implements SGISelectable {
        private boolean mSelected = false;
        private float mLineWidth = 0.0f;
        private int mLocation = 0;

        protected Line(float f, float f2, float f3, float f4) {
            super(f, f2, f3, f4);
        }

        public boolean contains(double d, double d2) {
            return this.ptLineDistSq(d, d2) < 36.0;
        }

        public boolean isSelected() {
            return this.mSelected;
        }

        public void setSelected(boolean bl) {
            this.mSelected = bl;
            this.mLineWidth = bl ? 2.0f : 1.0f;
        }

        public void setLocation(int n) {
            this.mLocation = n;
        }

        protected void draw(Graphics2D graphics2D) {
            BasicStroke basicStroke = new BasicStroke(this.mLineWidth, 2, 0);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(this);
            basicStroke = new BasicStroke(1.0f, 2, 0);
            graphics2D.setStroke(basicStroke);
            if (this.mSelected) {
                switch (this.mLocation) {
                    case 0: {
                        for (int i = (int)this.x1; i < (int)this.x2; i += 5) {
                            graphics2D.drawLine(i, (int)this.y1, i, (int)this.y1 + 2);
                        }
                        break;
                    }
                    case 1: {
                        for (int i = (int)this.x1; i < (int)this.x2; i += 5) {
                            graphics2D.drawLine(i, (int)this.y1 - 2 - 1, i, (int)this.y1);
                        }
                        break;
                    }
                    case 2: {
                        for (int i = (int)this.y1; i < (int)this.y2; i += 5) {
                            graphics2D.drawLine((int)this.x1, i, (int)this.x1 + 2, i);
                        }
                        break;
                    }
                    case 3: {
                        for (int i = (int)this.y1; i < (int)this.y2; i += 5) {
                            graphics2D.drawLine((int)this.x1 - 2 - 1, i, (int)this.x1, i);
                        }
                        break;
                    }
                }
            }
        }
    }

    protected class AxisImagePanel
    extends SGImagePanel
    implements MouseInputListener {
        private ArrayList mActionListenerList = new ArrayList();

        protected AxisImagePanel() {
            this.setPreferredSize(new Dimension(51, 36));
            this.setSize(new Dimension(51, 36));
            SGAxisSelectionPanel.this.mTopLine = new Line(3.0f, 3.0f, 48.0f, 3.0f);
            SGAxisSelectionPanel.this.mBottomLine = new Line(3.0f, 33.0f, 48.0f, 33.0f);
            SGAxisSelectionPanel.this.mLeftLine = new Line(3.0f, 3.0f, 3.0f, 33.0f);
            SGAxisSelectionPanel.this.mRightLine = new Line(48.0f, 3.0f, 48.0f, 33.0f);
            SGAxisSelectionPanel.this.mTopLine.setLocation(0);
            SGAxisSelectionPanel.this.mBottomLine.setLocation(1);
            SGAxisSelectionPanel.this.mLeftLine.setLocation(2);
            SGAxisSelectionPanel.this.mRightLine.setLocation(3);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(Color.GRAY);
            if (SGAxisSelectionPanel.this.mTopLine.isSelected()) {
                SGAxisSelectionPanel.this.mBottomLine.draw(graphics2D);
            } else {
                SGAxisSelectionPanel.this.mTopLine.draw(graphics2D);
            }
            if (SGAxisSelectionPanel.this.mLeftLine.isSelected()) {
                SGAxisSelectionPanel.this.mRightLine.draw(graphics2D);
            } else {
                SGAxisSelectionPanel.this.mLeftLine.draw(graphics2D);
            }
            graphics2D.setPaint(Color.BLACK);
            if (SGAxisSelectionPanel.this.mTopLine.isSelected()) {
                SGAxisSelectionPanel.this.mTopLine.draw(graphics2D);
            } else {
                SGAxisSelectionPanel.this.mBottomLine.draw(graphics2D);
            }
            if (SGAxisSelectionPanel.this.mLeftLine.isSelected()) {
                SGAxisSelectionPanel.this.mLeftLine.draw(graphics2D);
            } else {
                SGAxisSelectionPanel.this.mRightLine.draw(graphics2D);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Line[] lineArray = new Line[]{SGAxisSelectionPanel.this.mTopLine, SGAxisSelectionPanel.this.mBottomLine, SGAxisSelectionPanel.this.mLeftLine, SGAxisSelectionPanel.this.mRightLine};
            int n3 = lineArray.length;
            for (int i = 0; i < n3; ++i) {
                if (!lineArray[i].contains(n, n2)) continue;
                SGAxisSelectionPanel.this.selectLine(lineArray[i]);
            }
            ArrayList arrayList = this.mActionListenerList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ActionListener actionListener = (ActionListener)arrayList.get(i);
                actionListener.actionPerformed(new ActionEvent(this, 0, ""));
            }
            this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Line[] lineArray = new Line[]{SGAxisSelectionPanel.this.mTopLine, SGAxisSelectionPanel.this.mBottomLine, SGAxisSelectionPanel.this.mLeftLine, SGAxisSelectionPanel.this.mRightLine};
            int n3 = lineArray.length;
            boolean bl = false;
            for (int i = 0; i < n3; ++i) {
                if (!lineArray[i].contains(n, n2)) continue;
                bl = true;
                break;
            }
            Cursor cursor = null;
            cursor = bl ? new Cursor(12) : Cursor.getDefaultCursor();
            this.setCursor(cursor);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public boolean isTopSelected() {
            return SGAxisSelectionPanel.this.mTopLine.isSelected();
        }

        public boolean isBottomSelected() {
            return SGAxisSelectionPanel.this.mBottomLine.isSelected();
        }

        public boolean isLeftSelected() {
            return SGAxisSelectionPanel.this.mLeftLine.isSelected();
        }

        public boolean isRightSelected() {
            return SGAxisSelectionPanel.this.mRightLine.isSelected();
        }

        public void setTopSelected(boolean bl) {
            SGAxisSelectionPanel.this.mTopLine.setSelected(bl);
        }

        public void setBottomSelected(boolean bl) {
            SGAxisSelectionPanel.this.mBottomLine.setSelected(bl);
        }

        public void setLeftSelected(boolean bl) {
            SGAxisSelectionPanel.this.mLeftLine.setSelected(bl);
        }

        public void setRightSelected(boolean bl) {
            SGAxisSelectionPanel.this.mRightLine.setSelected(bl);
        }

        public void addActionListener(ActionListener actionListener) {
            ArrayList arrayList = this.mActionListenerList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ActionListener actionListener2 = (ActionListener)arrayList.get(i);
                if (!actionListener2.equals(actionListener)) continue;
                return;
            }
            arrayList.add(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            ArrayList arrayList = this.mActionListenerList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ActionListener actionListener2 = (ActionListener)arrayList.get(i);
                if (!actionListener2.equals(actionListener)) continue;
                arrayList.remove(actionListener);
            }
        }
    }
}

