
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;

/**
 *
 *
 */
public abstract class SGXYFigure extends SGFigure
	implements SGIXYFigureDialogObserver
{
	/**
	 * 
	 */
	public SGXYFigure()
	{
		super();
	}

	/**
	 * @param wnd
	 */
	public SGXYFigure(SGDrawingWindow wnd)
	{
		super(wnd);
	}



	/**
	 * 
	 */
	public int getXAxisConfiguration()
	{
		return this.mGridElement.getXAxisConfiguration();
	}


	/**
	 * 
	 */
	public int getYAxisConfiguration()
	{
		return this.mGridElement.getYAxisConfiguration();
	}


	/**
	 * 
	 */
	public void setAxisConfiguration( final int configX, final int configY )
	{
		this.mGridElement.setAxisConfiguration( configX, configY );
	}


	public boolean setGridVisible( final boolean b )
	{
		return this.mGridElement.setGridVisible(b);
	}

	public boolean setAutoRangeFlag( final boolean b )
	{
		return this.mGridElement.setAutoRangeFlag(b);
	}

	public boolean setStepValueX( final double value )
	{
		return this.mGridElement.setStepValueX(value);
	}

	public boolean setStepValueY( final double value )
	{
		return this.mGridElement.setStepValueY(value);
	}

	public boolean setBaselineValueX( final double value )
	{
		return this.mGridElement.setBaselineValueX(value);
	}

	public boolean setBaselineValueY( final double value )
	{
		return this.mGridElement.setBaselineValueY(value);
	}
	
	public boolean setLineWidth( final float width )
	{
		return this.mGridElement.setLineWidth(width);
	}

	public boolean setLineType( final int type )
	{
		return this.mGridElement.setLineType(type);
	}

	public boolean setColor( final Color cl )
	{
		return this.mGridElement.setColor(cl);
	}


	public boolean isGridVisible()
	{
		return this.mGridElement.isGridVisible();
	}
	
	public boolean isAutoRange()
	{
		return this.mGridElement.isAutoRange();
	}

	public double getStepValueX()
	{
		return this.mGridElement.getStepValueX();
	}

	public double getStepValueY()
	{
		return this.mGridElement.getStepValueY();
	}

	public double getBaselineValueX()
	{
		return this.mGridElement.getBaselineValueX();
	}
	public double getBaselineValueY()
	{
		return this.mGridElement.getBaselineValueY();
	}

	public float getLineWidth()
	{
		return this.mGridElement.getLineWidth();
	}

	public int getLineType()
	{
		return this.mGridElement.getLineType();
	}

	public Color getColor()
	{
		return this.mGridElement.getColor();
	}


	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		XYFigureProperties p = new XYFigureProperties();
		if( this.getProperties(p) == false ) return null;
		return p;
	}


	/**
	 * 
	 * @param p
	 * @return
	 */
	public boolean getProperties( SGProperties p )
	{
		if( ( p instanceof XYFigureProperties ) == false ) return false;

		if( super.getProperties(p) == false ) return false;

		XYFigureProperties fp = (XYFigureProperties)p;

		SGIGridElement el = this.mGridElement;
		fp.mXAxisConfiguration = el.getXAxisConfiguration();
		fp.mYAxisConfiguration = el.getYAxisConfiguration();
		fp.mBaselineValueX = el.getBaselineValueX();
		fp.mBaselineValueY = el.getBaselineValueY();
		fp.mStepValueX = el.getStepValueX();
		fp.mStepValueY = el.getStepValueY();
		fp.mVisibleFlag = el.isGridVisible();
		fp.mAutoRangeFlag = el.isAutoRange();
		fp.mLineWidth = el.getLineWidth();
		fp.mLineType = el.getLineType();
		fp.mColor = el.getColor();

		return true;
	}



	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof XYFigureProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		XYFigureProperties fp = (XYFigureProperties)p;

		SGIGridElement el = this.mGridElement;
		el.setAxisConfiguration( fp.mXAxisConfiguration, fp.mYAxisConfiguration );
		el.setBaselineValueX( fp.mBaselineValueX );
		el.setBaselineValueY( fp.mBaselineValueY );
		el.setStepValueX( fp.mStepValueX );
		el.setStepValueY( fp.mStepValueY );
		el.setGridVisible( fp.mVisibleFlag );
		el.setAutoRangeFlag( fp.mAutoRangeFlag );
		el.setLineWidth( fp.mLineWidth );
		el.setLineType( fp.mLineType );
		el.setColor( fp.mColor );

		return true;
	}



	/**
	 * 
	 * @author kuromaru
	 *
	 * ̐ꂽRg̑}ev[gύX邽
	 * EBhE > ݒ > Java > R[h > R[hƃRg
	 */
	public static class XYFigureProperties extends FigureProperties
	{
		private int mXAxisConfiguration;
		private int mYAxisConfiguration;
		private double mStepValueX;
		private double mBaselineValueX;
		private double mStepValueY;
		private double mBaselineValueY;
		private boolean mVisibleFlag;
		private boolean mAutoRangeFlag;
		private float mLineWidth;
		private int mLineType;
		private Color mColor;

		/**
		 * 
		 *
		 */
		public XYFigureProperties()
		{
			super();
		}

		/**
		 * 
		 */
		public boolean equals( Object obj )
		{
			if( ( obj instanceof XYFigureProperties ) == false ) return false;
			
			if( super.equals(obj) == false ) return false;
			
			XYFigureProperties p = (XYFigureProperties)obj;

			if( this.mXAxisConfiguration!=p.mXAxisConfiguration ) return false;
			if( this.mYAxisConfiguration!=p.mYAxisConfiguration ) return false;
			if( this.mBaselineValueX!=p.mBaselineValueX ) return false;
			if( this.mStepValueX!=p.mStepValueX ) return false;
			if( this.mBaselineValueY!=p.mBaselineValueY ) return false;
			if( this.mStepValueY!=p.mStepValueY ) return false;
			if( this.mVisibleFlag!=p.mVisibleFlag ) return false;
			if( this.mAutoRangeFlag!=p.mAutoRangeFlag ) return false;
			if( this.mLineWidth!=p.mLineWidth ) return false;
			if( this.mLineType!=p.mLineType ) return false;
			if( this.mColor.equals(p.mColor) == false ) return false;
			
			return true;
		}


	}


}
