
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;


/**
 * Default values for SGIShapeElement.
 */
public interface SGIDefaultValuesShape extends SGIConstants
{

	// X Axis
	public static final String SHAPE_HORIZONTAL_AXIS = SGIAxisElement.AXIS_BOTTOM;

	// Y Axis
	public static final String SHAPE_PERPENDICULAR_AXIS = SGIAxisElement.AXIS_LEFT;


	//
	// Line
	//

	// Line Width
	public static final float SHAPE_LINE_WIDTH = 1.5f;

	// Line Type
	public static final int SHAPE_LINE_TYPE = SGILineConstants.LINE_TYPE_SOLID;

	// Color
	public static final Color SHAPE_LINE_COLOR = Color.BLACK;


	//
	// Arrow
	//

	// Line Width
	public static final float SHAPE_ARROW_LINE_WIDTH = SHAPE_LINE_WIDTH;

	// Line Type
	public static final int SHAPE_ARROW_LINE_TYPE = SHAPE_LINE_TYPE;
	
	// Color
	public static final Color SHAPE_ARROW_COLOR = SHAPE_LINE_COLOR;
	
	// Head Size
	public static final float SHAPE_ARROW_HEAD_SIZE = 0.4f/CM_POINT_RATIO;

	// Start Head Type
	public static final int SHAPE_ARROW_START_HEAD_TYPE = SGISymbolConstants.SYMBOL_TYPE_VOID;

	// End Head Type
	public static final int SHAPE_ARROW_END_HEAD_TYPE = SGIArrowConstants.SYMBOL_TYPE_ARROW_HEAD;

	// Open Angle
	public static final float SHAPE_ARROW_HEAD_OPEN_ANGLE = (float)Math.PI/6.0f;

	// Close Angle
	public static final float SHAPE_ARROW_HEAD_CLOSE_ANGLE = (float)Math.PI/3.0f;


	//
	// Rectangle
	//

	// Width
	public static final float SHAPE_RETANGLE_WIDTH = 5.0f/CM_POINT_RATIO;

	// Height
	public static final float SHAPE_RETANGLE_HEIGHT = 4.0f/CM_POINT_RATIO;

	// Color
	public static final Color SHAPE_RECTANGLE_INNER_COLOR = Color.WHITE;

	// Edge Line Width
	public static final float SHAPE_RCTANGLE_EDGE_LINE_WIDTH = SHAPE_LINE_WIDTH;

	// Edge Line Type
	public static final int SHAPE_RCTANGLE_EDGE_LINE_TYPE = SHAPE_LINE_TYPE;

	// Edge Line Color
	public static final Color SHAPE_RECTANGLE_EDGE_LINE_COLOR = SHAPE_LINE_COLOR;

	// Transparecy
	public static final boolean SHAPE_RECTANGLE_TRANSPARENT = false;


}

