/*
 * SGWindowDialog.java
 *
 * Created on 2004/06/09, 16:23
 */

package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.SpinnerNumberModel;


/**
 *
 * @author  kuromaru
 */
public class SGWindowDialog  extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Window Properties";


    
    /** Creates new form SGWindowDialog */
    public SGWindowDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
		this.initialize();
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mWindowPanel = new javax.swing.JPanel();
        mWidthLabel = new javax.swing.JLabel();
        mHeightLabel = new javax.swing.JLabel();
        mWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mHeightSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSizeLabel = new javax.swing.JLabel();
        mColorLabel = new javax.swing.JLabel();
        mIntervalLabel = new javax.swing.JLabel();
        mGridLinesIntervalSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mBottomLabel = new javax.swing.JLabel();
        mGridLinesWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mGridLabel = new javax.swing.JLabel();
        mGridLinesColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mBackgroundColorLabel1 = new javax.swing.JLabel();
        mGridLinesColorLabel = new javax.swing.JLabel();
        mBackgroundColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mSizeSeparator = new javax.swing.JSeparator();
        mGridSeparator = new javax.swing.JSeparator();
        mColorSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mGridVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mWindowPanel.setLayout(new java.awt.GridBagLayout());

        mWindowPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mWindowPanel.add(mWidthLabel, gridBagConstraints);

        mHeightLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mHeightLabel.setText("Height");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mWindowPanel.add(mHeightLabel, gridBagConstraints);

        mWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mWidthSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mWindowPanel.add(mWidthSpinner, gridBagConstraints);

        mHeightSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mHeightSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mWindowPanel.add(mHeightSpinner, gridBagConstraints);

        mSizeLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 0, 5);
        mWindowPanel.add(mSizeLabel, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        mWindowPanel.add(mColorLabel, gridBagConstraints);

        mIntervalLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mIntervalLabel.setText("Interval");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mWindowPanel.add(mIntervalLabel, gridBagConstraints);

        mGridLinesIntervalSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mGridLinesIntervalSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mWindowPanel.add(mGridLinesIntervalSpinner, gridBagConstraints);

        mBottomLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBottomLabel.setText("Line width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mWindowPanel.add(mBottomLabel, gridBagConstraints);

        mGridLinesWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mGridLinesWidthSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mWindowPanel.add(mGridLinesWidthSpinner, gridBagConstraints);

        mGridLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mGridLabel.setText("Grid");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        mWindowPanel.add(mGridLabel, gridBagConstraints);

        mGridLinesColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mWindowPanel.add(mGridLinesColorButton, gridBagConstraints);

        mBackgroundColorLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        mBackgroundColorLabel1.setText("Background");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mWindowPanel.add(mBackgroundColorLabel1, gridBagConstraints);

        mGridLinesColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mGridLinesColorLabel.setText("Grid");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mWindowPanel.add(mGridLinesColorLabel, gridBagConstraints);

        mBackgroundColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mWindowPanel.add(mBackgroundColorButton, gridBagConstraints);

        mSizeSeparator.setRequestFocusEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 35, 0, 0);
        mWindowPanel.add(mSizeSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 35, 0, 0);
        mWindowPanel.add(mGridSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 42, 0, 0);
        mWindowPanel.add(mColorSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mWindowPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mWindowPanel.add(mRightSpaceLabel, gridBagConstraints);

        mGridVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mGridVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mWindowPanel.add(mGridVisibleCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mWindowPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mBackgroundColorButton;
    private javax.swing.JLabel mBackgroundColorLabel1;
    private javax.swing.JLabel mBottomLabel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JSeparator mColorSeparator;
    private javax.swing.JLabel mGridLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mGridLinesColorButton;
    private javax.swing.JLabel mGridLinesColorLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mGridLinesIntervalSpinner;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mGridLinesWidthSpinner;
    private javax.swing.JSeparator mGridSeparator;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mGridVisibleCheckBox;
    private javax.swing.JLabel mHeightLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mHeightSpinner;
    private javax.swing.JLabel mIntervalLabel;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mSizeLabel;
    private javax.swing.JSeparator mSizeSeparator;
    private javax.swing.JLabel mWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mWidthSpinner;
    private javax.swing.JPanel mWindowPanel;
    // ϐ錾̏I//GEN-END:variables




    /**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGWindowDialog.TITLE );


		//
		// spinner
		//

//		this.mWidthSpinner.setDigitForRoundingOut(-2);
		this.mWidthSpinner.initProperties(
			new SpinnerNumberModel(
				SGDrawingWindow.PAPER_WIDTH_MIN_VALUE,
				SGDrawingWindow.PAPER_WIDTH_MIN_VALUE,
				SGDrawingWindow.PAPER_WIDTH_MAX_VALUE,
				SGDrawingWindow.PAPER_STEP_SIZE ),
			cm, 1, 1
		);
//		this.mWidthSpinner.setMinimumFractionDigits(1);
//		this.mWidthSpinner.setMaximumFractionDigits(1);

//		this.mHeightSpinner.setDigitForRoundingOut(-2);
		this.mHeightSpinner.initProperties(
			new SpinnerNumberModel(
				SGDrawingWindow.PAPER_HEIGHT_MIN_VALUE,
				SGDrawingWindow.PAPER_HEIGHT_MIN_VALUE,
				SGDrawingWindow.PAPER_HEIGHT_MAX_VALUE,
				SGDrawingWindow.PAPER_STEP_SIZE ),
			cm, 1, 1
		);
//		this.mHeightSpinner.setMinimumFractionDigits(1);
//		this.mHeightSpinner.setMaximumFractionDigits(1);

		this.mGridLinesIntervalSpinner.initProperties(
			new SpinnerNumberModel(
				SGDrawingWindow.GRID_INTERVAL_MIN_VALUE,
				SGDrawingWindow.GRID_INTERVAL_MIN_VALUE,
				SGDrawingWindow.GRID_INTERVAL_MAX_VALUE,
				SGDrawingWindow.GRID_INTERVAL_STEP_SIZE ),
			cm, 1, 2
		);
		this.mGridLinesWidthSpinner.initProperties(
			getLineWidthSpinnerNumberModel(), pt, 1, 2 );


		//
		// add action listeners
		//

		{
			this.mOKButton.addActionListener(this);
			this.mCancelButton.addActionListener(this);
			this.mPreviewButton.addActionListener(this);
		}

		this.mGridVisibleCheckBox.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mBackgroundColorButton;


		//
		// create component group
		//

		SGComponentGroupElement[] array = {
			new SGComponentGroupElement( this.mIntervalLabel ),
			new SGComponentGroupElement( this.mGridLinesIntervalSpinner ),
			new SGComponentGroupElement( this.mBottomLabel ),
			new SGComponentGroupElement( this.mGridLinesWidthSpinner ),
			new SGComponentGroupElement( this.mGridLinesColorLabel ),
			new SGComponentGroupElement( this.mGridLinesColorButton )
		};
		
		this.mGridVisibleComponentGroup.addElement( array );


		return true;
	}


	/**
	 * 
	 */
	private SGComponentGroup mGridVisibleComponentGroup = new SGComponentGroup();


	/**
	 * 
	 */
	public Number getPaperWidth()
	{
		return this.mWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getPaperHeight()
	{
		return this.mHeightSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Color getPaperColor()
	{
		return this.mBackgroundColorButton.getColor();
	}

	/**
	 * 
	 */    
	public Color getGridLineColor()
	{
		return this.mGridLinesColorButton.getColor();
	}

	/**
	 * 
	 * @return
	 */
	public Boolean isGridVisible()
	{
		return this.mGridVisibleCheckBox.getSelected();
	}

	/**
	 * 
	 */
	public Number getGridLineInterval()
	{
		return this.mGridLinesIntervalSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Number getGridLineWidth()
	{
		return this.mGridLinesWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public boolean setPaperWidth( final Object value )
	{
		return this.setValue( this.mWidthSpinner, value );
	}

	/**
	 * 
	 */
	public boolean setPaperHeight( final Object value )
	{
		return this.setValue( this.mHeightSpinner, value );
	}

	/**
	 * 
	 * @param b
	 * @return
	 */
	public boolean setGridVisible( final Boolean b )
	{
		this.mGridVisibleCheckBox.setSelected(b);
		this.setGridComponentEnabled(b);
		return true;
	}

	/**
	 * 
	 */
	public boolean setGridLineInterval( final Object value )
	{
		return this.setValue( this.mGridLinesIntervalSpinner, value );
	}

	/**
	 * 
	 */
	public boolean setGridLineWidth( final Object value )
	{
		return this.setValue( this.mGridLinesWidthSpinner, value );
	}

	/**
	 * 
	 */
	public boolean setPaperColor( final Color cl )
	{
		this.mBackgroundColorButton.setColor( cl );
		return true;
	}

	/**
	 * 
	 */
	public boolean setGridLineColor( final Color cl )
	{
		this.mGridLinesColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public ArrayList getColorSelectionButtonsList()
	{
		final ArrayList list = new ArrayList();
		list.add(this.mBackgroundColorButton);
		list.add(this.mGridLinesColorButton);
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getTextFieldComponentsList()
	{
		final ArrayList list = this.getFormattedTextFieldsListFromSpinners();
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public ArrayList getNumberTextFieldList()
	{
		ArrayList list = new ArrayList();
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();

		list.add( this.mWidthSpinner );
		list.add( this.mHeightSpinner );
		list.add( this.mGridLinesIntervalSpinner );
		list.add( this.mGridLinesWidthSpinner );

		return list;
	}



//	/**
//	 * 
//	 */
//	public SGDrawingWindow.WindowProperties getProperties()
//	{
//
//		SGDrawingWindow.WindowProperties p
//			= new SGDrawingWindow.WindowProperties();
//
//
//		// paper width
//		final Number width = this.getWindowWidth();
//		if( width==null )
//		{
//			SGUtility.showIllegalInputErrorMessageDialog( this );
//			return null;
//		}
//		else
//		{
//			p.setPaperWidth( width.floatValue()/SGIConstants.CM_POINT_RATIO );
//		}
//
//
//		// paper height
//		final Number height = this.getWindowHeight();
//		if( height==null )
//		{
//			SGUtility.showIllegalInputErrorMessageDialog( this );
//			return null;
//		}
//		else
//		{
//			p.setPaperHeight( height.floatValue()/SGIConstants.CM_POINT_RATIO );
//		}
//
//
//		// grid visible
//		final boolean visible = this.getWindowGridVisible();
//		p.setGridVisible( visible );
//
//
//		// grind line interval
//		final Number gridLineInterval = this.getWindowGridLinesInterval();
//		if( gridLineInterval==null )
//		{
//			SGUtility.showIllegalInputErrorMessageDialog( this );
//			return null;
//		}
//		else
//		{
//			p.setGridInterval( gridLineInterval.floatValue()/SGIConstants.CM_POINT_RATIO );
//		}
//
//
//		// grid line width
//		final Number gridLineWidth = this.getWindowGridLinesWidth();
//		if( gridLineWidth==null )
//		{
//			SGUtility.showIllegalInputErrorMessageDialog( this );
//			return null;
//		}
//		else
//		{
//			p.setGridLineWidth( gridLineWidth.floatValue() );
//		}
//
//
//		// grid line color
//		Color gridLineColor = this.getWindowGridLinesColor();
//		p.setGridColor( gridLineColor );
//
//
//		//
//		Color bgColor = this.getWindowBackgroundColor();
//		p.setBackGroundColor( bgColor );
//
//
//		return p;
//	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();

		if( source.equals( this.mGridVisibleCheckBox ) )
		{
			this.setGridVisible( this.isGridVisible() );
		}
		
	}


	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setGridComponentEnabled( final Boolean flag )
	{
		boolean b = true;
		if( flag!=null )
		{
			b = flag.booleanValue();
		}

		this.setGridComponentEnabled(b);

		return true;
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setGridComponentEnabled( final boolean b )
	{
//		this.mIntervalLabel.setEnabled(b);
//		this.mGridLinesIntervalSpinner.setEnabled(b);
//		this.mBottomLabel.setEnabled(b);
//		this.mGridLinesWidthSpinner.setEnabled(b);
//		this.mGridLinesColorLabel.setEnabled(b);
//		this.mGridLinesColorButton.setEnabled(b);

		this.mGridVisibleComponentGroup.setEnabled(b);

		if( this.mGridLinesColorButton.equals( this.mFocusedColorSetButton ) )
		{
			this.mFocusedColorSetButton = this.mBackgroundColorButton;
			this.setColorButtonBorder( true );
		}

		return true;
	}



	/**
	 * 
	 */
	public boolean setDialogProperty()
	{
		ArrayList list = this.mPropertyDialogObserverList;

		SGIWindowDialogObserver wnd0
			= (SGIWindowDialogObserver)list.get(0);

		final float width0 = wnd0.getPaperWidth();
		final float height0 = wnd0.getPaperHeight();
		final float gridInterval0 = wnd0.getGridLineInterval();
		final float gridLineWidth0 = wnd0.getGridLineWidth();
		final boolean gridVisible0 = wnd0.isGridLineVisible();
		final Color paperColor0 = wnd0.getPaperColor();
		final Color gridLineColor0 = wnd0.getGridLineColor();

		Float width = new Float( width0 );
		Float height = new Float( height0 );
		Float gridInterval = new Float( gridInterval0 );
		Float gridLineWidth = new Float( gridLineWidth0 );
		Boolean gridVisible = Boolean.valueOf( gridVisible0 );
		Color paperColor = paperColor0;
		Color gridLineColor = gridLineColor0;

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIWindowDialogObserver wnd1
					= (SGIWindowDialogObserver)list.get(ii);
				final float width1 = wnd1.getPaperWidth();
				if( width0!=width1 )
				{
					width = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIWindowDialogObserver wnd1
					= (SGIWindowDialogObserver)list.get(ii);
				final float height1 = wnd1.getPaperHeight();
				if( height0!=height1 )
				{
					height = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIWindowDialogObserver wnd1
					= (SGIWindowDialogObserver)list.get(ii);
				final float gridInterval1 = wnd1.getGridLineInterval();
				if( gridInterval0!=gridInterval1 )
				{
					gridInterval = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIWindowDialogObserver wnd1
					= (SGIWindowDialogObserver)list.get(ii);
				final float gridLineWidth1 = wnd1.getGridLineWidth();
				if( gridLineWidth0!=gridLineWidth1 )
				{
					gridLineWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIWindowDialogObserver wnd1
					= (SGIWindowDialogObserver)list.get(ii);
				final boolean gridLineVisible1 = wnd1.isGridLineVisible();
				if( gridVisible0!=gridLineVisible1 )
				{
					gridVisible = null;
					break;
				}
			}
			
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIWindowDialogObserver wnd1
					= (SGIWindowDialogObserver)list.get(ii);
				final Color paperColor1 = wnd1.getPaperColor();
				if( paperColor0.equals(paperColor1) == false )
				{
					paperColor = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIWindowDialogObserver wnd1
					= (SGIWindowDialogObserver)list.get(ii);
				final Color gridLineColor1 = wnd1.getGridLineColor();
				if( gridLineColor0.equals(gridLineColor1) == false )
				{
					gridLineColor = null;
					break;
				}
			}

		}



		//
		if( width!=null )
		{
			width = new Float( width.floatValue()*CM_POINT_RATIO );
		}
		this.setPaperWidth( width );

		if( height!=null )		
		{
			height = new Float( height.floatValue()*CM_POINT_RATIO );
		}
		this.setPaperHeight( height );

		if( gridInterval!=null )
		{
			gridInterval = new Float( gridInterval.floatValue()*CM_POINT_RATIO );
		}
		this.setGridLineInterval( gridInterval );
		
		this.setGridLineWidth( gridLineWidth );

		this.setGridVisible( gridVisible );

		this.setPaperColor( paperColor );

		this.setGridLineColor( gridLineColor );


		this.setColorButtonBorder(true);

		return true;
	}



	/**
	 * 
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{
		SGIWindowDialogObserver wnd = (SGIWindowDialogObserver)l;

		Number width = this.getPaperWidth();
		if( width!=null )
		{
			wnd.setPaperWidth( width.floatValue()/SGIConstants.CM_POINT_RATIO );
		}

		Number height = this.getPaperHeight();
		if( height!=null )
		{
			wnd.setPaperHeight( height.floatValue()/SGIConstants.CM_POINT_RATIO );
		}
		
		Number interval = this.getGridLineInterval();
		if( interval!=null )
		{
			wnd.setGridLineInterval( interval.floatValue()/SGIConstants.CM_POINT_RATIO );
		}

		Number lineWidth = this.getGridLineWidth();
		if( lineWidth!=null )
		{
			wnd.setGridLineWidth( lineWidth.floatValue() );		
		}
		
		Boolean gridVisible = this.isGridVisible();
		if( gridVisible!=null )
		{
			wnd.setGridLineVisible( gridVisible.booleanValue() );
		}
		
		Color paperColor = this.getPaperColor();
		if( paperColor!=null )
		{
			wnd.setPaperColor( paperColor );
		}
		
		Color lineColor = this.getGridLineColor();
		if( lineColor!=null )
		{
			wnd.setGridLineColor( lineColor );
		}
		
		return true;
	}


}

