
package jp.riken.brain.ni.samuraigraph.base;

import javax.swing.JTextField;
import javax.swing.text.Document;

/**
 *
 *
 */
public class SGTextField extends JTextField
{
	/**
	 * 
	 */
	public SGTextField()
	{
		super();
	}

	/**
	 * @param columns
	 */
	public SGTextField(int columns)
	{
		super(columns);
	}

	/**
	 * @param text
	 */
	public SGTextField(String text)
	{
		super(text);
	}

	/**
	 * @param text
	 * @param columns
	 */
	public SGTextField(String text, int columns)
	{
		super(text, columns);
	}

	/**
	 * @param doc
	 * @param text
	 * @param columns
	 */
	public SGTextField(Document doc, String text, int columns)
	{
		super(doc, text, columns);
	}



	/**
	 * 
	 */
	private boolean mIndeterminate = false;


	/**
	 * 
	 * @return
	 */
	public boolean isIndeterminate()
	{
		return this.mIndeterminate;
	}


	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setIndeterminate( final boolean b )
	{
		this.mIndeterminate = b;
		return true;
	}


	/**
	 * 
	 * @param str
	 */
	public void setText( final String str )
	{
		String str2;
		if( str==null )
		{
			this.setIndeterminate(true);
			str2 = "";
		}
		else
		{
			this.setIndeterminate(false);
			str2 = str;
		}
		super.setText(str2);
	}


	/**
	 * 
	 */
	public String getText()
	{
		String str = super.getText();
		if( this.isIndeterminate() )
		{
			if( str.equals("") )
			{
				return null;
			}
			else
			{
				return str;
			}
		}
		else
		{
			return str;
		}
	}


	/**
	 * 
	 * @param tf
	 * @return
	 */
	public boolean hasValidText()
	{
		String text = this.getText();
		if( text==null )
		{
			if( this.isIndeterminate() == false )
			{
				return false;
			}
		}
		else
		{
			if( text.equals("") )
			{
				return false;
			}
		}

		return true;		
	}


}

