
package jp.riken.brain.ni.samuraigraph.base;

import java.util.TreeMap;

/**
 *
 */
public class SGRootManager
{


	private SGIRootObject mRoot;



	/**
	 * Map of figures which belongs to this window.
	 */
	private TreeMap mFigureMap = new TreeMap();



	/**
	 * 
	 *
	 */
	public SGRootManager( SGIRootObject obj )
	{
		super();
		this.mRoot = obj;
	}



	/**
	 * 
	 * @param id
	 * @return
	 */
	public SGFigure getFigure( final int id )
	{
		return (SGFigure)this.mFigureMap.get( new Integer(id) );
	}


	/**
	 * 
	 */
	public TreeMap getFigureMap()
	{
		return this.mFigureMap;
	}


	/**
	 * 
	 * @param id
	 * @param figure
	 * @return
	 */
	public boolean putFigure( final int id, final SGFigure figure )
	{
		this.mFigureMap.put( new Integer(id), figure );
		return true;
	}


	/**
	 * 
	 * @param figure
	 * @return
	 */
	public boolean removeFigure( final SGFigure figure )
	{
		this.mFigureMap.remove( new Integer( figure.getID() ) );
		return true;
	}

}


