/*
 * 쐬: 2004/07/05
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;

import javax.print.attribute.standard.MediaSize;


/**
 * @author kuromaru
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public interface SGDefaultValues extends SGIConstants
{
	/**
	 * Window
	 */

	// width of viewport
	public static final float DEFAULT_VIEWPORT_WIDTH = 20.0f/SGIConstants.CM_POINT_RATIO;

	// paper width
	public static final float PAPER_WIDTH
		= ( MediaSize.ISO.A4.getX( MediaSize.MM )/10.0f )/SGIConstants.CM_POINT_RATIO;

	// paper height
	public static final float PAPER_HEIGHT
		= ( MediaSize.ISO.A4.getY( MediaSize.MM )/10.0f )/SGIConstants.CM_POINT_RATIO;

	// paper color
	public static final Color WINDOW_PAPER_COLOR = new Color( 255, 255, 255 );
	
	// grid line width
	public static final float GRID_LINE_WIDTH = 1.0f;
	
	// grid interval
	public static final float GRID_INTERVAL = 1.0f/SGIConstants.CM_POINT_RATIO;

	// grid line color
	public static final Color GRID_LINE_COLOR = new Color( 233, 215, 215 );

	// grid visible
	public static final boolean GRID_VISIBLE = true;

	// font of ruler
	public static final float RULER_FONT_SIZE = 11.0f;
	public static final String RULER_FONT_NAME = "Serif";
	public static final String RULER_FONT_STYLE = "Plain";


	
	/**
	 * Figure
	 */

	/**
	 * 
	 */
	public static final float DEFAULT_FIGURE_WIDTH = 15.0f/SGIConstants.CM_POINT_RATIO;

	//
	// Space
	//

	// to Scale
	public static final float SPACE_AXIS_LINE_AND_NUMBER = 0.20f/SGIConstants.CM_POINT_RATIO;

	// to Title
	public static final float SPACE_NUMBER_AND_TITLE = 0.20f/SGIConstants.CM_POINT_RATIO;

	// background color to white
	public static final Color FIGURE_BACKGROUND_COLOR = new Color( 255, 255, 255 );

	// bounding box visible
	public static final boolean FIGURE_BOUNDING_BOX_VISIBLE = false;

	// rubber banding enabled
	public static final boolean FIGURE_RUBBER_BANDING_ENABLED = true;

	// snap to grid
	public static final boolean FIGURE_SNAP_TO_GRID = true;


	/**
	 * Axis
	 */

	//
	// Axis Line
	//
	
	// Axis width
	public static final float AXIS_LINE_WIDTH = 1.5f;

	// Scale width
	public static final float SCALE_LINE_WIDTH = 1.5f;

	// Scale length
	public static final float SCALE_LINE_LENGTH = 0.25f/SGIConstants.CM_POINT_RATIO;

	// Color
	public static final Color AXIS_LINE_COLOR = new Color( 0, 0, 0 );



	//
	// Frame
	//

	// Visible
	public static final boolean AXIS_FRAME_LINE_VISIBLE = false;

	// Width
	public static final float AXIS_FRAME_LINE_WIDTH = 1.5f;

	// Color
	public static final Color AXIS_FRAME_LINE_COLOR = new Color( 0, 0, 0 );



	//
	// Font
	//

	// Font
	public static final String AXIS_FONT_NAME = "Serif";
	public static final String AXIS_FONT_STYLE = "Plain";
	
	// Size
	public static final float AXIS_FONT_SIZE = 16.0f;
	
	// Color
	public static final Color AXIS_STRING_COLOR = new Color( 0, 0, 0 );



	//
	// Visible Axis
	//

	public static final boolean BOTTOM_AXIS_VISIBLE = true;
	public static final boolean TOP_AXIS_VISIBLE = false;
	public static final boolean LEFT_AXIS_VISIBLE = true;
	public static final boolean RIGHT_AXIS_VISIBLE = false;



	//
	// Title
	//

	public static final String BOTTOM_AXIS_TITLE = "X Label";
	public static final String TOP_AXIS_TITLE = "X Label";
	public static final String LEFT_AXIS_TITLE = "Y Label";
	public static final String RIGHT_AXIS_TITLE = "Y Label";



	//
	// Scale
	//

	// Number
	public static final boolean NUMBER_VISIBLE = true;
	public static final boolean NUMBER_INTEGER = false;

	// Scale Line
	public static final boolean SCALE_LINE_VISIBLE = true;
	public static final boolean SCALE_LINE_INNER = true;


	
	//
	// Grid Lines
	//

	// Visible
	public static final boolean AXIS_GRID_LINE_VISIBLE = false;
	
	// Width
	public static final float AXIS_GRID_LINE_WIDTH = 1.0f;
	
	// Type
	public static final String AXIS_GRID_LINE_TYPE = "Dotted";
	
	// Color
	public static final Color AXIS_GRID_LINE_COLOR = new Color( 0, 0, 0 );
	
	

	/**
	 * SXY-Data
	 */

	//
	// Scale Reference
	//

	public static final String SCALE_REFERENCE = SGIAxisElement.LEFT_BOTTOM;


	//
	// Line
	//

	// Visible
	public static final boolean LINE_VISIBLE = true;

	// Width
	public static final float LINE_WIDTH = 1.0f;

	// Type
	public static final String LINE_TYPE = "Solid";

	// Color
	public static final Color LINE_COLOR = new Color( 0, 0, 0 );


	//
	// Symbol
	//

	// Visible
	public static final boolean SYMBOL_VISIBLE = false;

	// Type
	public static final String SYMBOL_TYPE = "Circle";

	// Body Size
	public static final float SYMBOL_SIZE = 0.3f/SGIConstants.CM_POINT_RATIO;

	// Body Color
	public	static final Color SYMBOL_BODY_COLOR = new Color( 255, 255, 255 );

	// Line Width
	public static final float SYMBOL_LINE_WIDTH = 1.0f;

	// Line Color
	public	static final Color SYMBOL_LINE_COLOR = new Color( 0, 0, 0 );



	//
	// Bar
	//

	// Visible
	public static final boolean BAR_VISIBLE = false;
	
	// Baseline
	public static final double BAR_BASELINE_VALUE = 0.0;

	// Body Width
	public static final float BAR_WIDTH = 0.5f/SGIConstants.CM_POINT_RATIO;

	// Body Color
	public static final Color BAR_COLOR = new Color( 255, 255, 255 );

	// Line Width
	public static final float BAR_LINE_WIDTH = 0.5f;

	// Line Color
	public static final Color BAR_LINE_COLOR = new Color( 0, 0, 0 );



	//
	// Error Bar
	//

	// Visible
	public static final boolean ERROR_BAR_VISIBLE = true;

	// Symbol Type
	public static final String ERROR_BAR_SYMBOL_TYPE = "Transverse Line";

	// Symbol Color
	public static final Color ERROR_BAR_COLOR = new Color( 0, 0, 0 );

	// Symbol Size
	public static final float ERROR_BAR_SYMBOL_SIZE = 0.25f/SGIConstants.CM_POINT_RATIO;

	// Line Width
	public static final float ERROR_BAR_LINE_WIDTH = 1.0f;

	// Style
	public static final String ERROR_BAR_STYLE = "Bothsides";



	//
	// Tick Label
	//

	// Visible
	public static final boolean TICK_LABEL_VISIBLE = false;

	// Font
	public static final String TICK_LABEL_FONT_NAME = "Serif";
	public static final String TICK_LABEL_FONT_STYLE = "Plain";

	// Size
	public static final float TICK_LABEL_FONT_SIZE = 16.0f;

	// Color
	public static final Color TICK_LABEL_COLOR = new Color( 0, 0, 0 );

	// Angle
	public static final String TICK_LABEL_ANGLE = "Horizontal";




	/**
	 * Legend
	 */

	// Visible
	public static final boolean LEGEND_VISIBLE = true;
	// Opaque
	public static final boolean LEGEND_TRANSPARENT = false;

	//
	// String
	//
	// Font
	public static final String LEGEND_FONT_NAME = "Serif";
	public static final String LEGEND_FONT_STYLE = "Plain";

	// Size
	public static final float LEGEND_FONT_SIZE = 16.0f;

	// Color
	public static final Color LEGEND_STRING_COLOR= new Color( 0, 0, 0 );

	//
	// Frame
	//
	
	// Visible
	public static final boolean LEGEND_FRAME_VISIBLE = true;

	// Width
	public static final float LEGEND_FRAME_WIDTH = 0.5f;

	// Color
	public static final Color LEGEND_FRAME_COLOR= new Color( 0, 0, 0 );

	// BG Color
	public static final Color LEGEND_BACKGROUND_COLOR= new Color( 255, 255, 255 );

	//
	// Axes
	//
	
	// Horizontal Axis
	public static final String LEGEND_HORIZONTAL_AXIS = SGIAxisElement.AXIS_BOTTOM;
	
	// Perpendicular Axis
	public static final String LEGEND_PERPENDICULAR_AXIS = SGIAxisElement.AXIS_LEFT;



	/**
	 * Label
	 */

	// Font
	public static final String LABEL_FONT_NAME = "Serif";
	public static final String LABEL_FONT_STYLE = "Plain";

	// Size
	public static final float LABEL_FONT_SIZE = 16.0f;

	// Color
	public static final Color LABEL_COLOR= new Color( 0, 0, 0 );

	// Angle
	public static final float LABEL_ANGLE = 0.0f;
	
	// Horizontal Axis
	public static final String LABEL_HORIZONTAL_AXIS = SGIAxisElement.AXIS_BOTTOM;
	
	// Perpendicular Axis
	public static final String LABEL_PERPENDICULAR_AXIS = SGIAxisElement.AXIS_LEFT;



	/**
	 * Timing Line
	 */

	// Type
	public static final String TIMING_LINE_TYPE = "Solid";

	// Width
	public static final float TIMING_LINE_WIDTH = 1.0f;

	// Color
	public static final Color TIMING_LINE_COLOR= new Color( 0, 0, 0 );




	//
	// Axis Break Symbol
	// 

	// Length
	public static final float AXIS_BREAK_LENGTH = 1.0f/SGIConstants.CM_POINT_RATIO;

	// Interval
	public static final float AXIS_BREAK_INTERVAL = 0.50f/SGIConstants.CM_POINT_RATIO;

	// Line Width
	public static final float AXIS_BREAK_LINE_WIDTH = 1.5f;

	// Angle
	public static final float AXIS_BREAK_ANGLE = 0.0f;

	// Distortion
	public static final float AXIS_BREAK_DISTORTION = 0.50f;

	// Horizontal
	public static final boolean AXIS_BREAK_FOR_HORIZONTAL = true;

	// Line Color
	public static final Color AXIS_BREAK_LINE_COLOR = new Color( 0, 0, 0 );

	// Inner Color
	public static final Color AXIS_BREAK_INNER_COLOR = new Color( 255, 255, 255 );

	// Horizontal Axis
	public static final String AXIS_BREAK_HORIZONTAL_AXIS = SGIAxisElement.AXIS_BOTTOM;
	
	// Perpendicular Axis
	public static final String AXIS_BREAK_PERPENDICULAR_AXIS = SGIAxisElement.AXIS_LEFT;

	
	
	//
	// Grid in Figure
	//

	// Visible
	public static final boolean FIGURE_GRID_VISIBLE = false;

	// Line Width
	public static final float FIGURE_GRID_LINE_WIDTH = 1.0f;

	// Line Type
	public static final String FIGURE_GRID_LINE_TYPE = "Dotted";

	// Line Color
	public static final Color FIGURE_GRID_COLOR = Color.GRAY;

	// Horizontal Axis
	public static final String FIGURE_GRID_HORIZONTAL_AXIS = SGIAxisElement.AXIS_BOTTOM;
	
	// Perpendicular Axis
	public static final String FIGURE_GRID_PERPENDICULAR_AXIS = SGIAxisElement.AXIS_LEFT;

}

