/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesRadioButtonManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISignificantDifferenceDialogObserver;

public class SGSignificantDifferenceSymbolDialog
extends SGPropertyDialog {
    public static final String TITLE = "Significant Difference Symbol Properties";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private SGColorSelectionButton mColorButton;
    private JLabel mColorLabel;
    private JPanel mCommonPanel;
    private JLabel mFontFamilyLabel;
    private JComboBox mFontNameComboBox;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JComboBox mFontStyleComboBox;
    private JLabel mFontStyleLabel;
    private JLabel mFormLabel;
    private JSeparator mFormSeparator;
    private JLabel mHorizontalYValueLabel;
    private SGTextField mHorizontalYValueTextField;
    private JRadioButton mLeftBottomRadioButton;
    private JLabel mLeftSpaceLabel;
    private JRadioButton mLeftTopRadioButton;
    private JLabel mLeftXValueLabel;
    private SGTextField mLeftXValueTextField;
    private JLabel mLeftYValueLabel;
    private SGTextField mLeftYValueTextField;
    private SGCheckBox mLineVisibleCheckBox;
    private JLabel mLineWidthLabel1;
    private JLabel mLineWidthLabel2;
    private SGSpinner mLineWidthSpinner;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviewButton;
    private JRadioButton mRightBottomRadioButton;
    private JLabel mRightSpaceLabel;
    private JRadioButton mRightTopRadioButton;
    private JLabel mRightXValueLabel;
    private SGTextField mRightXValueTextField;
    private JLabel mRightYValueLabel;
    private SGTextField mRightYValueTextField;
    private JLabel mScaleReferenceLabel1;
    private JLabel mScaleReferenceLabel2;
    private JLabel mSpaceLabel;
    private SGSpinner mSpaceSpinner;
    private JLabel mStringLabel;
    private JSeparator mStringSeparator;
    private SGTextField mTextField;
    private JLabel mTextLabel;
    private SGTwoAxesRadioButtonManager mAxesButtonGroup = null;

    public SGSignificantDifferenceSymbolDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mPanel = new JPanel();
        this.mFontFamilyLabel = new JLabel();
        this.mFontStyleComboBox = new JComboBox();
        this.mFontSizeLabel = new JLabel();
        this.mLineWidthSpinner = new SGSpinner();
        this.mColorLabel = new JLabel();
        this.mLineWidthLabel1 = new JLabel();
        this.mLineWidthLabel2 = new JLabel();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontNameComboBox = new JComboBox();
        this.mColorButton = new SGColorSelectionButton();
        this.mFormLabel = new JLabel();
        this.mFormSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mSpaceLabel = new JLabel();
        this.mSpaceSpinner = new SGSpinner();
        this.mLocationLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mStringLabel = new JLabel();
        this.mStringSeparator = new JSeparator();
        this.mLeftXValueLabel = new JLabel();
        this.mLeftXValueTextField = new SGTextField();
        this.mLeftYValueLabel = new JLabel();
        this.mLeftYValueTextField = new SGTextField();
        this.mRightXValueLabel = new JLabel();
        this.mRightXValueTextField = new SGTextField();
        this.mRightYValueLabel = new JLabel();
        this.mRightYValueTextField = new SGTextField();
        this.mHorizontalYValueLabel = new JLabel();
        this.mHorizontalYValueTextField = new SGTextField();
        this.mLineVisibleCheckBox = new SGCheckBox();
        this.mFontStyleLabel = new JLabel();
        this.mTextLabel = new JLabel();
        this.mTextField = new SGTextField();
        this.mCommonPanel = new JPanel();
        this.mLeftTopRadioButton = new JRadioButton();
        this.mLeftBottomRadioButton = new JRadioButton();
        this.mRightTopRadioButton = new JRadioButton();
        this.mRightBottomRadioButton = new JRadioButton();
        this.mScaleReferenceLabel2 = new JLabel();
        this.mScaleReferenceLabel1 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new BevelBorder(0));
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mPanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mLineWidthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel1.setText("Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        this.mPanel.add((Component)this.mLineWidthLabel1, gridBagConstraints);
        this.mLineWidthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel2.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLineWidthLabel2, gridBagConstraints);
        this.mFontSizeSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mPanel.add((Component)this.mColorButton, gridBagConstraints);
        this.mFormLabel.setFont(new Font("Dialog", 3, 12));
        this.mFormLabel.setText("Form");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFormLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 45, 5, 5);
        this.mPanel.add((Component)this.mFormSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.mPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mSpaceLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceLabel.setText("Space");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mSpaceLabel, gridBagConstraints);
        this.mSpaceSpinner.setFont(new Font("Dialog", 0, 12));
        this.mSpaceSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mSpaceSpinner, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 4, 5, 5);
        this.mPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        this.mStringLabel.setFont(new Font("Dialog", 3, 12));
        this.mStringLabel.setText("String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mStringLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 50, 5, 5);
        this.mPanel.add((Component)this.mStringSeparator, gridBagConstraints);
        this.mLeftXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mLeftXValueLabel.setText("Left X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLeftXValueLabel, gridBagConstraints);
        this.mLeftXValueTextField.setColumns(6);
        this.mLeftXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLeftXValueTextField, gridBagConstraints);
        this.mLeftYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mLeftYValueLabel.setText("Left Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLeftYValueLabel, gridBagConstraints);
        this.mLeftYValueTextField.setColumns(6);
        this.mLeftYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLeftYValueTextField, gridBagConstraints);
        this.mRightXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mRightXValueLabel.setText("Right X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mRightXValueLabel, gridBagConstraints);
        this.mRightXValueTextField.setColumns(6);
        this.mRightXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mRightXValueTextField, gridBagConstraints);
        this.mRightYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mRightYValueLabel.setText("Right Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mRightYValueLabel, gridBagConstraints);
        this.mRightYValueTextField.setColumns(6);
        this.mRightYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mRightYValueTextField, gridBagConstraints);
        this.mHorizontalYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mHorizontalYValueLabel.setText("Horizontal Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mHorizontalYValueLabel, gridBagConstraints);
        this.mHorizontalYValueTextField.setColumns(6);
        this.mHorizontalYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mHorizontalYValueTextField, gridBagConstraints);
        this.mLineVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mLineVisibleCheckBox.setText("Line Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.mPanel.add((Component)this.mLineVisibleCheckBox, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        this.mTextLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextLabel.setText("Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mTextLabel, gridBagConstraints);
        this.mTextField.setColumns(16);
        this.mTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLeftTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftTopRadioButton, gridBagConstraints);
        this.mLeftBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftBottomRadioButton, gridBagConstraints);
        this.mRightTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightTopRadioButton, gridBagConstraints);
        this.mRightBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightBottomRadioButton, gridBagConstraints);
        this.mScaleReferenceLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel2, gridBagConstraints);
        this.mScaleReferenceLabel1.setFont(new Font("Dialog", 1, 12));
        this.mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mLineVisibleCheckBox)) {
            this.setLineComponentEnabled(this.mLineVisibleCheckBox.isSelected());
        }
    }

    public String getText() {
        return this.mTextField.getText();
    }

    public Number getLeftXValue() {
        return this.getNumber(this.mLeftXValueTextField);
    }

    public Number getLeftYValue() {
        return this.getNumber(this.mLeftYValueTextField);
    }

    public Number getRightXValue() {
        return this.getNumber(this.mRightXValueTextField);
    }

    public Number getRightYValue() {
        return this.getNumber(this.mRightYValueTextField);
    }

    public Number getHorizontalYValue() {
        return this.getNumber(this.mHorizontalYValueTextField);
    }

    public Boolean getLineVisible() {
        return this.mLineVisibleCheckBox.getSelected();
    }

    public Number getSpace() {
        return this.mSpaceSpinner.getNumber();
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontName() {
        return (String)this.mFontNameComboBox.getSelectedItem();
    }

    public int getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getColor() {
        return this.mColorButton.getColor();
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public boolean setText(String string) {
        this.mTextField.setText(string);
        return true;
    }

    public boolean setLeftXValue(Object object) {
        return this.setValue(this.mLeftXValueTextField, object);
    }

    public boolean setLeftYValue(Object object) {
        return this.setValue(this.mLeftYValueTextField, object);
    }

    public boolean setRightXValue(Object object) {
        return this.setValue(this.mRightXValueTextField, object);
    }

    public boolean setRightYValue(Object object) {
        return this.setValue(this.mRightYValueTextField, object);
    }

    public boolean setHorizontalYValue(Object object) {
        return this.setValue(this.mHorizontalYValueTextField, object);
    }

    public void setLineVisible(Boolean bl) {
        this.mLineVisibleCheckBox.setSelected(bl);
        if (bl != null) {
            this.setLineComponentEnabled(bl);
        } else {
            this.setLineComponentEnabled(true);
        }
    }

    private void setLineComponentEnabled(boolean bl) {
        this.mLineWidthLabel1.setEnabled(bl);
        this.mLineWidthLabel2.setEnabled(bl);
        this.mLineWidthSpinner.setEnabled(bl);
    }

    public boolean setSpace(Object object) {
        return this.setValue(this.mSpaceSpinner, object);
    }

    public boolean setFontSize(Object object) {
        return this.setValue(this.mFontSizeSpinner, object);
    }

    public boolean setFontName(String string) {
        this.mFontNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontStyle(Integer n) {
        String string = null;
        if (n != null) {
            string = SGUtilityText.getFontStyleName(n);
        }
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setColor(Color color) {
        this.mColorButton.setColor(color);
        return true;
    }

    public boolean setLineWidth(Object object) {
        return this.setValue(this.mLineWidthSpinner, object);
    }

    public ArrayList getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mColorButton);
        return arrayList;
    }

    public ArrayList getTextFieldComponentsList() {
        ArrayList arrayList = this.getFormattedTextFieldsListFromSpinners();
        arrayList.addAll(this.getNumberTextFieldList());
        arrayList.add(this.mTextField);
        return arrayList;
    }

    public ArrayList getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mLeftXValueTextField);
        arrayList.add(this.mLeftYValueTextField);
        arrayList.add(this.mRightXValueTextField);
        arrayList.add(this.mRightYValueTextField);
        arrayList.add(this.mHorizontalYValueTextField);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mSpaceSpinner);
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = SGUtility.getAvailableFontNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        this.mAxesButtonGroup = new SGTwoAxesRadioButtonManager(this.mLeftBottomRadioButton, this.mLeftTopRadioButton, this.mRightBottomRadioButton, this.mRightTopRadioButton, new JRadioButton());
        this.mSpaceSpinner.initProperties(new SpinnerNumberModel(0.1, -1.0, 1.0, 0.05), "cm", 1, 2);
        this.mFontSizeSpinner.initProperties(SGSignificantDifferenceSymbolDialog.getFontSizeSpinnerNumberModel(), "pt", 1, 2);
        this.mLineWidthSpinner.initProperties(SGSignificantDifferenceSymbolDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mLineVisibleCheckBox.addActionListener(this);
        this.mFocusedColorSetButton = this.mColorButton;
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        return true;
    }

    public boolean setDialogProperty() {
        SGSignificantDifferenceSymbolDialog sGSignificantDifferenceSymbolDialog = this;
        ArrayList arrayList = this.mPropertyDialogObserverList;
        if (!this.mAxesButtonGroup.setRadioButton(arrayList)) {
            return false;
        }
        SGISignificantDifferenceDialogObserver sGISignificantDifferenceDialogObserver = (SGISignificantDifferenceDialogObserver)arrayList.get(0);
        String string = sGISignificantDifferenceDialogObserver.getText();
        double d = sGISignificantDifferenceDialogObserver.getHorizontalYValue();
        double d2 = sGISignificantDifferenceDialogObserver.getLeftXValue();
        double d3 = sGISignificantDifferenceDialogObserver.getLeftYValue();
        double d4 = sGISignificantDifferenceDialogObserver.getRightXValue();
        double d5 = sGISignificantDifferenceDialogObserver.getRightYValue();
        boolean bl = sGISignificantDifferenceDialogObserver.isLineVisible();
        float f = sGISignificantDifferenceDialogObserver.getSpace();
        float f2 = sGISignificantDifferenceDialogObserver.getLineWidth();
        String string2 = sGISignificantDifferenceDialogObserver.getFontName();
        float f3 = sGISignificantDifferenceDialogObserver.getFontSize();
        int n = sGISignificantDifferenceDialogObserver.getFontStyle();
        Color color = sGISignificantDifferenceDialogObserver.getColor();
        String string3 = string;
        Double d6 = new Double(d);
        Double d7 = new Double(d2);
        Double d8 = new Double(d3);
        Double d9 = new Double(d4);
        Double d10 = new Double(d5);
        Boolean bl2 = bl;
        Float f4 = new Float(f);
        Float f5 = new Float(f2);
        String string4 = string2;
        Float f6 = new Float(f3);
        Integer n2 = new Integer(n);
        Color color2 = color;
        if (arrayList.size() > 1) {
            String string5;
            SGISignificantDifferenceDialogObserver sGISignificantDifferenceDialogObserver2;
            int n3;
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                string5 = sGISignificantDifferenceDialogObserver2.getText();
                if (string.equals(string5)) continue;
                string3 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                double d11 = sGISignificantDifferenceDialogObserver2.getHorizontalYValue();
                if (d == d11) continue;
                d6 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                double d12 = sGISignificantDifferenceDialogObserver2.getLeftXValue();
                if (d2 == d12) continue;
                d7 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                double d13 = sGISignificantDifferenceDialogObserver2.getLeftYValue();
                if (d3 == d13) continue;
                d8 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                double d14 = sGISignificantDifferenceDialogObserver2.getRightXValue();
                if (d4 == d14) continue;
                d9 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                double d15 = sGISignificantDifferenceDialogObserver2.getRightYValue();
                if (d5 == d15) continue;
                d10 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                boolean bl3 = sGISignificantDifferenceDialogObserver2.isLineVisible();
                if (bl == bl3) continue;
                bl2 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                float f7 = sGISignificantDifferenceDialogObserver2.getSpace();
                if (f == f7) continue;
                f4 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                float f8 = sGISignificantDifferenceDialogObserver2.getLineWidth();
                if (f2 == f8) continue;
                f5 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                string5 = sGISignificantDifferenceDialogObserver2.getFontName();
                if (string2.equals(string5)) continue;
                string4 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                float f9 = sGISignificantDifferenceDialogObserver2.getFontSize();
                if (f3 == f9) continue;
                f6 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                int n4 = sGISignificantDifferenceDialogObserver2.getFontStyle();
                if (n == n4) continue;
                n2 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGISignificantDifferenceDialogObserver2 = (SGISignificantDifferenceDialogObserver)arrayList.get(n3);
                Color color3 = sGISignificantDifferenceDialogObserver2.getColor();
                if (color.equals(color3)) continue;
                color2 = null;
                break;
            }
        }
        this.setText(string3);
        this.setHorizontalYValue(d6);
        this.setLeftXValue(d7);
        this.setLeftYValue(d8);
        this.setRightXValue(d9);
        this.setRightYValue(d10);
        this.setLineVisible(bl2);
        if (f4 != null) {
            f4 = new Float(f4.floatValue() * 0.035277776f);
        }
        this.setSpace(f4);
        this.setLineWidth(f5);
        this.setFontName(string4);
        this.setFontSize(f6);
        this.setFontStyle(n2);
        this.setColor(color2);
        this.setColorButtonBorder(true);
        return true;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        SGISignificantDifferenceDialogObserver sGISignificantDifferenceDialogObserver = (SGISignificantDifferenceDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxesButtonGroup.getXAxisConfiguration();
        int n2 = this.mAxesButtonGroup.getYAxisConfiguration();
        String string = this.getText();
        Number number = this.getHorizontalYValue();
        Number number2 = this.getLeftXValue();
        Number number3 = this.getLeftYValue();
        Number number4 = this.getRightXValue();
        Number number5 = this.getRightYValue();
        Boolean bl = this.getLineVisible();
        Number number6 = this.getSpace();
        Number number7 = this.getLineWidth();
        Number number8 = this.getFontSize();
        String string2 = this.getFontName();
        int n3 = this.getFontStyle();
        Color color = this.getColor();
        if (!sGISignificantDifferenceDialogObserver.hasValidHorizontalYValue(n2, number)) {
            return false;
        }
        if (!sGISignificantDifferenceDialogObserver.hasValidLeftXValue(n, number2)) {
            return false;
        }
        if (!sGISignificantDifferenceDialogObserver.hasValidLeftYValue(n2, number3)) {
            return false;
        }
        if (!sGISignificantDifferenceDialogObserver.hasValidRightXValue(n, number4)) {
            return false;
        }
        if (!sGISignificantDifferenceDialogObserver.hasValidRightYValue(n2, number5)) {
            return false;
        }
        if (n != -1 & n2 != -1) {
            sGISignificantDifferenceDialogObserver.setAxisConfiguration(n, n2);
        }
        if (string != null) {
            sGISignificantDifferenceDialogObserver.setText(string);
        }
        if (number != null) {
            sGISignificantDifferenceDialogObserver.setHorizontalYValue(number.doubleValue());
        }
        if (number2 != null) {
            sGISignificantDifferenceDialogObserver.setLeftXValue(number2.doubleValue());
        }
        if (number3 != null) {
            sGISignificantDifferenceDialogObserver.setLeftYValue(number3.doubleValue());
        }
        if (number4 != null) {
            sGISignificantDifferenceDialogObserver.setRightXValue(number4.doubleValue());
        }
        if (number5 != null) {
            sGISignificantDifferenceDialogObserver.setRightYValue(number5.doubleValue());
        }
        if (bl != null) {
            sGISignificantDifferenceDialogObserver.setLineVisible(bl);
        }
        if (number6 != null) {
            sGISignificantDifferenceDialogObserver.setSpace(number6.floatValue() / 0.035277776f);
        }
        if (number7 != null) {
            sGISignificantDifferenceDialogObserver.setLineWidth(number7.floatValue());
        }
        if (number8 != null) {
            sGISignificantDifferenceDialogObserver.setFontSize(number8.floatValue());
        }
        if (string2 != null) {
            sGISignificantDifferenceDialogObserver.setFontName(string2);
        }
        if (n3 != -1) {
            sGISignificantDifferenceDialogObserver.setFontStyle(n3);
        }
        if (color != null) {
            sGISignificantDifferenceDialogObserver.setColor(color);
        }
        return true;
    }

    protected boolean hasValidInputValues() {
        if (!super.hasValidInputValues()) {
            return false;
        }
        if (!this.mTextField.hasValidText()) {
            this.setInputErrorMessage("The input value is illegal.");
            return false;
        }
        return true;
    }
}

