/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import jp.riken.brain.ni.samuraigraph.base.SGImagePanel;

public class SGSplashWindow
extends JWindow {
    private static final int verpos_r = 375;
    private static final int verpos_t = 125;
    private static final int verpos_b = 155;
    public static final int PROGRESS_VALUE_MIN = 0;
    public static final int PROGRESS_VALUE_MAX = 100;
    private JProgressBar mProgressBar;

    public SGSplashWindow(Image image) {
        if (image == null) {
            throw new NullPointerException("img==null");
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2);
        SGImagePanel sGImagePanel = new SGImagePanel();
        sGImagePanel.setImage(image);
        sGImagePanel.setPreferredSize(new Dimension(n, n2));
        sGImagePanel.setLayout(null);
        JLabel jLabel = new JLabel("Version 0.8.0");
        Font font = new Font("Serif", 1, 14);
        jLabel.setFont(font);
        Dimension dimension2 = jLabel.getPreferredSize();
        int n3 = dimension2.width;
        int n4 = dimension2.height;
        int n5 = 375 - n3;
        int n6 = (30 - n4) / 2 + 125;
        jLabel.setBounds(n5, n6, n3, n4);
        JProgressBar jProgressBar = new JProgressBar(0, 100);
        jProgressBar.setValue(0);
        jProgressBar.setSize(350, 12);
        jProgressBar.setLocation(25, 258);
        this.mProgressBar = jProgressBar;
        sGImagePanel.add(jLabel);
        sGImagePanel.add(jProgressBar);
        this.getContentPane().add(sGImagePanel);
    }

    public void setProgressValue(float f) {
        int n;
        if (this.mProgressBar == null) {
            return;
        }
        JProgressBar jProgressBar = this.mProgressBar;
        int n2 = (int)(0.0f + f * 100.0f);
        int n3 = n = jProgressBar.getValue();
        if (n == n2) {
            return;
        }
        if (n < n2) {
            do {
                jProgressBar.setValue(n3);
            } while (++n3 <= n2);
        } else {
            do {
                jProgressBar.setValue(n3);
            } while (--n3 >= n2);
        }
    }
}

