
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;


/**
 *
 *
 */
public class SGSingleAxisRadioButtonManager
{

	/**
	 * A ButtonGroup to set radio buttons.
	 */
	private ButtonGroup mButtonGroup = new ButtonGroup();

	/**
	 * Radio button objects.
	 */
	private JRadioButton mTopRadioButton = null;
	private JRadioButton mBottomRadioButton = null;
	private JRadioButton mLeftRadioButton = null;
	private JRadioButton mRightRadioButton = null;
	private JRadioButton mNoAxisSelectionRadioButton = null;



	/**
	 * Construct a manager object.
	 * @param t - the top radio button
	 * @param b - the bottom radio button
	 * @param l - the left radio button
	 * @param r - the right radio button
	 * @param n - no-selection radio button
	 */
	public SGSingleAxisRadioButtonManager(
		JRadioButton t, JRadioButton b,
		JRadioButton l, JRadioButton r,
		JRadioButton n	)
	{
		super();

		// set to attributes
		this.mTopRadioButton = t;
		this.mBottomRadioButton = b;
		this.mLeftRadioButton = l;
		this.mRightRadioButton = r;
		this.mNoAxisSelectionRadioButton = n;
		
		// add to ButtonGroup
		ButtonGroup bg = this.mButtonGroup;
		bg.add( t );
		bg.add( b );
		bg.add( l );
		bg.add( r );
		bg.add( n );
	}


	/**
	 * 
	 */
	public boolean isTopSelected()
	{
		return this.mTopRadioButton.isSelected();
	}


	/**
	 * 
	 */
	public boolean isBottomSelected()
	{
		return this.mBottomRadioButton.isSelected();
	}

	/**
	 * 
	 */
	public boolean isLeftSelected()
	{
		return this.mLeftRadioButton.isSelected();
	}

	/**
	 * 
	 */
	public boolean isRightSelected()
	{
		return this.mRightRadioButton.isSelected();
	}



	/**
	 * 
	 * @param axisList
	 * @return
	 */
	private boolean setRadioButton_( final ArrayList axisList )
	{

		final int num = axisList.size();
		if( num==0 )
		{
			return false;
		}

		Integer axis0 = (Integer)axisList.get(0);
		Integer axis = axis0;

		if( num>1 )
		{
			for( int ii=1; ii<num; ii++ )
			{
				Integer axis1 = (Integer)axisList.get(ii);
				if( axis0.equals(axis1)==false )
				{
					axis = null;
					break;
				}
			}
		}


		// set radio buttons
		if( axis==null )
		{
			this.mNoAxisSelectionRadioButton.setSelected(true);
		}
		else
		{
			this.setRadioButton( axis.intValue() );
		}

		return true;
	}



	/**
	 * set radio buttons with given configuration
	 */
	private boolean setRadioButton( final int config )
	{

		switch( config )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				this.mBottomRadioButton.setSelected( true );
				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				this.mTopRadioButton.setSelected( true );
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_1 :
			{
				this.mLeftRadioButton.setSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_2 :
			{
				this.mRightRadioButton.setSelected(true);
				break;
			}
						
			default :
			{
				throw new IllegalArgumentException("");
			}
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public int getAxisConfiguration()
	{
		int config = -1;
		if( this.mNoAxisSelectionRadioButton.isSelected() == false )
		{
			if( this.isTopSelected() )
			{
				config = SGIAxisElement.AXIS_HORIZONTAL_2;
			}
			else if( this.isBottomSelected() )
			{
				config = SGIAxisElement.AXIS_HORIZONTAL_1;
			}
			else if( this.isLeftSelected() )
			{
				config = SGIAxisElement.AXIS_PERPENDICULAR_1;
			}
			else if( this.isRightSelected() )
			{
				config = SGIAxisElement.AXIS_PERPENDICULAR_2;
			}
		}

		return config;
	}


	/**
	 * 
	 * @param observerList
	 * @return
	 */
	public boolean setRadioButton( ArrayList observerList )
	{
		final int len = observerList.size();

		ArrayList axisList = new ArrayList( len );
		
		for( int ii=0; ii<len; ii++ )
		{
			SGISingleAxisHolder l
				= (SGISingleAxisHolder)observerList.get(ii);
			axisList.add( new Integer( l.getAxisConfiguration() ) );
		}

		if( this.setRadioButton_( axisList ) == false )
		{
			return false;
		}

		return true;
	}




}

