/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGIBarConstants;

public abstract class SGDrawingElementBar
extends SGDrawingElementRectangle
implements SGIBarConstants,
SGIDrawingElementConstants {
    protected double mBaselineValue;

    public double getBaselineValue() {
        return this.mBaselineValue;
    }

    public boolean setBaselineValue(double d) {
        this.mBaselineValue = d;
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementBar)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementBar sGDrawingElementBar = (SGDrawingElementBar)sGDrawingElement;
        this.setBaselineValue(sGDrawingElementBar.getBaselineValue());
        return true;
    }

    public SGProperties getProperties() {
        BarProperties barProperties = new BarProperties();
        this.getProperties(barProperties);
        return barProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        BarProperties barProperties = (BarProperties)sGProperties;
        barProperties.setBarWidth(this.getRectangleWidth());
        barProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        barProperties.setEdgeLineColor(this.getEdgeLineColor());
        barProperties.setBaselineValue(this.getBaselineValue());
        return true;
    }

    public static class BarProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mWidth = 0.0f;
        private float mEdgeLineWidth = 0.0f;
        private Color mEdgeLineColor = null;
        private double mBaselineValue = 0.0;

        public boolean equals(Object object) {
            if (!(object instanceof BarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            BarProperties barProperties = (BarProperties)object;
            if (this.mWidth != barProperties.mWidth) {
                return false;
            }
            if (this.mEdgeLineWidth != barProperties.mEdgeLineWidth) {
                return false;
            }
            if (!this.mEdgeLineColor.equals(barProperties.mEdgeLineColor)) {
                return false;
            }
            return this.mBaselineValue == barProperties.mBaselineValue;
        }

        public Float getBarWidth() {
            return new Float(this.mWidth);
        }

        public Float getEdgeLineWidth() {
            return new Float(this.mEdgeLineWidth);
        }

        public Color getEdgeLineColor() {
            return this.mEdgeLineColor;
        }

        public Double getBaselineValue() {
            return new Double(this.mBaselineValue);
        }

        public boolean setBarWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.mWidth = f;
            return true;
        }

        public boolean setBaselineValue(double d) {
            this.mBaselineValue = d;
            return true;
        }

        public boolean setEdgeLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.mEdgeLineWidth = f;
            return true;
        }

        public boolean setEdgeLineColor(Color color) {
            if (color == null) {
                return false;
            }
            this.mEdgeLineColor = color;
            return true;
        }
    }
}

