
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;


/**
 * The base class of arrow object.
 */
public abstract class SGDrawingElementArrow extends SGDrawingElement
	implements SGIArrowConstants, SGIDrawingElementConstants
{
	
	/**
	 * A line object.
	 */
	protected SGDrawingElementLine mLine;
	

	/**
	 * A symbol object for the start head.
	 */	
	protected SGDrawingElementSymbol mStartHead;


	/**
	 * A symbol object for the end head.
	 */
	protected SGDrawingElementSymbol mEndHead;
	
	
	/**
	 * Open angle of the arrow.
	 */
	protected float mHeadOpenAngle;


	/**
	 * Close angle of the arrow.
	 */
	protected float mHeadCloseAngle;


	/**
	 * Default constructor.
	 */
	public SGDrawingElementArrow()
	{
		super();
	}


	/**
	 * 
	 */
	public boolean setColor( final Color cl )
	{
		super.setColor( cl );
		this.mLine.setColor( cl );
		this.mStartHead.setColor( cl );
		this.mStartHead.setLineColor( cl );
		this.mEndHead.setColor( cl );
		this.mEndHead.setLineColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setColorList( final ArrayList cList )
	{
		super.setColorList( cList );
		this.mLine.setColorList( cList );
		this.mStartHead.setColorList( cList );
		this.mEndHead.setColorList( cList );
		
		Color cl = (Color)cList.get(0);
		this.mStartHead.setLineColor( cl );
		this.mEndHead.setLineColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setMagnification( final float ratio )
	{
		super.setMagnification( ratio );
		this.mLine.setMagnification( ratio );
		this.mStartHead.setMagnification( ratio );
		this.mEndHead.setMagnification( ratio );
		return true;
	}



	/**
	 *
	 */
	public boolean setTermPoints( final SGTuple2f start, final SGTuple2f end )
	{
		this.mLine.setTermPoints(start,end);
		this.mStartHead.setLocation( start );
		this.mEndHead.setLocation( end );
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public SGTuple2f getStart()
	{
		return this.mLine.getStart();
	}
	

	/**
	 * 
	 * @return
	 */
	public SGTuple2f getEnd()
	{
		return this.mLine.getEnd();
	}


	/**
	 * 
	 * @param width
	 * @return
	 */
	public boolean setLineWidth( final float width )
	{
		this.mLine.setLineWidth( width );
		return true;
	}


	/**
	 * 
	 * @param type
	 * @return
	 */
	public boolean setLineType( final int type )
	{
		this.mLine.setLineType( type );
		return true;
	}


	/**
	 * 
	 */
	public boolean setHeadSize( final float size )
	{
		this.mStartHead.setSize( size );
		this.mEndHead.setSize( size );
		return true;
	}



	/**
	 * 
	 */
	public boolean setHeadOpenAngle( final float angle )
	{
		this.mHeadOpenAngle = angle;
		return true;
	}


	/**
	 * 
	 */
	public boolean setHeadCloseAngle( final float angle )
	{
		this.mHeadCloseAngle = angle;
		return true;
	}


	/**
	 * 
	 */
	public boolean setHeadLineWidth( final float width )
	{
		this.mStartHead.setLineWidth( width );
		this.mEndHead.setLineWidth( width );
		return true;
	}


//	/**
//	 * 
//	 */
//	public boolean setHeadLineColor( final Color color )
//	{
//		this.mStartHead.setLineColor( color );
//		this.mEndHead.setLineColor( color );
//		return true;
//	}


	/**
	 * 
	 */
	public boolean setStartHeadType( final int type )
	{
		this.mStartHead.setType( type );
		return true;
	}


	/**
	 * 
	 */
	public boolean setEndHeadType( final int type )
	{
		this.mEndHead.setType( type );
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public float getLineWidth()
	{
		return this.mLine.getLineWidth();
	}


	/**
	 * 
	 * @return
	 */
	public int getLineType()
	{
		return this.mLine.getLineType();
	}


	/**
	 * 
	 * @return
	 */
	public float getHeadSize()
	{
		return this.mStartHead.getSize();
	}


	/**
	 * 
	 * @return
	 */
	public float getHeadOpenAngle()
	{
		return this.mHeadOpenAngle;
	}


	/**
	 * 
	 * @return
	 */
	public float getHeadCloseAngle()
	{
		return this.mHeadCloseAngle;
	}


	/**
	 * 
	 * @return
	 */
	public float getHeadLineWidth()
	{
		return this.mStartHead.getLineWidth();
	}


//	/**
//	 * 
//	 * @return
//	 */
//	public Color getHeadLineColor()
//	{
//		return this.mStartHead.getLineColor();
//	}


	/**
	 * 
	 * @return
	 */
	public int getStartHeadType()
	{
		return this.mStartHead.getType();
	}


	/**
	 * 
	 * @return
	 */
	public int getEndHeadType()
	{
		return this.mEndHead.getType();
	}



	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementArrow) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementArrow arrow = (SGDrawingElementArrow)element;
		this.setHeadSize( arrow.getHeadSize() );
		this.setHeadOpenAngle( arrow.getHeadOpenAngle() );
		this.setHeadCloseAngle( arrow.getHeadCloseAngle() );
		this.setHeadLineWidth( arrow.getHeadLineWidth() );
//		this.setHeadLineColor( arrow.getHeadLineColor() );
		this.setStartHeadType( arrow.getStartHeadType() );
		this.setEndHeadType( arrow.getEndHeadType() );

		return true;
	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		ArrowProperties p = new ArrowProperties();
		this.getProperties(p);
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;

		if( ( p instanceof ArrowProperties ) == false ) return false;

		if( super.getProperties(p) == false ) return false;

		ArrowProperties ap = (ArrowProperties)p;

		ap.setLineWidth( this.getLineWidth() );
		ap.setLineType( this.getLineType() );
		ap.setHeadSize( this.getHeadSize() );
		ap.setHeadOpenAngle( this.getHeadOpenAngle() );
		ap.setHeadCloseAngle( this.getHeadCloseAngle() );
		ap.setHeadLineWidth( this.getHeadLineWidth() );
//		ap.setHeadLineColor( this.getHeadLineColor() );
		ap.setStartHeadType( this.getStartHeadType() );
		ap.setEndHeadType( this.getEndHeadType() );

		return true;
	}



	/**
	 * 
	 *
	 */
	public static class ArrowProperties extends DrawingElementProperties
	{

		private SGDrawingElementLine.LineProperties mLineProperties
			= new SGDrawingElementLine.LineProperties();

		private SGDrawingElementSymbol.SymbolProperties mSymbolProperties
			= new SGDrawingElementSymbol.SymbolProperties();

		private int mEndHeadType;

		private double mHeadOpenAngle;

		private double mHeadCloseAngle;


		/**
		 * 
		 */
		public boolean equals( Object obj )
		{
			if( ( obj instanceof ArrowProperties ) == false ) return false;
			if( super.equals(obj) == false ) return false;

			ArrowProperties p = (ArrowProperties)obj;

			if( this.mLineProperties.equals( p.mLineProperties) == false ) return false;
			if( this.mSymbolProperties.equals( p.mSymbolProperties ) == false) return false;
			if( this.mEndHeadType!=p.mEndHeadType ) return false;
			if( this.mHeadOpenAngle!=p.mHeadOpenAngle ) return false;
			if( this.mHeadCloseAngle!=p.mHeadCloseAngle ) return false;

			return true;
		}


		public Float getLineWidth()
		{
			return this.mLineProperties.getLineWidth();
		}

		public Integer getLineType()
		{
			return this.mLineProperties.getLineType();
		}

		public Float getHeadLineWidth()
		{
			return this.mSymbolProperties.getLineWidth();
		}

		public Float getHeadSize()
		{
			return this.mSymbolProperties.getSize();
		}

//		public Color getHeadLineColor()
//		{
//			return this.mSymbolProperties.getLineColor();
//		}

		public Integer getStartHeadType()
		{
			return this.mSymbolProperties.getSymbolType();
		}

		public Integer getEndHeadType()
		{
			return new Integer( this.mEndHeadType );
		}

		public Float getHeadOpenAngle()
		{
			return new Float( this.mHeadOpenAngle );
		}

		public Float getHeadCloseAngle()
		{
			return new Float( this.mHeadCloseAngle );
		}


		public void setLineWidth( final float width )
		{
			this.mLineProperties.setLineWidth( width );
		}
		
		public void setLineType( final int type )
		{
			this.mLineProperties.setLineType( type );
		}

		public void setHeadLineWidth( final float width )
		{
			this.mSymbolProperties.setLineWidth( width );
		}

		public void setStartHeadType( final int num )
		{
			this.mSymbolProperties.setSymbolType( num );
		}

		public void setEndHeadType( final int num )
		{
			this.mEndHeadType = num;
		}

		public void setHeadSize( final float size )
		{
			this.mSymbolProperties.setSize( size );
		}

		public void setColor( final Color cl )
		{
			super.setColor( cl );
			this.mLineProperties.setColor( cl );
			this.mSymbolProperties.setColor( cl );
			this.mSymbolProperties.setLineColor( cl );
		}

		public void setColorList( final ArrayList cList )
		{
			super.setColorList( cList );
			this.mLineProperties.setColorList( cList );
			this.mSymbolProperties.setColorList( cList );
			
			Color cl = (Color)cList.get(0);
			this.mSymbolProperties.setLineColor(cl);
		}

//		public void setHeadLineColor( final Color cl )
//		{
//			this.mSymbolProperties.setColor( cl );
//			this.mSymbolProperties.setLineColor( cl );
//		}

		public void setHeadOpenAngle( final float value )
		{
			this.mHeadOpenAngle = value;
		}

		public void setHeadCloseAngle( final float value )
		{
			this.mHeadCloseAngle = value;
		}
		
	}

}

