
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;


/**
 * A ButtonGroup class for axes.
 *
 */
public class SGTwoAxesRadioButtonManager
{
	/**
	 * A ButtonGroup to set radio buttons.
	 */
	private ButtonGroup mButtonGroup = new ButtonGroup();

	/**
	 * Radio button objects.
	 */
	private JRadioButton mLeftBottomRadioButton = null;
	private JRadioButton mLeftTopRadioButton = null;
	private JRadioButton mRightBottomRadioButton = null;
	private JRadioButton mRightTopRadioButton = null;
	private JRadioButton mNoAxisSelectionRadioButton = null;


	/**
	 * Construct a manager object.
	 * @param lb - the left-bottom radio button
	 * @param lt - the left-top radio button
	 * @param rb - the right-bottom radio button
	 * @param rt - the right-top radio button
	 * @param no - no-selection radio button
	 */
	public SGTwoAxesRadioButtonManager(
		JRadioButton lb, JRadioButton lt,
		JRadioButton rb, JRadioButton rt,
		JRadioButton no	)
	{
		super();

		// set to attributes		
		this.mLeftBottomRadioButton = lb;
		this.mLeftTopRadioButton = lt;
		this.mRightBottomRadioButton = rb;
		this.mRightTopRadioButton = rt;
		this.mNoAxisSelectionRadioButton = no;
		
		// add to ButtonGroup
		ButtonGroup bg = this.mButtonGroup;
		bg.add( lb );
		bg.add( lt );
		bg.add( rb );
		bg.add( rt );
		bg.add( no );
	}


	/**
	 * 
	 */
	public boolean isLeftTopSelected()
	{
		return this.mLeftTopRadioButton.isSelected();
	}


	/**
	 * 
	 */
	public boolean isLeftBottomSelected()
	{
		return this.mLeftBottomRadioButton.isSelected();
	}

	/**
	 * 
	 */
	public boolean isRightTopSelected()
	{
		return this.mRightTopRadioButton.isSelected();
	}

	/**
	 * 
	 */
	public boolean isRightBottomSelected()
	{
		return this.mRightBottomRadioButton.isSelected();
	}



	/**
	 * 
	 * @param xAxisList
	 * @param yAxisList
	 * @return
	 */
	private boolean setRadioButton( final ArrayList xAxisList, final ArrayList yAxisList )
	{
		if( xAxisList.size()!=yAxisList.size() )
		{
			throw new IllegalArgumentException();
		}

		final int num = xAxisList.size();

		if( num==0 )
		{
			return false;
		}

		Integer xAxis0 = (Integer)xAxisList.get(0);
		Integer yAxis0 = (Integer)yAxisList.get(0);
		Integer xAxis = xAxis0;
		Integer yAxis = yAxis0;

		if( num>1 )
		{
			for( int ii=1; ii<num; ii++ )
			{
				Integer xAxis1 = (Integer)xAxisList.get(ii);
				if( xAxis0.equals(xAxis1)==false )
				{
					xAxis = null;
					break;
				}
			}
			for( int ii=1; ii<num; ii++ )
			{
				Integer yAxis1 = (Integer)yAxisList.get(ii);
				if( yAxis0.equals(yAxis1)==false )
				{
					yAxis = null;
					break;
				}
			}
		}


		// set radio buttons
		if( xAxis==null | yAxis==null )
		{
			this.mNoAxisSelectionRadioButton.setSelected(true);
		}
		else
		{
			this.setRadioButton( xAxis.intValue(), yAxis.intValue() );
		}

		return true;
	}



	/**
	 * set radio buttons with given configuration
	 */
	private boolean setRadioButton( final int configX, final int configY )
	{

		switch( configX )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftBottomRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightBottomRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftTopRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightTopRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			default :
			{
				return false;
			}
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public int getXAxisConfiguration()
	{
		int config = -1;

		// set the related axes
		if( this.mNoAxisSelectionRadioButton.isSelected() == false )
		{
			if( this.isLeftBottomSelected() | this.isRightBottomSelected() )
			{
				config = SGIAxisElement.AXIS_HORIZONTAL_1;
			}
			else if( this.isLeftTopSelected() | this.isRightTopSelected() )
			{
				config = SGIAxisElement.AXIS_HORIZONTAL_2;
			}
		}

		return config;		
	}


	/**
	 * 
	 * @return
	 */
	public int getYAxisConfiguration()
	{
		int config = -1;

		// set the related axes
		if( this.mNoAxisSelectionRadioButton.isSelected() == false )
		{
			if( this.isLeftBottomSelected() | this.isLeftTopSelected() )
			{
				config = SGIAxisElement.AXIS_PERPENDICULAR_1;
			}
			else if( this.isRightBottomSelected() | this.isRightTopSelected() )
			{
				config = SGIAxisElement.AXIS_PERPENDICULAR_2;
			}
		}

		return config;		
	}



	/**
	 * 
	 * @param observerList
	 * @return
	 */
	public boolean setRadioButton( ArrayList observerList )
	{
		final int len = observerList.size();
		ArrayList xAxisList = new ArrayList( len );
		ArrayList yAxisList = new ArrayList( len );
		
		for( int ii=0; ii<len; ii++ )
		{
			SGITwoAxesHolder l
				= (SGITwoAxesHolder)observerList.get(ii);
			xAxisList.add( new Integer( l.getXAxisConfiguration() ) );
			yAxisList.add( new Integer( l.getYAxisConfiguration() ) );
		}

		if( this.setRadioButton( xAxisList, yAxisList ) == false )
		{
			return false;
		}

		return true;
	}


}


