
package jp.riken.brain.ni.samuraigraph.base;


import java.util.ArrayList;


/**
 * XỸC^tF[X
 */

public interface SGIAxisElement extends SGIFigureElement
{

	/**
	 * 
	 */
	public static final int TWO_DIMENSIONAL_AXIS = 0;


	/**
	 * 
	 */
	public static final int THREE_DIMENSIONAL_AXIS = 1;


	/**
	 * 
	 */
	public static final int AXIS_HORIZONTAL_1 = 0;


	/**
	 * 
	 */
	public static final int AXIS_HORIZONTAL_2 = 1;


	/**
	 * 
	 */
	public static final int AXIS_PERPENDICULAR_1 = 2;


	/**
	 * 
	 */
	public static final int AXIS_PERPENDICULAR_2 = 3;



	/**
	 * 
	 */
	public static final int VIEW_XY = 0;


	/**
	 * 
	 */
	public static final int VIEW_XZ = 1;


	/**
	 * 
	 */
	public static final int VIEW_YZ = 2;



	/**
	 * 
	 */
	public static final int LOCATION_XAXIS_1 = 1;

	/**
	 * 
	 */
	public static final int LOCATION_XAXIS_2 = 2;

	/**
	 * 
	 */
	public static final int LOCATION_XAXIS_3 = 3;

	/**
	 * 
	 */
	public static final int LOCATION_XAXIS_4 = 4;

	/**
	 * 
	 */
	public static final int LOCATION_YAXIS_1 = 5;

	/**
	 * 
	 */
	public static final int LOCATION_YAXIS_2 = 6;

	/**
	 * 
	 */
	public static final int LOCATION_YAXIS_3 = 7;

	/**
	 * 
	 */
	public static final int LOCATION_YAXIS_4 = 8;

	/**
	 * 
	 */
	public static final int LOCATION_ZAXIS_1 = 9;

	/**
	 * 
	 */
	public static final int LOCATION_ZAXIS_2 = 10;

	/**
	 * 
	 */
	public static final int LOCATION_ZAXIS_3 = 11;

	/**
	 * 
	 */
	public static final int LOCATION_ZAXIS_4 = 12;


	/**
	 * 
	 */
	public static final String AXIS_TOP = "Top";

	/**
	 * 
	 */
	public static final String AXIS_BOTTOM = "Bottom";

	/**
	 * 
	 */
	public static final String AXIS_LEFT = "Left";

	/**
	 * 
	 */
	public static final String AXIS_RIGHT = "Right";

	
	
	public static final String LEFT_TOP = "Left-Top";
	public static final String LEFT_BOTTOM = "Left-Bottom";
	public static final String RIGHT_TOP = "Right-Top";
	public static final String RIGHT_BOTTOM = "Right-Bottom";
	
	
	
	
	/**
	 * 
	 * @param element
	 */
	public void setTimingLineElement( SGITimingLineElement element );


	
	/**
	 * 
	 * @return
	 */
	public ArrayList getXAxisList();


	/**
	 * 
	 * @return
	 */
	public ArrayList getYAxisList();


	/**
	 * 
	 * @return
	 */
	public ArrayList getZAxisList();



	/**
	 * 
	 * @return
	 */
	public ArrayList getAxisList();


	/**
	 * 
	 */
	public ArrayList getHorizontalAxisList();


	/**
	 * 
	 */
	public ArrayList getPerpendicularAxisList();


	/**
	 * 
	 */
	public ArrayList getNormalAxisList();

	
	/**
	 * 
	 * @param axis
	 * @return
	 */
	public boolean isHorizontal( final SGAxis axis );

	
	/**
	 * 
	 * @param axis
	 * @return
	 */
	public boolean isPerpendicular( final SGAxis axis );
	

	/**
	 * 
	 * @param axis
	 * @return
	 */
	public boolean isNormal( final SGAxis axis );


	
	/**
	 * Returns string representation of the axis location.
	 * @param config	One of the following parameters:
	 * AXIS_HORIZONTAL_1, AXIS_HORIZONTAL_2, AXIS_PERPENDICULAR_1 and AXIS_PERPENDICULAR_2
	 * @return	String representation of the axis location
	 */
	public String getAxisLocation( final int config );
	
	
	/**
	 * Returns string representation of the axis location.
	 * @param axis	an axis
	 * @return	String representation of the axis location
	 */
	public String getAxisLocation( final SGAxis axis );

	
	/**
	 * 
	 * @param axis
	 * @return
	 */
	public int getConfigurationInCube( final SGAxis axis );


	/**
	 * 
	 */
	public int getConfigurationInPlane( final SGAxis axis );


	/**
	 * 
	 */
	public SGAxis getAxisInCube( final int configurationInCube );


	/**
	 * 
	 */
	public SGAxis getAxisInPlane( final int configurationInPlane );


	/**
	 * 
	 * @return
	 */
	public int getConfiguration( final int configurationInCube );


	/**
	 * 
	 */
	public String getConfigurationString( final int configuraionInCube );


	/**
	 * 
	 */
	public int getConfigurationInCube( final String str );


	/**
	 * 
	 * @param str
	 * @return
	 */
	public SGAxis getAxis( final String str );

	

	/**
	 * 
	 * @return
	 */
	public boolean setSpaceAxisLineAndNumber( final float space );


	/**
	 * 
	 * @return
	 */
	public boolean setSpaceNumberAndTitle( final float space );




	/**
	 * 
	 */
	public float getSpaceAxisLineAndNumber();


	/**
	 * 
	 */
	public float getSpaceNumberAndTitle();



	/**
	 * 
	 */
	public float getNumberFontSize();


	/**
	 * 
	 */
	public float getTitleFontSize();


	/**
	 * 
	 */
	public boolean addTimingLine( final int x, final int y );



	public static final String TAG_NAME_AXES = "Axes";
//	public static final String KEY_VIEW_DIRECTION = "ViewDirection";
	public static final String KEY_LINE_COLOR = "LineColor";
	public static final String KEY_AXIS_LINE_WIDTH = "AxisLineWidth";
	public static final String KEY_TICK_MARK_WIDTH = "TickMarkWidth";
	public static final String KEY_TICK_MARK_LENGTH = "TickMarkLength";
	public static final String KEY_FRAME_LINE_VISIBLE = "FrameLineVisible";
	public static final String KEY_FRAME_LINE_WIDTH = "FrameLineWidth";
	public static final String KEY_FRAME_LINE_COLOR = "FrameLineColor";
	public static final String KEY_AXIS_STRING_COLOR = "StringColor";
	
	public static final String TAG_NAME_AXIS = "Axis";
	public static final String KEY_POSITION = "Position";
	public static final String KEY_AXIS_MIN_VALUE = "MinValue";
	public static final String KEY_AXIS_MAX_VALUE = "MaxValue";
	public static final String KEY_AXIS_SCALE_TYPE = "ScaleType";
	public static final String KEY_STEP_VALUE = "StepValue";
	public static final String KEY_BASELINE_VALUE = "BaselineValue";
	public static final String KEY_AUTO_CALC_NUMBER = "AutomaticCalculationOfTick";
	public static final String KEY_TITLE_TEXT = "Title";
	public static final String KEY_AXIS_VISIBLE = "AxisVisible";
	public static final String KEY_TITLE_VISIBLE = "TitleVisible";
	public static final String KEY_TICK_MARK_VISIBLE = "TickMarkVisible";
	public static final String KEY_NUMBER_VISIBLE = "NumberVisible";
	public static final String KEY_TICK_MARK_INSIDE = "TickMarkInside";
	public static final String KEY_NUMBER_INTEGER = "NumberInteger";
	public static final String KEY_EXPONENT_VISIBLE = "Exponent";
	public static final String KEY_EXPONENT_VALUE = "ExponentValue";

	public static final String KEY_GRID_LINE_VISIBLE = "GridLineVisible";
	public static final String KEY_GRID_LINE_WIDTH = "GridLineWidth";
	public static final String KEY_GRID_LINE_STYLE = "GridLineStyle";
	public static final String KEY_GRID_LINE_COLOR = "GridLineColor";
	

}

