
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.util.ArrayList;


/**
 *
 */

public abstract class SGDrawingElement
	implements SGIDrawingElementConstants
{

	/**
	 * zoom̔{
	 */
	protected float mMagnification = 1.0f;


	/**
	 *
	 */
	protected ArrayList mColorList = new ArrayList();



	/**
	 * 
	 */
	protected boolean mVisibleFlag = true;



	/**
	 *
	 */
	public SGDrawingElement()
	{
	}


	/**
	 *
	 */
	public abstract boolean contains( final int x, final int y );



	/**
	 *
	 */
	public boolean zoom( final float ratio )
	{
		this.setMagnification( ratio );
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean isVisible()
	{
		return this.mVisibleFlag;
	}


	/**
	 * 
	 * @param b
	 */
	public void setVisible( final boolean b )
	{
		this.mVisibleFlag = b;
	}



	/**
	 * 
	 */
	public boolean setMagnification( final float mag )
	{
		mMagnification = mag;
		return true;
	}



	/**
	 * 
	 */
	public boolean setColorList( final ArrayList colorList )
	{
		mColorList = new ArrayList( colorList );
		return true;
	}


	/**
	 * 
	 */
	public boolean setColor( final Color color )
	{
		ArrayList list = new ArrayList();
		list.add( color );
		this.setColorList( list );
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean addColor( final Color color )
	{
		if( mColorList == null )
		{
			mColorList = new ArrayList();
		}
		mColorList.add(color);
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public ArrayList getColorList()
	{
		return mColorList;
	}


	/**
	 * 
	 */
	public Color getColor( final int index )
	{
		if( mColorList == null )
		{
			return null;
		}

		if( index >= mColorList.size() )
		{
			return null;
		}

		return (Color)mColorList.get(index);
	}


	/**
	 * 
	 */
	public float getMagnification()
	{
		return this.mMagnification;
	}



	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		this.setVisible( element.isVisible() );
		this.setMagnification( element.getMagnification() );
		this.setColorList( element.getColorList() );

		return true;
	}




	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
//System.out.println("setProperties");

		if( ( p instanceof DrawingElementProperties ) == false ) return false;

		DrawingElementProperties dp = (DrawingElementProperties)p;

		final Boolean b = dp.isVisible();
		if( b==null )
		{
			return false;
		}
		this.setVisible( b.booleanValue() );


		final ArrayList cList = dp.getColorList();
		if( cList==null )
		{
			return false;
		}
		this.setColorList( cList );


		return true;
	}



	/**
	 * 
	 * @return
	 */
	public SGProperties getProperties()
	{
		final DrawingElementProperties p = new DrawingElementProperties();
		if( this.getProperties(p) == false )
		{
			return null;
		}
		return p;
	}



	/**
	 * 
	 * @param p
	 * @return
	 */
	public boolean getProperties( final SGProperties p )
	{
		if( ( p instanceof DrawingElementProperties ) == false )
		{
			return false;
		}
		
		final DrawingElementProperties dp = (DrawingElementProperties)p;
		dp.setVisible( this.isVisible() );
		dp.setColorList( this.getColorList() );

		return true;
	}





	/**
	 * Property of Drawing Element.
	 */
	public static class DrawingElementProperties extends SGProperties
	{

		private boolean mVisible = true;
		private ArrayList mColorList = new ArrayList();


		/**
		 * 
		 */
		public DrawingElementProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{

			if( ( obj instanceof DrawingElementProperties ) == false ) return false;

			DrawingElementProperties p = (DrawingElementProperties)obj;

			if( this.mVisible!=p.mVisible ) return false;

			if( this.mColorList.equals(p.mColorList) == false ) return false;

			return true;
		}


		public Boolean isVisible()
		{
			return Boolean.valueOf( this.mVisible );
		}

		public ArrayList getColorList()
		{
			return this.mColorList;
		}

		public void setVisible( final boolean b )
		{
			this.mVisible = b;
		}


		public void setColor( final Color cl )
		{
			if( cl==null )
			{
				new IllegalArgumentException("cl==null");
			}
			ArrayList list = new ArrayList();
			list.add( cl );
			this.setColorList( list );
		}

		public void setColorList( final ArrayList list )
		{
			if( list==null )
			{
				new IllegalArgumentException("list==null");
			}
			if( list.size()==0 )
			{
				new IllegalArgumentException("list.size()==0");
			}
			this.mColorList.clear();
			this.mColorList.addAll( list );
		}

	}

}

