/*
 * Created on 2004/06/18
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;


/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class SGWizardDialog extends SGDialog
{

	/**
	 * 
	 */
//	protected JButton mOKButton = new JButton(OK_BUTTON_TEXT);


	/**
	 * 
	 */
//	protected JButton mPreviousButton = new JButton(PREVIOUS_BUTTON_TEXT);


	/**
	 * 
	 */
//	protected JButton mNextButton = new JButton(NEXT_BUTTON_TEXT);

        
	/**
	 * 
	 */
//	protected JButton mCancelButton = new JButton(CANCEL_BUTTON_TEXT);


	/**
	 * 
	 */
	private SGWizardDialog mPreviousWizardDialog = null;


	/**
	 * 
	 */
	private SGWizardDialog mNextWizardDialog = null;



	/**
	 * 
	 */
	public SGWizardDialog()
	{
		super();
		this.init();
	}


	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner )
	{
		super(owner);
		this.init();
	}



	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner, final String title )
	{
		super(owner,title);
		this.init();
	}


	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner, final boolean modal )
	{
		super(owner,modal);
		this.init();
	}


	/**
	 * 
	 * @param title
	 */
	public SGWizardDialog( final Frame owner, final String title, final boolean modal )
	{
		super(owner,title,modal);
		this.init();
	}



	/**
	 * 
	 * @return
	 */
	private boolean init()
	{
//		this.setVisible(false);
		return true;
	}


	/**
	 * 
	 */
	public SGDrawingWindow getOwnerWindow()
	{
		Window owner = this.getOwner();
		SGDrawingWindow wnd = null;
		if( owner instanceof SGDrawingWindow )
		{
			 wnd = (SGDrawingWindow)owner;
		}

		return wnd;
	}



	/**
	 * 
	 */
	public SGWizardDialog getPrevious()
	{
		return this.mPreviousWizardDialog;
	}


	/**
	 * 
	 */
	public SGWizardDialog getNext()
	{
		return this.mNextWizardDialog;
	}


	/**
	 * 
	 */
	public boolean setPrevious( final SGWizardDialog dg )
	{
		this.mPreviousWizardDialog = dg;
		return true;
	}


	/**
	 * 
	 */
	public boolean setNext( final SGWizardDialog dg )
	{
		this.mNextWizardDialog = dg;
		return true;
	}



	/**
	 * 
	 */
	public void windowClosing(final WindowEvent e)
	{
		super.windowClosing(e);
		this.close(e);
	}


	/**
	 * Overrode this method.
	 * @param e
	 */
	protected void close( final WindowEvent e )
	{
		Object obj = e.getSource();
		if( obj.equals( this ) )
		{
			this.onCanceled();
		}
	}


	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		Object source = e.getSource();
		AbstractButton btn = (AbstractButton)source;
		if( source.equals( this.getOKButton() ) )
		{
			this.onOK();
		}
		else if( source.equals( this.getCancelButton() ) )
		{
			this.onCanceled();
		}
		else if( source.equals( this.getPreviousButton() ) )
		{
			this.onPrevious();
		}
		else if( source.equals( this.getNextButton() ) )
		{
			this.onNext();
		}
	}




	/**
	 * 
	 */
	protected boolean onOK()
	{
		this.setCloseOption( OK_OPTION );
		this.setVisible(false);
		this.notifyToListener( OK_BUTTON_TEXT );
		return true;
	}


	/**
	 * 
	 */
	protected boolean onCanceled()
	{
		this.setCloseOption( CANCEL_OPTION );
		this.setVisible(false);
		this.notifyToListener( CANCEL_BUTTON_TEXT );
		return true;
	}


	/**
	 * Called when the previous button is pressed.
	 * Show the previous wizard dialog.
	 */
	protected boolean onPrevious()
	{
		this.notifyToListener( PREVIOUS_BUTTON_TEXT );
//		this.showPrevious();
		return true;
	}


	/**
	 * Called when the previous button is pressed.
	 * Notify the action to the listener.
	 */
	protected boolean onNext()
	{
		this.notifyToListener( NEXT_BUTTON_TEXT );
		return true;
	}


	
	/**
	 * 
	 *
	 */
	public void showNext()
	{
		SGWizardDialog next = this.getNext();
		if( next!=null )
		{
			this.setVisible(false);
			next.setCenter(this);
			next.setVisible(true);
		}
	}

	
	/**
	 * 
	 *
	 */
	public void showPrevious()
	{
		SGWizardDialog prev = this.getPrevious();
		if( prev!=null )
		{
			this.setVisible(false);
			prev.setCenter(this);
			prev.setVisible(true);
		}
	}

	
	
	/**
	 * 
	 */
	public void setVisible( final boolean b )
	{

		if( b )
		{
			Object owner = this.getOwner();
			if( owner instanceof Window )
			{
				
			}
			else
			{
				Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
				final int width = this.getWidth();
				final int height = this.getHeight();
				final int x = ( dim.width - width )/2;
				final int y = ( dim.height - height )/2;
				this.setLocation(x,y);
			}
		}

		super.setVisible(b);
	}



	protected abstract JButton getPreviousButton();


	protected abstract JButton getNextButton();


	protected abstract JButton getOKButton();
	
	
	protected abstract JButton getCancelButton();


}

