/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jp.riken.brain.ni.samuraigraph.base.SGButtonGroup;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGToggleMenuItem;

public class SGMenuBar
extends JMenuBar
implements ActionListener,
MenuListener,
SGIRootObjectConstants {
    private ArrayList mActionListenerList = new ArrayList();
    private ArrayList mMenuListenerList = new ArrayList();

    public SGMenuBar() {
        this.create();
    }

    private boolean create() {
        SGMenuBar sGMenuBar = this;
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        sGMenuBar.add(jMenu);
        this.createMenuItem(jMenu, "Create New Window", this, 78, KeyStroke.getKeyStroke(78, 2), true);
        this.createMenuItem(jMenu, "Close Window", this, 87, KeyStroke.getKeyStroke(87, 2), true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Draw Graph", this, 68, KeyStroke.getKeyStroke(79, 2), true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Load Property", this, 76, null, true);
        this.createMenuItem(jMenu, "Save Property", this, 83, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Export as Image", this, 69, KeyStroke.getKeyStroke(69, 2), false);
        this.createMenuItem(jMenu, "Print", this, 80, KeyStroke.getKeyStroke(80, 2), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Exit", this, 88, KeyStroke.getKeyStroke(81, 2), true);
        jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        sGMenuBar.add(jMenu);
        this.createMenuItem(jMenu, "Undo", this, 85, KeyStroke.getKeyStroke(90, 2), false);
        this.createMenuItem(jMenu, "Redo", this, 82, KeyStroke.getKeyStroke(89, 2), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Cut", this, 84, KeyStroke.getKeyStroke(88, 2), false);
        this.createMenuItem(jMenu, "Copy", this, 67, KeyStroke.getKeyStroke(67, 2), false);
        this.createMenuItem(jMenu, "Paste", this, 80, KeyStroke.getKeyStroke(86, 2), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Delete", this, 68, KeyStroke.getKeyStroke(127, 0), false);
        this.createMenuItem(jMenu, "Duplicate", this, 73, KeyStroke.getKeyStroke(68, 2), false);
        jMenu = new JMenu("Insert");
        jMenu.setMnemonic(73);
        sGMenuBar.add(jMenu);
        JMenuItem jMenuItem = this.createToggleMenuItem(jMenu, "Label", this, 76, null, false);
        JMenuItem jMenuItem2 = this.createToggleMenuItem(jMenu, "Significant Difference", this, 68, null, false);
        JMenuItem jMenuItem3 = this.createToggleMenuItem(jMenu, "Axis Break", this, 66, null, false);
        Serializable serializable = this.createToggleMenuItem(jMenu, "Timing Line", this, 84, null, false);
        SGButtonGroup sGButtonGroup = new SGButtonGroup();
        sGButtonGroup.add(jMenuItem);
        sGButtonGroup.add(jMenuItem2);
        sGButtonGroup.add(jMenuItem3);
        sGButtonGroup.add((AbstractButton)serializable);
        jMenu = new JMenu("Layout");
        jMenu.setMnemonic(76);
        sGMenuBar.add(jMenu);
        jMenuItem = new JMenu("Paper Size");
        jMenuItem.setMnemonic(80);
        jMenu.add(jMenuItem);
        this.createMenuItem((JMenu)jMenuItem, "A4", this, 52, null, true);
        this.createMenuItem((JMenu)jMenuItem, "B5", this, 53, null, true);
        this.createMenuItem((JMenu)jMenuItem, "US Letter", this, 85, null, true);
        ((JMenu)jMenuItem).addSeparator();
        jMenuItem2 = (JRadioButtonMenuItem)this.createRadioButtonMenuItem((JMenu)jMenuItem, "Portrait", this, 80, null, true);
        jMenuItem3 = (JRadioButtonMenuItem)this.createRadioButtonMenuItem((JMenu)jMenuItem, "Landscape", this, 76, null, true);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(jMenuItem2);
        ((ButtonGroup)serializable).add(jMenuItem3);
        ((JMenu)jMenuItem).addSeparator();
        this.createMenuItem((JMenu)jMenuItem, "Bounding Box", this, 66, null, true);
        this.createMenuItem((JMenu)jMenuItem, "User Customize", this, 67, null, true);
        jMenu.addSeparator();
        jMenuItem = new JMenu("Tool Bar");
        jMenuItem.setMnemonic(84);
        jMenu.add(jMenuItem);
        jMenuItem2 = this.createCheckBoxMenuItem((JMenu)jMenuItem, "File", this, -1, null, true);
        jMenuItem2.setSelected(true);
        jMenuItem2 = this.createCheckBoxMenuItem((JMenu)jMenuItem, "Edit", this, -1, null, true);
        jMenuItem2.setSelected(true);
        jMenuItem2 = this.createCheckBoxMenuItem((JMenu)jMenuItem, "Insert", this, -1, null, true);
        jMenuItem2.setSelected(true);
        jMenuItem2 = this.createCheckBoxMenuItem((JMenu)jMenuItem, "Arrange", this, -1, null, true);
        jMenuItem2.setSelected(true);
        jMenuItem2 = this.createCheckBoxMenuItem((JMenu)jMenuItem, "Zoom", this, -1, null, true);
        jMenuItem2.setSelected(true);
        jMenu.addSeparator();
        jMenuItem = new JMenu("Grid");
        jMenuItem.setMnemonic(71);
        jMenu.add(jMenuItem);
        this.createMenuItem((JMenu)jMenuItem, "Plus", this, 80, KeyStroke.getKeyStroke(73, 9), true);
        this.createMenuItem((JMenu)jMenuItem, "Minus", this, 77, KeyStroke.getKeyStroke(68, 9), true);
        this.createCheckBoxMenuItem((JMenu)jMenuItem, "Visible", this, 86, KeyStroke.getKeyStroke(71, 9), true);
        jMenu.addSeparator();
        jMenuItem = new JMenu("Zoom");
        jMenuItem.setMnemonic(90);
        jMenu.add(jMenuItem);
        this.createMenuItem((JMenu)jMenuItem, "Zoom In", this, 73, KeyStroke.getKeyStroke(90, 9), true);
        jMenuItem2 = this.createMenuItem((JMenu)jMenuItem, "Zoom Out", this, 79, KeyStroke.getKeyStroke(79, 9), true);
        jMenuItem2.setDisplayedMnemonicIndex(5);
        this.createMenuItem((JMenu)jMenuItem, "Default Zoom", this, 68, null, true);
        this.createMenuItem((JMenu)jMenuItem, "Zoom Way Out", this, 87, null, true);
        this.createCheckBoxMenuItem((JMenu)jMenuItem, "Auto Zoom", this, 65, null, true);
        jMenu.addSeparator();
        this.createCheckBoxMenuItem(jMenu, "Lock", this, 79, null, true);
        jMenu = new JMenu("Arrange");
        jMenu.setMnemonic(65);
        sGMenuBar.add(jMenu);
        this.createMenuItem(jMenu, "Move to Front", this, 70, KeyStroke.getKeyStroke(70, 2), false);
        this.createMenuItem(jMenu, "Move to Back", this, 66, KeyStroke.getKeyStroke(66, 2), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Auto Arrangement", this, 82, null, true);
        jMenu = new JMenu("Properties");
        jMenu.setMnemonic(80);
        sGMenuBar.add(jMenu);
        jMenu.addMenuListener(this);
        jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        sGMenuBar.add(jMenu);
        this.createMenuItem(jMenu, "Upgrade", this, 85, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Change Log", this, 67, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Proxy", this, 80, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "About", this, 65, null, true);
        return true;
    }

    private JMenuItem createMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        return this.createMenuItem(jMenu, string, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createMenuItem(JMenu jMenu, String string, String string2, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        return this.createMenuItem_(jMenu, jMenuItem, string2, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createRadioButtonMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        return this.createMenuItem_(jMenu, jRadioButtonMenuItem, string, actionListener, n, keyStroke, bl);
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        return (JCheckBoxMenuItem)this.createMenuItem_(jMenu, jCheckBoxMenuItem, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createToggleMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        SGToggleMenuItem sGToggleMenuItem = new SGToggleMenuItem(string);
        return this.createMenuItem_(jMenu, sGToggleMenuItem, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createNodeMenuItem(SGINode sGINode, JMenu jMenu, String string, ActionListener actionListener) {
        return this.createNodeMenuItem(sGINode, jMenu, string, actionListener, -1, null, true);
    }

    private JMenuItem createNodeMenuItem(SGINode sGINode, JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        SGDrawingWindow.NodeMenuItem nodeMenuItem = new SGDrawingWindow.NodeMenuItem(string);
        nodeMenuItem.setNode(sGINode);
        return this.createMenuItem_(jMenu, nodeMenuItem, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createMenuItem_(JMenu jMenu, JMenuItem jMenuItem, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(actionListener);
        if (n != -1) {
            jMenuItem.setMnemonic(n);
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.setEnabled(bl);
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    private JMenu getMenuFromMenuBar(String string) {
        SGMenuBar sGMenuBar = this;
        for (int i = 0; i < sGMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = sGMenuBar.getMenu(i);
            String string2 = jMenu.getText();
            if (!string2.equals(string)) continue;
            return jMenu;
        }
        return null;
    }

    private JMenu getMenu(JMenu jMenu, String string) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenu jMenu2;
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !(jMenuItem instanceof JMenu) || !(jMenu2 = (JMenu)jMenuItem).getText().equals(string)) continue;
            return jMenu2;
        }
        return null;
    }

    private JMenuItem getMenuItem(String string, String string2) {
        JMenu jMenu = this.getMenuFromMenuBar(string);
        if (jMenu == null) {
            return null;
        }
        return this.getMenuItem(jMenu, string2);
    }

    private JMenuItem getMenuItem(JMenu jMenu, String string) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            if (jMenuItem instanceof JMenu) {
                JMenu jMenu2 = (JMenu)jMenuItem;
                JMenuItem jMenuItem2 = this.getMenuItem(jMenu2, string);
                if (jMenuItem2 == null) continue;
                return jMenuItem2;
            }
            if (!jMenuItem.getText().equals(string)) continue;
            return jMenuItem;
        }
        return null;
    }

    private ArrayList getMenuItemList(String string) {
        JMenu jMenu = this.getMenuFromMenuBar(string);
        if (jMenu == null) {
            return null;
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Component[] componentArray = jMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem)) continue;
            arrayList.add(componentArray[i]);
        }
        return arrayList;
    }

    public void addActionListener(ActionListener actionListener) {
        this.mActionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.mActionListenerList.remove(actionListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object instanceof SGToggleMenuItem) {
            serializable.setSelected(!(serializable = (SGToggleMenuItem)object).isSelected());
        }
        serializable = new ActionEvent(this, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers());
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener = (ActionListener)arrayList.get(i);
            actionListener.actionPerformed((ActionEvent)serializable);
        }
    }

    public boolean isMenuItemEnabled(String string, String string2) {
        JMenuItem jMenuItem = this.getMenuItem(string, string2);
        if (jMenuItem == null) {
            throw new IllegalArgumentException("item==null");
        }
        return jMenuItem.isEnabled();
    }

    public void setMenuItemEnabled(String string, String string2, boolean bl) {
        JMenuItem jMenuItem = this.getMenuItem(string, string2);
        if (jMenuItem == null) {
            throw new IllegalArgumentException("item==null");
        }
        jMenuItem.setEnabled(bl);
    }

    public boolean isMenuItemSelected(String string, String string2) {
        JMenuItem jMenuItem = this.getMenuItem(string, string2);
        if (jMenuItem == null) {
            throw new IllegalArgumentException("item==null");
        }
        return jMenuItem.isSelected();
    }

    public void setMenuItemSelected(String string, String string2, boolean bl) {
        JMenuItem jMenuItem = this.getMenuItem(string, string2);
        if (jMenuItem == null) {
            throw new IllegalArgumentException("item==null");
        }
        jMenuItem.setSelected(bl);
    }

    public void addMenuListener(MenuListener menuListener) {
        ArrayList arrayList = this.mMenuListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            MenuListener menuListener2 = (MenuListener)arrayList.get(i);
            if (!menuListener2.equals(menuListener)) continue;
            return;
        }
        arrayList.add(menuListener);
    }

    public void removeActionListener(MenuListener menuListener) {
        ArrayList arrayList = this.mMenuListenerList;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            MenuListener menuListener2 = (MenuListener)arrayList.get(i);
            if (!menuListener2.equals(menuListener)) continue;
            this.mMenuListenerList.remove(menuListener);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        ArrayList arrayList = this.mMenuListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            MenuListener menuListener = (MenuListener)arrayList.get(i);
            menuListener.menuSelected(menuEvent);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
        ArrayList arrayList = this.mMenuListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            MenuListener menuListener = (MenuListener)arrayList.get(i);
            menuListener.menuDeselected(menuEvent);
        }
    }

    public void menuCanceled(MenuEvent menuEvent) {
        ArrayList arrayList = this.mMenuListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            MenuListener menuListener = (MenuListener)arrayList.get(i);
            menuListener.menuCanceled(menuEvent);
        }
    }

    public void setInsertToggleButtonsEnabled(boolean bl) {
        ArrayList arrayList = this.getMenuItemList("Insert");
        for (int i = 0; i < arrayList.size(); ++i) {
            SGToggleMenuItem sGToggleMenuItem = (SGToggleMenuItem)arrayList.get(i);
            sGToggleMenuItem.setEnabled(bl);
        }
    }

    public void setInsertToggleItemsUnSelected() {
        ArrayList arrayList = this.getMenuItemList("Insert");
        for (int i = 0; i < arrayList.size(); ++i) {
            SGToggleMenuItem sGToggleMenuItem = (SGToggleMenuItem)arrayList.get(i);
            sGToggleMenuItem.setSelected(false);
        }
    }

    public void setInsertToggleItemSelected(String string, boolean bl) {
        this.getMenuItem("Insert", string).setSelected(bl);
    }

    public boolean isInsertToggleItemSelected(String string) {
        return this.getMenuItem("Insert", string).isSelected();
    }

    public void createPropertyMenuBarItem(SGINode sGINode, ActionListener actionListener) {
        JMenu jMenu = this.getMenuFromMenuBar("Properties");
        jMenu.removeAll();
        this.createMenuItem(sGINode, jMenu, actionListener);
    }

    private void createMenuItem(SGINode sGINode, JMenu jMenu, ActionListener actionListener) {
        ArrayList arrayList = sGINode.getChildNodes();
        String string = sGINode.getClassDescription();
        String string2 = sGINode.getInstanceDescription();
        boolean bl = sGINode instanceof SGIPropertyDialogObserver;
        if (arrayList.size() != 0) {
            if (string != null & string2 != null) {
                JMenu jMenu2 = new JMenu(string);
                jMenu.add(jMenu2);
                if (bl) {
                    this.createNodeMenuItem(sGINode, jMenu2, string2, actionListener);
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    SGINode sGINode2 = (SGINode)arrayList.get(i);
                    this.createMenuItem(sGINode2, jMenu2, actionListener);
                }
            }
        } else if (bl && string2 != null) {
            this.createNodeMenuItem(sGINode, jMenu, string2, actionListener);
        }
    }

    public boolean isToolBarMenuSelected(String string) {
        JMenu jMenu = this.getMenuFromMenuBar("Layout");
        JMenu jMenu2 = this.getMenu(jMenu, "Tool Bar");
        JMenuItem jMenuItem = this.getMenuItem(jMenu2, string);
        if (jMenuItem != null) {
            return jMenuItem.isSelected();
        }
        throw new IllegalArgumentException();
    }

    public void setToolBarMenuItemSelected(String string, boolean bl) {
        JMenu jMenu = this.getMenuFromMenuBar("Layout");
        JMenu jMenu2 = this.getMenu(jMenu, "Tool Bar");
        JMenuItem jMenuItem = this.getMenuItem(jMenu2, string);
        if (jMenuItem == null) {
            throw new IllegalArgumentException();
        }
        jMenuItem.setSelected(bl);
    }
}

