/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EtchedBorder;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;

public class SGProgressMonitorDialog
extends SGDialog
implements Runnable {
    public static final String TITLE = "Downloading";
    protected JPanel mButtonPanel;
    protected JButton mCancelButton;
    private JLabel mLabel;
    private JLabel mMessageLabel;
    protected JPanel mPanel;
    private JProgressBar mProgressBar;
    private boolean mCanceledFlag = false;
    private InputStream mInputStream = null;
    private OutputStream mOutputStream = null;
    private int mInputSize = 0;

    public SGProgressMonitorDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGProgressMonitorDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    public SGProgressMonitorDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mButtonPanel = new JPanel();
        this.mCancelButton = new JButton();
        this.mProgressBar = new JProgressBar();
        this.mLabel = new JLabel();
        this.mMessageLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mPanel.setLayout(new GridBagLayout());
        this.mButtonPanel.setBorder(new EtchedBorder());
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(9, 6, 4, 6);
        this.mPanel.add((Component)this.mButtonPanel, gridBagConstraints);
        this.mProgressBar.setPreferredSize(new Dimension(150, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mPanel.add((Component)this.mProgressBar, gridBagConstraints);
        this.mLabel.setText("                       ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 10, 10, 10);
        this.mPanel.add((Component)this.mLabel, gridBagConstraints);
        this.mMessageLabel.setFont(new Font("Dialog", 0, 12));
        this.mMessageLabel.setText("Downloading Now...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 10, 0, 0);
        this.mPanel.add((Component)this.mMessageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mCancelButton.addActionListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Cancel")) {
            this.onCanceled();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.onCanceled();
    }

    private boolean onCanceled() {
        this.mCanceledFlag = true;
        this.setVisible(false);
        return true;
    }

    public JProgressBar getProgressBar() {
        return this.mProgressBar;
    }

    public void setLabel(String string) {
        this.mLabel.setText(string);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.mCanceledFlag = false;
        }
        super.setVisible(bl);
    }

    public boolean isCanceled() {
        return this.mCanceledFlag;
    }

    public void setInputStream(InputStream inputStream) {
        this.mInputStream = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.mOutputStream = outputStream;
    }

    public void setInputSize(int n) {
        this.mInputSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] byArray = new byte[1024];
        int n = 0;
        int n2 = 0;
        InputStream inputStream = this.mInputStream;
        OutputStream outputStream = this.mOutputStream;
        int n3 = this.mInputSize;
        JProgressBar jProgressBar = this.mProgressBar;
        try {
            while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
                outputStream.write(byArray, 0, n);
                jProgressBar.setValue(n2 += n);
                float f = 100.0f * (float)n2 / (float)n3;
                String string = new Integer((int)f).toString() + "%";
                jProgressBar.setString(string);
                if (!this.isCanceled()) continue;
                break;
            }
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            this.setVisible(false);
        }
    }
}

