
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;


/**
 * A dialog class for grid in figure.
 *
 */
public class SGGridDialog extends SGPropertyDialog
	implements SGILineConstants
{
	/**
	 * A string for the title of this dialog.
	 */
	public static final String TITLE = "Grid Properties";


    /** Creates new form SGGridDialog */
    public SGGridDialog( Frame parent, boolean modal )
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }


	public SGGridDialog( Dialog parent, boolean modal )
	{
		super(parent, modal);
		initComponents();
		this.initProperty();
	}

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mCommonPanel = new javax.swing.JPanel();
        mLeftTopRadioButton = new javax.swing.JRadioButton();
        mLeftBottomRadioButton = new javax.swing.JRadioButton();
        mRightTopRadioButton = new javax.swing.JRadioButton();
        mRightBottomRadioButton = new javax.swing.JRadioButton();
        mScaleReferenceLabel2 = new javax.swing.JLabel();
        mScaleReferenceLabel1 = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mGridPanel = new javax.swing.JPanel();
        mLineLabel = new javax.swing.JLabel();
        mLineSeparator = new javax.swing.JSeparator();
        mGridVisibleCheckBox = new javax.swing.JCheckBox();
        mLocationLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mStepXValueLabel = new javax.swing.JLabel();
        mStepXValueTextField = new javax.swing.JTextField();
        mBaseXValueLabel = new javax.swing.JLabel();
        mBaseXValueTextField = new javax.swing.JTextField();
        mStepYValueLabel = new javax.swing.JLabel();
        mStepYValueTextField = new javax.swing.JTextField();
        mBaseYValueLabel = new javax.swing.JLabel();
        mBaseYValueTextField = new javax.swing.JTextField();
        mLineTypeLabel = new javax.swing.JLabel();
        mLineTypeComboBox = new javax.swing.JComboBox();
        mLineWidthLabel = new javax.swing.JLabel();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineColorLabel = new javax.swing.JLabel();
        mLineColorButton = new javax.swing.JButton();
        mAutoCheckBox = new javax.swing.JCheckBox();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mCommonPanel.setLayout(new java.awt.GridBagLayout());

        mLeftTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftTopRadioButton, gridBagConstraints);

        mLeftBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftBottomRadioButton, gridBagConstraints);

        mRightTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightTopRadioButton, gridBagConstraints);

        mRightBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightBottomRadioButton, gridBagConstraints);

        mScaleReferenceLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mCommonPanel.add(mScaleReferenceLabel2, gridBagConstraints);

        mScaleReferenceLabel1.setFont(new java.awt.Font("Dialog", 1, 12));
        mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        mCommonPanel.add(mScaleReferenceLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mCommonPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mGridPanel.setLayout(new java.awt.GridBagLayout());

        mGridPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mLineLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLineLabel.setText("Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 10, 0, 5);
        mGridPanel.add(mLineLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(8, 40, 0, 10);
        mGridPanel.add(mLineSeparator, gridBagConstraints);

        mGridVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mGridVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        mGridPanel.add(mGridVisibleCheckBox, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 5, 5);
        mGridPanel.add(mLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 65, 5, 10);
        mGridPanel.add(mLocationSeparator, gridBagConstraints);

        mStepXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mStepXValueLabel.setText("Step X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mGridPanel.add(mStepXValueLabel, gridBagConstraints);

        mStepXValueTextField.setColumns(6);
        mStepXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mGridPanel.add(mStepXValueTextField, gridBagConstraints);

        mBaseXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBaseXValueLabel.setText("Base X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mGridPanel.add(mBaseXValueLabel, gridBagConstraints);

        mBaseXValueTextField.setColumns(6);
        mBaseXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        mGridPanel.add(mBaseXValueTextField, gridBagConstraints);

        mStepYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mStepYValueLabel.setText("Step Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mGridPanel.add(mStepYValueLabel, gridBagConstraints);

        mStepYValueTextField.setColumns(6);
        mStepYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mGridPanel.add(mStepYValueTextField, gridBagConstraints);

        mBaseYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBaseYValueLabel.setText("Base Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mGridPanel.add(mBaseYValueLabel, gridBagConstraints);

        mBaseYValueTextField.setColumns(6);
        mBaseYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        mGridPanel.add(mBaseYValueTextField, gridBagConstraints);

        mLineTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeLabel.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mGridPanel.add(mLineTypeLabel, gridBagConstraints);

        mLineTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeComboBox.setPreferredSize(new java.awt.Dimension(140, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mGridPanel.add(mLineTypeComboBox, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mGridPanel.add(mLineWidthLabel, gridBagConstraints);

        mLineWidthSpinner.setMinimumSize(new java.awt.Dimension(65, 20));
        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mGridPanel.add(mLineWidthSpinner, gridBagConstraints);

        mLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mGridPanel.add(mLineColorLabel, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mGridPanel.add(mLineColorButton, gridBagConstraints);

        mAutoCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mAutoCheckBox.setText("Auto");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        mGridPanel.add(mAutoCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mGridPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents


    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JCheckBox mAutoCheckBox;
    private javax.swing.JLabel mBaseXValueLabel;
    private javax.swing.JTextField mBaseXValueTextField;
    private javax.swing.JLabel mBaseYValueLabel;
    private javax.swing.JTextField mBaseYValueTextField;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JPanel mCommonPanel;
    private javax.swing.JPanel mGridPanel;
    private javax.swing.JCheckBox mGridVisibleCheckBox;
    private javax.swing.JRadioButton mLeftBottomRadioButton;
    private javax.swing.JRadioButton mLeftTopRadioButton;
    private javax.swing.JButton mLineColorButton;
    private javax.swing.JLabel mLineColorLabel;
    private javax.swing.JLabel mLineLabel;
    private javax.swing.JSeparator mLineSeparator;
    private javax.swing.JComboBox mLineTypeComboBox;
    private javax.swing.JLabel mLineTypeLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JRadioButton mRightBottomRadioButton;
    private javax.swing.JRadioButton mRightTopRadioButton;
    private javax.swing.JLabel mScaleReferenceLabel1;
    private javax.swing.JLabel mScaleReferenceLabel2;
    private javax.swing.JLabel mStepXValueLabel;
    private javax.swing.JTextField mStepXValueTextField;
    private javax.swing.JLabel mStepYValueLabel;
    private javax.swing.JTextField mStepYValueTextField;
    // ϐ錾̏I//GEN-END:variables


	/**
	 * 
	 */
	private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();


	private void initProperty()
	{
		
		// set the title
		this.setTitle( TITLE );


		// set the combo box
		{
			JComboBox cb = this.mLineTypeComboBox;
			final String array[] = {
				LINE_NAME_SOLID,
				LINE_NAME_BROKEN,
				LINE_NAME_DOT,
				LINE_NAME_DASHED,
				LINE_NAME_DOUBLE_DASHED
			};
			for(int ii=0 ; ii<array.length ; ii++)
			{
				cb.addItem( array[ii] );
			}
		}


		this.pack();

		
		// create a button group
		ButtonGroup bg = new ButtonGroup();
		bg.add( this.mLeftBottomRadioButton );
		bg.add( this.mRightBottomRadioButton );
		bg.add( this.mLeftTopRadioButton );
		bg.add( this.mRightTopRadioButton );
		bg.add( this.mNoAxisSelectionRadioButton );

		
		// set spinner model
		this.mLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		// FύX{^ɃANVXiǉ
		this.mLineColorButton.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mLineColorButton;


		// set action listeners
		this.mGridVisibleCheckBox.addActionListener(this);
		this.mAutoCheckBox.addActionListener(this);

{
	this.mOKButton.addActionListener(this);
	this.mCancelButton.addActionListener(this);
	this.mPreviewButton.addActionListener(this);
}
		
	}



	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		list.add( this.mBaseXValueTextField );
		list.add( this.mBaseYValueTextField );
		list.add( this.mStepXValueTextField );
		list.add( this.mStepYValueTextField );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		final ArrayList list = new ArrayList();
		list.add( this.mLineColorButton );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineWidthSpinner );
		return list;
	}


	/**
	 * 
	 */
	public void actionPerformed( ActionEvent e )
	{
		super.actionPerformed(e);
		Object source = e.getSource();

		if( source.equals( this.mGridVisibleCheckBox ) )
		{
			this.setGridVisible( this.mGridVisibleCheckBox.isSelected() );
		}
		else if( source.equals( this.mAutoCheckBox ) )
		{
			this.setAutoFlag( this.mAutoCheckBox.isSelected() );
		}
	}


	/**
	 * 
	 */
	public void componentShown( ComponentEvent e )
	{
		super.componentShown(e);
		this.setOwnerEnabled(false);
	}

	/**
	 * 
	 */
	public void componentHidden( ComponentEvent e )
	{
		super.componentHidden(e);
		this.setOwnerEnabled(true);
		this.onCanceled();
	}

	/**
	 * 
	 */
	public void windowClosing( WindowEvent e )
	{
		super.windowClosing(e);
		this.setOwnerEnabled(true);
	}

	/**
	 * 
	 */
	public void windowClosed( WindowEvent e )
	{
		super.windowClosed(e);
		this.setOwnerEnabled(true);
	}


	private void setOwnerEnabled( final boolean b )
	{
		this.getOwner().setEnabled(b);
	}


	/**
	 * 
	 * @param b
	 */
	public void setGridVisible( final boolean b )
	{
		this.mGridVisibleCheckBox.setSelected(b);

		Component[] array =
		{
			this.mAutoCheckBox,
			this.mBaseXValueLabel,
			this.mBaseXValueTextField,
			this.mBaseYValueLabel,
			this.mBaseYValueTextField,
			this.mStepXValueLabel,
			this.mStepXValueTextField,
			this.mStepYValueLabel,
			this.mStepYValueTextField,
			this.mLineWidthLabel,
			this.mLineWidthSpinner,
			this.mLineTypeLabel,
			this.mLineTypeComboBox,
			this.mLineColorLabel,
			this.mLineColorButton
		};
		
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].setEnabled(b);
		}
	}


	/**
	 * 
	 * @param b
	 */
	public void setAutoFlag( final boolean b )
	{
		this.mAutoCheckBox.setSelected(b);

		JTextComponent[] array =
		{
			this.mBaseXValueTextField,
			this.mBaseYValueTextField,
			this.mStepXValueTextField,
			this.mStepYValueTextField
		};

		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].setEditable(!b);
		}
	}



	/**
	 * 
	 */
	public boolean setLineType( final int type )
	{
		final String typeName = SGDrawingElementLine.getLineTypeName( type );
		this.mLineTypeComboBox.setSelectedItem(typeName);
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean getGridVisible()
	{
		return this.mGridVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public int getLineType()
	{
		final String typeName = (String)this.mLineTypeComboBox.getSelectedItem();
		final Integer num = SGDrawingElementLine.getLineTypeFromName(typeName);
		if( num==null )
		{
			throw new Error();
		}
		return num.intValue();
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float width )
	{
		this.mLineWidthSpinner.setValue( new Double( width ) );
		return true;
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public boolean setLineColor( final Color cl )
	{
		this.mLineColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public Color getLineColor()
	{
		return this.mLineColorButton.getBackground();
	}


	/**
	 * 
	 * @return
	 */
	public boolean getAutoFlag()
	{
		return this.mAutoCheckBox.isSelected();
	}
	

	/**
	 * 
	 * @return
	 */
	public String getXAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_BOTTOM;
		}
		else if( this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_TOP;
		}
		return str;
	}
	

	
	/**
	 * 
	 * @return
	 */
	public String getYAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_LEFT;
		}
		else if( this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_RIGHT;
		}
		return str;
	}


    
	/**
	 * 
	 */
	public boolean setAxisRadioButton( final int configX, final int configY )
	{

		switch( configX )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftBottomRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightBottomRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftTopRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightTopRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			default :
			{
				return false;
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public Number getBaseXValue()
	{
		String str = this.mBaseXValueTextField.getText();
		Number d = SGUtilityText.getDouble(str);
		return d;
	}


	/**
	 * 
	 */
	public Number getBaseYValue()
	{
		String str = this.mBaseYValueTextField.getText();
		Number d = SGUtilityText.getDouble(str);
		return d;
	}


	/**
	 * 
	 */
	public Number getStepXValue()
	{
		String str = this.mStepXValueTextField.getText();
		Number d = SGUtilityText.getDouble(str);
		return d;
	}


	/**
	 * 
	 */
	public Number getStepYValue()
	{
		String str = this.mStepYValueTextField.getText();
		Number d = SGUtilityText.getDouble(str);
		return d;
	}


	/**
	 * 
	 * @param value
	 */
	public void setBaseXValue( final double value )
	{
		this.mBaseXValueTextField.setText( Double.toString(value) );
	}


	/**
	 * 
	 * @param value
	 */
	public void setStepXValue( final double value )
	{
		if( value<=0.0 )
		{
			throw new IllegalArgumentException("value<=0.0");
		}
		this.mStepXValueTextField.setText( Double.toString(value) );
	}


	/**
	 * 
	 * @param value
	 */
	public void setBaseYValue( final double value )
	{
		this.mBaseYValueTextField.setText( Double.toString(value) );
	}


	/**
	 * 
	 * @param value
	 */
	public void setStepYValue( final double value )
	{
		if( value<=0.0 )
		{
			throw new IllegalArgumentException("value<=0.0");
		}
		this.mStepYValueTextField.setText( Double.toString(value) );
	}
    
}

