
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Font;
import java.util.ArrayList;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;


/**
 *
 */
public abstract class SGDrawingElementString extends SGDrawingElement
	implements SGIStringConstants, SGIDrawingElementConstants
{

	
	/**
	 *
	 */
	protected String mString = new String();


	/**
	 * 
	 */
	protected Font mFont = null;


	/**
	 * 
	 */
	protected String mFontName;


	/**
	 *
	 */
	protected float mFontSize;


	/**
	 *
	 */
	protected int mFontStyle;


	/**
	 * ̂wW
	 */
	protected float mX;


	/**
	 * ̂xW
	 */
	protected float mY;


	/**
	 * 
	 */
	protected float mAngle;


	/**
	 * 
	 */
	public SGDrawingElementString()
	{
		super();
	}


	/**
	 * 
	 */
	public SGDrawingElementString( final String str )
	{
		super();
		mString = new String( str );
	}


	/**
	 * 
	 */
	public SGDrawingElementString(
		final SGDrawingElementString element )
	{
		super();
		this.mMagnification = element.mMagnification;
		this.mString = new String( element.mString );
		this.setFont( element.getFontName(), element.getFontStyle(), element.getFontSize() );
		this.mX = element.mX;
		this.mY = element.mY;
		this.mAngle = element.mAngle;
		this.mColorList = new ArrayList( element.mColorList );
	}


	/**
	 *
	 */
	public SGDrawingElementString(
		final String str,
		final String fontName,
		final int fontStyle,
		final float fontSize )
	{
		super();
		this.mString = new String( str );
		this.setFont( fontName, fontStyle, fontSize );
	}
	

	/**
	 *
	 */
	public SGDrawingElementString(
		final String str,
		final String fontName,
		final int fontStyle,
		final float fontSize,
		final float x,
		final float y )
	{
		super();
		this.mString = new String( str );
		this.setFont( fontName, fontStyle, fontSize );
		this.mX = x;
		this.mY = y;
	}



	/**
	 * 
	 */
	public String toString()
	{
		return this.mString;
	}



	/**
	 * 
	 * @param name
	 * @param style
	 * @param size
	 * @return
	 */
	public boolean setFont( final String name, final int style, final float size )
	{
		this.mFontName = name;
		this.mFontStyle = style;
		this.mFontSize = size;

		this.mFont = new Font(
			this.mFontName,
			this.mFontStyle,
			(int)(this.mMagnification*this.mFontSize)
		);

		return true;
	}


	/**
	 *
	 */
	public boolean setString( final String str )
	{
		mString = str;
		return true;
	}


	/**
	 * 
	 */
	public boolean setMagnification( final float mag )
	{
		super.setMagnification( mag );
		this.setFont( this.mFontName, this.mFontStyle, this.mFontSize );
		return true;
	}


	/**
	 *
	 */
	public String getString()
	{
		return mString;
	}



	/**
	 *
	 */
	public float getX()
	{
		return this.getLocation().x;
	}


	/**
	 *
	 */
	public float getY()
	{
		return this.getLocation().y;
	}



	/**
	 * 
	 * @return
	 */
	public SGTuple2f getLocation()
	{
		return new SGTuple2f( this.mX, this.mY );
	}



	/**
	 *
	 */
	public float getFontSize()
	{
		return mFontSize;
	}


	/**
	 *
	 */
	public int getFontStyle()
	{
		return mFontStyle;
	}



	/**
	 * 
	 * @param pos
	 * @return
	 */
	public boolean setLocation( final SGTuple2f pos )
	{
		if( pos==null )
		{
			throw new IllegalArgumentException("pos==null");
		}
		this.setLocation( pos.x, pos.y );
		return true;
	}



	/**
	 *
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.mX = x;
		this.mY = y;
		return true;
	}



	/**
	 * 
	 */
	public boolean setX( final float x )
	{
		this.setLocation( x, this.getY() );
		return true;
	}


	/**
	 * 
	 */
	public boolean setY( final float y )
	{
		this.setLocation( this.getX(), y );
		return true;
	}


	/**
	 * 
	 */
	public boolean setAngle( final float angle )
	{
		mAngle = angle;
		return true;
	}


	/**
	 * 
	 */
	public float getAngle()
	{
		return mAngle;
	}


	/**
	 * 
	 * @return
	 */
	public String getFontName()
	{
		return mFontName;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementString) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementString el = (SGDrawingElementString)element;

		this.setX( el.getX() );
		this.setY( el.getY() );
		this.setString( el.getString() );
		this.setFont( el.getFontName(), el.getFontStyle(), el.getFontSize() );
		this.setAngle( el.getAngle() );

		return true;
	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		StringProperties p = new StringProperties();
		this.getProperties(p);
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof StringProperties ) == false ) return false;

		super.getProperties(p);

		StringProperties sp = (StringProperties)p;
		sp.setX( this.mX );
		sp.setY( this.mY );
		sp.setText( this.getString() );
		sp.setFontName( this.getFontName() );
		sp.setFontSize( this.getFontSize() );
		sp.setFontStyle( this.getFontStyle() );
		sp.setAngle( this.getAngle() );

		return true;
	}



	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof StringProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		StringProperties ep = (StringProperties)p;

		this.mX = ep.getX().floatValue();
		this.mY = ep.getY().floatValue();
		this.setString( ep.getText() );
		this.setFont(
			ep.getFontName(),
			ep.getFontStyle().intValue(),
			ep.getFontSize().floatValue() );
		this.setAngle( ep.getAngle().floatValue() );

		return true;

	}


	/**
	 * 
	 * @param dx
	 * @param dy
	 * @return
	 */
	public boolean translate( final float dx, final float dy )
	{
		this.setLocation( this.getX() + dx, this.getY() + dy );
		return true;
	}





	/**
	 * 
	 */
	public static class StringProperties extends DrawingElementProperties
	{

		public static final String[] keys = {
			KEY_X, KEY_Y,
			KEY_TEXT,
			KEY_FONT_SIZE, KEY_FONT_STYLE, KEY_FONT_NAME,
			KEY_ANGLE
		};


		/**
		 * 
		 *
		 */
		public StringProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof StringProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			StringProperties p = (StringProperties)obj;
			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}

			return true;
		}


		public Float getX()
		{
			final String value = this.getProperty(KEY_X);
			return SGUtilityText.getFloat(value);
		}

		public Float getY()
		{
			final String value = this.getProperty(KEY_Y);
			return SGUtilityText.getFloat(value);
		}

		public String getText()
		{
			return this.getProperty(KEY_TEXT);
		}

		public String getFontName()
		{
			return this.getProperty(KEY_FONT_NAME);
		}
		
		public Float getFontSize()
		{
			String value = this.getProperty(KEY_FONT_SIZE);
			return SGUtilityText.getFloat(value);
		}

		public Integer getFontStyle()
		{
			String value = this.getProperty(KEY_FONT_STYLE);
			return SGUtilityText.getInteger(value);
		}

		public Float getAngle()
		{
			final String value = this.getProperty(KEY_ANGLE);
			return SGUtilityText.getFloat(value);
		}


		public boolean setX( final float x )
		{
			this.setProperty( KEY_X, new Float(x).toString() );
			return true;
		}

		public boolean setY( final float y )
		{
			this.setProperty( KEY_Y, new Float(y).toString() );
			return true;
		}

		
		public boolean setText( final String text )
		{
			this.setProperty( KEY_TEXT, text );
			return true;
		}

		public boolean setFontName( final String name )
		{
			this.setProperty( KEY_FONT_NAME, name );
			return true;
		}

		public boolean setFontSize( final float size )
		{
			this.setProperty( KEY_FONT_SIZE, new Float(size).toString() );
			return true;
		}

		public boolean setFontStyle( final int style )
		{
			this.setProperty( KEY_FONT_STYLE, new Integer(style).toString() );
			return true;
		}

		public boolean setAngle( final float angle )
		{
			this.setProperty( KEY_ANGLE, new Float(angle).toString() );
			return true;
		}

	
	}



}

