/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingLineDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGTimingLineElement
extends SGFigureElement
implements SGITimingLineElement {
    private SGIAxisElement mAxisElement = null;
    protected ArrayList mTimingLineList = new ArrayList();
    protected SGTimingLineDialog mTimingLineDialog = null;

    public String toString() {
        return "SGTimingLineEement";
    }

    public void setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
    }

    public void addTimingLine(SGAxis sGAxis, double d) {
        TimingLine timingLine = new TimingLine();
        timingLine.setAxis(sGAxis);
        timingLine.setValue(d);
        timingLine.setMagnification(this.mMagnification);
        this.addTimingLine_(timingLine);
        this.setAllDrawingElementsLocation();
        this.updateFocusedObjectsList((SGISelectable)timingLine, 0);
        this.setChanged(true);
        this.notifyToRoot();
    }

    private void addTimingLine_(TimingLine timingLine) {
        timingLine.initDrawingElement(2);
        timingLine.setPropertiesOfDrawingElements();
        timingLine.initPropertiesHistory();
        this.mTimingLineList.add(timingLine);
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createTimingLineDialog();
        return true;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGILegendElement)) {
            if (sGIFigureElement instanceof SGIAxisElement) {
                SGIAxisElement sGIAxisElement = (SGIAxisElement)sGIFigureElement;
                bl = this.synchronizeToAxisElement(sGIAxisElement);
            } else if (!(sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement || sGIFigureElement instanceof SGIGridElement)) {
                bl = this.synchronizeArgument(sGIFigureElement);
            }
        }
        return bl;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    public boolean updateHistory() {
        return this.updateHistory_(this.getVisibleTimingElementList());
    }

    public SGProperties getProperties() {
        TimingElementProperties timingElementProperties = new TimingElementProperties();
        if (!this.getProperties(timingElementProperties)) {
            return null;
        }
        return timingElementProperties;
    }

    public String getTagName() {
        return "TimingLines";
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("TimingLine");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            TimingLine timingLine = new TimingLine();
            Element element2 = (Element)node;
            if (!timingLine.readProperty(element2)) {
                return false;
            }
            this.addTimingLine_(timingLine);
        }
        return true;
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = this.getVisibleTimingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            Element element2 = timingLine.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        ArrayList arrayList = this.getVisibleTimingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            if (!sGIUndoable.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        for (int i = 0; i < this.mTimingLineList.size(); ++i) {
            SGTimingLine sGTimingLine = (SGTimingLine)this.mTimingLineList.get(i);
            sGTimingLine.zoom(f);
        }
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        return this.setAllDrawingElementsLocation();
    }

    private boolean calcLocationOfTimingLine(double d, SGAxis sGAxis, boolean bl, SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        float f = this.calcLocation(d, sGAxis, bl);
        Rectangle2D rectangle2D = this.getGraphRect();
        if (bl) {
            sGTuple2f.x = f;
            sGTuple2f.y = (float)rectangle2D.getY();
            sGTuple2f2.x = f;
            sGTuple2f2.y = sGTuple2f.y + (float)rectangle2D.getHeight();
        } else {
            sGTuple2f.x = (float)rectangle2D.getX();
            sGTuple2f.y = f;
            sGTuple2f2.x = sGTuple2f.x + (float)rectangle2D.getWidth();
            sGTuple2f2.y = f;
        }
        return true;
    }

    private boolean createTimingLineDialog() {
        SGTimingLineDialog sGTimingLineDialog;
        this.mTimingLineDialog = sGTimingLineDialog = new SGTimingLineDialog(this.mDialogOwner, true);
        return true;
    }

    protected ArrayList getVisibleTimingElementList() {
        ArrayList<SGTimingLine> arrayList = new ArrayList<SGTimingLine>();
        for (int i = 0; i < this.mTimingLineList.size(); ++i) {
            SGTimingLine sGTimingLine = (SGTimingLine)this.mTimingLineList.get(i);
            if (!sGTimingLine.isVisible() || !this.isInsideRange(sGTimingLine)) continue;
            arrayList.add(sGTimingLine);
        }
        return arrayList;
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleTimingElementList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList2.get(i);
            if (!sGISelectable.isSelected()) continue;
            arrayList.add(sGISelectable);
        }
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        TimingLine timingLine = (TimingLine)sGISelectable;
        timingLine.setVisible(false);
        return true;
    }

    private boolean isInsideRange(SGTimingLine sGTimingLine) {
        SGAxis sGAxis = sGTimingLine.mAxis;
        double d = sGTimingLine.mValue;
        return sGAxis.insideRange(d);
    }

    protected boolean setVisibleTimingElements(ArrayList arrayList) {
        int n;
        ArrayList arrayList2 = new ArrayList(arrayList);
        ArrayList<SGTimingLine> arrayList3 = new ArrayList<SGTimingLine>();
        for (n = 0; n < this.mTimingLineList.size(); ++n) {
            SGTimingLine sGTimingLine = (SGTimingLine)this.mTimingLineList.get(n);
            boolean bl = arrayList.contains(sGTimingLine);
            sGTimingLine.setVisible(bl);
            if (bl) continue;
            arrayList3.add(sGTimingLine);
        }
        this.mTimingLineList.clear();
        for (n = 0; n < arrayList2.size(); ++n) {
            this.mTimingLineList.add(arrayList2.get(n));
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            this.mTimingLineList.add(arrayList3.get(n));
        }
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleTimingElementList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (!this.clickDrawingElements(timingLine, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    private boolean clickDrawingElements(TimingLine timingLine, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (timingLine.contains(n, n2)) {
            if (n3 == 1) {
                this.updateFocusedObjectsList((SGISelectable)timingLine, mouseEvent);
                if (!SwingUtilities.isLeftMouseButton(mouseEvent) && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    timingLine.getPopupMenu().show(this, n, n2);
                }
            } else if (n3 == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                timingLine.getDialog().setVisible(true);
            }
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ArrayList arrayList = this.getVisibleTimingElementList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGTimingLine sGTimingLine = (SGTimingLine)arrayList.get(i);
            if (!sGTimingLine.contains(n, n2)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        ArrayList arrayList = this.getVisibleTimingElementList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGTimingLine sGTimingLine = (SGTimingLine)arrayList.get(i);
            boolean bl = sGTimingLine.contains(n, n2);
            if (!bl) continue;
            this.setMouseCursor(12);
            return true;
        }
        this.setMouseCursor(0);
        return false;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            timingLine.mTemporaryProperties = timingLine.getProperties();
        }
        return true;
    }

    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            SGProperties sGProperties = timingLine.mTemporaryProperties;
            SGProperties sGProperties2 = timingLine.getProperties();
            if (sGProperties2.equals(sGProperties)) continue;
            timingLine.setChanged(true);
        }
        return true;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Object object;
        SGTimingLine sGTimingLine;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.getVisibleTimingElementList();
        if (bl) {
            SGUtilityForFigureElement.clipGraphRect(this, graphics2D);
        }
        Rectangle2D rectangle2D = this.getGraphRect();
        for (n = 0; n < arrayList.size(); ++n) {
            sGTimingLine = (SGTimingLine)arrayList.get(n);
            if (bl) {
                sGTimingLine.paintElement(graphics2D);
                continue;
            }
            sGTimingLine.paintElement(graphics2D, rectangle2D);
        }
        if (bl) {
            graphics2D.setClip(this.getBounds());
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < arrayList.size(); ++n) {
                sGTimingLine = (TimingLine)arrayList.get(n);
                object = ((TimingLine)sGTimingLine).getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsChildObject((ArrayList)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList arrayList2 = new ArrayList();
            this.getFocusedObjectsList(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (TimingLine)arrayList2.get(i);
                ArrayList arrayList3 = ((TimingLine)object).getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsFocusedObject(arrayList3, graphics2D);
            }
        }
    }

    public boolean moveFocusedObjects(boolean bl) {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                TimingLine timingLine = (TimingLine)arrayList.get(i);
                this.moveTimingLineToFront(timingLine);
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                TimingLine timingLine = (TimingLine)arrayList.get(i);
                this.moveTimingLineToBack(timingLine);
            }
        }
        return true;
    }

    protected boolean moveTimingLineToFront(SGTimingLine sGTimingLine) {
        return this.moveObjectToFront(sGTimingLine, this.mTimingLineList);
    }

    protected boolean moveTimingLineToBack(SGTimingLine sGTimingLine) {
        return this.moveObjectToBack(sGTimingLine, this.mTimingLineList);
    }

    protected boolean hideTimingElementGroupSet(SGTimingLine sGTimingLine) {
        sGTimingLine.setVisible(false);
        this.notifyChange();
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    protected boolean removeTimingElementGroupSet(SGTimingLine sGTimingLine) {
        this.mTimingLineList.remove(sGTimingLine);
        return false;
    }

    protected boolean synchronizeToAxisElement(SGIAxisElement sGIAxisElement) {
        return this.setAllDrawingElementsLocation();
    }

    protected boolean setAllDrawingElementsLocation() {
        ArrayList arrayList = this.getVisibleTimingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (timingLine.setDrawingElementsLocation()) continue;
            return false;
        }
        return true;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof TimingElementProperties)) {
            return false;
        }
        TimingElementProperties timingElementProperties = (TimingElementProperties)sGProperties;
        timingElementProperties.visibleTimingElementList = this.getVisibleTimingElementList();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof TimingElementProperties)) {
            return false;
        }
        TimingElementProperties timingElementProperties = (TimingElementProperties)sGProperties;
        boolean bl = this.setVisibleTimingElements(timingElementProperties.visibleTimingElementList);
        return bl;
    }

    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        ArrayList arrayList = this.duplicateObjects();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            SGAxis sGAxis = timingLine.mAxis;
            boolean bl = timingLine.isHorizontal();
            float f = this.calcLocation(timingLine.getValue(), sGAxis, bl);
            float f2 = timingLine.isHorizontal() ? f + (float)n : f + (float)n2;
            double d = this.calcValue(f2, sGAxis, bl);
            d = this.getNumberInRangeOrder(d, sGAxis);
            timingLine.setValue(d);
            timingLine.setDrawingElementsLocation();
            timingLine.setSelected(true);
            this.addTimingLine_(timingLine);
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
        }
        this.setAllDrawingElementsLocation();
        return true;
    }

    public boolean paste(ArrayList arrayList) {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof TimingLine)) continue;
            TimingLine timingLine = (TimingLine)e;
            SGProperties sGProperties = timingLine.getProperties();
            TimingLine timingLine2 = new TimingLine();
            timingLine2.setProperties(sGProperties);
            timingLine2.mAxis = this.mAxisElement.getAxisInCube(timingLine.mTempAxis);
            timingLine2.setDrawingElementsLocation();
            this.addTimingLine_(timingLine2);
            timingLine2.initPropertiesHistory();
            ++n3;
        }
        this.setAllDrawingElementsLocation();
        if (n3 != 0) {
            this.setChanged(true);
        }
        this.repaint();
        return true;
    }

    public static class TimingElementProperties
    extends SGProperties {
        ArrayList visibleTimingElementList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof TimingElementProperties)) {
                return false;
            }
            TimingElementProperties timingElementProperties = (TimingElementProperties)object;
            return timingElementProperties.visibleTimingElementList.equals(this.visibleTimingElementList);
        }

        public String toString() {
            String string = new String("[");
            string = string + this.visibleTimingElementList.toString();
            string = string + new String("]");
            return string;
        }
    }

    class TimingLine
    extends SGTimingLine
    implements ActionListener,
    WindowListener,
    SGIUndoable,
    SGISelectable,
    SGICopiable {
        private boolean mSelectedFlag = false;
        private SGProperties mTemporaryProperties = null;
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private ArrayList mElementGroupSetPropertyHistoryList = new ArrayList();
        private int mElementGroupSetStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();
        private boolean mChangedFlag = false;
        public static final String TAG_NAME_TIMING_LINE = "TimingLine";
        private int mTempAxis = -1;

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        protected TimingLine() {
            this.init();
        }

        private boolean init() {
            this.setLineWidth(1.0f);
            Integer n = SGDrawingElementLine.getLineTypeFromName("Solid");
            if (n == null) {
                return false;
            }
            this.setLineType(n);
            this.setColor(SGDefaultValues.TIMING_LINE_COLOR);
            this.createPopupMenu();
            return true;
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            Point2D.Float float_ = new Point2D.Float();
            Point2D.Float float_2 = new Point2D.Float();
            boolean bl = this.isHorizontal();
            float f = SGTimingLineElement.this.calcLocation(this.mValue, this.mAxis, bl);
            Rectangle2D rectangle2D = SGTimingLineElement.this.getGraphRect();
            if (bl) {
                float f2 = (float)rectangle2D.getY();
                float f3 = f2 + (float)rectangle2D.getHeight();
                ((Point2D)float_).setLocation(f, f2);
                ((Point2D)float_2).setLocation(f, f3);
            } else {
                float f4 = (float)rectangle2D.getX();
                float f5 = f4 + (float)rectangle2D.getWidth();
                ((Point2D)float_).setLocation(f4, f);
                ((Point2D)float_2).setLocation(f5, f);
            }
            arrayList.add(float_);
            arrayList.add(float_2);
            return arrayList;
        }

        private boolean createPopupMenu() {
            JPopupMenu jPopupMenu = this.mPopupMenu;
            jPopupMenu.setBounds(0, 0, 100, 100);
            jPopupMenu.add(new JLabel("  -- Timing Line --"));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Move to Front");
            SGUtility.addItem(jPopupMenu, this, "Move to Back");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Cut");
            SGUtility.addItem(jPopupMenu, this, "Copy");
            SGUtility.addItem(jPopupMenu, this, "Paste");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Delete");
            SGUtility.addItem(jPopupMenu, this, "Duplicate");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return true;
        }

        public JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        public boolean setDialogProperty() {
            SGTimingLineDialog sGTimingLineDialog = SGTimingLineElement.this.mTimingLineDialog;
            int n = SGTimingLineElement.this.mAxisElement.getConfigurationInPlane(this.mAxis);
            sGTimingLineDialog.setAxisRadioButton(n);
            sGTimingLineDialog.setTiminValueString(this.mValue);
            sGTimingLineDialog.setLineType(this.mLineType);
            sGTimingLineDialog.setLineWidth(this.mLineWidth);
            sGTimingLineDialog.setLineColorList(this.mColorList);
            return true;
        }

        public boolean setPropertyWithDialog() {
            SGTimingLineDialog sGTimingLineDialog = SGTimingLineElement.this.mTimingLineDialog;
            SGTimingLine.TimingLineProperties timingLineProperties = sGTimingLineDialog.getTimingLineProperties();
            if (timingLineProperties == null) {
                return false;
            }
            String string = sGTimingLineDialog.getAxisLocation();
            int n = SGTimingLineElement.this.mAxisElement.getConfigurationInCube(string);
            SGAxis sGAxis = SGTimingLineElement.this.mAxisElement.getAxisInCube(n);
            timingLineProperties.setAxis(sGAxis);
            timingLineProperties.setVisible(this.isVisible());
            return this.setProperties(timingLineProperties);
        }

        public boolean setDrawingElementsLocation() {
            SGAxis sGAxis = this.mAxis;
            double d = this.mValue;
            boolean bl = this.isHorizontal();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{new SGTuple2f(), new SGTuple2f()};
            if (!SGTimingLineElement.this.calcLocationOfTimingLine(d, sGAxis, bl, sGTuple2fArray[0], sGTuple2fArray[1])) {
                return false;
            }
            return this.setLocation(sGTuple2fArray);
        }

        private boolean isHorizontal() {
            ArrayList arrayList = SGTimingLineElement.this.mAxisElement.getHorizontalAxisList();
            ArrayList arrayList2 = SGTimingLineElement.this.mAxisElement.getPerpendicularAxisList();
            Boolean bl = null;
            if (arrayList.contains(this.mAxis)) {
                bl = Boolean.TRUE;
            }
            if (arrayList2.contains(this.mAxis)) {
                bl = Boolean.FALSE;
            }
            if (bl == null) {
                throw new Error("");
            }
            return bl;
        }

        public JDialog getDialog() {
            SGTimingLineDialog sGTimingLineDialog = SGTimingLineElement.this.mTimingLineDialog;
            this.setDialogProperty();
            sGTimingLineDialog.setLocation(SGTimingLineElement.this.mDialogOwner.getLocation());
            sGTimingLineDialog.setColorButtonBorder(true);
            sGTimingLineDialog.setActionListener(this);
            sGTimingLineDialog.addWindowListener(this);
            this.mTemporaryProperties = this.getProperties();
            return sGTimingLineDialog;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object.equals(SGTimingLineElement.this.mTimingLineDialog)) {
                this.onCanceled();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                this.getDialog().setVisible(true);
            } else if (string.equals("Copy") | string.equals("Cut") | string.equals("Paste") | string.equals("Delete") | string.equals("Duplicate") | string.equals("Move to Front") | string.equals("Move to Back")) {
                SGTimingLineElement.this.notifyToListener(string);
            }
            SGTimingLineDialog sGTimingLineDialog = SGTimingLineElement.this.mTimingLineDialog;
            if (string.equals("OK") || sGTimingLineDialog.getActiveComponentList().contains(object) ? !this.onOK() : (string.equals("Cancel") ? !this.onCanceled() : string.equals("Preview") && !this.onPreviewed())) {
                return;
            }
        }

        private boolean onOK() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.setChanged(true);
            }
            this.mTemporaryProperties = null;
            SGTimingLineElement.this.mTimingLineDialog.setVisible(false);
            SGTimingLineElement.this.mTimingLineDialog.removeActionListener();
            SGTimingLineElement.this.mTimingLineDialog.removeWindowListener(this);
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGTimingLineElement.this.notifyChange();
            this.notifyToRoot();
            return true;
        }

        private boolean onCanceled() {
            boolean bl = this.recover();
            if (!bl) {
                return false;
            }
            this.mTemporaryProperties = null;
            SGTimingLineElement.this.mTimingLineDialog.setVisible(false);
            SGTimingLineElement.this.mTimingLineDialog.removeActionListener();
            SGTimingLineElement.this.mTimingLineDialog.removeWindowListener(this);
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGTimingLineElement.this.notifyChange();
            return true;
        }

        private boolean onPreviewed() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGTimingLineElement.this.notifyChange();
            return true;
        }

        public boolean recover() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            return true;
        }

        public boolean initPropertiesHistory() {
            this.addElementGroupSetPropertyHistory(this.getProperties());
            return true;
        }

        private boolean addElementGroupSetPropertyHistory(SGProperties sGProperties) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mElementGroupSetStateCounter; ++i) {
                arrayList.add(this.mElementGroupSetPropertyHistoryList.get(i));
            }
            arrayList.add(sGProperties);
            this.mElementGroupSetPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mElementGroupSetStateCounter;
            SGProperties sGProperties = (SGProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            if (!this.setProperties(sGProperties)) {
                return false;
            }
            SGTimingLineElement.this.setAllDrawingElementsLocation();
            SGTimingLineElement.this.notifyChange();
            return true;
        }

        public boolean redo() {
            ++this.mElementGroupSetStateCounter;
            SGProperties sGProperties = (SGProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            if (!this.setProperties(sGProperties)) {
                return false;
            }
            SGTimingLineElement.this.setAllDrawingElementsLocation();
            SGTimingLineElement.this.notifyChange();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            if (this.isChanged()) {
                this.updateThisObjectHistory();
                this.setChanged(false);
                this.updateObjectHistory(this);
            }
            return true;
        }

        public boolean updateThisObjectHistory() {
            ++this.mElementGroupSetStateCounter;
            this.addElementGroupSetPropertyHistory(this.getProperties());
            return true;
        }

        public void notifyToRoot() {
            SGTimingLineElement.this.notifyToRootFromFigureElement();
        }

        public boolean isChanged() {
            return this.mChangedFlag;
        }

        public void setChanged(boolean bl) {
            this.mChangedFlag = bl;
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public String getTagName() {
            return TAG_NAME_TIMING_LINE;
        }

        public boolean writeProperty(Element element) {
            element.setAttribute("AxisPosition", SGTimingLineElement.this.mAxisElement.getAxisLocation(this.mAxis));
            element.setAttribute("Value", Double.toString(this.mValue));
            element.setAttribute("Width", Float.toString(this.mLineWidth) + "pt");
            element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.mLineType));
            element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
            return true;
        }

        public boolean readProperties(Element element, SGProperties sGProperties) {
            if (!(sGProperties instanceof SGTimingLine.TimingLineProperties)) {
                return false;
            }
            SGTimingLine.TimingLineProperties timingLineProperties = (SGTimingLine.TimingLineProperties)sGProperties;
            String string = null;
            Number number = null;
            Object var9_6 = null;
            Object var10_7 = null;
            ArrayList arrayList = null;
            string = element.getAttribute("Width");
            if (string.length() == 0) {
                return false;
            }
            number = SGUtilityText.getDouble(string, "pt");
            if (number == null) {
                return false;
            }
            timingLineProperties.setLineWidth(number.floatValue());
            string = element.getAttribute("Type");
            if (string.length() == 0) {
                return false;
            }
            number = SGDrawingElementLine.getLineTypeFromName(string);
            if (number == null) {
                return false;
            }
            timingLineProperties.setLineType(number.intValue());
            string = element.getAttribute("Color");
            if (string.length() == 0) {
                return false;
            }
            arrayList = SGUtilityText.getColorList(string);
            if (arrayList == null) {
                return false;
            }
            timingLineProperties.setColorList(arrayList);
            string = element.getAttribute("Value");
            if (string.length() == 0) {
                return false;
            }
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            timingLineProperties.setValue(number.doubleValue());
            string = element.getAttribute("AxisPosition");
            if (string.length() == 0) {
                return false;
            }
            int n = SGTimingLineElement.this.mAxisElement.getConfigurationInCube(string);
            SGAxis sGAxis = SGTimingLineElement.this.mAxisElement.getAxisInCube(n);
            if (sGAxis == null) {
                return false;
            }
            timingLineProperties.setAxis(sGAxis);
            timingLineProperties.setVisible(true);
            return true;
        }

        public Object copy() {
            TimingLine timingLine = new TimingLine();
            timingLine.setMagnification(this.mMagnification);
            timingLine.setProperties(this.getProperties());
            timingLine.mTempAxis = SGTimingLineElement.this.mAxisElement.getConfigurationInCube(this.mAxis);
            return timingLine;
        }
    }
}

