/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIPropertySettingListenerData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIPropertySettingListenerSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogVXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SGLegendElement
extends SGFigureElement
implements SGILegendElement,
SGIStringConstants,
CaretListener,
WindowListener,
ActionListener,
SGIMovable,
SGISelectable {
    private SGIGraphElement mGraphElement = null;
    private SGIAxisElement mAxisElement = null;
    private ArrayList mLegendList = new ArrayList();
    private SGAxis mXAxis = null;
    private SGAxis mYAxis = null;
    private float mLegendX = 0.0f;
    private float mLegendY = 0.0f;
    private float mLegendWidth = 0.0f;
    private float mLegendHeight = 0.0f;
    private float mFontSize;
    private int mFontStyle;
    private String mFontName;
    private Color mStringColor;
    private static final float MIN_WIDTH_DATA_ELEMENT = 70.86614f;
    private float mFrameLineWidth;
    private Color mFrameLineColor;
    private Color mBackgroundColor;
    private boolean mLegendVisibleFlag = true;
    private boolean mFrameVisibleFlag = true;
    private boolean mLegendTransparentFlag = true;
    private SGProperties mTemporaryProperties = null;
    private JPopupMenu mPopupMenu = new JPopupMenu();
    private SGLegendDialog mLegendDialog;
    private SGPropertyDialogSXYData mSXYDataDialog;
    private SGPropertyDialogVXYData mVXYDataDialog;
    private JTextField mEditField = new JTextField();
    public static final String MENUCMD_HIDE = "Hide";
    private boolean mStartFlag = true;
    private boolean mSelectedFlag = false;
    private static final float MARGIN_HORIZONTAL = 6.0f;
    private static final float MARGIN_VERTICAL = 4.0f;
    private static final float marginTop = 4.0f;
    private static final float marginBottom = 4.0f;
    private static final float marginLeft = 6.0f;
    private static final float marginRight = 6.0f;
    private static final float spaceDataAndString = 6.0f;
    private static final float spaceLegend = 4.0f;
    private ElementGroupSetInLegend mFocusedGroup = null;
    private Point mLegendLocation = null;
    private Point mPressedPoint = null;

    public SGLegendElement() {
        this.initEditField();
        if (!this.init()) {
            throw new Error();
        }
    }

    private boolean init() {
        this.setLegendVisible(true);
        this.setFontName("Serif");
        this.setFontSize(16.0f);
        int n = SGUtilityText.getFontStyle("Plain");
        if (n == -1) {
            return false;
        }
        this.setFontStyle(n);
        this.setStringColor(SGDefaultValues.LEGEND_STRING_COLOR);
        this.setFrameVisible(true);
        this.setFrameLineWidth(0.5f);
        this.setFrameLineColor(SGDefaultValues.LEGEND_FRAME_COLOR);
        this.setBackgroundColor(SGDefaultValues.LEGEND_BACKGROUND_COLOR);
        this.setLegendTransparent(false);
        this.createPopupMenu();
        return true;
    }

    private boolean createPopupMenu() {
        JPopupMenu jPopupMenu = this.mPopupMenu;
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Legend --"));
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, MENUCMD_HIDE);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Property");
        return true;
    }

    public String toString() {
        return new String("SGLegendElement");
    }

    public boolean addData(SGData sGData, String string) {
        if (this.mGraphElement == null || sGData == null) {
            throw new Error("mGraphElement==null || data==null");
        }
        super.addData(sGData, string);
        ElementGroupSetInLegend elementGroupSetInLegend = this.createGroupSet(sGData, string);
        this.createAllDrawingElements();
        this.updateSymbolsVisibleAroundFocusedObjects();
        if (this.mStartFlag) {
            this.onStartup(sGData);
        }
        return true;
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (this.mGraphElement == null || sGData == null) {
            throw new Error("mGraphElement==null || data==null");
        }
        super.addData(sGData, string, sGProperties);
        ElementGroupSetInLegend elementGroupSetInLegend = this.createGroupSet(sGData, string);
        if (!elementGroupSetInLegend.setWholeProperties(sGProperties)) {
            throw new Error();
        }
        this.createAllDrawingElements();
        this.updateSymbolsVisibleAroundFocusedObjects();
        if (this.mStartFlag) {
            this.onStartup(sGData);
        }
        return true;
    }

    private ElementGroupSetInLegend createGroupSet(SGData sGData, String string) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.createLegendElement(sGData, string);
        if (elementGroupSetInLegend == null) {
            return null;
        }
        elementGroupSetInLegend.setMagnification(this.mMagnification);
        this.mLegendList.add(elementGroupSetInLegend);
        return elementGroupSetInLegend;
    }

    private void onStartup(SGData sGData) {
        float f = this.getGraphRectX() + this.getGraphRectWidth() - this.mMagnification * this.getLegendWidth();
        float f2 = this.getGraphRectY();
        this.setLegendLocation(f, f2);
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        this.mXAxis = sGAxis;
        this.mYAxis = sGAxis2;
        this.createDataDialog(sGData);
        this.mStartFlag = false;
    }

    private void createDataDialog(SGData sGData) {
        if (sGData instanceof SGSXYData | sGData instanceof SGSXYMultipleData) {
            if (this.mSXYDataDialog == null) {
                this.mSXYDataDialog = new SGPropertyDialogSXYData(this.mDialogOwner, true);
            }
        } else if (!(sGData instanceof SGVXYData) || this.mVXYDataDialog == null) {
            // empty if block
        }
    }

    private SGPropertyDialog showDataDialog(ElementGroupSetInLegend elementGroupSetInLegend) {
        SGPropertyDialogSXYData sGPropertyDialogSXYData = null;
        if (elementGroupSetInLegend instanceof ElementGroupSetInLegendSXY) {
            sGPropertyDialogSXYData = this.mSXYDataDialog;
            sGPropertyDialogSXYData.setColorButtonBorder(true);
            sGPropertyDialogSXYData.setLocation(this.mDialogOwner.getLocation());
        }
        if (sGPropertyDialogSXYData == null) {
            return null;
        }
        sGPropertyDialogSXYData.addPropertySettingListener(elementGroupSetInLegend);
        ((SGPropertyDialog)sGPropertyDialogSXYData).setDialogProperty();
        sGPropertyDialogSXYData.setColorButtonBorder(true);
        elementGroupSetInLegend.createTemporaryPropertyObject();
        sGPropertyDialogSXYData.setVisible(true);
        sGPropertyDialogSXYData.removeAllPropertySettingListeners();
        return sGPropertyDialogSXYData;
    }

    private ElementGroupSetInLegend createLegendElement(SGData sGData, String string) {
        int n;
        Object object;
        int n2;
        ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = null;
        if (!(sGData instanceof SGSXYData) && !(sGData instanceof SGSXYMultipleData)) {
            return null;
        }
        elementGroupSetInLegendSXY = new ElementGroupSetInLegendSXY();
        elementGroupSetInLegendSXY.setName(string);
        ArrayList arrayList = this.mGraphElement.getDrawingElementList(sGData);
        if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object = (SGDrawingElement)arrayList.get(n2);
                if (object instanceof SGDrawingElementLine) {
                    elementGroupSetInLegendSXY.addDrawingElementGroup(0);
                    continue;
                }
                if (object instanceof SGDrawingElementRectangle) {
                    elementGroupSetInLegendSXY.addDrawingElementGroup(2);
                    continue;
                }
                if (object instanceof SGDrawingElementSymbol) {
                    elementGroupSetInLegendSXY.addDrawingElementGroup(1);
                    continue;
                }
                throw new Error();
            }
        } else if (sGData instanceof SGVXYData) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object = (SGDrawingElement)arrayList.get(n2);
                if (!(object instanceof SGDrawingElementArrow)) {
                    throw new Error();
                }
                elementGroupSetInLegendSXY.addDrawingElementGroup(3);
            }
        } else {
            throw new Error("This data-type is not defined.");
        }
        ArrayList arrayList2 = this.mGraphElement.getVisibleFlagList(sGData);
        object = elementGroupSetInLegendSXY.mDrawingElementGroupList;
        if (arrayList2.size() != ((ArrayList)object).size()) {
            throw new Error();
        }
        for (n = 0; n < ((ArrayList)object).size(); ++n) {
            SGElementGroup sGElementGroup = (SGElementGroup)((ArrayList)object).get(n);
            boolean bl = (Boolean)arrayList2.get(n);
            sGElementGroup.setVisible(bl);
        }
        n = this.mGraphElement.getVisibleInLegendFlag(sGData) ? 1 : 0;
        elementGroupSetInLegendSXY.setVisibleInLegend(n != 0);
        elementGroupSetInLegendSXY.initPropertiesHistory();
        return elementGroupSetInLegendSXY;
    }

    public ArrayList getDrawingElementList(SGData sGData) {
        return this.getLegendData(sGData).getDrawingElementList();
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        if (this.isSelected()) {
            arrayList.add(this);
        }
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        return true;
    }

    public String getDataName(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getLegendData(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.mName;
        }
        return null;
    }

    public boolean isDataVisible(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        return elementGroupSetInLegend.isVisible();
    }

    protected ElementGroupSetInLegend getLegendData(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            return elementGroupSetInLegend;
        }
        return null;
    }

    public ArrayList getVisibleFlagList(SGData sGData) {
        if (sGData == null) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        ElementGroupSetInLegend elementGroupSetInLegend = this.getLegendData(sGData);
        ArrayList arrayList2 = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
            boolean bl = sGElementGroup.isVisible();
            arrayList.add(new Boolean(bl));
        }
        return arrayList;
    }

    public void setSelected(boolean bl) {
        this.mSelectedFlag = bl;
    }

    public boolean isSelected() {
        return this.mSelectedFlag;
    }

    public float getLegendX() {
        return this.mGraphRectX + this.mLegendX * this.mMagnification;
    }

    public float getLegendY() {
        return this.mGraphRectY + this.mLegendY * this.mMagnification;
    }

    public float getLegendWidth() {
        return this.mLegendWidth;
    }

    public float getLegendHeight() {
        return this.mLegendHeight;
    }

    public Point2D getLegendLocation() {
        Point2D.Float float_ = new Point2D.Float(this.getLegendX(), this.getLegendY());
        return float_;
    }

    public boolean setLegendLocation(float f, float f2) {
        this.mLegendX = (f - this.mGraphRectX) / this.mMagnification;
        this.mLegendY = (f2 - this.mGraphRectY) / this.mMagnification;
        return true;
    }

    public void translate(int n, int n2) {
        this.setLegendLocation(this.getLegendX() + (float)n, this.getLegendY() + (float)n2);
        this.createAllDrawingElements();
    }

    private double getXValue() {
        SGAxis sGAxis = this.mXAxis;
        double d = this.calcValue(this.getLegendX(), sGAxis, true);
        d = this.getNumberInRangeOrder(d, sGAxis);
        return d;
    }

    private double getYValue() {
        SGAxis sGAxis = this.mYAxis;
        double d = this.calcValue(this.getLegendY(), sGAxis, false);
        d = this.getNumberInRangeOrder(d, sGAxis);
        return d;
    }

    private boolean initEditField() {
        this.setLayout(null);
        this.add(this.mEditField);
        this.mEditField.setVisible(false);
        this.mEditField.addActionListener(this);
        this.mEditField.addCaretListener(this);
        return true;
    }

    public boolean clearFocusedObjects() {
        if (!super.clearFocusedObjects()) {
            return false;
        }
        if (this.mEditField.isVisible()) {
            this.terminateEditField();
        }
        this.clearFocusedGroup();
        return true;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    public JDialog getDialog() {
        this.mLegendDialog.setColorButtonBorder(true);
        this.mLegendDialog.setLocation(this.mDialogOwner.getLocation());
        this.setDialogProperty();
        this.mTemporaryProperties = this.getProperties();
        return this.mLegendDialog;
    }

    private boolean createDialog() {
        SGLegendDialog sGLegendDialog = new SGLegendDialog(this.mDialogOwner, true);
        sGLegendDialog.setActionListener(this);
        sGLegendDialog.addWindowListener(this);
        this.mLegendDialog = sGLegendDialog;
        return true;
    }

    private boolean setDialogProperty() {
        SGLegendDialog sGLegendDialog = this.mLegendDialog;
        double d = this.calcValue(this.getLegendX(), this.mXAxis, true);
        double d2 = this.calcValue(this.getLegendY(), this.mYAxis, false);
        d = this.getNumberInRangeOrder(d, this.mXAxis);
        d2 = this.getNumberInRangeOrder(d2, this.mYAxis);
        sGLegendDialog.setXValue(new Double(d));
        sGLegendDialog.setYValue(new Double(d2));
        sGLegendDialog.setLegendVisible(this.mLegendVisibleFlag);
        sGLegendDialog.setFrameVisible(this.mFrameVisibleFlag);
        sGLegendDialog.setFrameLineWidth(this.mFrameLineWidth);
        sGLegendDialog.setFrameLineColor(this.mFrameLineColor);
        sGLegendDialog.setFontName(this.mFontName);
        sGLegendDialog.setFontSize(this.mFontSize);
        sGLegendDialog.setFontStyle(this.mFontStyle);
        sGLegendDialog.setTextColor(this.mStringColor);
        sGLegendDialog.setBackgroundColor(this.mBackgroundColor);
        sGLegendDialog.setLegendTransparent(this.mLegendTransparentFlag);
        this.setDialogPropertyOfAxis();
        return true;
    }

    private boolean setDialogPropertyOfAxis() {
        int n;
        SGLegendDialog sGLegendDialog = this.mLegendDialog;
        int n2 = this.mAxisElement.getConfigurationInPlane(this.mXAxis);
        boolean bl = sGLegendDialog.setAxisRadioButton(n2, n = this.mAxisElement.getConfigurationInPlane(this.mYAxis));
        return bl;
    }

    private LegendCommonProperties getCommonPropertiesFromDialog() {
        SGLegendDialog sGLegendDialog = this.mLegendDialog;
        LegendCommonProperties legendCommonProperties = sGLegendDialog.getCommonProperties();
        if (legendCommonProperties == null) {
            return null;
        }
        return legendCommonProperties;
    }

    protected SGProperties getCommonProperties() {
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties.x = this.mLegendX;
        legendCommonProperties.y = this.mLegendY;
        legendCommonProperties.visible = this.isLegendVisible();
        legendCommonProperties.frameLineVisible = this.isFrameLineVisible();
        legendCommonProperties.frameLineWidth = this.getFrameLineWidth();
        legendCommonProperties.frameLineColor = this.getFrameLineColor();
        legendCommonProperties.backgroundColor = this.getBackgroundColor();
        legendCommonProperties.transparent = this.isLegendTransparent();
        legendCommonProperties.fontName = this.getFontName();
        legendCommonProperties.fontSize = this.getFontSize();
        legendCommonProperties.fontStyle = this.getFontStyle();
        legendCommonProperties.stringColor = this.getStringColor();
        legendCommonProperties.xAxis = this.mXAxis;
        legendCommonProperties.yAxis = this.mYAxis;
        return legendCommonProperties;
    }

    public SGProperties getDataProperties(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.getWholeProperties();
        }
        return null;
    }

    protected TreeMap getDataPropertiesMap() {
        TreeMap<Integer, SGProperties> treeMap = new TreeMap<Integer, SGProperties>();
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            SGProperties sGProperties = elementGroupSetInLegend.getProperties();
            SGData sGData = this.getData(elementGroupSetInLegend);
            treeMap.put(new Integer(sGData.hashCode()), sGProperties);
        }
        return treeMap;
    }

    public SGProperties getProperties() {
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties = (LegendCommonProperties)this.getCommonProperties();
        return legendCommonProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LegendCommonProperties)) {
            return false;
        }
        LegendCommonProperties legendCommonProperties = (LegendCommonProperties)sGProperties;
        return this.setCommonProperties(legendCommonProperties);
    }

    protected SGData getData(int n) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData = (SGData)this.mDataList.get(i);
            if (sGData.hashCode() != n) continue;
            return sGData;
        }
        return null;
    }

    private boolean setCommonProperties(LegendCommonProperties legendCommonProperties) {
        this.mLegendX = legendCommonProperties.x;
        this.mLegendY = legendCommonProperties.y;
        this.setLegendVisible(legendCommonProperties.visible);
        this.setFrameVisible(legendCommonProperties.frameLineVisible);
        this.setFrameLineWidth(legendCommonProperties.frameLineWidth);
        this.setFrameLineColor(legendCommonProperties.frameLineColor);
        this.setBackgroundColor(legendCommonProperties.backgroundColor);
        this.setLegendTransparent(legendCommonProperties.transparent);
        this.setFontName(legendCommonProperties.fontName);
        this.setFontSize(legendCommonProperties.fontSize);
        this.setFontStyle(legendCommonProperties.fontStyle);
        this.setStringColor(legendCommonProperties.stringColor);
        this.mXAxis = legendCommonProperties.xAxis;
        this.mYAxis = legendCommonProperties.yAxis;
        return true;
    }

    private boolean setPropertyWithDialog() {
        float f;
        float f2;
        LegendCommonProperties legendCommonProperties = this.getCommonPropertiesFromDialog();
        if (legendCommonProperties == null) {
            return false;
        }
        SGLegendDialog sGLegendDialog = this.mLegendDialog;
        String string = sGLegendDialog.getXAxisLocation();
        SGAxis sGAxis = this.mAxisElement.getAxis(string);
        String string2 = sGLegendDialog.getYAxisLocation();
        SGAxis sGAxis2 = this.mAxisElement.getAxis(string2);
        legendCommonProperties.xAxis = sGAxis;
        legendCommonProperties.yAxis = sGAxis2;
        Number number = sGLegendDialog.getXValue();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(sGLegendDialog);
            return false;
        }
        Number number2 = sGLegendDialog.getYValue();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(sGLegendDialog);
            return false;
        }
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        double d3 = this.calcValue(this.getLegendX(), sGAxis, true);
        double d4 = this.calcValue(this.getLegendY(), sGAxis2, false);
        d3 = this.getNumberInRangeOrder(d3, sGAxis);
        d4 = this.getNumberInRangeOrder(d4, sGAxis2);
        if (d == d3) {
            f2 = this.mLegendX;
        } else {
            f = this.calcLocation(d, sGAxis, true);
            f2 = (f - this.mGraphRectX) / this.mMagnification;
        }
        if (d2 == d4) {
            f = this.mLegendY;
        } else {
            float f3 = this.calcLocation(d2, sGAxis2, false);
            f = (f3 - this.mGraphRectY) / this.mMagnification;
        }
        legendCommonProperties.x = f2;
        legendCommonProperties.y = f;
        return this.setCommonProperties(legendCommonProperties);
    }

    private boolean createAllDrawingElements() {
        int n;
        int n2;
        int n3;
        float f = this.mMagnification;
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        int n4 = arrayList.size();
        ElementGroupSetInLegend[] elementGroupSetInLegendArray = new ElementGroupSetInLegend[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            elementGroupSetInLegendArray[n3] = (ElementGroupSetInLegend)arrayList.get(n3);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            elementGroupSetInLegendArray[n3].createStringElement();
        }
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n4];
        for (int i = 0; i < n4; ++i) {
            rectangle2DArray[i] = elementGroupSetInLegendArray[i].getStringBounds();
        }
        float[] fArray = new float[n4];
        for (int i = 0; i < n4; ++i) {
            fArray[i] = (float)rectangle2DArray[i].getHeight();
        }
        float f2 = 0.0f;
        for (int i = 0; i < n4; ++i) {
            float f3 = (float)rectangle2DArray[i].getWidth();
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        float f4 = 70.86614f;
        for (int i = 0; i < n4; ++i) {
            float f5 = elementGroupSetInLegendArray[i].getMaxDataElementWidth() / f;
            if (!(f5 > f4)) continue;
            f4 = f5;
        }
        float f6 = f4 + f2 / f + 6.0f;
        double[] dArray = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray[i] = elementGroupSetInLegendArray[i].getMaxDataElementHeight();
        }
        float[] fArray2 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            fArray2[i] = (float)Math.max(dArray[i], (double)fArray[i]);
        }
        Rectangle2D[] rectangle2DArray2 = new Rectangle2D[n4];
        float f7 = this.getLegendY() + f * 4.0f;
        float f8 = this.getLegendX() + f * 6.0f;
        float f9 = f * f6;
        for (n2 = 0; n2 < n4; ++n2) {
            float f10 = f7;
            float f11 = fArray2[n2];
            rectangle2DArray2[n2] = new Rectangle2D.Float(f8, f10, f9, f11);
            f7 += f11 + f * 4.0f;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            elementGroupSetInLegendArray[n2].setRect(rectangle2DArray2[n2]);
        }
        float f12 = 0.0f;
        for (n = 0; n < n4; ++n) {
            f12 += fArray2[n] / f;
        }
        f12 += (float)(n4 - 1) * 4.0f;
        for (n = 0; n < n4; ++n) {
            elementGroupSetInLegendArray[n].createDrawingElement();
        }
        float f13 = this.getLegendX() + f * (6.0f + f4 + 6.0f);
        for (int i = 0; i < n4; ++i) {
            float f14 = (float)rectangle2DArray2[i].getY() + 0.5f * (float)rectangle2DArray2[i].getHeight() - 0.5f * fArray[i];
            elementGroupSetInLegendArray[i].getStringElement().setLocation(f13, f14);
        }
        this.mLegendWidth = 6.0f + f6 + 6.0f;
        this.mLegendHeight = 4.0f + f12 + 4.0f;
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        if (!this.terminateEditField()) {
            return false;
        }
        return this.createAllDrawingElements();
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isLegendVisible()) {
            Cloneable cloneable;
            if (!this.mLegendTransparentFlag) {
                cloneable = this.getLegendRect();
                graphics2D.setPaint(this.getBackgroundColor());
                graphics2D.fill((Shape)((Object)cloneable));
            }
            cloneable = this.getVisibleTotallyLegendList();
            for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)((ArrayList)cloneable).get(i);
                elementGroupSetInLegend.paintGraphics2D(graphics2D);
            }
            if (this.mFrameVisibleFlag & ((ArrayList)cloneable).size() != 0) {
                this.drawLegendFrameLines(graphics2D);
            }
            if (this.mSymbolsVisibleFlagAroundAllObjects & ((ArrayList)cloneable).size() != 0) {
                ArrayList arrayList = this.getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsChildObject(arrayList, graphics2D);
            }
            if (this.mSymbolsVisibleFlagAroundFocusedObjects & this.isSelected()) {
                ArrayList arrayList = this.getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsFocusedObject(arrayList, graphics2D);
            }
        }
    }

    private void updateSymbolsVisibleAroundFocusedObjects() {
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        this.setSymbolsVisibleAroundFocusedObjects(arrayList.size() != 0);
    }

    private ArrayList getAnchorPointList() {
        ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
        Rectangle2D rectangle2D = this.getLegendRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        Point2D.Float float_ = new Point2D.Float(f, f2);
        Point2D.Float float_2 = new Point2D.Float(f, f2 + f4);
        Point2D.Float float_3 = new Point2D.Float(f + f3, f2);
        Point2D.Float float_4 = new Point2D.Float(f + f3, f2 + f4);
        arrayList.add(float_);
        arrayList.add(float_2);
        arrayList.add(float_3);
        arrayList.add(float_4);
        return arrayList;
    }

    private void drawLegendFrameLines(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        if (arrayList.size() == 0) {
            return;
        }
        graphics2D.setPaint(this.mFrameLineColor);
        graphics2D.setStroke(new BasicStroke(this.mMagnification * this.mFrameLineWidth, 0, 0));
        graphics2D.draw(this.getLegendRect());
    }

    public boolean contains(int n, int n2) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getLegendX(), this.getLegendY(), this.mLegendWidth, this.mLegendHeight);
        return float_.contains(n, n2);
    }

    public boolean removeData(SGData sGData) {
        for (int i = this.mDataList.size() - 1; i >= 0; --i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            this.mDataList.remove(i);
            this.mLegendList.remove(i);
        }
        return true;
    }

    protected boolean moveGraphToFront(SGElementGroupSet sGElementGroupSet) {
        SGData sGData = null;
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mLegendList.get(i))) continue;
            this.mLegendList.remove(i);
            sGData = (SGData)this.mDataList.remove(i);
            break;
        }
        this.mLegendList.add(this.mLegendList.size(), sGElementGroupSet);
        this.mDataList.add(this.mDataList.size(), sGData);
        return true;
    }

    protected boolean moveGraphToBack(SGElementGroupSet sGElementGroupSet) {
        SGData sGData = null;
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mLegendList.get(i))) continue;
            this.mLegendList.remove(i);
            sGData = (SGData)this.mDataList.remove(i);
            break;
        }
        this.mLegendList.add(0, sGElementGroupSet);
        this.mDataList.add(0, sGData);
        return true;
    }

    protected boolean removeGraph(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mLegendList.get(i))) continue;
            this.mLegendList.remove(i);
            this.mDataList.remove(i);
            return true;
        }
        return false;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIAxisElement)) {
            if (sGIFigureElement instanceof SGIGraphElement) {
                SGIGraphElement sGIGraphElement = (SGIGraphElement)sGIFigureElement;
                bl = this.synchronizeToGraphElement(sGIGraphElement);
            } else if (!(sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement || sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement || sGIFigureElement instanceof SGIGridElement)) {
                bl = sGIFigureElement.synchronizeArgument(this);
            }
        }
        return bl;
    }

    private boolean synchronizeToGraphElement(SGIGraphElement sGIGraphElement) {
        Object object;
        Object object2;
        SGData sGData;
        int n;
        ArrayList arrayList = sGIGraphElement.getDataList();
        if (arrayList.size() != this.mDataList.size()) {
            throw new Error("dataList.size() != this.mDataList.size()");
        }
        ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        block0: for (n = 0; n < arrayList.size(); ++n) {
            sGData = (SGData)arrayList.get(n);
            for (int i = this.mDataList.size() - 1; i >= 0; --i) {
                SGData sGData2 = (SGData)this.mDataList.get(i);
                if (!sGData.equals(sGData2)) continue;
                object2 = (SGData)this.mDataList.remove(i);
                arrayList2.add((SGData)object2);
                object = (SGElementGroupSet)this.mLegendList.remove(i);
                arrayList3.add(object);
                continue block0;
            }
        }
        this.mDataList = arrayList2;
        this.mLegendList = arrayList3;
        for (n = this.mDataList.size() - 1; n >= 0; --n) {
            int n2;
            sGData = (SGData)this.mDataList.get(n);
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(n);
            boolean bl = false;
            object2 = sGIGraphElement.getDataName(sGData);
            if (!((String)object2).equals(object = elementGroupSetInLegend.getName())) {
                elementGroupSetInLegend.setChanged(true);
            }
            elementGroupSetInLegend.setName((String)object2);
            boolean bl2 = sGIGraphElement.isDataVisible(sGData);
            if (bl2 != elementGroupSetInLegend.isVisible()) {
                this.setChanged(true);
            }
            elementGroupSetInLegend.setVisible(bl2);
            ArrayList arrayList4 = sGIGraphElement.getDrawingElementList(sGData);
            for (n2 = arrayList4.size() - 1; n2 >= 0; --n2) {
                SGProperties sGProperties;
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList4.get(n2);
                ArrayList arrayList5 = elementGroupSetInLegend.mDrawingElementGroupList;
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList5.get(n2);
                SGDrawingElement sGDrawingElement2 = sGElementGroup.getDrawingElement();
                SGProperties sGProperties2 = sGDrawingElement.getProperties();
                if (!sGProperties2.equals(sGProperties = sGDrawingElement2.getProperties())) {
                    bl = true;
                }
                sGElementGroup.setProperty(sGDrawingElement);
            }
            n2 = sGIGraphElement.getVisibleInLegendFlag(sGData) ? 1 : 0;
            if (n2 != elementGroupSetInLegend.isVisibleInLegend()) {
                bl = true;
            }
            elementGroupSetInLegend.setVisibleInLegend(n2 != 0);
            if (!bl) continue;
            elementGroupSetInLegend.setChanged(true);
        }
        this.createAllDrawingElements();
        this.updateSymbolsVisibleAroundFocusedObjects();
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    public boolean setISize(SGTuple2f sGTuple2f) {
        super.setISize(sGTuple2f);
        this.createAllDrawingElements();
        return true;
    }

    public boolean zoom(float f) {
        if (!super.zoom(f)) {
            return false;
        }
        if (!this.terminateEditField()) {
            return false;
        }
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
            elementGroupSetInLegend.zoom(f);
        }
        this.createAllDrawingElements();
        return true;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphRect();
        Rectangle2D rectangle2D2 = this.getLegendRect();
        if (rectangle2D2.getWidth() < Double.MIN_VALUE || rectangle2D2.getHeight() < Double.MIN_VALUE) {
            return true;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(rectangle2D);
        if (this.isLegendVisible()) {
            arrayList.add(rectangle2D2);
        }
        Rectangle2D rectangle2D3 = SGUtility.createUnion(arrayList);
        float f = (float)(rectangle2D.getY() - rectangle2D3.getY());
        float f2 = (float)(rectangle2D3.getY() + rectangle2D3.getHeight() - (rectangle2D.getY() + rectangle2D.getHeight()));
        float f3 = (float)(rectangle2D.getX() - rectangle2D3.getX());
        float f4 = (float)(rectangle2D3.getX() + rectangle2D3.getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        if (!this.isLegendVisible()) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        boolean bl = false;
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Rectangle2D rectangle2D;
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
            Rectangle2D rectangle2D2 = elementGroupSetInLegend.getRect();
            if (rectangle2D2 == null || !rectangle2D2.contains(n, n2) || !(rectangle2D = elementGroupSetInLegend.getStringBounds()).contains(n, n2) || !(SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 1)) continue;
            if (this.isSelected()) {
                this.showEditField(elementGroupSetInLegend);
                continue;
            }
            this.updateFocusedObjectsList((SGISelectable)this, mouseEvent);
        }
        Rectangle2D rectangle2D = this.getLegendRect();
        if (rectangle2D.contains(n, n2)) {
            this.updateFocusedObjectsList((SGISelectable)this, mouseEvent);
            if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                this.mPopupMenu.show(this, n, n2);
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 2) {
                this.getDialog().setVisible(true);
            }
            return true;
        }
        return false;
    }

    public String getFontName() {
        return this.mFontName;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public float getFrameLineWidth() {
        return this.mFrameLineWidth;
    }

    public Color getFrameLineColor() {
        return this.mFrameLineColor;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public Color getStringColor() {
        return this.mStringColor;
    }

    private boolean showEditField(ElementGroupSetInLegend elementGroupSetInLegend) {
        this.mFocusedGroup = elementGroupSetInLegend;
        JTextField jTextField = this.mEditField;
        Rectangle2D rectangle2D = elementGroupSetInLegend.getStringBounds();
        float f = this.getMagnification() * this.getFontSize();
        int n = (int)(rectangle2D.getX() - (double)jTextField.getInsets().left);
        int n2 = (int)(rectangle2D.getY() - (double)(f / 2.0f));
        int n3 = (int)(rectangle2D.getWidth() + (double)f);
        int n4 = (int)(rectangle2D.getHeight() + (double)f);
        jTextField.setLocation(n, n2);
        jTextField.setSize(n3, n4);
        Font font = new Font(this.getFontName(), this.getFontStyle(), (int)f);
        jTextField.setFont(font);
        jTextField.setForeground(this.mStringColor);
        jTextField.setText(elementGroupSetInLegend.getName());
        jTextField.setVisible(true);
        jTextField.requestFocus();
        jTextField.setCaretPosition(0);
        return true;
    }

    private boolean isMoved() {
        boolean bl = (int)this.mLegendX == (int)this.mLegendLocation.getX();
        boolean bl2 = (int)this.mLegendY == (int)this.mLegendLocation.getY();
        boolean bl3 = !bl || !bl2;
        return bl3;
    }

    private boolean terminateEditField() {
        this.commitEdit();
        this.hideEditField();
        this.clearFocusedGroup();
        return true;
    }

    private boolean commitEdit() {
        char c;
        String string = this.mEditField.getText();
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        if (n < string.length() && ((c = string.charAt(n)) == ' ' || c == '\u3000')) {
            return false;
        }
        String string2 = this.mFocusedGroup.getName();
        String string3 = string;
        this.mFocusedGroup.setName(string3);
        this.createAllDrawingElements();
        if (!string2.equals(string3)) {
            if (!this.mFocusedGroup.updateHistory()) {
                return false;
            }
            this.mFocusedGroup.setChanged(true);
        }
        this.notifyChange();
        this.notifyToRoot();
        return true;
    }

    private boolean hideEditField() {
        this.mEditField.setText("");
        this.mEditField.setVisible(false);
        return true;
    }

    private boolean clearFocusedGroup() {
        this.mFocusedGroup = null;
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        Rectangle2D rectangle2D;
        if (!this.isLegendVisible()) {
            return false;
        }
        if (this.mEditField.isVisible()) {
            this.terminateEditField();
        }
        if ((rectangle2D = this.getLegendRect()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.mLegendLocation = new Point((int)this.mLegendX, (int)this.mLegendY);
            this.mPressedPoint = mouseEvent.getPoint();
            this.setMouseCursor(13);
            return true;
        }
        this.clearFocusedGroup();
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (this.isSelected()) {
            int n = mouseEvent.getX() - this.mPressedPoint.x;
            int n2 = mouseEvent.getY() - this.mPressedPoint.y;
            this.translate(n, n2);
            this.mPressedPoint = mouseEvent.getPoint();
            if (!this.createAllDrawingElements()) {
                return false;
            }
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        Rectangle2D rectangle2D;
        if (this.mLegendLocation != null && this.isMoved()) {
            this.mChangedFlag = true;
        }
        if ((rectangle2D = this.getLegendRect()).contains(mouseEvent.getPoint())) {
            this.setMouseCursor(12);
        } else {
            this.setMouseCursor(0);
        }
        return true;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    public boolean setChangedFocusedObjects() {
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties2.equals(sGProperties)) {
            this.setChanged(true);
        }
        return true;
    }

    public Rectangle2D getLegendRect() {
        float f = this.mMagnification;
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getLegendX(), this.getLegendY(), f * this.mLegendWidth, f * this.mLegendHeight);
        return float_;
    }

    public boolean isResizable(double d, double d2) {
        Rectangle2D rectangle2D = this.getLegendRect();
        return !(d < rectangle2D.getWidth()) && !(d2 < rectangle2D.getHeight());
    }

    public void caretUpdate(CaretEvent caretEvent) {
        String string = this.mEditField.getText();
        Font font = new Font(this.getFontName(), this.getFontStyle(), (int)(this.getFontSize() * this.getMagnification()));
        Rectangle2D rectangle2D = font.getStringBounds(string, new FontRenderContext(null, false, false));
        double d = rectangle2D.getWidth();
        if (d > (double)this.mEditField.getWidth()) {
            this.mEditField.setSize((int)(rectangle2D.getWidth() + (double)(this.getMagnification() * this.getFontSize())), this.mEditField.getHeight());
        }
    }

    public boolean onDrawingElement(int n, int n2) {
        if (this.isLegendVisible() && this.getLegendRect().contains(n, n2)) {
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    public boolean setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
        return true;
    }

    public boolean setGraphElement(SGIGraphElement sGIGraphElement) {
        this.mGraphElement = sGIGraphElement;
        return true;
    }

    public boolean setLegendVisible(boolean bl) {
        this.mLegendVisibleFlag = bl;
        return true;
    }

    public boolean setLegendTransparent(boolean bl) {
        this.mLegendTransparentFlag = bl;
        return true;
    }

    public boolean setFrameVisible(boolean bl) {
        this.mFrameVisibleFlag = bl;
        return true;
    }

    public boolean setFrameLineWidth(float f) {
        this.mFrameLineWidth = f;
        return true;
    }

    public boolean setFrameLineColor(Color color) {
        this.mFrameLineColor = color;
        return true;
    }

    public boolean setBackgroundColor(Color color) {
        this.mBackgroundColor = color;
        return true;
    }

    public boolean setFontSize(float f) {
        this.mFontSize = f;
        return true;
    }

    public boolean setFontStyle(int n) {
        this.mFontStyle = n;
        return true;
    }

    public boolean setStringColor(Color color) {
        this.mStringColor = color;
        return true;
    }

    public boolean setFontName(String string) {
        this.mFontName = string;
        return true;
    }

    private SGData getData(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = this.mLegendList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend2 = (ElementGroupSetInLegend)arrayList.get(i);
            if (!elementGroupSetInLegend2.equals(elementGroupSetInLegend)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public boolean isLegendVisible() {
        int n;
        int n2 = this.mLegendVisibleFlag;
        int n3 = 0;
        ArrayList arrayList = this.mLegendList;
        for (n = 0; n < arrayList.size(); ++n) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(n);
            boolean bl = elementGroupSetInLegend.isVisibleTotally();
            if (!bl) continue;
            n3 = 1;
            break;
        }
        n = n2 & n3;
        return n != 0;
    }

    public boolean isFrameLineVisible() {
        return this.mFrameVisibleFlag;
    }

    public boolean isLegendTransparent() {
        return this.mLegendTransparentFlag;
    }

    public Rectangle2D getRectOfGroup(SGElementGroup sGElementGroup) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
            for (int j = 0; j < arrayList.size(); ++j) {
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(j);
                if (!sGElementGroup2.equals(sGElementGroup)) continue;
                return elementGroupSetInLegend.mDataRect;
            }
        }
        return null;
    }

    public Rectangle2D getRectOfGroupSet(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            if (!sGElementGroupSet.equals(elementGroupSetInLegend)) continue;
            return elementGroupSetInLegend.mDataRect;
        }
        return null;
    }

    private ElementGroupLine getGroupLine(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupLine)) continue;
            return (ElementGroupLine)sGElementGroup;
        }
        return null;
    }

    private ElementGroupBar getGroupBar(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupBar)) continue;
            return (ElementGroupBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupSymbol getGroupSymbol(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupSymbol)) continue;
            return (ElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object.equals(this.mEditField)) {
            this.terminateEditField();
            return;
        }
        if (string.equals(MENUCMD_HIDE)) {
            this.setLegendVisible(false);
            this.repaint();
            this.setChanged(true);
            this.notifyToRoot();
            return;
        }
        if (string.equals("Property")) {
            this.getDialog().setVisible(true);
        }
        if (string.equals("OK") || this.mLegendDialog.getActiveComponentList().contains(object) ? !this.onOK() : (string.equals("Cancel") ? !this.onCanceled() : string.equals("Preview") && !this.onPreviewed())) {
            return;
        }
    }

    private boolean onOK() {
        if (!this.setPropertyWithDialog()) {
            return false;
        }
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mChangedFlag = true;
        }
        this.mTemporaryProperties = null;
        this.mLegendDialog.setVisible(false);
        this.createAllDrawingElements();
        this.notifyChange();
        this.notifyToRoot();
        return true;
    }

    public boolean addPropertiesHistory(SGProperties sGProperties) {
        if (!(sGProperties instanceof LegendCommonProperties)) {
            return false;
        }
        super.addPropertiesHistory(sGProperties);
        return true;
    }

    private boolean onCanceled() {
        boolean bl = this.recover();
        if (!bl) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.mLegendDialog.setVisible(false);
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    private boolean onPreviewed() {
        if (!this.setPropertyWithDialog()) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object.equals(this.mLegendDialog)) {
            this.onCanceled();
        }
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        ArrayList arrayList = this.getVisibleLegendList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            if (!sGIUndoable.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean updateHistory() {
        ArrayList arrayList = this.getVisibleLegendList();
        return this.updateHistory_(arrayList);
    }

    protected ArrayList getVisibleLegendList() {
        ArrayList<ElementGroupSetInLegend> arrayList = new ArrayList<ElementGroupSetInLegend>();
        ArrayList arrayList2 = this.mLegendList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList2.get(i);
            if (!elementGroupSetInLegend.isVisible()) continue;
            arrayList.add(elementGroupSetInLegend);
        }
        return arrayList;
    }

    protected ArrayList getVisibleTotallyLegendList() {
        ArrayList<ElementGroupSetInLegend> arrayList = new ArrayList<ElementGroupSetInLegend>();
        ArrayList arrayList2 = this.mLegendList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList2.get(i);
            if (!elementGroupSetInLegend.isVisibleTotally()) continue;
            arrayList.add(elementGroupSetInLegend);
        }
        return arrayList;
    }

    public boolean recover() {
        return this.setProperties(this.mTemporaryProperties);
    }

    protected ElementGroupSetInLegend getElementGroupSet(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            return elementGroupSetInLegend;
        }
        return null;
    }

    protected SGData getData(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet2 = (SGElementGroupSet)this.mLegendList.get(i);
            if (!sGElementGroupSet2.equals(sGElementGroupSet)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (!super.createDataObject(element, sGData)) {
            return false;
        }
        ElementGroupSetInLegend elementGroupSetInLegend = this.getGroupSetNewInstance(sGData);
        if (elementGroupSetInLegend == null) {
            return false;
        }
        this.mLegendList.add(elementGroupSetInLegend);
        int n = this.setProperty(element, elementGroupSetInLegend);
        if (n == 1) {
            return false;
        }
        this.createAllDrawingElements();
        this.mStartFlag = false;
        this.createDataDialog(sGData);
        return true;
    }

    protected ElementGroupSetInLegend getGroupSetNewInstance(SGData sGData) {
        ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = null;
        if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
            elementGroupSetInLegendSXY = new ElementGroupSetInLegendSXY();
        }
        return elementGroupSetInLegendSXY;
    }

    private int setProperty(Element element, ElementGroupSetInLegend elementGroupSetInLegend) {
        SGData sGData = this.getData(elementGroupSetInLegend);
        int n = 1;
        if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)elementGroupSetInLegend;
            n = this.setPropertyOfElementGroupSetInLegendSXY(element, elementGroupSetInLegendSXY);
        } else if (sGData instanceof SGVXYData) {
            // empty if block
        }
        return n;
    }

    private int setPropertyOfElementGroupSetInLegendSXY(Element element, ElementGroupSetInLegendSXY elementGroupSetInLegendSXY) {
        String string = null;
        string = element.getAttribute("Name");
        if (string.length() == 0) {
            return 1;
        }
        String string2 = string;
        elementGroupSetInLegendSXY.setName(string2);
        string = element.getAttribute("VisibleInLegend");
        if (string.length() == 0) {
            return 1;
        }
        Boolean bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return 1;
        }
        elementGroupSetInLegendSXY.setVisibleInLegend(bl);
        SGElementGroup sGElementGroup = null;
        NodeList nodeList = null;
        nodeList = element.getElementsByTagName("Line");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInLegendSXY.addDrawingElementGroup(0)) {
            return 1;
        }
        Element element2 = (Element)nodeList.item(0);
        sGElementGroup = (SGElementGroup)elementGroupSetInLegendSXY.getLineGroups().get(0);
        if (!sGElementGroup.readProperty(element2)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("Symbol");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInLegendSXY.addDrawingElementGroup(1)) {
            return 1;
        }
        Element element3 = (Element)nodeList.item(0);
        sGElementGroup = (SGElementGroup)elementGroupSetInLegendSXY.getSymbolGroups().get(0);
        if (!sGElementGroup.readProperty(element3)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("Bar");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInLegendSXY.addDrawingElementGroup(2)) {
            return 1;
        }
        Element element4 = (Element)nodeList.item(0);
        sGElementGroup = (SGElementGroup)elementGroupSetInLegendSXY.getBarGroups().get(0);
        if (!sGElementGroup.readProperty(element4)) {
            return 1;
        }
        elementGroupSetInLegendSXY.initPropertiesHistory();
        return 0;
    }

    public String getTagName() {
        return "Legend";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("LegendVisible", Boolean.toString(this.mLegendVisibleFlag));
        element.setAttribute("XAxisPosition", this.mAxisElement.getAxisLocation(this.mXAxis));
        element.setAttribute("YAxisPosition", this.mAxisElement.getAxisLocation(this.mYAxis));
        element.setAttribute("XValue", Double.toString(this.getXValue()));
        element.setAttribute("YValue", Double.toString(this.getYValue()));
        element.setAttribute("FrameVisible", Boolean.toString(this.mFrameVisibleFlag));
        element.setAttribute("FrameLineWidth", Float.toString(this.mFrameLineWidth) + "pt");
        element.setAttribute("FrameLineColor", SGUtilityText.getColorString(this.mFrameLineColor));
        element.setAttribute("BackgroundColor", SGUtilityText.getColorString(this.mBackgroundColor));
        element.setAttribute("BackgroundTransparent", Boolean.toString(this.mLegendTransparentFlag));
        element.setAttribute("FontName", this.mFontName);
        element.setAttribute("FontSize", Float.toString(this.mFontSize) + "pt");
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.mFontStyle));
        element.setAttribute("StringColor", SGUtilityText.getColorString(this.mStringColor));
        return true;
    }

    public Element createElement(Document document) {
        return this.createThisElement(document);
    }

    public boolean readProperty(Element element) {
        LegendCommonProperties legendCommonProperties = this.readProperty_(element);
        if (legendCommonProperties == null) {
            return false;
        }
        return this.setProperties(legendCommonProperties);
    }

    private LegendCommonProperties readProperty_(Element element) {
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        string = element.getAttribute("LegendVisible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        string = element.getAttribute("XAxisPosition");
        if (string.length() == 0) {
            return null;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis(string);
        string = element.getAttribute("YAxisPosition");
        if (string.length() == 0) {
            return null;
        }
        SGAxis sGAxis2 = this.mAxisElement.getAxis(string);
        string = element.getAttribute("XValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        float f = this.calcLocation(d, sGAxis, true);
        float f2 = (f - this.mGraphRectX) / this.mMagnification;
        string = element.getAttribute("YValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d2 = number.doubleValue();
        float f3 = this.calcLocation(d2, sGAxis2, false);
        float f4 = (f3 - this.mGraphRectY) / this.mMagnification;
        string = element.getAttribute("LegendVisible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl3 = bl;
        string = element.getAttribute("FrameLineWidth");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "pt");
        float f5 = number.floatValue();
        string = element.getAttribute("FrameLineColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        Color color2 = color;
        string = element.getAttribute("BackgroundColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        Color color3 = color;
        string = element.getAttribute("BackgroundTransparent");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl4 = bl;
        string = element.getAttribute("FontName");
        if (string.length() == 0) {
            return null;
        }
        String string2 = string;
        string = element.getAttribute("FontSize");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "pt");
        if (number == null) {
            return null;
        }
        float f6 = number.floatValue();
        string = element.getAttribute("FontStyle");
        if (string.length() == 0) {
            return null;
        }
        int n = SGUtilityText.getFontStyle(string);
        if (n == -1) {
            return null;
        }
        string = element.getAttribute("StringColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        Color color4 = color;
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties.visible = bl2;
        legendCommonProperties.x = f2;
        legendCommonProperties.y = f4;
        legendCommonProperties.frameLineVisible = bl3;
        legendCommonProperties.frameLineWidth = f5;
        legendCommonProperties.frameLineColor = color2;
        legendCommonProperties.backgroundColor = color3;
        legendCommonProperties.transparent = bl4;
        legendCommonProperties.fontName = string2;
        legendCommonProperties.fontSize = f6;
        legendCommonProperties.fontStyle = n;
        legendCommonProperties.stringColor = color4;
        legendCommonProperties.xAxis = sGAxis;
        legendCommonProperties.yAxis = sGAxis2;
        return legendCommonProperties;
    }

    public static class LegendCommonProperties
    extends SGProperties {
        float x;
        float y;
        boolean visible;
        boolean frameLineVisible;
        float frameLineWidth;
        Color frameLineColor;
        String fontName;
        float fontSize;
        int fontStyle;
        Color stringColor;
        Color backgroundColor;
        boolean transparent;
        SGAxis xAxis;
        SGAxis yAxis;

        public boolean equals(Object object) {
            if (!(object instanceof LegendCommonProperties)) {
                return false;
            }
            LegendCommonProperties legendCommonProperties = (LegendCommonProperties)object;
            if (legendCommonProperties.x != this.x) {
                return false;
            }
            if (legendCommonProperties.y != this.y) {
                return false;
            }
            if (legendCommonProperties.visible != this.visible) {
                return false;
            }
            if (legendCommonProperties.frameLineVisible != this.frameLineVisible) {
                return false;
            }
            if (legendCommonProperties.frameLineWidth != this.frameLineWidth) {
                return false;
            }
            if (!legendCommonProperties.frameLineColor.equals(this.frameLineColor)) {
                return false;
            }
            if (!legendCommonProperties.fontName.equals(this.fontName)) {
                return false;
            }
            if (legendCommonProperties.fontSize != this.fontSize) {
                return false;
            }
            if (legendCommonProperties.fontStyle != this.fontStyle) {
                return false;
            }
            if (!legendCommonProperties.stringColor.equals(this.stringColor)) {
                return false;
            }
            if (!legendCommonProperties.backgroundColor.equals(this.backgroundColor)) {
                return false;
            }
            return legendCommonProperties.transparent == this.transparent;
        }

        public String toString() {
            String string = new String("[");
            string = string + new String("x=" + this.x + ", ");
            string = string + new String("y=" + this.y + ", ");
            string = string + new String("visible=" + this.visible + ", ");
            string = string + new String("frameLineVisible=" + this.frameLineVisible + ", ");
            string = string + new String("frameLineWidth=" + this.frameLineWidth + ", ");
            string = string + new String("frameLineColor=" + this.frameLineColor + ", ");
            string = string + new String("fontName=" + this.fontName + ", ");
            string = string + new String("fontSize=" + this.fontSize + ", ");
            string = string + new String("fontStyle=" + this.fontStyle + ", ");
            string = string + new String("stringColor=" + this.stringColor + ", ");
            string = string + new String("innerColor=" + this.backgroundColor + ", ");
            string = string + new String("transparent=" + this.transparent + ", ");
            string = string + new String("]");
            return string;
        }
    }

    class ElementGroupErrorBar
    extends SGElementGroupErrorBar {
        ElementGroupErrorBar() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            this.setLineType(1);
            this.setHeadSize(7.0866146f);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Transverse Line");
            if (n == null) {
                return false;
            }
            this.setStartHeadType(n);
            this.setEndHeadType(n);
            this.setHeadEdgeLineWidth(1.0f);
            Integer n2 = ElementGroupErrorBar.getErrorBarStyleFromName("Bothsides");
            if (n2 == null) {
                return false;
            }
            this.mErrorBarStyle = n2;
            this.setColor(SGDefaultValues.ERROR_BAR_COLOR);
            return true;
        }

        public float getDataElementWidth() {
            return this.mMagnification * 70.86614f;
        }

        public float getDataElementHeight() {
            return 1.5f * this.mMagnification * this.mLineWidth;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX() + 0.0f * this.getDataElementWidth();
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = sGTuple2f.x + 1.0f * this.mMagnification * 70.86614f;
            sGTuple2f2.y = sGTuple2f.y;
            this.setLocation(new SGTuple2f[]{sGTuple2f}, new SGTuple2f[]{sGTuple2f2});
            return true;
        }
    }

    class ElementGroupArrow
    extends SGElementGroupArrow
    implements ILegendElement {
        protected ElementGroupArrow() {
        }

        public float getDataElementWidth() {
            return this.mMagnification * 70.86614f;
        }

        public float getDataElementHeight() {
            return 0.0f;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX() + 0.1f * this.mMagnification * 70.86614f;
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = sGTuple2f.x + 0.8f * this.mMagnification * 70.86614f;
            sGTuple2f2.y = sGTuple2f.y;
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{sGTuple2f};
            SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[]{sGTuple2f2};
            return this.setLocation(sGTuple2fArray, sGTuple2fArray2);
        }
    }

    class ElementGroupSymbol
    extends SGElementGroupSymbol
    implements ILegendElement {
        protected ElementGroupSymbol() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Circle");
            if (n == null) {
                return false;
            }
            this.setType(n);
            this.setSize(8.503938f);
            this.setColor(SGDefaultValues.SYMBOL_BODY_COLOR);
            this.setLineWidth(1.0f);
            this.setLineColor(SGDefaultValues.SYMBOL_LINE_COLOR);
            return true;
        }

        public float getDataElementWidth() {
            float f = this.mMagnification * 70.86614f;
            float f2 = this.getDataElementSize();
            if (f < f2) {
                return f2;
            }
            return f;
        }

        public float getDataElementHeight() {
            return 1.5f * this.getDataElementSize();
        }

        private float getDataElementSize() {
            if (this.mDrawingElementArray != null) {
                if (this.mDrawingElementArray.length == 0) {
                    return 0.0f;
                }
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[0];
                Rectangle2D rectangle2D = sGDrawingElementSymbol2D.getElementBounds().getBounds2D();
                return (float)rectangle2D.getHeight();
            }
            return 0.0f;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX() + 0.5f * this.mMagnification * 70.86614f;
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{sGTuple2f};
            this.setLocation(sGTuple2fArray);
            return true;
        }
    }

    class ElementGroupBar
    extends SGElementGroupBar
    implements ILegendElement {
        protected ElementGroupBar() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setBaselineValue(0.0);
            this.setRectangleWidth(14.173229f);
            this.setColor(SGDefaultValues.BAR_COLOR);
            this.setEdgeLineWidth(0.5f);
            this.setEdgeLineColor(SGDefaultValues.BAR_LINE_COLOR);
            return true;
        }

        public float getDataElementWidth() {
            return this.mMagnification * 70.86614f;
        }

        public float getDataElementHeight() {
            return 1.5f * this.mRectangleWidth * this.mMagnification;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            float f = this.mMagnification * this.mRectangleWidth;
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX() + 0.2f * this.getDataElementWidth();
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight() - 0.5f * f;
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{sGTuple2f};
            this.setLocation(sGTuple2fArray);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            if (this.mDrawingElementArray == null) {
                return true;
            }
            if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementArray[i];
                SGTuple2f sGTuple2f = sGTuple2fArray[i];
                sGDrawingElementBar2D.setBounds(sGTuple2f.x, sGTuple2f.y, 0.6f * this.getDataElementWidth(), this.mMagnification * this.mRectangleWidth);
            }
            return true;
        }
    }

    class ElementGroupLine
    extends SGElementGroupLine
    implements ILegendElement {
        protected ElementGroupLine() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            Integer n = SGDrawingElementLine.getLineTypeFromName("Solid");
            if (n == null) {
                return false;
            }
            this.setLineType(n);
            this.setColor(SGDefaultValues.LINE_COLOR);
            return true;
        }

        public float getDataElementWidth() {
            return this.mMagnification * 70.86614f;
        }

        public float getDataElementHeight() {
            return 1.5f * this.mMagnification * this.mLineWidth;
        }

        public int getNumberOfPoints() {
            return 2;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX() + 0.0f * this.getDataElementWidth();
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = sGTuple2f.x + 1.0f * this.mMagnification * 70.86614f;
            sGTuple2f2.y = sGTuple2f.y;
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{sGTuple2f, sGTuple2f2};
            this.setLocation(sGTuple2fArray);
            return true;
        }
    }

    class ElementGroupSetInLegendSXY
    extends ElementGroupSetInLegend
    implements SGIPropertySettingListenerSXYData {
        protected SGPropertyDialogSXYData mDialog = null;

        protected ElementGroupSetInLegendSXY() {
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        public boolean createTemporaryPropertyObject() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public boolean commit() {
            return this.commit(SGLegendElement.this.mSXYDataDialog);
        }

        public boolean cancel() {
            if (!this.setWholeProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            if (!SGLegendElement.this.createAllDrawingElements()) {
                return false;
            }
            SGLegendElement.this.notifyChange();
            return true;
        }

        public boolean preview() {
            return this.preview(SGLegendElement.this.mSXYDataDialog);
        }

        public boolean commit(SGPropertyDialog sGPropertyDialog) {
            boolean bl = this.setPropertiesFromDialog(sGPropertyDialog);
            if (!bl) {
                return false;
            }
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getWholeProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mChangedFlag = true;
            }
            this.mTemporaryProperties = null;
            SGLegendElement.this.mSXYDataDialog.setVisible(false);
            if (!SGLegendElement.this.createAllDrawingElements()) {
                return false;
            }
            SGLegendElement.this.notifyChange();
            this.notifyToRoot();
            return true;
        }

        public boolean preview(SGPropertyDialog sGPropertyDialog) {
            boolean bl = this.setPropertiesFromDialog(sGPropertyDialog);
            if (!bl) {
                return false;
            }
            if (!SGLegendElement.this.createAllDrawingElements()) {
                return false;
            }
            SGLegendElement.this.notifyChange();
            return true;
        }

        public boolean setPropertiesFromDialog(SGPropertyDialog sGPropertyDialog) {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)sGPropertyDialog;
            if (!(sGPropertyDialogSXYData.getLineVisible() || sGPropertyDialogSXYData.getBarVisible() || sGPropertyDialogSXYData.getSymbolVisible())) {
                JOptionPane.showMessageDialog(sGPropertyDialogSXYData, "Lines, symbol and bars cannot be hidden at the same time.");
                return false;
            }
            return this.setPropertyWithDialog_(sGPropertyDialogSXYData);
        }

        private boolean setPropertyWithDialog_(SGPropertyDialogSXYData sGPropertyDialogSXYData) {
            SGIAxisElement sGIAxisElement = SGLegendElement.this.mAxisElement;
            SGAxis sGAxis = sGIAxisElement.getAxisInPlane(0);
            SGAxis sGAxis2 = sGIAxisElement.getAxisInPlane(1);
            SGAxis sGAxis3 = sGIAxisElement.getAxisInPlane(2);
            SGAxis sGAxis4 = sGIAxisElement.getAxisInPlane(3);
            Boolean bl = sGPropertyDialogSXYData.getLegendVisible();
            if (bl != null) {
                this.setVisibleInLegend(bl);
            }
            SGLegendElement.this.updateSymbolsVisibleAroundFocusedObjects();
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroupLine sGElementGroupLine = (SGElementGroupLine)arrayList.get(i);
                if (!sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getLinePanel()) || sGPropertyDialogSXYData.setLineProperties(sGElementGroupLine)) continue;
                return false;
            }
            ArrayList arrayList2 = this.getSymbolGroups();
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroupSymbol sGElementGroupSymbol = (SGElementGroupSymbol)arrayList2.get(i);
                if (!sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getSymbolPanel()) || sGPropertyDialogSXYData.setSymbolProperties(sGElementGroupSymbol)) continue;
                return false;
            }
            ArrayList arrayList3 = this.getBarGroups();
            for (int i = 0; i < arrayList3.size(); ++i) {
                SGElementGroupBar sGElementGroupBar = (SGElementGroupBar)arrayList3.get(i);
                if (!sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getBarPanel()) || sGPropertyDialogSXYData.setBarProperties(sGElementGroupBar)) continue;
                return false;
            }
            return true;
        }

        public ArrayList getLineGroups() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                Object e = this.mDrawingElementGroupList.get(i);
                if (!(e instanceof SGElementGroupLine)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }

        public ArrayList getSymbolGroups() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                Object e = this.mDrawingElementGroupList.get(i);
                if (!(e instanceof SGElementGroupSymbol)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }

        public ArrayList getBarGroups() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                Object e = this.mDrawingElementGroupList.get(i);
                if (!(e instanceof SGElementGroupBar)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }

        public int getXAxisConfiguration() {
            return -1;
        }

        public int getYAxisConfiguration() {
            return -1;
        }

        public ArrayList getErrorBarGroups() {
            return new ArrayList();
        }

        public ArrayList getTickLabelGroups() {
            return new ArrayList();
        }

        public boolean setLineProperties(SGProperties sGProperties) {
            return true;
        }

        public boolean setSymbolProperties(SGProperties sGProperties) {
            return true;
        }

        public boolean setBarProperties(SGProperties sGProperties) {
            return true;
        }

        public boolean setErrorBarProperties(SGProperties sGProperties) {
            return true;
        }

        public boolean setTickLabelProperties(SGProperties sGProperties) {
            return true;
        }
    }

    abstract class ElementGroupSetInLegend
    extends SGElementGroupSetInFigureElement
    implements ActionListener,
    SGIUndoable,
    SGIPropertySettingListenerData {
        protected Rectangle2D mDataRect = null;
        protected SGDrawingElementString2DExtended mDrawingString = null;
        protected SGProperties mTemporaryProperties = null;
        private ArrayList mElementGroupSetPropertyHistoryList = new ArrayList();
        private int mElementGroupSetStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();
        protected boolean mChangedFlag = false;

        protected ElementGroupSetInLegend() {
        }

        private boolean isVisibleTotally() {
            return this.isVisible() & this.isVisibleInLegend();
        }

        private boolean createStringElement() {
            String string = this.mName;
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended(string, SGLegendElement.this.mFontName, SGLegendElement.this.mFontStyle, SGLegendElement.this.mFontSize);
            sGDrawingElementString2DExtended.setColor(SGLegendElement.this.mStringColor);
            sGDrawingElementString2DExtended.setMagnification(this.mMagnification);
            this.mDrawingString = sGDrawingElementString2DExtended;
            return true;
        }

        private boolean paintString(Graphics2D graphics2D) {
            if (this.mDrawingString != null) {
                this.mDrawingString.drawString(graphics2D);
            }
            return true;
        }

        private SGDrawingElementString2D getStringElement() {
            return this.mDrawingString;
        }

        private Rectangle2D getStringBounds() {
            if (this.mDrawingString == null) {
                return null;
            }
            Rectangle2D rectangle2D = this.getStringElement().getElementBounds();
            return rectangle2D;
        }

        private Rectangle2D getRect() {
            return this.mDataRect;
        }

        private void setRect(Rectangle2D rectangle2D) {
            this.mDataRect = rectangle2D;
        }

        public float getMaxDataElementWidth() {
            float f = 0.0f;
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ILegendElement iLegendElement = (ILegendElement)arrayList.get(i);
                float f2 = iLegendElement.getDataElementWidth();
                if (!(f2 > f)) continue;
                f = f2;
            }
            return f;
        }

        public double getMaxDataElementHeight() {
            double d = 0.0;
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ILegendElement iLegendElement;
                double d2;
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup.isVisible() || !((d2 = (double)(iLegendElement = (ILegendElement)arrayList.get(i)).getDataElementHeight()) > d)) continue;
                d = d2;
            }
            return d;
        }

        public boolean onDrawingElement(int n, int n2) {
            return this.mDataRect.contains(n, n2);
        }

        private boolean createDrawingElement() {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ILegendElement iLegendElement = (ILegendElement)arrayList.get(i);
                iLegendElement.createDrawingElementInLegend();
            }
            return true;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ElementGroupSymbol elementGroupSymbol;
            ElementGroupLine elementGroupLine;
            graphics2D.setPaint(SGLegendElement.this.mStringColor);
            this.paintString(graphics2D);
            ElementGroupBar elementGroupBar = SGLegendElement.this.getGroupBar(this);
            if (elementGroupBar != null && elementGroupBar.isVisible()) {
                elementGroupBar.paintElement(graphics2D);
            }
            if ((elementGroupLine = SGLegendElement.this.getGroupLine(this)) != null && elementGroupLine.isVisible()) {
                elementGroupLine.paintElement(graphics2D);
            }
            if ((elementGroupSymbol = SGLegendElement.this.getGroupSymbol(this)) != null && elementGroupSymbol.isVisible()) {
                elementGroupSymbol.paintElement(graphics2D);
            }
        }

        protected boolean clickDrawingElements(MouseEvent mouseEvent) {
            return false;
        }

        public boolean addDrawingElementGroup(int n) {
            SGElementGroup sGElementGroup = null;
            if (n == 0) {
                sGElementGroup = new ElementGroupLine();
            } else if (n == 2) {
                sGElementGroup = new ElementGroupBar();
            } else if (n == 1) {
                sGElementGroup = new ElementGroupSymbol();
            } else if (n == 3) {
                sGElementGroup = new ElementGroupArrow();
            } else {
                throw new Error("");
            }
            this.addDrawingElementGroup(sGElementGroup);
            return true;
        }

        public boolean addDrawingElementGroup(SGDrawingElement sGDrawingElement) {
            SGElementGroup sGElementGroup = null;
            if (sGDrawingElement instanceof SGDrawingElementLine) {
                sGElementGroup = new ElementGroupLine();
            } else if (sGDrawingElement instanceof SGDrawingElementBar) {
                sGElementGroup = new ElementGroupBar();
            } else if (sGDrawingElement instanceof SGDrawingElementSymbol) {
                sGElementGroup = new ElementGroupSymbol();
            } else if (sGDrawingElement instanceof SGDrawingElementArrow) {
                sGElementGroup = new ElementGroupArrow();
            } else {
                throw new Error("");
            }
            ((SGElementGroup)sGElementGroup).setProperty(sGDrawingElement);
            sGElementGroup.setMagnification(this.mMagnification);
            this.addDrawingElementGroup(sGElementGroup);
            SGLegendElement.this.createAllDrawingElements();
            return true;
        }

        private boolean addDrawingElementGroup(SGElementGroup sGElementGroup) {
            sGElementGroup.mGroupSet = this;
            ILegendElement iLegendElement = (ILegendElement)((Object)sGElementGroup);
            sGElementGroup.initDrawingElement(iLegendElement.getNumberOfPoints());
            if (!sGElementGroup.setPropertiesOfDrawingElements()) {
                return false;
            }
            sGElementGroup.setMagnification(this.mMagnification);
            this.mDrawingElementGroupList.add(sGElementGroup);
            return true;
        }

        public String getTagName() {
            return "";
        }

        public boolean writeProperty(Element element) {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            SGLegendElement.this.createAllDrawingElements();
            SGLegendElement.this.notifyChange();
        }

        public boolean setProperties(SGProperties sGProperties) {
            SGElementGroupSet.ElementGroupSetProperties elementGroupSetProperties = (SGElementGroupSet.ElementGroupSetProperties)sGProperties;
            elementGroupSetProperties.visible = this.isVisible();
            return super.setProperties(elementGroupSetProperties);
        }

        public boolean initPropertiesHistory() {
            this.addElementGroupSetPropertyHistory((SGElementGroupSet.WholeProperties)this.getWholeProperties());
            return true;
        }

        private boolean addElementGroupSetPropertyHistory(SGElementGroupSet.WholeProperties wholeProperties) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mElementGroupSetStateCounter; ++i) {
                arrayList.add(this.mElementGroupSetPropertyHistoryList.get(i));
            }
            arrayList.add(wholeProperties);
            this.mElementGroupSetPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            this.setWholeProperties(wholeProperties);
            SGLegendElement.this.createAllDrawingElements();
            return true;
        }

        public boolean redo() {
            ++this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            this.setWholeProperties(wholeProperties);
            SGLegendElement.this.createAllDrawingElements();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            if (this.isChanged()) {
                this.updateThisObjectHistory();
                this.setChanged(false);
                this.updateObjectHistory(this);
            }
            return true;
        }

        public boolean updateThisObjectHistory() {
            ++this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.getWholeProperties();
            this.addElementGroupSetPropertyHistory(wholeProperties);
            return true;
        }

        public void notifyToRoot() {
            SGLegendElement.this.notifyToRootFromFigureElement();
        }

        public boolean isChanged() {
            return this.mChangedFlag;
        }

        public void setChanged(boolean bl) {
            this.mChangedFlag = bl;
        }
    }

    static interface ILegendElement {
        public float getDataElementWidth();

        public float getDataElementHeight();

        public boolean createDrawingElementInLegend();

        public int getNumberOfPoints();
    }
}

