/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;

public class SGGridDialog
extends SGPropertyDialog
implements SGILineConstants {
    public static final String TITLE = "Grid Properties";
    private JCheckBox mAutoCheckBox;
    private JLabel mBaseXValueLabel;
    private JTextField mBaseXValueTextField;
    private JLabel mBaseYValueLabel;
    private JTextField mBaseYValueTextField;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JPanel mCommonPanel;
    private JPanel mGridPanel;
    private JCheckBox mGridVisibleCheckBox;
    private JRadioButton mLeftBottomRadioButton;
    private JRadioButton mLeftTopRadioButton;
    private JButton mLineColorButton;
    private JLabel mLineColorLabel;
    private JLabel mLineLabel;
    private JSeparator mLineSeparator;
    private JComboBox mLineTypeComboBox;
    private JLabel mLineTypeLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JRadioButton mRightBottomRadioButton;
    private JRadioButton mRightTopRadioButton;
    private JLabel mScaleReferenceLabel1;
    private JLabel mScaleReferenceLabel2;
    private JLabel mStepXValueLabel;
    private JTextField mStepXValueTextField;
    private JLabel mStepYValueLabel;
    private JTextField mStepYValueTextField;
    private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

    public SGGridDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    public SGGridDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mCommonPanel = new JPanel();
        this.mLeftTopRadioButton = new JRadioButton();
        this.mLeftBottomRadioButton = new JRadioButton();
        this.mRightTopRadioButton = new JRadioButton();
        this.mRightBottomRadioButton = new JRadioButton();
        this.mScaleReferenceLabel2 = new JLabel();
        this.mScaleReferenceLabel1 = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mGridPanel = new JPanel();
        this.mLineLabel = new JLabel();
        this.mLineSeparator = new JSeparator();
        this.mGridVisibleCheckBox = new JCheckBox();
        this.mLocationLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mStepXValueLabel = new JLabel();
        this.mStepXValueTextField = new JTextField();
        this.mBaseXValueLabel = new JLabel();
        this.mBaseXValueTextField = new JTextField();
        this.mStepYValueLabel = new JLabel();
        this.mStepYValueTextField = new JTextField();
        this.mBaseYValueLabel = new JLabel();
        this.mBaseYValueTextField = new JTextField();
        this.mLineTypeLabel = new JLabel();
        this.mLineTypeComboBox = new JComboBox();
        this.mLineWidthLabel = new JLabel();
        this.mLineWidthSpinner = new SGSpinner();
        this.mLineColorLabel = new JLabel();
        this.mLineColorButton = new JButton();
        this.mAutoCheckBox = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLeftTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftTopRadioButton.setText("Left/Top");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftTopRadioButton, gridBagConstraints);
        this.mLeftBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftBottomRadioButton, gridBagConstraints);
        this.mRightTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightTopRadioButton, gridBagConstraints);
        this.mRightBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightBottomRadioButton, gridBagConstraints);
        this.mScaleReferenceLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel2, gridBagConstraints);
        this.mScaleReferenceLabel1.setFont(new Font("Dialog", 1, 12));
        this.mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mGridPanel.setLayout(new GridBagLayout());
        this.mGridPanel.setBorder(new BevelBorder(0));
        this.mLineLabel.setFont(new Font("Dialog", 3, 12));
        this.mLineLabel.setText("Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 10, 0, 5);
        this.mGridPanel.add((Component)this.mLineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 40, 0, 10);
        this.mGridPanel.add((Component)this.mLineSeparator, gridBagConstraints);
        this.mGridVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mGridVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.mGridPanel.add((Component)this.mGridVisibleCheckBox, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 5);
        this.mGridPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 65, 5, 10);
        this.mGridPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        this.mStepXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mStepXValueLabel.setText("Step X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mGridPanel.add((Component)this.mStepXValueLabel, gridBagConstraints);
        this.mStepXValueTextField.setColumns(6);
        this.mStepXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mGridPanel.add((Component)this.mStepXValueTextField, gridBagConstraints);
        this.mBaseXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mBaseXValueLabel.setText("Base X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mGridPanel.add((Component)this.mBaseXValueLabel, gridBagConstraints);
        this.mBaseXValueTextField.setColumns(6);
        this.mBaseXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mGridPanel.add((Component)this.mBaseXValueTextField, gridBagConstraints);
        this.mStepYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mStepYValueLabel.setText("Step Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mGridPanel.add((Component)this.mStepYValueLabel, gridBagConstraints);
        this.mStepYValueTextField.setColumns(6);
        this.mStepYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mGridPanel.add((Component)this.mStepYValueTextField, gridBagConstraints);
        this.mBaseYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mBaseYValueLabel.setText("Base Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mGridPanel.add((Component)this.mBaseYValueLabel, gridBagConstraints);
        this.mBaseYValueTextField.setColumns(6);
        this.mBaseYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mGridPanel.add((Component)this.mBaseYValueTextField, gridBagConstraints);
        this.mLineTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeLabel.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mGridPanel.add((Component)this.mLineTypeLabel, gridBagConstraints);
        this.mLineTypeComboBox.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeComboBox.setPreferredSize(new Dimension(140, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mGridPanel.add((Component)this.mLineTypeComboBox, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mGridPanel.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mLineWidthSpinner.setMinimumSize(new Dimension(65, 20));
        this.mLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mGridPanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mGridPanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mGridPanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mAutoCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mAutoCheckBox.setText("Auto");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.mGridPanel.add((Component)this.mAutoCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mGridPanel, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        Serializable serializable = this.mLineTypeComboBox;
        String[] stringArray = new String[]{"Solid", "Broken", "Dotted", "Dashed", "Double Dashed"};
        for (int i = 0; i < stringArray.length; ++i) {
            ((JComboBox)serializable).addItem(stringArray[i]);
        }
        this.pack();
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.mLeftBottomRadioButton);
        ((ButtonGroup)serializable).add(this.mRightBottomRadioButton);
        ((ButtonGroup)serializable).add(this.mLeftTopRadioButton);
        ((ButtonGroup)serializable).add(this.mRightTopRadioButton);
        ((ButtonGroup)serializable).add(this.mNoAxisSelectionRadioButton);
        this.mLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mLineColorButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mLineColorButton;
        this.mGridVisibleCheckBox.addActionListener(this);
        this.mAutoCheckBox.addActionListener(this);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        arrayList.add(this.mBaseXValueTextField);
        arrayList.add(this.mBaseYValueTextField);
        arrayList.add(this.mStepXValueTextField);
        arrayList.add(this.mStepYValueTextField);
        return arrayList;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mLineColorButton);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mGridVisibleCheckBox)) {
            this.setGridVisible(this.mGridVisibleCheckBox.isSelected());
        } else if (object.equals(this.mAutoCheckBox)) {
            this.setAutoFlag(this.mAutoCheckBox.isSelected());
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        super.componentShown(componentEvent);
        this.setOwnerEnabled(false);
    }

    public void componentHidden(ComponentEvent componentEvent) {
        super.componentHidden(componentEvent);
        this.setOwnerEnabled(true);
        this.onCanceled();
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.setOwnerEnabled(true);
    }

    public void windowClosed(WindowEvent windowEvent) {
        super.windowClosed(windowEvent);
        this.setOwnerEnabled(true);
    }

    private void setOwnerEnabled(boolean bl) {
        this.getOwner().setEnabled(bl);
    }

    public void setGridVisible(boolean bl) {
        this.mGridVisibleCheckBox.setSelected(bl);
        Component[] componentArray = new Component[]{this.mAutoCheckBox, this.mBaseXValueLabel, this.mBaseXValueTextField, this.mBaseYValueLabel, this.mBaseYValueTextField, this.mStepXValueLabel, this.mStepXValueTextField, this.mStepYValueLabel, this.mStepYValueTextField, this.mLineWidthLabel, this.mLineWidthSpinner, this.mLineTypeLabel, this.mLineTypeComboBox, this.mLineColorLabel, this.mLineColorButton};
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
    }

    public void setAutoFlag(boolean bl) {
        this.mAutoCheckBox.setSelected(bl);
        JTextComponent[] jTextComponentArray = new JTextComponent[]{this.mBaseXValueTextField, this.mBaseYValueTextField, this.mStepXValueTextField, this.mStepYValueTextField};
        for (int i = 0; i < jTextComponentArray.length; ++i) {
            jTextComponentArray[i].setEditable(!bl);
        }
    }

    public boolean setLineType(int n) {
        String string = SGDrawingElementLine.getLineTypeName(n);
        this.mLineTypeComboBox.setSelectedItem(string);
        return true;
    }

    public boolean getGridVisible() {
        return this.mGridVisibleCheckBox.isSelected();
    }

    public int getLineType() {
        String string = (String)this.mLineTypeComboBox.getSelectedItem();
        Integer n = SGDrawingElementLine.getLineTypeFromName(string);
        if (n == null) {
            throw new Error();
        }
        return n;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidthSpinner.setValue(new Double(f));
        return true;
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setBackground(color);
        return true;
    }

    public Color getLineColor() {
        return this.mLineColorButton.getBackground();
    }

    public boolean getAutoFlag() {
        return this.mAutoCheckBox.isSelected();
    }

    public String getXAxisLocation() {
        String string = null;
        if (this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected()) {
            string = "Bottom";
        } else if (this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected()) {
            string = "Top";
        }
        return string;
    }

    public String getYAxisLocation() {
        String string = null;
        if (this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected()) {
            string = "Left";
        } else if (this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected()) {
            string = "Right";
        }
        return string;
    }

    public boolean setAxisRadioButton(int n, int n2) {
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 2: {
                        this.mLeftBottomRadioButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        this.mRightBottomRadioButton.setSelected(true);
                        break block0;
                    }
                }
                return false;
            }
            case 1: {
                switch (n2) {
                    case 2: {
                        this.mLeftTopRadioButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        this.mRightTopRadioButton.setSelected(true);
                        break block0;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public Number getBaseXValue() {
        String string = this.mBaseXValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public Number getBaseYValue() {
        String string = this.mBaseYValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public Number getStepXValue() {
        String string = this.mStepXValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public Number getStepYValue() {
        String string = this.mStepYValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public void setBaseXValue(double d) {
        this.mBaseXValueTextField.setText(Double.toString(d));
    }

    public void setStepXValue(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("value<=0.0");
        }
        this.mStepXValueTextField.setText(Double.toString(d));
    }

    public void setBaseYValue(double d) {
        this.mBaseYValueTextField.setText(Double.toString(d));
    }

    public void setStepYValue(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("value<=0.0");
        }
        this.mStepYValueTextField.setText(Double.toString(d));
    }
}

