/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Element;

public abstract class SGElementGroupLine
extends SGElementGroupSXY
implements SGILineConstants,
SGIElementGroupConstants {
    protected float mLineWidth;
    protected int mLineType;
    protected int mCap = 0;
    protected int mJoin = 1;
    protected float mMiterLimit = 1.0f;
    protected float mDashPhase = 0.0f;
    protected final ArrayList mConnectedPathList = new ArrayList();

    public boolean setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("width<0.0f");
        }
        this.mLineWidth = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.mDrawingElementArray[i];
                sGDrawingElementLine2D.setLineWidth(this.mLineWidth);
            }
        }
        return true;
    }

    public boolean setLineType(int n) {
        this.mLineType = n;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.mDrawingElementArray[i];
                sGDrawingElementLine2D.setType(this.mLineType);
            }
        }
        return true;
    }

    public boolean setBasicStrokeProperty(int n, int n2, float f, float f2) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        if (n2 != 2 && n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        if (f < 1.0f && n2 == 0) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        this.mCap = n;
        this.mJoin = n2;
        this.mMiterLimit = f;
        this.mDashPhase = f2;
        return true;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public int getLineType() {
        return this.mLineType;
    }

    public int getCap() {
        return this.mCap;
    }

    public int getJoin() {
        return this.mJoin;
    }

    public float getMiterLimit() {
        return this.mMiterLimit;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementLine2D sGDrawingElementLine2D = new SGDrawingElementLine2D();
        sGDrawingElementLine2D.setVisible(this.mVisibleFlag);
        sGDrawingElementLine2D.setLineWidth(this.mLineWidth);
        sGDrawingElementLine2D.setType(this.mLineType);
        sGDrawingElementLine2D.setColorList(this.mColorList);
        return sGDrawingElementLine2D;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementLine)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)sGDrawingElement;
        this.setLineType(sGDrawingElementLine.getLineType());
        this.setLineWidth(sGDrawingElementLine.getLineWidth());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(this.getColor(0));
        float f = this.mMagnification * this.mLineWidth;
        BasicStroke basicStroke = SGUtilityJava2D.getBasicStroke(this.mLineType, f, this.mCap, this.mJoin, this.mMiterLimit, this.mDashPhase);
        graphics2D.setStroke(basicStroke);
        ArrayList arrayList = new ArrayList(this.mConnectedPathList);
        if (rectangle2D == null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                GeneralPath generalPath = (GeneralPath)arrayList.get(i);
                graphics2D.draw(generalPath);
            }
        } else {
            Area area = new Area(rectangle2D);
            for (int i = 0; i < arrayList.size(); ++i) {
                GeneralPath generalPath = (GeneralPath)arrayList.get(i);
                Shape shape = basicStroke.createStrokedShape(generalPath);
                Area area2 = new Area(shape);
                area2.intersect(area);
                graphics2D.fill(area2);
            }
        }
        return true;
    }

    public String getTagName() {
        return "Line";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute("Width", Float.toString(this.mLineWidth) + "pt");
        element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.mLineType));
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        return true;
    }

    public boolean readProperties(Element element, SGProperties sGProperties) {
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        LineProperties lineProperties = (LineProperties)sGProperties;
        String string = null;
        Number number = null;
        Object var9_6 = null;
        Boolean bl = null;
        ArrayList arrayList = null;
        string = element.getAttribute("Visible");
        if (string.length() == 0) {
            return false;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return false;
        }
        lineProperties.setVisible(bl);
        string = element.getAttribute("Width");
        if (string.length() == 0) {
            return false;
        }
        number = SGUtilityText.getDouble(string, "pt");
        if (number == null) {
            return false;
        }
        lineProperties.setLineWidth(number.floatValue());
        string = element.getAttribute("Type");
        if (string.length() == 0) {
            return false;
        }
        number = SGDrawingElementLine.getLineTypeFromName(string);
        if (number == null) {
            return false;
        }
        lineProperties.setLineType(number.intValue());
        string = element.getAttribute("Color");
        if (string.length() == 0) {
            return false;
        }
        arrayList = SGUtilityText.getColorList(string);
        if (arrayList == null) {
            return false;
        }
        lineProperties.setColorList(arrayList);
        return true;
    }

    public SGProperties readProperties(Element element) {
        LineProperties lineProperties = new LineProperties();
        if (!this.readProperties(element, lineProperties)) {
            return null;
        }
        return lineProperties;
    }

    protected boolean initDrawingElement(int n) {
        int n2 = n - 1;
        SGDrawingElementLine[] sGDrawingElementLineArray = new SGDrawingElementLine[n2];
        for (int i = 0; i < n2; ++i) {
            sGDrawingElementLineArray[i] = new SGDrawingElementLine2D();
        }
        this.mDrawingElementArray = sGDrawingElementLineArray;
        return true;
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length - 1;
        SGDrawingElementLine[] sGDrawingElementLineArray = new SGDrawingElementLine[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementLineArray[i] = new SGDrawingElementLine2D();
            sGDrawingElementLineArray[i].setTermPoints(sGTuple2fArray[i], sGTuple2fArray[i + 1]);
        }
        this.mDrawingElementArray = sGDrawingElementLineArray;
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        return this.setLocation_(sGTuple2fArray, true);
    }

    protected boolean setLocation_(SGTuple2f[] sGTuple2fArray, boolean bl) {
        int n;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length - 1 != sGDrawingElementArray.length) {
            throw new Error("pointArray.length != this.mDrawingElementArray.length + 1");
        }
        ArrayList arrayList = this.mConnectedPathList;
        arrayList.clear();
        boolean bl2 = true;
        boolean[] blArray = new boolean[sGTuple2fArray.length];
        for (n = 0; n < blArray.length; ++n) {
            boolean bl3 = blArray[n] = !sGTuple2fArray[n].isInfinite() && !sGTuple2fArray[n].isNaN();
            if (blArray[n]) continue;
            bl2 = false;
        }
        if (bl2) {
            Object object;
            if (bl) {
                for (n = 0; n < sGTuple2fArray.length - 1; ++n) {
                    object = (SGDrawingElementLine)sGDrawingElementArray[n];
                    ((SGDrawingElementLine)object).setTermPoints(sGTuple2fArray[n], sGTuple2fArray[n + 1]);
                }
            }
            GeneralPath generalPath = new GeneralPath();
            object = new Line2D.Float(sGTuple2fArray[0].x, sGTuple2fArray[0].y, sGTuple2fArray[1].x, sGTuple2fArray[1].y);
            generalPath.append((Shape)object, true);
            if (sGTuple2fArray.length > 2) {
                for (int i = 2; i < sGTuple2fArray.length; ++i) {
                    generalPath.lineTo(sGTuple2fArray[i].x, sGTuple2fArray[i].y);
                }
            }
            arrayList.add(generalPath);
        } else {
            Object object;
            int n2;
            ArrayList arrayList2 = new ArrayList();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (n2 = 0; n2 < sGTuple2fArray.length - 1; ++n2) {
                object = (SGDrawingElementLine)sGDrawingElementArray[n2];
                boolean bl4 = blArray[n2] && blArray[n2 + 1];
                ((SGDrawingElement)object).setVisible(bl4);
                if (bl4) {
                    ((SGDrawingElementLine)object).setTermPoints(sGTuple2fArray[n2], sGTuple2fArray[n2 + 1]);
                    arrayList3.add(object);
                    continue;
                }
                if (arrayList3.size() == 0) continue;
                arrayList2.add(arrayList3);
                arrayList3 = new ArrayList();
            }
            if (arrayList3.size() != 0) {
                arrayList2.add(arrayList3);
            }
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                object = (ArrayList)arrayList2.get(n2);
                GeneralPath generalPath = new GeneralPath();
                SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)((ArrayList)object).get(0);
                Line2D line2D = SGDrawingElementLine2D.getLine(sGDrawingElementLine);
                generalPath.append(line2D, true);
                if (((ArrayList)object).size() > 2) {
                    for (int i = 1; i < ((ArrayList)object).size(); ++i) {
                        sGDrawingElementLine = (SGDrawingElementLine)((ArrayList)object).get(i);
                        SGTuple2f sGTuple2f = sGDrawingElementLine.getEnd();
                        generalPath.lineTo(sGTuple2f.x, sGTuple2f.y);
                    }
                }
                arrayList.add(generalPath);
            }
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)this.mDrawingElementArray[i];
            sGDrawingElementLine.setType(this.mLineType);
            sGDrawingElementLine.setColorList(this.mColorList);
            sGDrawingElementLine.setLineWidth(this.mLineWidth);
            sGDrawingElementLine.setMagnification(this.mMagnification);
        }
        return true;
    }

    public SGProperties getProperties() {
        LineProperties lineProperties = new LineProperties();
        this.getProperties(lineProperties);
        return lineProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        LineProperties lineProperties = (LineProperties)sGProperties;
        lineProperties.setLineWidth(this.getLineWidth());
        lineProperties.setLineType(this.getLineType());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        LineProperties lineProperties = (LineProperties)sGProperties;
        Float f = lineProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        Integer n = lineProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        this.setLineType(n);
        return true;
    }

    public static class LineProperties
    extends SGElementGroup.ElementGroupProperties {
        public static final String[] keys = new String[]{"Width", "Type"};

        public boolean equals(Object object) {
            if (!(object instanceof LineProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            LineProperties lineProperties = (LineProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(lineProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getLineWidth() {
            String string = this.getProperty("Width");
            return SGUtilityText.getFloat(string);
        }

        public Integer getLineType() {
            String string = this.getProperty("Type");
            return SGUtilityText.getInteger(string);
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("Width", new Float(f).toString());
            return true;
        }

        public boolean setLineType(int n) {
            this.setProperty("Type", new Integer(n).toString());
            return true;
        }
    }
}

