/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public class SGDrawingElementString2D
extends SGDrawingElementString
implements SGIDrawingElementJava2D {
    protected Rectangle2D mStringRect = new Rectangle2D.Float();

    public SGDrawingElementString2D() {
    }

    public SGDrawingElementString2D(String string) {
        super(string);
    }

    public SGDrawingElementString2D(SGDrawingElementString sGDrawingElementString) {
        super(sGDrawingElementString);
    }

    public SGDrawingElementString2D(String string, String string2, int n, float f) {
        super(string, string2, n, f);
    }

    public SGDrawingElementString2D(String string, String string2, int n, float f, float f2, float f3) {
        super(string, string2, n, f, f2, f3);
    }

    public boolean setFont(String string, int n, float f) {
        super.setFont(string, n, f);
        this.setStringRect();
        return true;
    }

    public boolean setString(String string) {
        super.setString(string);
        this.setStringRect();
        return true;
    }

    public boolean contains(int n, int n2) {
        Rectangle2D rectangle2D = this.getElementBounds();
        return rectangle2D.contains(n, n2);
    }

    public Rectangle2D getElementBounds() {
        Rectangle2D rectangle2D = this.getStringRect();
        AffineTransform affineTransform = this.getAffineTransform();
        Shape shape = affineTransform.createTransformedShape(rectangle2D);
        return shape.getBounds2D();
    }

    protected boolean setStringRect() {
        if (this.mFont == null || this.mString == null) {
            return false;
        }
        String string = this.mString;
        if (string.length() == 0) {
            return true;
        }
        Font font = new Font(this.getFontName(), this.getFontStyle(), (int)this.getFontSize());
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        float f = this.getMagnification();
        rectangle2D.setRect(0.0, 0.0, (double)f * rectangle2D.getWidth(), (double)f * rectangle2D.getHeight());
        this.mStringRect = rectangle2D;
        return true;
    }

    protected Rectangle2D getVisualBounds() {
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Rectangle2D rectangle2D = this.mFont.createGlyphVector(fontRenderContext, this.mString).getVisualBounds();
        return rectangle2D;
    }

    public Rectangle2D getStringRect() {
        return this.mStringRect;
    }

    protected float getAscent() {
        LineMetrics lineMetrics = this.mFont.getLineMetrics(this.getString(), new FontRenderContext(null, false, false));
        return lineMetrics.getAscent();
    }

    protected float getDescent() {
        LineMetrics lineMetrics = this.mFont.getLineMetrics(this.getString(), new FontRenderContext(null, false, false));
        return lineMetrics.getDescent();
    }

    protected AffineTransform getAffineTransform() {
        AffineTransform affineTransform = new AffineTransform();
        double d = this.getX();
        double d2 = this.getY();
        affineTransform.translate(d, d2);
        affineTransform.rotate(-this.getAngle());
        return affineTransform;
    }

    public boolean drawString(Graphics2D graphics2D) {
        String string = this.getString();
        graphics2D.setPaint(this.getColor(0));
        graphics2D.setFont(this.mFont);
        if (Math.abs(this.getAngle()) < Float.MIN_VALUE) {
            this.drawStringHorizontally(string, graphics2D);
            return true;
        }
        AffineTransform affineTransform = this.getAffineTransform();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        graphics2D.transform(affineTransform);
        Rectangle2D rectangle2D = this.getVisualBounds();
        graphics2D.drawString(string, 0.0f, this.getAscent());
        graphics2D.setTransform(affineTransform2);
        return true;
    }

    protected boolean drawStringHorizontally(String string, Graphics2D graphics2D) {
        Rectangle2D rectangle2D = this.getVisualBounds();
        graphics2D.drawString(string, this.getX(), this.getY() + this.getAscent());
        return true;
    }

    public static void main(String[] stringArray) {
        SGDrawingElementString2D sGDrawingElementString2D = new SGDrawingElementString2D("ABCDEFG", "Serif", 0, 15.0f, 0.0f, 0.0f);
        sGDrawingElementString2D.setMagnification(1.0f);
        System.out.println(sGDrawingElementString2D.getElementBounds());
        sGDrawingElementString2D.setMagnification(2.0f);
        System.out.println(sGDrawingElementString2D.getElementBounds());
        sGDrawingElementString2D.setMagnification(4.0f);
        System.out.println(sGDrawingElementString2D.getElementBounds());
        sGDrawingElementString2D.setMagnification(2.0f);
        System.out.println(sGDrawingElementString2D.getElementBounds());
    }
}

