/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakElement;

public class SGAxisBreakSymbolDialog
extends SGPropertyDialog {
    public static final String TITLE = "Axis Break Symbol Properties";
    private JLabel mAngleLabel;
    private SGSpinner mAngleSpinner;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mColorLabel;
    private JSeparator mColorSeparator;
    private JPanel mCommonPanel;
    private JLabel mDistortionLabel;
    private SGSpinner mDistortionSpinner;
    private JLabel mFormLabel;
    private JSeparator mFormSeparator;
    private JRadioButton mHorizontalRadioButton;
    private JButton mInnerColorButton;
    private JLabel mInnerColorLabel;
    private JLabel mIntervalLabel;
    private SGSpinner mIntervalSpinner;
    private JRadioButton mLeftBottomRadioButton;
    private JLabel mLeftSpaceLabel;
    private JRadioButton mLeftTopRadioButton;
    private JLabel mLengthLabel;
    private SGSpinner mLengthSpinner;
    private JButton mLineColorButton;
    private JLabel mLineColorLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviewButton;
    private JRadioButton mRightBottomRadioButton;
    private JLabel mRightSpaceLabel;
    private JRadioButton mRightTopRadioButton;
    private JLabel mScaleReferenceLabel1;
    private JLabel mScaleReferenceLabel2;
    private JLabel mSizeLabel;
    private JSeparator mSizeSeparator;
    private JRadioButton mVerticalRadioButton;
    private JLabel mXValueLabel;
    private JTextField mXValueTextField;
    private JLabel mYValueLabel;
    private JTextField mYValueTextField;
    private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

    public SGAxisBreakSymbolDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mPanel = new JPanel();
        this.mSizeSeparator = new JSeparator();
        this.mFormSeparator = new JSeparator();
        this.mColorSeparator = new JSeparator();
        this.mDistortionLabel = new JLabel();
        this.mAngleLabel = new JLabel();
        this.mDistortionSpinner = new SGSpinner();
        this.mAngleSpinner = new SGSpinner();
        this.mSizeLabel = new JLabel();
        this.mFormLabel = new JLabel();
        this.mLengthLabel = new JLabel();
        this.mLengthSpinner = new SGSpinner();
        this.mIntervalLabel = new JLabel();
        this.mIntervalSpinner = new SGSpinner();
        this.mLineWidthLabel = new JLabel();
        this.mLineWidthSpinner = new SGSpinner();
        this.mColorLabel = new JLabel();
        this.mInnerColorButton = new JButton();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mLineColorLabel = new JLabel();
        this.mLineColorButton = new JButton();
        this.mInnerColorLabel = new JLabel();
        this.mHorizontalRadioButton = new JRadioButton();
        this.mVerticalRadioButton = new JRadioButton();
        this.mLocationLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mXValueLabel = new JLabel();
        this.mXValueTextField = new JTextField();
        this.mYValueLabel = new JLabel();
        this.mYValueTextField = new JTextField();
        this.mCommonPanel = new JPanel();
        this.mLeftTopRadioButton = new JRadioButton();
        this.mLeftBottomRadioButton = new JRadioButton();
        this.mRightTopRadioButton = new JRadioButton();
        this.mRightBottomRadioButton = new JRadioButton();
        this.mScaleReferenceLabel2 = new JLabel();
        this.mScaleReferenceLabel1 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        this.mPanel.add((Component)this.mSizeSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 45, 0, 0);
        this.mPanel.add((Component)this.mFormSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 45, 0, 0);
        this.mPanel.add((Component)this.mColorSeparator, gridBagConstraints);
        this.mDistortionLabel.setFont(new Font("Dialog", 0, 12));
        this.mDistortionLabel.setText("Distortion");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mDistortionLabel, gridBagConstraints);
        this.mAngleLabel.setFont(new Font("Dialog", 0, 12));
        this.mAngleLabel.setText("Angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mPanel.add((Component)this.mAngleLabel, gridBagConstraints);
        this.mDistortionSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mDistortionSpinner, gridBagConstraints);
        this.mAngleSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mAngleSpinner, gridBagConstraints);
        this.mSizeLabel.setFont(new Font("Dialog", 3, 12));
        this.mSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mSizeLabel, gridBagConstraints);
        this.mFormLabel.setFont(new Font("Dialog", 3, 12));
        this.mFormLabel.setText("Form");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFormLabel, gridBagConstraints);
        this.mLengthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLengthLabel.setText("Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLengthLabel, gridBagConstraints);
        this.mLengthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLengthSpinner, gridBagConstraints);
        this.mIntervalLabel.setFont(new Font("Dialog", 0, 12));
        this.mIntervalLabel.setText("Interval");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mPanel.add((Component)this.mIntervalLabel, gridBagConstraints);
        this.mIntervalSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mIntervalSpinner, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Line Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 3, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mInnerColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mPanel.add((Component)this.mInnerColorButton, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.mPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        this.mPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mPanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mPanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mInnerColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mInnerColorLabel.setText("Inner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mPanel.add((Component)this.mInnerColorLabel, gridBagConstraints);
        this.mHorizontalRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mHorizontalRadioButton.setText("Horizontal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mHorizontalRadioButton, gridBagConstraints);
        this.mVerticalRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mVerticalRadioButton.setText("Vertical");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mVerticalRadioButton, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 60, 0, 0);
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        this.mXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mXValueLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mXValueLabel, gridBagConstraints);
        this.mXValueTextField.setColumns(6);
        this.mXValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mXValueTextField.setPreferredSize(new Dimension(72, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mXValueTextField, gridBagConstraints);
        this.mYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mYValueLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mYValueLabel, gridBagConstraints);
        this.mYValueTextField.setColumns(6);
        this.mYValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mYValueTextField.setPreferredSize(new Dimension(72, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mYValueTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLeftTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftTopRadioButton, gridBagConstraints);
        this.mLeftBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftBottomRadioButton, gridBagConstraints);
        this.mRightTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightTopRadioButton, gridBagConstraints);
        this.mRightBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightBottomRadioButton, gridBagConstraints);
        this.mScaleReferenceLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel2, gridBagConstraints);
        this.mScaleReferenceLabel1.setFont(new Font("Dialog", 1, 12));
        this.mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mLengthSpinner.initProperties(new SpinnerNumberModel(0.5, 0.5, 2.0, 0.1), " cm");
        this.mIntervalSpinner.initProperties(new SpinnerNumberModel(0.5, 0.1, 2.0, 0.1), " cm");
        this.mDistortionSpinner.initProperties(new SpinnerNumberModel(0.0, -1.0, 1.0, 0.1), null);
        this.mAngleSpinner.initProperties(new SpinnerNumberModel(0.0, -60.000003814697266, 60.000003814697266, 1.0), SGSpinner.SPINNER_UNIT_DEGREE);
        this.mLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.mHorizontalRadioButton);
        ((ButtonGroup)serializable).add(this.mVerticalRadioButton);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.mLeftBottomRadioButton);
        ((ButtonGroup)serializable).add(this.mLeftTopRadioButton);
        ((ButtonGroup)serializable).add(this.mRightBottomRadioButton);
        ((ButtonGroup)serializable).add(this.mRightTopRadioButton);
        ((ButtonGroup)serializable).add(this.mNoAxisSelectionRadioButton);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        this.mLineColorButton.addActionListener(this);
        this.mInnerColorButton.addActionListener(this);
        serializable = this.getSpinnerList();
        for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)((ArrayList)serializable).get(i);
            sGSpinner.getFormattedTextField().addActionListener(this);
        }
        this.mXValueTextField.addActionListener(this);
        this.mYValueTextField.addActionListener(this);
        this.mFocusedColorSetButton = this.mLineColorButton;
        return true;
    }

    public Number getXValue() {
        return this.getNumber(this.mXValueTextField);
    }

    public Number getYValue() {
        return this.getNumber(this.mYValueTextField);
    }

    public Number getLength() {
        return this.mLengthSpinner.getNumber();
    }

    public Number getInterval() {
        return this.mIntervalSpinner.getNumber();
    }

    public Number getDistortion() {
        return this.mDistortionSpinner.getNumber();
    }

    public Number getAngle() {
        return this.mAngleSpinner.getNumber();
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public Boolean isHorizontal() {
        return new Boolean(this.mHorizontalRadioButton.isSelected());
    }

    public Color getLineColor() {
        return this.mLineColorButton.getBackground();
    }

    public Color getInnerColor() {
        return this.mInnerColorButton.getBackground();
    }

    public boolean setAxisRadioButton(int n, int n2) {
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 2: {
                        this.mLeftBottomRadioButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        this.mRightBottomRadioButton.setSelected(true);
                        break block0;
                    }
                }
                return false;
            }
            case 1: {
                switch (n2) {
                    case 2: {
                        this.mLeftTopRadioButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        this.mRightTopRadioButton.setSelected(true);
                        break block0;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setXValue(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Double d = SGUtilityText.getDouble(string);
        if (d == null) {
            return false;
        }
        this.mXValueTextField.setText(string);
        return true;
    }

    public boolean setYValue(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Double d = SGUtilityText.getDouble(string);
        if (d == null) {
            return false;
        }
        this.mYValueTextField.setText(string);
        return true;
    }

    public boolean setLength(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Float f = SGUtilityText.getFloat(string);
        if (f == null) {
            return false;
        }
        this.mLengthSpinner.setValue(f);
        return true;
    }

    public boolean setInterval(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Float f = SGUtilityText.getFloat(string);
        if (f == null) {
            return false;
        }
        this.mIntervalSpinner.setValue(f);
        return true;
    }

    public boolean setDistortion(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Float f = SGUtilityText.getFloat(string);
        if (f == null) {
            return false;
        }
        this.mDistortionSpinner.setValue(f);
        return true;
    }

    public boolean setAngle(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Float f = SGUtilityText.getFloat(string);
        if (f == null) {
            return false;
        }
        this.mAngleSpinner.setValue(f);
        return true;
    }

    public boolean setLineWidth(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Float f = SGUtilityText.getFloat(string);
        if (f == null) {
            return false;
        }
        this.mLineWidthSpinner.setValue(f);
        return true;
    }

    public boolean setHorizontal(boolean bl) {
        this.mHorizontalRadioButton.setSelected(bl);
        this.mVerticalRadioButton.setSelected(!bl);
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setBackground(color);
        return true;
    }

    public boolean setInnerColor(Color color) {
        this.mInnerColorButton.setBackground(color);
        return true;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        arrayList.add(this.mXValueTextField);
        arrayList.add(this.mYValueTextField);
        return arrayList;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mLineColorButton);
        arrayList.add(this.mInnerColorButton);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mLengthSpinner);
        arrayList.add(this.mIntervalSpinner);
        arrayList.add(this.mDistortionSpinner);
        arrayList.add(this.mAngleSpinner);
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    public SGAxisBreakElement.AxisBreakSymbolWithAxesProperties getProperties() {
        SGAxisBreakElement.AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = new SGAxisBreakElement.AxisBreakSymbolWithAxesProperties();
        Number number = this.getXValue();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolWithAxesProperties.setXValue(number.doubleValue());
        Number number2 = this.getYValue();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolWithAxesProperties.setYValue(number2.doubleValue());
        Number number3 = this.getLength();
        if (number3 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolWithAxesProperties.setLength(number3.floatValue() / 0.035277776f);
        Number number4 = this.getInterval();
        if (number4 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolWithAxesProperties.setInterval(number4.floatValue() / 0.035277776f);
        Number number5 = this.getDistortion();
        if (number5 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolWithAxesProperties.setDistortion(number5.floatValue());
        Number number6 = this.getAngle();
        if (number6 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolWithAxesProperties.setAngle(number6.floatValue() * ((float)Math.PI / 180));
        Number number7 = this.getLineWidth();
        if (number7 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolWithAxesProperties.setLineWidth(number7.floatValue());
        Boolean bl = this.isHorizontal();
        if (bl == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisBreakSymbolWithAxesProperties.setHorizontal(bl);
        Color color = this.getLineColor();
        axisBreakSymbolWithAxesProperties.setLineColor(color);
        Color color2 = this.getInnerColor();
        axisBreakSymbolWithAxesProperties.setColor(color2);
        return axisBreakSymbolWithAxesProperties;
    }

    public String getXAxisLocation() {
        String string = null;
        if (this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected()) {
            string = "Bottom";
        } else if (this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected()) {
            string = "Top";
        }
        return string;
    }

    public String getYAxisLocation() {
        String string = null;
        if (this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected()) {
            string = "Left";
        } else if (this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected()) {
            string = "Right";
        }
        return string;
    }

    private boolean setAxesProperties(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList.size() != arrayList2.size()) {
            throw new IllegalArgumentException();
        }
        int n = arrayList.size();
        if (n == 0) {
            return false;
        }
        Integer n2 = (Integer)arrayList.get(0);
        Integer n3 = (Integer)arrayList2.get(0);
        Integer n4 = n2;
        Integer n5 = n3;
        if (n > 1) {
            Integer n6;
            int n7;
            for (n7 = 1; n7 < n; ++n7) {
                n6 = (Integer)arrayList.get(n7);
                if (n2.equals(n6)) continue;
                n4 = null;
                break;
            }
            for (n7 = 1; n7 < n; ++n7) {
                n6 = (Integer)arrayList2.get(n7);
                if (n3.equals(n6)) continue;
                n5 = null;
                break;
            }
        }
        if (n4 == null || n5 == null) {
            this.mNoAxisSelectionRadioButton.setSelected(true);
            return false;
        }
        this.setAxisRadioButton(n4, n5);
        return true;
    }
}

