/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.geom.Line2D;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;

public final class SGPreviewDialog
extends SGDialog {
    private JButton mOKButton = new JButton("OK");
    private JButton mCancelButton = new JButton("Cancel");
    private JScrollPane mScrollPane;
    private Color mPaperColor;
    public static final int DEFAULT_WIDTH = 600;
    public static final int DEFAULT_HEIGHT = 500;
    private static int mTempWidth = 600;
    private static int mTempHeight = 500;

    public SGPreviewDialog() {
        this.initComponents();
    }

    public SGPreviewDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.initComponents();
    }

    public SGPreviewDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.mOKButton);
        jPanel.add(this.mCancelButton);
        jPanel.setBorder(new EtchedBorder(0));
        this.getContentPane().add((Component)jPanel, "North");
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.setVisible(false);
        this.setResizable(true);
    }

    public boolean setTargetObject(Component component, int n, int n2, int n3, int n4, Color color) {
        PaperPanel paperPanel = new PaperPanel(color, new Rectangle(0, 0, n, n2));
        paperPanel.add(component);
        paperPanel.setPreferredSize(new Dimension(n3, n4));
        ShadowPanel shadowPanel = new ShadowPanel(paperPanel);
        shadowPanel.add(paperPanel);
        JPanel jPanel = new JPanel();
        jPanel.add(shadowPanel);
        this.mScrollPane = new JScrollPane(jPanel);
        this.getContentPane().add(this.mScrollPane);
        this.setSize(mTempWidth, mTempHeight);
        return true;
    }

    public void setOKButtonText(String string) {
        this.mOKButton.setText(new String(string));
    }

    public void setCancelButtonText(String string) {
        this.mCancelButton.setText(new String(string));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.mOKButton.getText())) {
            this.setCloseOption(0);
            this.setVisible(false);
        } else if (string.equals(this.mCancelButton.getText())) {
            this.setCloseOption(1);
            this.setVisible(false);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        Component component = componentEvent.getComponent();
        mTempWidth = component.getWidth();
        mTempHeight = component.getHeight();
    }

    public static class ShadowPanel
    extends JPanel {
        private Component mComponent;

        public ShadowPanel(Component component) {
            this.mComponent = component;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.mComponent != null) {
                graphics2D.setPaint(Color.BLACK);
                Rectangle rectangle = this.mComponent.getBounds();
                graphics2D.setStroke(new BasicStroke(4.0f));
                int n = rectangle.x + rectangle.width + 2;
                Line2D.Float float_ = new Line2D.Float(n, (float)rectangle.y + 6.0f, n, rectangle.y + rectangle.height + 2);
                int n2 = rectangle.y + rectangle.height + 2;
                Line2D.Float float_2 = new Line2D.Float((float)rectangle.x + 6.0f, n2, rectangle.x + rectangle.width + 2, n2);
                graphics2D.draw(float_);
                graphics2D.draw(float_2);
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.draw(rectangle);
            }
        }
    }

    public static class PaperPanel
    extends JPanel {
        private Rectangle mRect;
        private Color mColor;

        public PaperPanel(Color color, Rectangle rectangle) {
            this.init();
            this.mColor = color;
            this.mRect = rectangle;
        }

        private void init() {
            this.setLayout(null);
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.mRect != null & this.mColor != null) {
                Rectangle rectangle = this.mRect;
                graphics2D.setPaint(this.mColor);
                graphics2D.fill(rectangle);
            }
        }
    }
}

