/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertySettingListener;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGGridDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SGGridElement
extends SGFigureElement
implements SGIGridElement,
SGILineConstants,
SGIPropertySettingListener {
    private SGIAxisElement mAxisElement;
    private SGAxis mXAxis;
    private SGAxis mYAxis;
    private double mStepValueX = 1.0;
    private double mBaselineValueX = 0.0;
    private double mStepValueY = 1.0;
    private double mBaselineValueY = 0.0;
    private boolean mVisibleFlag;
    private boolean mAutoRangeFlag = true;
    private float mLineWidth;
    private int mLineType;
    private Color mColor;
    private int mCap = 0;
    private int mJoin = 1;
    private float mMiterLimit = 1.0f;
    private float mDashPhase = 0.0f;
    private HashSet mLineSet;
    private SGGridDialog mDialog = null;
    protected SGProperties mTemporaryProperties = null;

    public SGGridElement() {
        this.init();
    }

    private void init() {
        this.mVisibleFlag = false;
        this.mLineWidth = 1.0f;
        Integer n = SGDrawingElementLine.getLineTypeFromName("Dotted");
        if (n == null) {
            throw new Error();
        }
        this.mLineType = n;
        this.mColor = SGDefaultValues.FIGURE_GRID_COLOR;
    }

    public void setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
    }

    public boolean addData(SGData sGData, String string) {
        if (!super.addData(sGData, string)) {
            return false;
        }
        SGIAxisElement sGIAxisElement = this.mAxisElement;
        if (this.mXAxis == null) {
            this.mXAxis = sGIAxisElement.getAxis("Bottom");
        }
        if (this.mYAxis == null) {
            this.mYAxis = sGIAxisElement.getAxis("Left");
        }
        this.createAll();
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        this.createAll();
        return true;
    }

    public void showPropertyDialog(Dialog dialog) {
        SGGridDialog sGGridDialog;
        this.mDialog = sGGridDialog = new SGGridDialog(dialog, false);
        sGGridDialog.addPropertySettingListener(this);
        this.createTemporaryPropertyObject();
        if (!this.setDialogProperties()) {
            return;
        }
        sGGridDialog.setLocation(this.mDialogOwner.getLocation());
        sGGridDialog.setVisible(true);
        this.notifyToRoot();
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        HashSet hashSet;
        if (!this.isGridVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        float f = this.mMagnification * this.mLineWidth;
        graphics2D.setPaint(this.getColor());
        BasicStroke basicStroke = SGUtilityJava2D.getBasicStroke(this.mLineType, f, this.mCap, this.mJoin, this.mMiterLimit, this.mDashPhase);
        graphics2D.setStroke(basicStroke);
        if (bl) {
            SGUtilityForFigureElement.clipGraphRect(this, graphics2D);
        }
        if ((hashSet = this.mLineSet) != null) {
            Iterator iterator = hashSet.iterator();
            if (bl) {
                while (iterator.hasNext()) {
                    Shape shape = (Shape)iterator.next();
                    graphics2D.draw(shape);
                }
            } else {
                Area area = new Area(this.getGraphRect());
                while (iterator.hasNext()) {
                    Shape shape = (Shape)iterator.next();
                    Area area2 = new Area(basicStroke.createStrokedShape(shape));
                    area2.intersect(area);
                    graphics2D.fill(area2);
                }
            }
        }
        if (bl) {
            graphics2D.setClip(this.getGraphRect());
        }
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement)) {
            if (sGIFigureElement instanceof SGIAxisElement) {
                this.createAll();
            } else if (!(sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement || sGIFigureElement instanceof SGIGridElement)) {
                bl = sGIFigureElement.synchronizeArgument(this);
            }
        }
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    private void createAll() {
        HashSet hashSet = new HashSet();
        if (this.isGridVisible()) {
            Set set;
            if (this.mXAxis != null) {
                set = this.create(this.mXAxis, this.mBaselineValueX, true);
                hashSet.addAll(set);
            }
            if (this.mYAxis != null) {
                set = this.create(this.mYAxis, this.mBaselineValueY, false);
                hashSet.addAll(set);
            }
        }
        this.mLineSet = hashSet;
        this.repaint();
    }

    private Set create(SGAxis sGAxis, double d, boolean bl) {
        int n = sGAxis.getScaleType();
        float[] fArray = null;
        if (n == 0) {
            fArray = this.calcLocationLinear(sGAxis, d, bl);
        } else if (n == 1) {
            fArray = this.calcLocationLog(sGAxis, d, bl);
        } else {
            throw new Error();
        }
        int n2 = fArray.length;
        float f = this.getGraphRectX();
        float f2 = this.getGraphRectY();
        float f3 = this.getGraphRectWidth();
        float f4 = this.getGraphRectHeight();
        HashSet<Line2D.Float> hashSet = new HashSet<Line2D.Float>();
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                float f5 = fArray[i];
                Line2D.Float float_ = new Line2D.Float(f5, f2, f5, f2 + f4);
                hashSet.add(float_);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                float f6 = fArray[i];
                Line2D.Float float_ = new Line2D.Float(f, f6, f + f3, f6);
                hashSet.add(float_);
            }
        }
        return hashSet;
    }

    private float[] calcLocationLinear(SGAxis sGAxis, double d, boolean bl) {
        double d2 = this.mAutoRangeFlag ? this.calcStepValue(sGAxis) : (bl ? this.mStepValueX : this.mStepValueY);
        double d3 = sGAxis.getMinValue();
        double d4 = sGAxis.getMaxValue();
        HashSet<Double> hashSet = new HashSet<Double>();
        hashSet.add(new Double(d));
        double d5 = d;
        do {
            hashSet.add(new Double(d5 += d2));
        } while (!(d5 > d4));
        d5 = d;
        do {
            hashSet.add(new Double(d5 -= d2));
        } while (!(d5 < d3));
        int n = hashSet.size();
        float[] fArray = new float[n];
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Double d6 = (Double)iterator.next();
            fArray[n2] = this.calcLocation(d6, sGAxis, bl);
            ++n2;
        }
        return fArray;
    }

    private float[] calcLocationLog(SGAxis sGAxis, double d, boolean bl) {
        int n;
        int n2;
        double d2 = sGAxis.getRange().x;
        double d3 = sGAxis.getRange().y;
        int n3 = SGUtilityNumber.getOrder(0.99999999999999 * d2);
        int n4 = SGUtilityNumber.getOrder(d3);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = n3 + 1; n2 <= n4; ++n2) {
            arrayList.add(new Integer(n2));
        }
        n2 = arrayList.size();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            n = (Integer)arrayList.get(i);
            dArray[i] = SGUtilityNumber.getPowersOfTen(n);
        }
        float[] fArray = new float[n2];
        for (n = 0; n < n2; ++n) {
            fArray[n] = this.calcLocation(dArray[n], sGAxis, bl);
        }
        return fArray;
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        return true;
    }

    public SGProperties getProperties() {
        GridProperties gridProperties = new GridProperties();
        if (!this.getProperties(gridProperties)) {
            return null;
        }
        return gridProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GridProperties)) {
            return false;
        }
        GridProperties gridProperties = (GridProperties)sGProperties;
        gridProperties.mXAxis = this.mXAxis;
        gridProperties.mYAxis = this.mYAxis;
        gridProperties.mVisibleFlag = this.mVisibleFlag;
        gridProperties.mBaselineValueX = this.mBaselineValueX;
        gridProperties.mBaselineValueY = this.mBaselineValueY;
        gridProperties.mStepValueX = this.mStepValueX;
        gridProperties.mStepValueY = this.mStepValueY;
        gridProperties.mAutoRangeFlag = this.mAutoRangeFlag;
        gridProperties.mLineWidth = this.mLineWidth;
        gridProperties.mLineType = this.mLineType;
        gridProperties.mColor = this.mColor;
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GridProperties)) {
            return false;
        }
        GridProperties gridProperties = (GridProperties)sGProperties;
        this.mXAxis = gridProperties.mXAxis;
        this.mYAxis = gridProperties.mYAxis;
        this.mVisibleFlag = gridProperties.mVisibleFlag;
        this.mBaselineValueX = gridProperties.mBaselineValueX;
        this.mBaselineValueY = gridProperties.mBaselineValueY;
        this.mStepValueX = gridProperties.mStepValueX;
        this.mStepValueY = gridProperties.mStepValueY;
        this.mAutoRangeFlag = gridProperties.mAutoRangeFlag;
        this.mLineWidth = gridProperties.mLineWidth;
        this.mLineType = gridProperties.mLineType;
        this.mColor = gridProperties.mColor;
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        return true;
    }

    public String getTagName() {
        return "Grid";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("GridVisible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute("XAxisPosition", this.mAxisElement.getAxisLocation(this.mXAxis));
        element.setAttribute("YAxisPosition", this.mAxisElement.getAxisLocation(this.mYAxis));
        element.setAttribute("AutomaticCalculationOfTick", Boolean.toString(this.mAutoRangeFlag));
        element.setAttribute("StepValueX", Double.toString(this.mStepValueX));
        element.setAttribute("BaselineValueX", Double.toString(this.mBaselineValueX));
        element.setAttribute("StepValueY", Double.toString(this.mStepValueY));
        element.setAttribute("BaselineValueY", Double.toString(this.mBaselineValueY));
        element.setAttribute("Width", Float.toString(this.mLineWidth) + "pt");
        element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.mLineType));
        element.setAttribute("Color", SGUtilityText.getColorString(this.mColor));
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        return false;
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        return element;
    }

    public boolean readProperty(Element element) {
        GridProperties gridProperties = this.readProperty_(element);
        if (gridProperties == null) {
            return false;
        }
        return this.setProperties(gridProperties);
    }

    private GridProperties readProperty_(Element element) {
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        string = element.getAttribute("GridVisible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        string = element.getAttribute("XAxisPosition");
        if (string.length() == 0) {
            return null;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis(string);
        string = element.getAttribute("YAxisPosition");
        if (string.length() == 0) {
            return null;
        }
        SGAxis sGAxis2 = this.mAxisElement.getAxis(string);
        string = element.getAttribute("AutomaticCalculationOfTick");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl3 = bl;
        string = element.getAttribute("BaselineValueX");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        string = element.getAttribute("StepValueX");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d2 = number.doubleValue();
        string = element.getAttribute("BaselineValueY");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d3 = number.doubleValue();
        string = element.getAttribute("StepValueY");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d4 = number.doubleValue();
        string = element.getAttribute("Width");
        if (string == null) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "pt");
        if (number == null) {
            return null;
        }
        float f = number.floatValue();
        string = element.getAttribute("Type");
        if (string == null) {
            return null;
        }
        number = SGDrawingElementLine.getLineTypeFromName(string);
        if (number == null) {
            return null;
        }
        int n = number.intValue();
        string = element.getAttribute("Color");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        Color color2 = color;
        GridProperties gridProperties = new GridProperties();
        gridProperties.mVisibleFlag = bl2;
        gridProperties.mXAxis = sGAxis;
        gridProperties.mYAxis = sGAxis2;
        gridProperties.mAutoRangeFlag = bl3;
        gridProperties.mBaselineValueX = d;
        gridProperties.mStepValueX = d2;
        gridProperties.mBaselineValueY = d3;
        gridProperties.mStepValueY = d4;
        gridProperties.mLineWidth = f;
        gridProperties.mLineType = n;
        gridProperties.mColor = color2;
        return gridProperties;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        return true;
    }

    public boolean setChangedFocusedObjects() {
        return true;
    }

    public boolean createTemporaryPropertyObject() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    public boolean commit() {
        return this.commit(this.mDialog);
    }

    public boolean commit(SGPropertyDialog sGPropertyDialog) {
        boolean bl = this.setPropertiesFromDialog((SGGridDialog)sGPropertyDialog);
        if (!bl) {
            return false;
        }
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mChangedFlag = true;
        }
        this.mTemporaryProperties = null;
        this.createAll();
        this.mDialog.removeAllPropertySettingListeners();
        this.notifyChange();
        this.notifyToRoot();
        return true;
    }

    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.createAll();
        this.mDialog.removeAllPropertySettingListeners();
        this.notifyChange();
        return true;
    }

    public boolean preview() {
        return this.preview(this.mDialog);
    }

    public boolean preview(SGPropertyDialog sGPropertyDialog) {
        if (!this.setPropertiesFromDialog((SGGridDialog)sGPropertyDialog)) {
            return false;
        }
        this.createAll();
        this.notifyChange();
        return true;
    }

    public boolean undo() {
        if (!super.undo()) {
            return false;
        }
        this.createAll();
        this.notifyChange();
        return true;
    }

    public boolean redo() {
        if (!super.redo()) {
            return false;
        }
        this.createAll();
        this.notifyChange();
        return true;
    }

    public double getBaselineValueX() {
        return this.mBaselineValueX;
    }

    public double getBaselineValueY() {
        return this.mBaselineValueY;
    }

    public Color getColor() {
        return this.mColor;
    }

    public int getLineType() {
        return this.mLineType;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public double getStepValueX() {
        return this.mStepValueX;
    }

    public double getStepValueY() {
        return this.mStepValueY;
    }

    public void setAxes(SGAxis sGAxis, SGAxis sGAxis2) {
        this.mXAxis = sGAxis;
        this.mYAxis = sGAxis2;
    }

    public SGAxis getXAxis() {
        return this.mXAxis;
    }

    public SGAxis getYAxis() {
        return this.mYAxis;
    }

    public void setBaselineValueX(double d) {
        this.mBaselineValueX = d;
    }

    public void setBaselineValueY(double d) {
        this.mBaselineValueY = d;
    }

    public void setColor(Color color) {
        this.mColor = color;
    }

    public void setLineType(int n) {
        this.mLineType = n;
    }

    public void setLineWidth(float f) {
        this.mLineWidth = f;
    }

    public void setStepValueX(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("d<=0.0");
        }
        this.mStepValueX = d;
    }

    public void setStepValueY(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("d<=0.0");
        }
        this.mStepValueY = d;
    }

    public boolean isGridVisible() {
        return this.mVisibleFlag;
    }

    public void setGridVisible(boolean bl) {
        this.mVisibleFlag = bl;
        this.createAll();
    }

    public boolean isAutoRange() {
        return this.mAutoRangeFlag;
    }

    public void setAutoRangeFlag(boolean bl) {
        this.mAutoRangeFlag = bl;
    }

    private boolean setDialogProperties() {
        SGGridDialog sGGridDialog = this.mDialog;
        sGGridDialog.setGridVisible(this.mVisibleFlag);
        int n = this.mAxisElement.getConfigurationInPlane(this.mXAxis);
        if (n == -1) {
            throw new Error();
        }
        int n2 = this.mAxisElement.getConfigurationInPlane(this.mYAxis);
        if (n2 == -1) {
            throw new Error();
        }
        sGGridDialog.setAxisRadioButton(n, n2);
        sGGridDialog.setAutoFlag(this.isAutoRange());
        sGGridDialog.setBaseXValue(this.mBaselineValueX);
        sGGridDialog.setStepXValue(this.mStepValueX);
        sGGridDialog.setBaseYValue(this.mBaselineValueY);
        sGGridDialog.setStepYValue(this.mStepValueY);
        sGGridDialog.setLineWidth(this.mLineWidth);
        sGGridDialog.setLineType(this.mLineType);
        sGGridDialog.setLineColor(this.mColor);
        return true;
    }

    private boolean setPropertiesFromDialog(SGGridDialog sGGridDialog) {
        boolean bl;
        this.mVisibleFlag = bl = sGGridDialog.getGridVisible();
        String string = sGGridDialog.getXAxisLocation();
        if (string == null) {
            return false;
        }
        String string2 = sGGridDialog.getYAxisLocation();
        if (string2 == null) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis(string);
        SGAxis sGAxis2 = this.mAxisElement.getAxis(string2);
        this.setAxes(sGAxis, sGAxis2);
        this.setAutoRangeFlag(sGGridDialog.getAutoFlag());
        Number number = sGGridDialog.getBaseXValue();
        if (number == null) {
            return false;
        }
        Number number2 = sGGridDialog.getStepXValue();
        if (number2 == null) {
            return false;
        }
        if (!this.checkStepValue(number2.doubleValue(), sGAxis)) {
            return false;
        }
        Number number3 = sGGridDialog.getBaseYValue();
        if (number3 == null) {
            return false;
        }
        Number number4 = sGGridDialog.getStepYValue();
        if (number4 == null) {
            return false;
        }
        if (!this.checkStepValue(number4.doubleValue(), sGAxis2)) {
            return false;
        }
        this.setBaselineValueX(number.doubleValue());
        this.setStepValueX(number2.doubleValue());
        this.setBaselineValueY(number3.doubleValue());
        this.setStepValueY(number4.doubleValue());
        Number number5 = sGGridDialog.getLineWidth();
        if (number5 == null) {
            return false;
        }
        this.setLineWidth(number5.floatValue());
        int n = sGGridDialog.getLineType();
        if (n == -1) {
            return false;
        }
        this.setLineType(n);
        Color color = sGGridDialog.getLineColor();
        this.setColor(color);
        return true;
    }

    private boolean checkStepValue(double d, SGAxis sGAxis) {
        if (d <= 0.0) {
            SGUtility.showMessageDialog(this, "Set positive value.", "Error", 0);
            return false;
        }
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d2 = sGTuple2d.y - sGTuple2d.x;
        int n = SGUtilityNumber.getOrder(d2);
        double d3 = SGUtilityNumber.getPowersOfTen(n - 2);
        if (d < d3) {
            SGUtility.showMessageDialog(this, "Set value is too small.", "Error", 0);
            return false;
        }
        return true;
    }

    public static class GridProperties
    extends SGProperties {
        private SGAxis mXAxis;
        private SGAxis mYAxis;
        private double mStepValueX;
        private double mBaselineValueX;
        private double mStepValueY;
        private double mBaselineValueY;
        private boolean mVisibleFlag;
        private boolean mAutoRangeFlag;
        private float mLineWidth;
        private int mLineType;
        private Color mColor;

        public boolean equals(Object object) {
            if (!(object instanceof GridProperties)) {
                return false;
            }
            GridProperties gridProperties = (GridProperties)object;
            if (!this.mXAxis.equals(gridProperties.mXAxis)) {
                return false;
            }
            if (!this.mYAxis.equals(gridProperties.mYAxis)) {
                return false;
            }
            if (this.mBaselineValueX != gridProperties.mBaselineValueX) {
                return false;
            }
            if (this.mStepValueX != gridProperties.mStepValueX) {
                return false;
            }
            if (this.mBaselineValueY != gridProperties.mBaselineValueY) {
                return false;
            }
            if (this.mStepValueY != gridProperties.mStepValueY) {
                return false;
            }
            if (this.mVisibleFlag != gridProperties.mVisibleFlag) {
                return false;
            }
            if (this.mAutoRangeFlag != gridProperties.mAutoRangeFlag) {
                return false;
            }
            if (this.mLineWidth != gridProperties.mLineWidth) {
                return false;
            }
            if (this.mLineType != gridProperties.mLineType) {
                return false;
            }
            return this.mColor.equals(gridProperties.mColor);
        }
    }
}

