/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGISymbolConstants;

public abstract class SGDrawingElementSymbol
extends SGDrawingElement
implements SGISymbolConstants,
SGIDrawingElementConstants {
    protected SGTuple2f mLocation = new SGTuple2f();
    protected float mSize;
    protected int mType;
    protected float mAngle;
    protected Color mLineColor;
    protected float mLineWidth;

    public boolean setLocation(float f, float f2) {
        this.mLocation.setValues(f, f2);
        return true;
    }

    public boolean setLocation(SGTuple2f sGTuple2f) {
        this.mLocation = sGTuple2f;
        return true;
    }

    public boolean setSize(float f) {
        this.mSize = f;
        return true;
    }

    public boolean setType(int n) {
        this.mType = n;
        return true;
    }

    public boolean setAngle(float f) {
        this.mAngle = f;
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColor = color;
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        return true;
    }

    public SGTuple2f getLocation() {
        return new SGTuple2f(this.mLocation);
    }

    public float getX() {
        return this.mLocation.x;
    }

    public float getY() {
        return this.mLocation.y;
    }

    public float getSize() {
        return this.mSize;
    }

    public int getType() {
        return this.mType;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public static Integer getSymbolTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.equals("No Symbol")) {
            n = -1;
        } else if (string.equals("Circle")) {
            n = 0;
        } else if (string.equals("Square")) {
            n = 1;
        } else if (string.equals("Diamond")) {
            n = 2;
        } else if (string.equals("Triangle")) {
            n = 3;
        } else if (string.equals("I-Triangle")) {
            n = 4;
        } else if (string.equals("Cross")) {
            n = 5;
        } else if (string.equals("Plus")) {
            n = 6;
        } else if (string.equals("Transverse Line")) {
            n = 7;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getSymbolTypeName(int n) {
        String string = null;
        switch (n) {
            case -1: {
                string = "No Symbol";
                break;
            }
            case 0: {
                string = "Circle";
                break;
            }
            case 1: {
                string = "Square";
                break;
            }
            case 2: {
                string = "Diamond";
                break;
            }
            case 3: {
                string = "Triangle";
                break;
            }
            case 4: {
                string = "I-Triangle";
                break;
            }
            case 5: {
                string = "Cross";
                break;
            }
            case 6: {
                string = "Plus";
                break;
            }
            case 7: {
                string = "Transverse Line";
                break;
            }
        }
        return string;
    }

    public SGProperties getProperties() {
        SymbolProperties symbolProperties = new SymbolProperties();
        this.getProperties(symbolProperties);
        return symbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        symbolProperties.setSize(this.getSize());
        symbolProperties.setSymbolType(this.getType());
        symbolProperties.setLineWidth(this.getLineWidth());
        symbolProperties.setLineColor(this.getLineColor());
        symbolProperties.angle = this.getAngle();
        return true;
    }

    public static class SymbolProperties
    extends SGDrawingElement.DrawingElementProperties {
        double angle;
        public static final String[] keys = new String[]{"Type", "Size", "LineWidth", "LineColor"};

        public boolean equals(Object object) {
            if (!(object instanceof SymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SymbolProperties symbolProperties = (SymbolProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(symbolProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return symbolProperties.angle == this.angle;
        }

        public Float getSize() {
            String string = this.getProperty("Size");
            return SGUtilityText.getFloat(string);
        }

        public Integer getSymbolType() {
            String string = this.getProperty("Type");
            return SGUtilityText.getInteger(string);
        }

        public Float getLineWidth() {
            String string = this.getProperty("LineWidth");
            return SGUtilityText.getFloat(string);
        }

        public Color getLineColor() {
            String string = this.getProperty("LineColor");
            return SGUtilityText.getColorFromString(string);
        }

        public boolean setSize(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("Size", new Float(f).toString());
            return true;
        }

        public boolean setSymbolType(int n) {
            this.setProperty("Type", new Integer(n).toString());
            return true;
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("LineWidth", new Float(f).toString());
            return true;
        }

        public boolean setLineColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty("LineColor", string);
            return true;
        }
    }
}

