/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.riken.brain.ni.samuraigraph.application.SGFileChooserWizardDialog;

public class SGMultiDataFileChooserWizardDialog
extends SGFileChooserWizardDialog
implements TableModelListener,
DropTargetListener,
ComponentListener,
PropertyChangeListener,
MouseMotionListener {
    public static final String TITLE = "Choose data files.";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JPanel mInsideScrollPanePanel;
    private JButton mNextButton;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviousButton;
    private JScrollPane mScrollPane;
    private JPanel mSingleFileChooserButtonPanel;
    protected JTable mTable;
    private JScrollPane mTableScrollPane;
    public static final String COLUMN_NAME_FIGURE_ID = "Figure ID";
    public static final String COLUMN_NAME_DATA_TYPE = "Data Type";
    public static final String COLUMN_NAME_DATA_NAME = "Data Name";
    public static final String COLUMN_NAME_FILE_NAME = "File Name";
    private static final int[] PREFERRED_COLUMN_WIDTH_ARRAY = new int[]{30, 80, 80, 110};
    private int mFileNumber;
    private DefaultTableModel mTableModel = null;
    public static final int DEFAULT_ROW_HEIGHT = 20;
    public static final String NO_DATA = "NO_DATA";
    public static final int DEFAULT_SINGLE_FILE_CHOOSER_BUTTON_WIDTH = 20;
    private JButton[] mSingleFileChooserButtonArray = null;

    public SGMultiDataFileChooserWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGMultiDataFileChooserWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        this.updateTable();
    }

    public void componentShown(ComponentEvent componentEvent) {
        super.componentShown(componentEvent);
        this.updateTable();
    }

    private void updateTable() {
        int n = this.mTable.getHeight();
        if (n != 0) {
            this.updateButtonsPanel();
            this.setPreferredColumnWidth();
        }
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mScrollPane = new JScrollPane();
        this.mInsideScrollPanePanel = new JPanel();
        this.mSingleFileChooserButtonPanel = new JPanel();
        this.mTableScrollPane = new JScrollPane();
        this.mTable = new JTable();
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setFont(new Font("SansSerif", 0, 11));
        this.mScrollPane.setFont(new Font("Dialog", 0, 11));
        this.mScrollPane.setPreferredSize(new Dimension(458, 200));
        this.mInsideScrollPanePanel.setLayout(new GridBagLayout());
        this.mInsideScrollPanePanel.setFont(new Font("Dialog", 0, 11));
        this.mSingleFileChooserButtonPanel.setLayout(null);
        this.mSingleFileChooserButtonPanel.setFont(new Font("Dialog", 0, 11));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.mInsideScrollPanePanel.add((Component)this.mSingleFileChooserButtonPanel, gridBagConstraints);
        this.mTableScrollPane.setVerticalScrollBarPolicy(21);
        this.mTableScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTableScrollPane.setBorder(null);
        this.mTableScrollPane.setFont(new Font("Dialog", 0, 11));
        this.mTableScrollPane.setPreferredSize(new Dimension(434, 196));
        this.mTable.setFont(new Font("Dialog", 0, 11));
        this.mTableScrollPane.setViewportView(this.mTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.mInsideScrollPanePanel.add((Component)this.mTableScrollPane, gridBagConstraints);
        this.mScrollPane.setViewportView(this.mInsideScrollPanePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.mPanel.add((Component)this.mScrollPane, gridBagConstraints);
        this.getContentPane().add((Component)this.mPanel, new GridBagConstraints());
        this.mButtonPanel.setBorder(new EtchedBorder());
        this.mButtonPanel.setFont(new Font("Dialog", 0, 11));
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviousButton.setText("<Prev");
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mNextButton.setText("Next>");
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    public static String[] getColumnNameArray() {
        return new String[]{COLUMN_NAME_FIGURE_ID, COLUMN_NAME_DATA_TYPE, COLUMN_NAME_DATA_NAME, COLUMN_NAME_FILE_NAME};
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mOKButton.setEnabled(false);
        this.mTableModel = new OriginalTableModel();
        this.mTableModel.addTableModelListener(this);
        this.mTable.setRowHeight(20);
        DropTarget dropTarget = new DropTarget(this.mTable, 3, this, true);
        this.setDropTarget(dropTarget);
        this.getPreviousButton().addActionListener(this);
        this.getNextButton().addActionListener(this);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        this.mTable.addComponentListener(this);
        this.mTable.addPropertyChangeListener(this);
        this.mTable.addMouseMotionListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        JTable jTable = this.getTable();
        JButton[] jButtonArray = this.mSingleFileChooserButtonArray;
        for (int i = 0; i < jButtonArray.length; ++i) {
            if (!object.equals(jButtonArray[i])) continue;
            this.mFileChooser.setMultiSelectionEnabled(false);
            File[] fileArray = this.showFileChooser();
            if (fileArray == null) {
                return;
            }
            File file = fileArray[0];
            this.setSelectedFile(i, file);
            break;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        JTable jTable = this.mTable;
        Point point = mouseEvent.getPoint();
        int n2 = jTable.rowAtPoint(point);
        Object object = jTable.getValueAt(n2, n = this.getFileNameColumnIndex());
        if (object == null | "".equals(object)) {
            jTable.setToolTipText(null);
            return;
        }
        String string = (String)object;
        jTable.setToolTipText(string);
    }

    public int getColumnIndex(String string) {
        return this.mTable.getColumnModel().getColumnIndex(string);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        boolean bl = true;
        DefaultTableModel defaultTableModel = this.mTableModel;
        int n = defaultTableModel.getRowCount();
        int n2 = defaultTableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = defaultTableModel.getValueAt(i, j);
                if (!(object == null | "".equals(object))) continue;
                bl = false;
                break;
            }
            if (!bl) break;
        }
        this.getOKButton().setEnabled(bl);
    }

    public JTable getTable() {
        return this.mTable;
    }

    public boolean setTable(JTable jTable) {
        this.mTable = jTable;
        return true;
    }

    public TableModel getTableModel() {
        return this.mTable.getModel();
    }

    public boolean setTableModel(TableModel tableModel) {
        JTable jTable = this.mTable;
        jTable.setModel(tableModel);
        return true;
    }

    public int getFigureIDColumnIndex() {
        return this.getColumnIndex(COLUMN_NAME_FIGURE_ID);
    }

    public void setFigureIDArray(String[] stringArray) {
        this.setData(stringArray, this.getFigureIDColumnIndex());
    }

    public int getDataNameColumnIndex() {
        return this.getColumnIndex(COLUMN_NAME_DATA_NAME);
    }

    public void setDataNameArray(String[] stringArray) {
        this.setData(stringArray, this.getDataNameColumnIndex());
    }

    public int getDataTypeColumnIndex() {
        return this.getColumnIndex(COLUMN_NAME_DATA_TYPE);
    }

    public void setDataTypeArray(String[] stringArray) {
        this.setData(stringArray, this.getDataTypeColumnIndex());
    }

    public int getFileNameColumnIndex() {
        return this.getColumnIndex(COLUMN_NAME_FILE_NAME);
    }

    public void setFileNameArray(String[] stringArray) {
        this.setData(stringArray, this.getFileNameColumnIndex());
    }

    private void setData(Object[] objectArray, int n) {
        Component[] componentArray;
        int n2;
        DefaultTableModel defaultTableModel = this.mTableModel;
        int n3 = SGMultiDataFileChooserWizardDialog.getColumnNameArray().length;
        int n4 = this.mTableModel.getRowCount();
        Object[][] objectArray2 = new Object[n4][n3];
        for (int i = 0; i < n3; ++i) {
            if (i == n) {
                for (n2 = 0; n2 < n4; ++n2) {
                    objectArray2[n2][i] = objectArray[n2];
                }
                continue;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                objectArray2[n2][i] = defaultTableModel.getDataVector().elementAt(n2).elementAt(i);
            }
        }
        Object[] objectArray3 = new String[]{COLUMN_NAME_FIGURE_ID, COLUMN_NAME_DATA_TYPE, COLUMN_NAME_DATA_NAME, COLUMN_NAME_FILE_NAME};
        defaultTableModel.setDataVector(objectArray2, objectArray3);
        this.setTableModel(defaultTableModel);
        n2 = -1;
        int n5 = this.getDataNameColumnIndex();
        for (int i = 0; i < n4; ++i) {
            componentArray = objectArray2[i][n5];
            if (!NO_DATA.equals(componentArray)) continue;
            n2 = i;
            break;
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        componentArray = this.mSingleFileChooserButtonPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton)) continue;
            arrayList.add(componentArray[i]);
        }
        if (n2 != -1) {
            JButton jButton = (JButton)arrayList.get(n2);
            jButton.setEnabled(false);
        }
    }

    private void updateButtonsPanel() {
        int n = this.mFileNumber;
        JTableHeader jTableHeader = this.mTable.getTableHeader();
        int n2 = jTableHeader.getHeight();
        int n3 = n2 + (n + 1) * 20;
        Dimension dimension = new Dimension(20, n3);
        this.mSingleFileChooserButtonPanel.setSize(dimension);
        Component[] componentArray = this.mSingleFileChooserButtonPanel.getComponents();
        int n4 = n2;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton)) continue;
            JButton jButton = (JButton)componentArray[i];
            jButton.setSize(20, 20);
            jButton.setLocation(jButton.getX(), n4);
            n4 += 20;
        }
    }

    private void setPreferredColumnWidth() {
        JTable jTable = this.mTable;
        String[] stringArray = SGMultiDataFileChooserWizardDialog.getColumnNameArray();
        int[] nArray = PREFERRED_COLUMN_WIDTH_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            TableColumn tableColumn = jTable.getColumn(stringArray[i]);
            tableColumn.setPreferredWidth(nArray[i]);
        }
    }

    private void setOriginalTableCellRenderer() {
        JTable jTable = this.mTable;
        String[] stringArray = SGMultiDataFileChooserWizardDialog.getColumnNameArray();
        for (int i = 0; i < stringArray.length; ++i) {
            TableColumn tableColumn = jTable.getColumn(stringArray[i]);
            tableColumn.setCellRenderer(new OriginalTableCellRenderer());
        }
    }

    public void init(int n) {
        Component[] componentArray = this.mSingleFileChooserButtonPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton)) continue;
            JButton jButton = (JButton)componentArray[i];
            jButton.removeActionListener(this);
            this.mSingleFileChooserButtonPanel.remove(jButton);
        }
        int n2 = 20 * (n + 1);
        this.mSingleFileChooserButtonPanel.setPreferredSize(new Dimension(20, n2));
        int n3 = this.mInsideScrollPanePanel.getHeight();
        int n4 = n3 < n2 ? n2 : n3;
        int n5 = this.mTableScrollPane.getPreferredSize().width;
        this.mTableScrollPane.setPreferredSize(new Dimension(n5, n4));
        JButton[] jButtonArray = this.mSingleFileChooserButtonArray = new JButton[n];
        for (int i = 0; i < n; ++i) {
            JButton jButton = new JButton(" ");
            jButton.setFont(new Font("Dialog", 1, 12));
            jButton.setPreferredSize(new Dimension(20, 20));
            jButton.addActionListener(this);
            jButtonArray[i] = jButton;
            this.mSingleFileChooserButtonPanel.add(jButton);
        }
        Object[][] objectArray = new Object[n][];
        int n6 = SGMultiDataFileChooserWizardDialog.getColumnNameArray().length;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new Object[n6];
        }
        this.setData(objectArray);
    }

    public void setData(Object[][] objectArray) {
        DefaultTableModel defaultTableModel = this.mTableModel;
        defaultTableModel.setDataVector(objectArray, SGMultiDataFileChooserWizardDialog.getColumnNameArray());
        this.setTableModel(defaultTableModel);
    }

    private File[] showFileChooser() {
        ArrayList arrayList = this.openFileChooser();
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        File[] fileArray = new File[arrayList.size()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = (File)arrayList.get(i);
        }
        return fileArray;
    }

    public TreeMap getSelectedFilePathListMap() {
        JTable jTable = this.mTable;
        int n = this.getFigureIDColumnIndex();
        int n2 = this.getFileNameColumnIndex();
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            Object object = jTable.getValueAt(i, n);
            Object object2 = treeMap.get(object);
            if (object2 == null) {
                object2 = new ArrayList();
                treeMap.put(object, object2);
            }
            ArrayList arrayList = (ArrayList)object2;
            Object object3 = jTable.getValueAt(i, n2);
            arrayList.add(object3);
        }
        return treeMap;
    }

    public String[] getSelectedFileNames() {
        JTable jTable = this.getTable();
        int n = this.getFileNameColumnIndex();
        int n2 = jTable.getRowCount();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = (String)jTable.getValueAt(i, n);
        }
        return stringArray;
    }

    private boolean setSelectedFiles(File[] fileArray) {
        int n;
        JTable jTable = this.getTable();
        int n2 = this.getFileNameColumnIndex();
        for (n = 0; n < jTable.getRowCount(); ++n) {
            jTable.setValueAt(null, n, n2);
        }
        for (n = 0; n < fileArray.length; ++n) {
            this.setSelectedFile(n, fileArray[n]);
        }
        return true;
    }

    private boolean setSelectedFile(int n, File file) {
        int n2 = this.getFileNameColumnIndex();
        String string = file.getPath();
        this.mTable.setValueAt(string, n, n2);
        return true;
    }

    public int getFileNumber() {
        return this.mFileNumber;
    }

    public void setFileNumber(int n) {
        if (n < 0) {
            new IllegalArgumentException("num<0");
        }
        this.mFileNumber = n;
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
        Component component = dropTarget.getComponent();
        SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)component;
        dropTargetDropEvent.acceptDrop(3);
        JTable jTable = this.mTable;
        JTableHeader jTableHeader = jTable.getTableHeader();
        DefaultTableModel defaultTableModel = this.mTableModel;
        JViewport jViewport = this.mScrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        Point point2 = dropTargetDropEvent.getLocation();
        Insets insets = this.getInsets();
        int n = insets.left - point.x;
        int n2 = insets.top + this.mScrollPane.getY() - point.y + jTableHeader.getHeight();
        Point point3 = new Point(point2.x - n, point2.y - n2);
        int n3 = this.getFileNameColumnIndex();
        try {
            if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() == 0) {
                    return;
                }
                File file = (File)list.get(0);
                int n4 = jTable.rowAtPoint(point3);
                if (n4 == -1) {
                    return;
                }
                if (!NO_DATA.equals(defaultTableModel.getValueAt(n4, n3))) {
                    Rectangle rectangle = jTable.getCellRect(n4, n3, true);
                    jTable.setValueAt(file.getPath(), n4, n3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            dropTargetDropEvent.dropComplete(false);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private class OriginalTableCellRenderer
    extends DefaultTableCellRenderer {
        OriginalTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return null;
            }
            this.setText((String)object);
            String string = jTable.getColumnName(n2);
            if (string.equals(SGMultiDataFileChooserWizardDialog.COLUMN_NAME_FIGURE_ID)) {
                this.setHorizontalAlignment(2);
            } else if (string.equals(SGMultiDataFileChooserWizardDialog.COLUMN_NAME_DATA_TYPE)) {
                this.setHorizontalAlignment(2);
            } else if (string.equals(SGMultiDataFileChooserWizardDialog.COLUMN_NAME_DATA_NAME)) {
                this.setHorizontalAlignment(2);
            } else if (string.equals(SGMultiDataFileChooserWizardDialog.COLUMN_NAME_FILE_NAME)) {
                this.setHorizontalAlignment(4);
            }
            return this;
        }
    }

    private class OriginalTableModel
    extends DefaultTableModel {
        public boolean isCellEditable(int n, int n2) {
            JTable jTable = SGMultiDataFileChooserWizardDialog.this.mTable;
            String string = jTable.getColumnName(n2);
            boolean bl = false;
            if (string.equals(SGMultiDataFileChooserWizardDialog.COLUMN_NAME_FILE_NAME)) {
                Object object = jTable.getValueAt(n, n2);
                if (object == null) {
                    bl = true;
                } else if (!object.equals(SGMultiDataFileChooserWizardDialog.NO_DATA)) {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

