/*
 * Created on 2004/08/06
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;


import java.awt.Color;
import java.util.ArrayList;

import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;

import org.w3c.dom.Element;



/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class SGElementGroupErrorBar extends SGElementGroupArrow
{

	/**
	 * 
	 */
	public static final String TAG_NAME_ERROR_BAR = "ErrorBar";
	public static final String KEY_ERROR_BAR_STYLE = "Style";
	public static final String KEY_ERROR_BAR_HEAD_TYPE = "HeadType";


	/**
	 * 
	 */
	public static final int ERROR_BAR_FULL = 0;


	/**
	 * 
	 */
	public static final int ERROR_BAR_UPPER_ONLY = 1;


	/**
	 * 
	 */
	public static final int ERROR_BAR_LOWER_ONLY = 2;



	/**
	 * 
	 */
	public static final String SHOW_FULLY = "Bothsides";


	/**
	 * 
	 */
	public static final String SHOW_UPPER_ONLY = "Upside";


	/**
	 * 
	 */
	public static final String SHOW_LOWER_ONLY = "Downside";


	/**
	 * 
	 */
	protected int mErrorBarStyle = ERROR_BAR_FULL;



	/**
	 *
	 */
	public SGElementGroupErrorBar()
	{
		super();
	}


	/**
	 * 
	 */
	public boolean setColor( final Color color )
	{
		super.setColor( color );

		this.mHeadEdgeLineColor = color;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementArray[ii];
				el.setHeadEdgeLineColor(color);
			}
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean setColorList( final ArrayList cList )
	{
		super.setColorList( cList );

		Color color = (Color)cList.get(0);
		this.mHeadEdgeLineColor = color;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementArrow2D el = (SGDrawingElementArrow2D)mDrawingElementArray[ii];
				el.setHeadEdgeLineColor(color);
			}
		}
		
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public int getErrorBarStyle()
	{
		return this.mErrorBarStyle;
	}


	/**
	 * 
	 * @param style
	 * @return
	 */
	public boolean setErrorBarStyle( final int style )
	{
		this.mErrorBarStyle = style;
		return true;
	}


	
	/**
	 * 
	 * @return
	 */
	public String getTagName()
	{
		return TAG_NAME_ERROR_BAR;
	}


	/**
	 * 
	 */
	public boolean writeProperty( final Element el )
	{
		String cm = SGUtilityNumber.cm;
		String pt = SGUtilityNumber.pt;

		el.setAttribute( KEY_VISIBLE, Boolean.toString( this.mVisibleFlag ) );
		el.setAttribute( KEY_ERROR_BAR_STYLE, getErrorBarStyleName( this.mErrorBarStyle ) );
		el.setAttribute( KEY_LINE_WIDTH, Float.toString( this.mLineWidth ) + pt );
		el.setAttribute( KEY_HEAD_SIZE, Float.toString( this.mHeadSize*SGIConstants.CM_POINT_RATIO ) + cm );
		el.setAttribute( KEY_ERROR_BAR_HEAD_TYPE, SGDrawingElementSymbol.getSymbolTypeName( this.getHeadType() ) );
		el.setAttribute( KEY_COLOR_LIST, SGUtilityText.getColorListString( this.mColorList ) );
		return true;
	}


	
	/**
	 * 
	 * @param el
	 * @return
	 */
	public SGProperties readProperties( final Element el )
	{
		final String cm = SGUtilityNumber.cm;
		final String pt = SGUtilityNumber.pt;
		final float ratio = SGIConstants.CM_POINT_RATIO;

		String str = null;
		Number num = null;
		Color cl = null;
		Boolean b = null;
		ArrayList list = null;

		ErrorBarProperties p = new ErrorBarProperties();


		// visible
		str = el.getAttribute( KEY_VISIBLE );
		if( str.length()==0 )
		{
			return null;
		}
		b = SGUtilityText.getBoolean(str);
		if( b==null )
		{
			return null;
		}
		p.setVisible( b.booleanValue() );

		
		// color
		str = el.getAttribute( KEY_COLOR_LIST );
		if( str.length()==0 )
		{
			return null;
		}
		list = SGUtilityText.getColorList(str);
		if( list==null )
		{
			return null;
		}
		p.setColorList( list );


		// line width
		str = el.getAttribute( KEY_LINE_WIDTH );
		if( str.length()==0 )
		{
			return null;
		}
		num = SGUtilityText.getFloat(str,pt);
		if( num==null )
		{
			return null;
		}
		final float lineWidth = num.floatValue();
		p.setLineWidth( lineWidth );


		// head size
		str = el.getAttribute( KEY_HEAD_SIZE );
		if( str.length()==0 )
		{
			return null;
		}
		num = SGUtilityText.getFloat(str,cm);
		if( num==null )
		{
			return null;
		}
		p.setHeadSize( num.floatValue()/ratio );

		
		// style of error bars
		str = el.getAttribute( KEY_ERROR_BAR_STYLE );
		if( str.length()==0 )
		{
			return null;
		}
		num = getErrorBarStyleFromName( str );
		if( num==null )
		{
			return null;
		}
		final int style = num.intValue();
		p.setErrorBarStyle( style );


		// start head type
		str = el.getAttribute( KEY_ERROR_BAR_HEAD_TYPE );
		if( str.length()==0 )
		{
			return null;
		}
		final Integer type = getHeadTypeFromName(str);
		if( type==null )
		{
			return null;
		}
		int symbolType = type.intValue();

		switch( style )
		{
			case SGElementGroupErrorBar.ERROR_BAR_FULL :
			{
				p.setStartHeadType( symbolType );
				p.setEndHeadType( symbolType );
				break;
			}
				
			case SGElementGroupErrorBar.ERROR_BAR_UPPER_ONLY :
			{
				p.setStartHeadType( SGDrawingElementSymbol.SYMBOL_TYPE_VOID );
				p.setEndHeadType( symbolType );
				break;
			}

			case SGElementGroupErrorBar.ERROR_BAR_LOWER_ONLY :
			{
				p.setStartHeadType( symbolType );
				p.setEndHeadType( SGDrawingElementSymbol.SYMBOL_TYPE_VOID );
				break;
			}

			default :
			{

			}
		}
		
		
		// not from Element object
		p.setLineType( SGDrawingElementLine.LINE_TYPE_SOLID );
		p.setHeadLineColor( (Color)list.get(0) );
		p.setHeadLineWidth( lineWidth );

		return p;
	}

	

	/**
	 * 
	 */
	public static Integer getErrorBarStyleFromName( final String name )
	{
		if( name==null )
		{
			return null;
		}

		int style;
		if( name.equals(SHOW_FULLY) )
		{
			style = ERROR_BAR_FULL;
		}
		else if( name.equals(SHOW_UPPER_ONLY) )
		{
			style = ERROR_BAR_UPPER_ONLY;
		}
		else if( name.equals(SHOW_LOWER_ONLY) )
		{
			style = ERROR_BAR_LOWER_ONLY;
		}
		else
		{
			return null;
		}

		return new Integer(style);
	}



	/**
	 * 
	 */
	public static String getErrorBarStyleName( final int style )
	{

		String name = null;
		switch( style )
		{
			case ERROR_BAR_FULL :
			{
				name = SHOW_FULLY;
				break;
			}

			case ERROR_BAR_UPPER_ONLY :
			{
				name = SHOW_UPPER_ONLY;
				break;
			}

			case ERROR_BAR_LOWER_ONLY :
			{
				name = SHOW_LOWER_ONLY;
				break;
			}
			
			default :
			{
				
			}
		}

		return name;
	}




	/**
	 * 
	 */
	public int getHeadType()
	{

		int headType;
		switch( this.mErrorBarStyle )
		{
			case ERROR_BAR_FULL :
			{
				headType = this.mStartHeadType;
				break;
			}
			
			case ERROR_BAR_UPPER_ONLY :
			{
				headType = this.mEndHeadType;
				break;
			}

			case ERROR_BAR_LOWER_ONLY :
			{
				headType = this.mStartHeadType;
				break;
			}

			default :
			{
				throw new Error();
			}
		}

		return headType;
	}


	/**
	 * 
	 */
	public boolean setHeadType( int type )
	{
		switch( this.mErrorBarStyle )
		{
			case ERROR_BAR_FULL :
			{
				this.mStartHeadType = type;
				this.mEndHeadType = type;
				break;
			}
			
			case ERROR_BAR_UPPER_ONLY :
			{
				this.mStartHeadType = SGDrawingElementSymbol.SYMBOL_TYPE_VOID;
				this.mEndHeadType = type;
				break;
			}

			case ERROR_BAR_LOWER_ONLY :
			{
				this.mStartHeadType = type;
				this.mEndHeadType = SGDrawingElementSymbol.SYMBOL_TYPE_VOID;
				break;
			}

			default :
			{
				throw new Error();
			}
		}

		return true;
	}

	
	
	
	/**
	 * 
	 */
	public static Integer getHeadTypeFromName( final String name )
	{
		if( name==null )
		{
			return null;
		}
		
		int type;
		if( name.equals( SGElementGroupArrow.SYMBOL_NAME_CIRCLE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE;
		}
		else if( name.equals( SGElementGroupArrow.SYMBOL_NAME_TRANSVERSE_LINE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE;
		}
		else if( name.equals( SGElementGroupArrow.NO_SYMBOL ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_VOID;
		}
		else
		{
			return null;
		}

		return new Integer(type);
	}



	/**
	 * 
	 */
	public static String getHeadTypeName( final int type )
	{
		
		String name = null;
		switch( type )
		{
			case SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE :
			{
				name = SGElementGroupArrow.SYMBOL_NAME_CIRCLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE :
			{
				name = SGElementGroupArrow.SYMBOL_NAME_TRANSVERSE_LINE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_VOID :
			{
				name = SGElementGroupArrow.NO_SYMBOL;
				break;
			}

			default :
			{
				
			}
		}
		
		return name;
	}





	/**
	 * 
	 * @return
	 */
	public boolean setPropertiesOfDrawingElements()
	{
		for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
		{
			SGDrawingElementArrow2D arrow
				= (SGDrawingElementArrow2D)this.mDrawingElementArray[ii];
			arrow.setMagnification(mMagnification);
			arrow.setColorList( this.mColorList );
			arrow.setLineWidth( this.mLineWidth );
			arrow.setLineType( this.mLineType );
			arrow.setStartHeadType( this.mStartHeadType );
			arrow.setEndHeadType( this.mEndHeadType );
			arrow.setHeadSize( this.mHeadSize );
			arrow.setHeadOpenAngle( this.mHeadOpenAngle );
			arrow.setHeadCloseAngle( this.mHeadCloseAngle );
		}
		return true;
	}


	/**
	 * 
	 */
	protected String[] getPopupMenuCommandArray()
	{
		final String[] commandArray = {
			SYMBOL_NAME_CIRCLE,
			SYMBOL_NAME_TRANSVERSE_LINE,
			NO_SYMBOL,
			SHOW_FULLY,
			SHOW_UPPER_ONLY,
			SHOW_LOWER_ONLY
		};

		return commandArray;
	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		ErrorBarProperties p = new ErrorBarProperties();
		this.getProperties(p);
		return p;
	}



	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof ErrorBarProperties ) == false ) return false;

		super.getProperties(p);

		ErrorBarProperties ep = (ErrorBarProperties)p;
		ep.setErrorBarStyle( this.getErrorBarStyle() );

		return true;
	}



	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof ErrorBarProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		ErrorBarProperties ep = (ErrorBarProperties)p;
		Integer style = ep.getErrorBarStyle();
		if( style==null )
		{
			return false;
		}
		this.mErrorBarStyle = style.intValue();

		return true;
	}





	/**
	 * 
	 */
	public static class ErrorBarProperties extends ArrowProperties
	{

		public static final String[] keys =
		{
			KEY_ERROR_BAR_STYLE
		};


		/**
		 * 
		 *
		 */
		public ErrorBarProperties()
		{
			super();
			this.init();
		}


		/**
		 * 
		 * @return
		 */
		private boolean init()
		{
			this.setLineType( SGDrawingElementLine.LINE_TYPE_SOLID );
			this.setHeadOpenAngle( 0.0f );
			this.setHeadCloseAngle( 0.0f );

			return true;
		}



		/*
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof ErrorBarProperties ) == false )
			{
				return false;
			}

			boolean flag = super.equals(obj);
			if( !flag ) return false;

			ErrorBarProperties p = (ErrorBarProperties)obj;
			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}

			return true;
		}


		public Integer getErrorBarStyle()
		{
			final String value = this.getProperty(KEY_ERROR_BAR_STYLE);
			return SGUtilityText.getInteger(value);
		}

		public boolean setErrorBarStyle( final int style )
		{
			this.setProperty( KEY_ERROR_BAR_STYLE, new Integer(style).toString() );
			return true;
		}


		/**
		 * 
		 */
		public String toString()
		{
			String str = new String("[");
			str += this.getProperty(KEY_ERROR_BAR_STYLE);
			str += new String("]");

			return str;
		}


	}



}
