/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGSignificantDifferenceSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGSignificantDifferenceSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGSignificantDifferenceSymbolDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGSignificantDifferenceElement
extends SGFigureElement
implements SGISignificantDifferenceElement,
SGIStringConstants,
CaretListener,
ActionListener {
    private SGIAxisElement mAxisElement = null;
    private JTextField mEditField = null;
    private int mFocusedX = 0;
    private int mFocusedY = 0;
    private SigDiffSymbol mEditingSymbol = null;
    private SGSignificantDifferenceSymbolDialog mDialog = null;
    private final ArrayList mSignificantDifferentSymbolsList = new ArrayList();
    private SigDiffSymbol mPressedSymbol = null;
    private Point mPressedPoint = null;

    public SGSignificantDifferenceElement() {
        this.initEditField();
    }

    private boolean createSignificanceDialog() {
        SGSignificantDifferenceSymbolDialog sGSignificantDifferenceSymbolDialog;
        this.mDialog = sGSignificantDifferenceSymbolDialog = new SGSignificantDifferenceSymbolDialog(this.mDialogOwner, true);
        return true;
    }

    public boolean zoom(float f) {
        if (!this.terminateEditField()) {
            return false;
        }
        super.zoom(f);
        this.onZoomed(f);
        return true;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createSignificanceDialog();
        return true;
    }

    public boolean addSignificantDifferenceSymbol(SGAxis sGAxis, SGAxis sGAxis2, int n, int n2) {
        SigDiffSymbol sigDiffSymbol = new SigDiffSymbol();
        sigDiffSymbol.zoom(this.mMagnification);
        sigDiffSymbol.mXAxis = sGAxis;
        sigDiffSymbol.mYAxis = sGAxis2;
        sigDiffSymbol.setLocation(n, n2);
        sigDiffSymbol.createDrawingElement();
        sigDiffSymbol.setAxisValuesWithShape();
        this.mSignificantDifferentSymbolsList.add(sigDiffSymbol);
        this.setChanged(true);
        sigDiffSymbol.initPropertiesHistory();
        this.notifyToRoot();
        return true;
    }

    public boolean addSignificantDifferenceSymbol(int n, int n2) {
        if (!this.getGraphRect().contains(n, n2)) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        return this.addSignificantDifferenceSymbol(sGAxis, sGAxis2, n, n2);
    }

    public boolean moveFocusedObjects(boolean bl) {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
                this.moveSigDiffSymbolToFront(sigDiffSymbol);
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
                this.moveSigDiffSymbolToBack(sigDiffSymbol);
            }
        }
        return true;
    }

    private boolean moveSigDiffSymbolToFront(SigDiffSymbol sigDiffSymbol) {
        return this.moveObjectToFront(sigDiffSymbol, this.mSignificantDifferentSymbolsList);
    }

    private boolean moveSigDiffSymbolToBack(SigDiffSymbol sigDiffSymbol) {
        return this.moveObjectToBack(sigDiffSymbol, this.mSignificantDifferentSymbolsList);
    }

    private boolean hideSigDiffSymbol(SigDiffSymbol sigDiffSymbol) {
        this.hideObject(sigDiffSymbol);
        this.clearFocusedObjects();
        return true;
    }

    private boolean onZoomed(float f) {
        for (int i = 0; i < this.mSignificantDifferentSymbolsList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            sigDiffSymbol.zoom(f);
        }
        return true;
    }

    public void setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement)) {
            if (sGIFigureElement instanceof SGIAxisElement) {
                bl = this.synchronizeToAxisElement((SGIAxisElement)sGIFigureElement);
            } else if (!(sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement || sGIFigureElement instanceof SGIGridElement)) {
                bl = sGIFigureElement.synchronizeArgument(this);
            }
        }
        return bl;
    }

    private boolean synchronizeToAxisElement(SGIAxisElement sGIAxisElement) {
        ArrayList arrayList = this.getVisibleSigDiffSymbolList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            sigDiffSymbol.setShapeWithAxesValues();
        }
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    public SGProperties getProperties() {
        SigDiffElementProperties sigDiffElementProperties = new SigDiffElementProperties();
        if (!this.getProperties(sigDiffElementProperties)) {
            return null;
        }
        return sigDiffElementProperties;
    }

    public String getTagName() {
        return "SignificantDifferenceSymbols";
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("SignificantDifferenceSymbol");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            SigDiffSymbol sigDiffSymbol = new SigDiffSymbol();
            Element element2 = (Element)node;
            if (!sigDiffSymbol.readProperty(element2)) {
                return false;
            }
            sigDiffSymbol.initPropertiesHistory();
            this.mSignificantDifferentSymbolsList.add(sigDiffSymbol);
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mEditField)) {
            this.terminateEditField();
        }
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        if (!super.setGraphRect(f, f2, f3, f4)) {
            return false;
        }
        if (!this.terminateEditField()) {
            return false;
        }
        for (int i = 0; i < this.mSignificantDifferentSymbolsList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            sigDiffSymbol.setShapeWithAxesValues();
        }
        return true;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ArrayList arrayList = this.getVisibleSigDiffSymbolList();
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            Rectangle2D rectangle2D = sigDiffSymbol.getElementBounds();
            arrayList2.add(rectangle2D);
        }
        if (arrayList2.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList2);
        float f = this.mGraphRectY - (float)rectangle2D.getY();
        float f2 = -(this.mGraphRectY + this.mGraphRectHeight) + (float)(rectangle2D.getY() + rectangle2D.getHeight());
        float f3 = this.mGraphRectX - (float)rectangle2D.getX();
        float f4 = -(this.mGraphRectX + this.mGraphRectWidth) + (float)(rectangle2D.getX() + rectangle2D.getWidth());
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Object object;
        SigDiffSymbol sigDiffSymbol;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.getVisibleSigDiffSymbolList();
        for (n = 0; n < arrayList.size(); ++n) {
            sigDiffSymbol = (SigDiffSymbol)arrayList.get(n);
            sigDiffSymbol.drawSymbol(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < arrayList.size(); ++n) {
                sigDiffSymbol = (SigDiffSymbol)arrayList.get(n);
                object = sigDiffSymbol.getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsChildObject((ArrayList)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList arrayList2 = this.getFocusedObjectsList();
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (SigDiffSymbol)arrayList2.get(i);
                ArrayList arrayList3 = ((SigDiffSymbol)object).getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsFocusedObject(arrayList3, graphics2D);
            }
        }
    }

    private ArrayList getVisibleSigDiffSymbolList() {
        ArrayList<SigDiffSymbol> arrayList = new ArrayList<SigDiffSymbol>();
        for (int i = 0; i < this.mSignificantDifferentSymbolsList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)this.mSignificantDifferentSymbolsList.get(i);
            if (!sigDiffSymbol.isVisible()) continue;
            arrayList.add(sigDiffSymbol);
        }
        return arrayList;
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleSigDiffSymbolList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList2.get(i);
            if (!sGISelectable.isSelected()) continue;
            arrayList.add(sGISelectable);
        }
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)sGISelectable;
        sigDiffSymbol.setVisible(false);
        return true;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        Font font;
        Rectangle2D rectangle2D;
        double d;
        String string = this.mEditField.getText();
        if (this.mEditingSymbol != null && (d = (rectangle2D = (font = new Font(this.mEditingSymbol.getFontName(), this.mEditingSymbol.getFontStyle(), (int)(this.mEditingSymbol.getFontSize() * this.getMagnification()))).getStringBounds(string, new FontRenderContext(null, false, false))).getWidth()) > (double)this.mEditField.getWidth()) {
            this.mEditField.setSize((int)(rectangle2D.getWidth() + (double)(this.getMagnification() * this.mEditingSymbol.getFontSize())), this.mEditField.getHeight());
        }
    }

    public boolean onDrawingElement(int n, int n2) {
        ArrayList arrayList = this.getVisibleSigDiffSymbolList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            if (!sigDiffSymbol.contains(n, n2)) continue;
            if (sigDiffSymbol.isSelected()) {
                sigDiffSymbol.mMouseLocation = sigDiffSymbol.getMouseLocation(n, n2);
                this.setMouseCursor(sigDiffSymbol.getCursor(sigDiffSymbol.mMouseLocation));
                return true;
            }
            this.setMouseCursor(12);
            return true;
        }
        if (!this.isInsideGraphArea(n, n2)) {
            return false;
        }
        return false;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleSigDiffSymbolList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            if (!this.clickDrawingElements(sigDiffSymbol, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    private boolean clickDrawingElements(SigDiffSymbol sigDiffSymbol, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (sigDiffSymbol.contains(n, n2)) {
            if (sigDiffSymbol.getStringElement().contains(n, n2)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 1) {
                    if (sigDiffSymbol.isSelected()) {
                        this.mEditingSymbol = sigDiffSymbol;
                        this.showEditField(sigDiffSymbol);
                    } else {
                        this.updateFocusedObjectsList((SGISelectable)sigDiffSymbol, mouseEvent);
                    }
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                    sigDiffSymbol.getPopupMenu().show(this, n, n2);
                }
            } else {
                this.updateFocusedObjectsList((SGISelectable)sigDiffSymbol, mouseEvent);
                if (!(SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 1)) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 2) {
                        JDialog jDialog = sigDiffSymbol.getDialog();
                        jDialog.setVisible(true);
                    } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                        sigDiffSymbol.getPopupMenu().show(this, n, n2);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void translateSelectedObjects(int n, int n2) {
        if (!this.terminateEditField()) {
            return;
        }
        super.translateSelectedObjects(n, n2);
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        if (!this.terminateEditField()) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ArrayList arrayList = this.getVisibleSigDiffSymbolList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            if (!sigDiffSymbol.pressDrawingElements(mouseEvent)) continue;
            this.mPressedPoint = mouseEvent.getPoint();
            this.mPressedSymbol = sigDiffSymbol;
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 1) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(0);
            if (!sigDiffSymbol.drag(mouseEvent)) {
                return false;
            }
            sigDiffSymbol.createDrawingElement();
            if (!sigDiffSymbol.setAxisValuesWithShape()) {
                return false;
            }
            if (!sigDiffSymbol.setShapeWithAxesValues()) {
                return false;
            }
            this.mPressedPoint = mouseEvent.getPoint();
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            sigDiffSymbol.translate(n, n2);
            sigDiffSymbol.createDrawingElement();
            if (!sigDiffSymbol.setAxisValuesWithShape()) {
                return false;
            }
            if (sigDiffSymbol.setShapeWithAxesValues()) continue;
            return false;
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        return true;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            sigDiffSymbol.mTemporaryProperties = sigDiffSymbol.getProperties();
        }
        return true;
    }

    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            SGProperties sGProperties = sigDiffSymbol.mTemporaryProperties;
            SGProperties sGProperties2 = sigDiffSymbol.getProperties();
            if (sGProperties2.equals(sGProperties)) continue;
            sigDiffSymbol.setChanged(true);
        }
        return true;
    }

    public boolean clearFocusedObjects() {
        if (!super.clearFocusedObjects()) {
            return false;
        }
        return this.terminateEditField();
    }

    public String toString() {
        return "SGSignificantDifferenceElement";
    }

    private boolean initEditField() {
        this.mEditField = new JTextField(10);
        this.setLayout(null);
        this.add(this.mEditField);
        this.mEditField.setVisible(false);
        this.mEditField.addActionListener(this);
        this.mEditField.addCaretListener(this);
        return true;
    }

    private boolean showEditField(SigDiffSymbol sigDiffSymbol) {
        SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)sigDiffSymbol.getStringElement();
        Rectangle2D rectangle2D = sGDrawingElementString2DExtended.getElementBounds();
        float f = sigDiffSymbol.getMagnification() * sigDiffSymbol.getFontSize();
        JTextField jTextField = this.mEditField;
        int n = (int)(rectangle2D.getWidth() + (double)f);
        int n2 = (int)(rectangle2D.getHeight() + (double)(0.0f * f));
        Insets insets = jTextField.getInsets();
        int n3 = (int)(rectangle2D.getX() - (double)insets.left);
        int n4 = (int)rectangle2D.getY();
        Font font = new Font(sigDiffSymbol.getFontName(), sigDiffSymbol.getFontStyle(), (int)f);
        jTextField.setLocation(n3, n4);
        jTextField.setSize(n, n2);
        jTextField.setFont(font);
        jTextField.setForeground(sigDiffSymbol.getColor());
        jTextField.setText(sigDiffSymbol.getStringElement().getString());
        jTextField.setVisible(true);
        jTextField.requestFocus();
        jTextField.setCaretPosition(0);
        return true;
    }

    private boolean terminateEditField() {
        if (this.mEditField.isVisible()) {
            return this.commitEdit();
        }
        return true;
    }

    private boolean hideEditField() {
        this.mEditField.setText("");
        this.mEditField.setVisible(false);
        return true;
    }

    private boolean commitEdit() {
        if (this.mEditingSymbol == null) {
            return false;
        }
        String string = this.mEditingSymbol.mStringElement.getString();
        String string2 = this.mEditField.getText();
        if (SGUtilityText.isValidString(string2)) {
            this.mEditingSymbol.setText(string2);
            if (!string.equals(string2)) {
                this.mEditingSymbol.setChanged(true);
                this.notifyToRoot();
            }
            this.mEditingSymbol.createDrawingElement();
        }
        this.mEditingSymbol = null;
        this.hideEditField();
        this.repaint();
        return true;
    }

    private boolean setVisibleSigDiffSymbols(ArrayList arrayList) {
        return this.setVisibleDrawingElement(this.mSignificantDifferentSymbolsList, arrayList);
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffElementProperties)) {
            return false;
        }
        SigDiffElementProperties sigDiffElementProperties = (SigDiffElementProperties)sGProperties;
        sigDiffElementProperties.visibleSigDiffSymbolList = this.getVisibleSigDiffSymbolList();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffElementProperties)) {
            return false;
        }
        SigDiffElementProperties sigDiffElementProperties = (SigDiffElementProperties)sGProperties;
        boolean bl = this.setVisibleSigDiffSymbols(sigDiffElementProperties.visibleSigDiffSymbolList);
        return bl;
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = this.getVisibleSigDiffSymbolList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            Element element2 = sigDiffSymbol.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean addPropertiesHistory(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffElementProperties)) {
            return false;
        }
        boolean bl = super.addPropertiesHistory(sGProperties);
        return bl;
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.notifyChange();
        this.clearFocusedObjects();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.notifyChange();
        this.clearFocusedObjects();
        return true;
    }

    public boolean updateHistory() {
        return this.updateHistory_(this.getVisibleSigDiffSymbolList());
    }

    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        ArrayList arrayList = this.getVisibleSigDiffSymbolList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            if (!sGIUndoable.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        ArrayList arrayList = this.duplicateObjects();
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            sigDiffSymbol.setShapeWithAxesValues();
            sigDiffSymbol.translate(n, n2);
            sigDiffSymbol.setSelected(true);
            this.mSignificantDifferentSymbolsList.add(sigDiffSymbol);
            sigDiffSymbol.initPropertiesHistory();
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public boolean paste(ArrayList arrayList) {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SigDiffSymbol)) continue;
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)e;
            SGProperties sGProperties = sigDiffSymbol.getProperties();
            SigDiffSymbol sigDiffSymbol2 = new SigDiffSymbol();
            sigDiffSymbol2.setProperties(sGProperties);
            sigDiffSymbol2.mXAxis = this.mAxisElement.getAxisInCube(sigDiffSymbol.mTempXAxis);
            sigDiffSymbol2.mYAxis = this.mAxisElement.getAxisInCube(sigDiffSymbol.mTempYAxis);
            sigDiffSymbol2.setShapeWithAxesValues();
            this.mSignificantDifferentSymbolsList.add(sigDiffSymbol2);
            sigDiffSymbol2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        this.repaint();
        return true;
    }

    public static class SigDiffPropertiesWithAxes
    extends SGSignificantDifferenceSymbol.SigDiffProperties {
        double leftXValue;
        double rightXValue;
        double leftYValue;
        double rightYValue;
        double horizontalYValue;
        SGAxis xAxis;
        SGAxis yAxis;

        public boolean equals(Object object) {
            if (!(object instanceof SigDiffPropertiesWithAxes)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = (SigDiffPropertiesWithAxes)object;
            if (sigDiffPropertiesWithAxes.leftXValue != this.leftXValue) {
                return false;
            }
            if (sigDiffPropertiesWithAxes.rightXValue != this.rightXValue) {
                return false;
            }
            if (sigDiffPropertiesWithAxes.leftYValue != this.leftYValue) {
                return false;
            }
            if (sigDiffPropertiesWithAxes.rightYValue != this.rightYValue) {
                return false;
            }
            if (sigDiffPropertiesWithAxes.horizontalYValue != this.horizontalYValue) {
                return false;
            }
            if (!sigDiffPropertiesWithAxes.xAxis.equals(this.xAxis)) {
                return false;
            }
            return sigDiffPropertiesWithAxes.yAxis.equals(this.yAxis);
        }
    }

    class SigDiffSymbol
    extends SGSignificantDifferenceSymbol2D
    implements ActionListener,
    WindowListener,
    SGIUndoable,
    SGISelectable,
    SGIMovable,
    SGICopiable {
        private SigDiffSymbol mTempSymbol = null;
        private boolean mSelectedFlag = false;
        private SGAxis mXAxis = null;
        private SGAxis mYAxis = null;
        private double mXValue1;
        private double mXValue2;
        private double mHorizontalYValue;
        private double mYValue1;
        private double mYValue2;
        private Point mPressedSymbolOrigin = null;
        private SGProperties mTemporaryProperties = null;
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private int mTempXAxis = -1;
        private int mTempYAxis = -1;
        private boolean mFlippingHorizontalFlag;
        private int mMouseLocation;
        private ArrayList mSigDiffSymbolPropertyHistoryList = new ArrayList();
        private int mSigDiffStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();
        private boolean mChangedFlag = false;

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        private SigDiffSymbol() {
            this.init();
        }

        public Object copy() {
            SigDiffSymbol sigDiffSymbol = new SigDiffSymbol();
            sigDiffSymbol.setMagnification(this.mMagnification);
            sigDiffSymbol.setProperties(this.getProperties());
            sigDiffSymbol.setLocation(this.getX(), this.getY());
            sigDiffSymbol.mTempXAxis = SGSignificantDifferenceElement.this.mAxisElement.getConfigurationInCube(this.mXAxis);
            sigDiffSymbol.mTempYAxis = SGSignificantDifferenceElement.this.mAxisElement.getConfigurationInCube(this.mYAxis);
            return sigDiffSymbol;
        }

        private SigDiffSymbol(float f, float f2, float f3, float f4, float f5) {
            super(f, f2, f3, f4, f5);
            this.init();
        }

        private boolean createPopupMenu() {
            JPopupMenu jPopupMenu = this.mPopupMenu;
            jPopupMenu.setBounds(0, 0, 100, 100);
            jPopupMenu.add(new JLabel("  -- Significant Difference --"));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Move to Front");
            SGUtility.addItem(jPopupMenu, this, "Move to Back");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Cut");
            SGUtility.addItem(jPopupMenu, this, "Copy");
            SGUtility.addItem(jPopupMenu, this, "Paste");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Delete");
            SGUtility.addItem(jPopupMenu, this, "Duplicate");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return true;
        }

        private boolean init() {
            this.setWidth(28.346458f);
            this.setPerpendicularHeight1(28.346458f);
            this.setPerpendicularHeight2(28.346458f);
            int n = SGUtilityText.getFontStyle("Plain");
            if (n == -1) {
                return false;
            }
            this.setFont("Serif", n, 24.0f);
            this.setLineWidth(1.0f);
            this.setColor(SGDefaultValues.SIGDIFF_SYMBOL_COLOR);
            this.setSpace(0.0f);
            this.createPopupMenu();
            return true;
        }

        private JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        private JDialog getDialog() {
            SGSignificantDifferenceElement.this.mDialog.setActionListener(this);
            SGSignificantDifferenceElement.this.mDialog.addWindowListener(this);
            SGSignificantDifferenceElement.this.mDialog.setLocation(SGSignificantDifferenceElement.this.mDialogOwner.getLocation());
            SGSignificantDifferenceElement.this.mDialog.setColorButtonBorder(true);
            this.setDialogProperty();
            this.mTemporaryProperties = this.getProperties();
            SGSignificantDifferenceElement.this.mEditField.setVisible(false);
            return SGSignificantDifferenceElement.this.mDialog;
        }

        public String getTagName() {
            return "SignificantDifferenceSymbol";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            String string = "cm";
            String string2 = "pt";
            element.setAttribute("LeftX", Double.toString(this.getLeftXValue()));
            element.setAttribute("LeftY", Double.toString(this.getLeftYValue()));
            element.setAttribute("RightX", Double.toString(this.getRightXValue()));
            element.setAttribute("RightY", Double.toString(this.getRightYValue()));
            element.setAttribute("HorizontalY", Double.toString(this.getHorizontalYValue()));
            element.setAttribute("XAxisPosition", SGSignificantDifferenceElement.this.mAxisElement.getAxisLocation(this.mXAxis));
            element.setAttribute("YAxisPosition", SGSignificantDifferenceElement.this.mAxisElement.getAxisLocation(this.mYAxis));
            element.setAttribute("Text", this.getText());
            element.setAttribute("FontName", this.getFontName());
            element.setAttribute("FontSize", Float.toString(this.getFontSize()) + string2);
            element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.getFontStyle()));
            element.setAttribute("Color", SGUtilityText.getColorListString(this.getColorList()));
            element.setAttribute("LineVisible", Boolean.toString(this.isLineVisible()));
            element.setAttribute("LineWidth", Float.toString(this.getLineWidth()) + string2);
            element.setAttribute("Space", Float.toString(this.getSpace() * 0.035277776f) + string);
            return true;
        }

        public boolean readProperty(Element element) {
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = this.readProperty_(element);
            if (sigDiffPropertiesWithAxes == null) {
                return false;
            }
            return this.setProperties(sigDiffPropertiesWithAxes);
        }

        private SigDiffPropertiesWithAxes readProperty_(Element element) {
            String string = SGIConstants.degree;
            String string2 = null;
            Number number = null;
            Object var8_5 = null;
            Boolean bl = null;
            ArrayList arrayList = null;
            string2 = element.getAttribute("LeftX");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return null;
            }
            double d = number.doubleValue();
            string2 = element.getAttribute("LeftY");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return null;
            }
            double d2 = number.doubleValue();
            string2 = element.getAttribute("RightX");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return null;
            }
            double d3 = number.doubleValue();
            string2 = element.getAttribute("RightY");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return null;
            }
            double d4 = number.doubleValue();
            string2 = element.getAttribute("HorizontalY");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return null;
            }
            double d5 = number.doubleValue();
            string2 = element.getAttribute("XAxisPosition");
            if (string2.length() == 0) {
                return null;
            }
            int n = SGSignificantDifferenceElement.this.mAxisElement.getConfigurationInCube(string2);
            SGAxis sGAxis = SGSignificantDifferenceElement.this.mAxisElement.getAxisInCube(n);
            if (sGAxis == null) {
                return null;
            }
            string2 = element.getAttribute("YAxisPosition");
            if (string2.length() == 0) {
                return null;
            }
            int n2 = SGSignificantDifferenceElement.this.mAxisElement.getConfigurationInCube(string2);
            SGAxis sGAxis2 = SGSignificantDifferenceElement.this.mAxisElement.getAxisInCube(n2);
            if (sGAxis2 == null) {
                return null;
            }
            string2 = element.getAttribute("Text");
            if (string2.length() == 0) {
                return null;
            }
            String string3 = string2;
            string2 = element.getAttribute("FontName");
            if (string2.length() == 0) {
                return null;
            }
            String string4 = string2;
            string2 = element.getAttribute("FontSize");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string2, "pt");
            if (number == null) {
                return null;
            }
            float f = number.floatValue();
            string2 = element.getAttribute("FontStyle");
            if (string2.length() == 0) {
                return null;
            }
            int n3 = SGUtilityText.getFontStyle(string2);
            if (n3 == -1) {
                return null;
            }
            string2 = element.getAttribute("Color");
            if (string2.length() == 0) {
                return null;
            }
            arrayList = SGUtilityText.getColorList(string2);
            if (arrayList == null) {
                return null;
            }
            ArrayList arrayList2 = arrayList;
            string2 = element.getAttribute("LineVisible");
            if (string2.length() == 0) {
                return null;
            }
            bl = SGUtilityText.getBoolean(string2);
            if (bl == null) {
                return null;
            }
            boolean bl2 = bl;
            string2 = element.getAttribute("LineWidth");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string2, "pt");
            if (number == null) {
                return null;
            }
            float f2 = number.floatValue();
            string2 = element.getAttribute("Space");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string2, "cm");
            if (number == null) {
                return null;
            }
            float f3 = number.floatValue() / 0.035277776f;
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = new SigDiffPropertiesWithAxes();
            sigDiffPropertiesWithAxes.leftXValue = d;
            sigDiffPropertiesWithAxes.leftYValue = d2;
            sigDiffPropertiesWithAxes.rightXValue = d3;
            sigDiffPropertiesWithAxes.rightYValue = d4;
            sigDiffPropertiesWithAxes.horizontalYValue = d5;
            sigDiffPropertiesWithAxes.xAxis = sGAxis;
            sigDiffPropertiesWithAxes.yAxis = sGAxis2;
            sigDiffPropertiesWithAxes.text = string3;
            sigDiffPropertiesWithAxes.fontName = string4;
            sigDiffPropertiesWithAxes.fontSize = f;
            sigDiffPropertiesWithAxes.fontStyle = n3;
            sigDiffPropertiesWithAxes.lineVisible = bl2;
            sigDiffPropertiesWithAxes.lineWidth = f2;
            sigDiffPropertiesWithAxes.space = f3;
            sigDiffPropertiesWithAxes.setColorList(arrayList2);
            sigDiffPropertiesWithAxes.setVisible(true);
            return sigDiffPropertiesWithAxes;
        }

        public SGProperties getProperties() {
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = new SigDiffPropertiesWithAxes();
            if (!this.getProperties(sigDiffPropertiesWithAxes)) {
                return null;
            }
            return sigDiffPropertiesWithAxes;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SigDiffPropertiesWithAxes)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = (SigDiffPropertiesWithAxes)sGProperties;
            sigDiffPropertiesWithAxes.leftXValue = this.getLeftXValue();
            sigDiffPropertiesWithAxes.leftYValue = this.getLeftYValue();
            sigDiffPropertiesWithAxes.rightXValue = this.getRightXValue();
            sigDiffPropertiesWithAxes.rightYValue = this.getRightYValue();
            sigDiffPropertiesWithAxes.horizontalYValue = this.getHorizontalYValue();
            sigDiffPropertiesWithAxes.xAxis = this.mXAxis;
            sigDiffPropertiesWithAxes.yAxis = this.mYAxis;
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SigDiffPropertiesWithAxes)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = (SigDiffPropertiesWithAxes)sGProperties;
            this.setLeftXValue(sigDiffPropertiesWithAxes.leftXValue);
            this.setLeftYValue(sigDiffPropertiesWithAxes.leftYValue);
            this.setRightXValue(sigDiffPropertiesWithAxes.rightXValue);
            this.setRightYValue(sigDiffPropertiesWithAxes.rightYValue);
            this.setHorizontalYValue(sigDiffPropertiesWithAxes.horizontalYValue);
            this.mXAxis = sigDiffPropertiesWithAxes.xAxis;
            this.mYAxis = sigDiffPropertiesWithAxes.yAxis;
            return true;
        }

        private SigDiffPropertiesWithAxes getPropertiesFromDialog() {
            SGSignificantDifferenceSymbolDialog sGSignificantDifferenceSymbolDialog = SGSignificantDifferenceElement.this.mDialog;
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = sGSignificantDifferenceSymbolDialog.getProperties();
            if (sigDiffPropertiesWithAxes == null) {
                return null;
            }
            String string = sGSignificantDifferenceSymbolDialog.getXAxisLocation();
            SGAxis sGAxis = SGSignificantDifferenceElement.this.mAxisElement.getAxis(string);
            String string2 = sGSignificantDifferenceSymbolDialog.getYAxisLocation();
            SGAxis sGAxis2 = SGSignificantDifferenceElement.this.mAxisElement.getAxis(string2);
            sigDiffPropertiesWithAxes.xAxis = sGAxis;
            sigDiffPropertiesWithAxes.yAxis = sGAxis2;
            sigDiffPropertiesWithAxes.setVisible(true);
            sigDiffPropertiesWithAxes.text = this.getText();
            return sigDiffPropertiesWithAxes;
        }

        private boolean setDialogProperty() {
            SGSignificantDifferenceSymbolDialog sGSignificantDifferenceSymbolDialog = SGSignificantDifferenceElement.this.mDialog;
            this.setDialogPropertyOfAxis();
            sGSignificantDifferenceSymbolDialog.setLeftXValue(this.getLeftXValue());
            sGSignificantDifferenceSymbolDialog.setLeftYValue(this.getLeftYValue());
            sGSignificantDifferenceSymbolDialog.setRightXValue(this.getRightXValue());
            sGSignificantDifferenceSymbolDialog.setRightYValue(this.getRightYValue());
            sGSignificantDifferenceSymbolDialog.setHorizontalYValue(this.getHorizontalYValue());
            sGSignificantDifferenceSymbolDialog.setSpace(this.mSpace * 0.035277776f);
            sGSignificantDifferenceSymbolDialog.setFontSize(this.getFontSize());
            sGSignificantDifferenceSymbolDialog.setFontName(this.getFontName());
            sGSignificantDifferenceSymbolDialog.setFontStyle(this.getFontStyle());
            sGSignificantDifferenceSymbolDialog.setLineVisible(this.isLineVisible());
            sGSignificantDifferenceSymbolDialog.setLineWidth(this.getLineWidth());
            sGSignificantDifferenceSymbolDialog.setColorList(this.getColorList());
            return true;
        }

        private boolean setDialogPropertyOfAxis() {
            int n;
            int n2;
            SGSignificantDifferenceSymbolDialog sGSignificantDifferenceSymbolDialog = SGSignificantDifferenceElement.this.mDialog;
            boolean bl = sGSignificantDifferenceSymbolDialog.setAxisRadioButton(n2 = SGSignificantDifferenceElement.this.mAxisElement.getConfigurationInPlane(this.mXAxis), n = SGSignificantDifferenceElement.this.mAxisElement.getConfigurationInPlane(this.mYAxis));
            return bl;
        }

        public boolean setPropertyWithDialog() {
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = this.getPropertiesFromDialog();
            if (sigDiffPropertiesWithAxes == null) {
                return false;
            }
            if (!this.setProperties(sigDiffPropertiesWithAxes)) {
                return false;
            }
            return this.setShapeWithAxesValues();
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object.equals(SGSignificantDifferenceElement.this.mDialog)) {
                this.onCanceled();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (string.equals("Property")) {
                this.getDialog().setVisible(true);
                return;
            }
            if (string.equals("Copy") | string.equals("Cut") | string.equals("Paste") | string.equals("Delete") | string.equals("Duplicate") | string.equals("Move to Front") | string.equals("Move to Back")) {
                SGSignificantDifferenceElement.this.notifyToListener(string);
            }
            if (string.equals("OK") || SGSignificantDifferenceElement.this.mDialog.getActiveComponentList().contains(object) ? !this.onOK() : (string.equals("Cancel") ? !this.onCanceled() : string.equals("Preview") && !this.onPreviewed())) {
                return;
            }
            SGSignificantDifferenceElement.this.repaint();
        }

        private boolean onOK() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mChangedFlag = true;
            }
            this.setShapeWithAxesValues();
            SGSignificantDifferenceElement.this.notifyChange();
            this.notifyToRoot();
            this.mTemporaryProperties = null;
            SGSignificantDifferenceElement.this.mDialog.setVisible(false);
            SGSignificantDifferenceElement.this.mDialog.removeActionListener();
            SGSignificantDifferenceElement.this.mDialog.removeWindowListener(this);
            return true;
        }

        private boolean onCanceled() {
            boolean bl = this.recover();
            if (!bl) {
                return false;
            }
            this.setShapeWithAxesValues();
            SGSignificantDifferenceElement.this.notifyChange();
            this.mTemporaryProperties = null;
            SGSignificantDifferenceElement.this.mDialog.setVisible(false);
            SGSignificantDifferenceElement.this.mDialog.removeActionListener();
            SGSignificantDifferenceElement.this.mDialog.removeWindowListener(this);
            return true;
        }

        private boolean onPreviewed() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            this.setShapeWithAxesValues();
            SGSignificantDifferenceElement.this.notifyChange();
            return true;
        }

        private boolean recover() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            return true;
        }

        public float getX() {
            return this.mMagnification * this.mX + SGSignificantDifferenceElement.this.mGraphRectX;
        }

        public float getY() {
            return this.mMagnification * this.mY + SGSignificantDifferenceElement.this.mGraphRectY;
        }

        public boolean setX(float f) {
            this.mX = (f - SGSignificantDifferenceElement.this.mGraphRectX) / this.mMagnification;
            return true;
        }

        public boolean setY(float f) {
            this.mY = (f - SGSignificantDifferenceElement.this.mGraphRectY) / this.mMagnification;
            return true;
        }

        public void translate(int n, int n2) {
            this.setLocation(this.getX() + (float)n, this.getY() + (float)n2);
            this.createDrawingElement();
            this.setAxisValuesWithShape();
            this.setShapeWithAxesValues();
        }

        public double getLeftXValue() {
            if (!this.isFlippingHorizontal()) {
                return this.mXValue1;
            }
            return this.mXValue2;
        }

        public double getLeftYValue() {
            if (!this.isFlippingHorizontal()) {
                return this.mYValue1;
            }
            return this.mYValue2;
        }

        public double getRightXValue() {
            if (!this.isFlippingHorizontal()) {
                return this.mXValue2;
            }
            return this.mXValue1;
        }

        public double getRightYValue() {
            if (!this.isFlippingHorizontal()) {
                return this.mYValue2;
            }
            return this.mYValue1;
        }

        public double getHorizontalYValue() {
            return this.mHorizontalYValue;
        }

        public void setLeftXValue(double d) {
            if (!this.isFlippingHorizontal()) {
                this.mXValue1 = d;
            } else {
                this.mXValue2 = d;
            }
        }

        public void setLeftYValue(double d) {
            if (!this.isFlippingHorizontal()) {
                this.mYValue1 = d;
            } else {
                this.mYValue2 = d;
            }
        }

        public void setRightXValue(double d) {
            if (!this.isFlippingHorizontal()) {
                this.mXValue2 = d;
            } else {
                this.mXValue1 = d;
            }
        }

        public void setRightYValue(double d) {
            if (!this.isFlippingHorizontal()) {
                this.mYValue2 = d;
            } else {
                this.mYValue1 = d;
            }
        }

        public void setHorizontalYValue(double d) {
            this.mHorizontalYValue = d;
        }

        private boolean pressDrawingElements(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (this.contains(n2, n = mouseEvent.getY()) || this.mStringElement.contains(n2, n)) {
                this.mTempSymbol = new SigDiffSymbol();
                this.mTempSymbol.setMagnification(this.mMagnification);
                this.mTempSymbol.setLocation(this.getX(), this.getY());
                this.mTempSymbol.setSize(this.getWidth(), this.getPerpendicularHeight1(), this.getPerpendicularHeight2());
                this.mFlippingHorizontalFlag = this.isFlippingHorizontal();
                this.mMouseLocation = this.getMouseLocation(n2, n);
                Cursor cursor = null;
                if (this.mMouseLocation == 0 || this.mMouseLocation == 8) {
                    cursor = Cursor.getPredefinedCursor(13);
                } else {
                    this.getCursor(this.mMouseLocation);
                }
                SGSignificantDifferenceElement.this.setMouseCursor(cursor);
                return true;
            }
            return false;
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            if (this.isLineVisible()) {
                arrayList.add(this.getLeftTerm());
                arrayList.add(this.getLeftMiddle());
                arrayList.add(this.getLeftJoint());
                arrayList.add(this.getHorizontalMiddle());
                arrayList.add(this.getRightJoint());
                arrayList.add(this.getRightMiddle());
                arrayList.add(this.getRightTerm());
            }
            Rectangle2D rectangle2D = this.mStringElement.getElementBounds();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            Point2D.Float float_ = new Point2D.Float(f, f2);
            Point2D.Float float_2 = new Point2D.Float(f + f3, f2);
            Point2D.Float float_3 = new Point2D.Float(f, f2 + f4);
            Point2D.Float float_4 = new Point2D.Float(f + f3, f2 + f4);
            arrayList.add(float_);
            arrayList.add(float_2);
            arrayList.add(float_3);
            arrayList.add(float_4);
            return arrayList;
        }

        private boolean isInside(Point2D point2D, int n, int n2, int n3) {
            return Math.abs(point2D.getX() - (double)n2) < (double)n && Math.abs(point2D.getY() - (double)n3) < (double)n;
        }

        private int getMouseLocation(int n, int n2) {
            Point2D point2D = this.getHorizontalMiddle();
            Point2D point2D2 = this.getLeftMiddle();
            Point2D point2D3 = this.getRightMiddle();
            Point2D point2D4 = this.getLeftJoint();
            Point2D point2D5 = this.getRightJoint();
            Point2D point2D6 = this.getLeftTerm();
            Point2D point2D7 = this.getRightTerm();
            int n3 = -1;
            if (this.isLineVisible()) {
                n3 = this.isInside(point2D, 7, n, n2) ? 1 : (this.isInside(point2D4, 7, n, n2) ? 5 : (this.isInside(point2D5, 7, n, n2) ? 7 : (this.isInside(point2D6, 7, n, n2) ? 4 : (this.isInside(point2D2, 7, n, n2) ? 2 : (this.isInside(point2D7, 7, n, n2) ? 6 : (this.isInside(point2D3, 7, n, n2) ? 3 : 0))))));
            }
            if (this.mStringElement.contains(n, n2)) {
                n3 = 8;
            }
            return n3;
        }

        private Cursor getCursor(int n) {
            Cursor cursor = null;
            switch (n) {
                case 1: {
                    if (!this.isFlippingVertical()) {
                        cursor = new Cursor(8);
                        break;
                    }
                    cursor = new Cursor(9);
                    break;
                }
                case 2: {
                    cursor = new Cursor(10);
                    break;
                }
                case 3: {
                    cursor = new Cursor(11);
                    break;
                }
                case 4: {
                    if (!this.isFlippingVerticalLeft()) {
                        cursor = new Cursor(4);
                        break;
                    }
                    cursor = new Cursor(6);
                    break;
                }
                case 5: {
                    if (!this.isFlippingVerticalLeft()) {
                        cursor = new Cursor(6);
                        break;
                    }
                    cursor = new Cursor(4);
                    break;
                }
                case 6: {
                    if (!this.isFlippingVerticalRight()) {
                        cursor = new Cursor(5);
                        break;
                    }
                    cursor = new Cursor(7);
                    break;
                }
                case 7: {
                    if (!this.isFlippingVerticalRight()) {
                        cursor = new Cursor(7);
                        break;
                    }
                    cursor = new Cursor(5);
                    break;
                }
                case 8: {
                    cursor = new Cursor(12);
                    break;
                }
                default: {
                    cursor = new Cursor(12);
                }
            }
            return cursor;
        }

        private boolean drag(MouseEvent mouseEvent) {
            if (SGSignificantDifferenceElement.this.mPressedPoint == null) {
                return false;
            }
            if (this.mMouseLocation == 0 || this.mMouseLocation == 8) {
                boolean bl = this.dragOtherPoint(mouseEvent);
                return bl;
            }
            SigDiffSymbol sigDiffSymbol = this.mTempSymbol;
            float f = sigDiffSymbol.getX();
            float f2 = sigDiffSymbol.getY();
            float f3 = sigDiffSymbol.getWidth();
            float f4 = sigDiffSymbol.getPerpendicularHeight1();
            float f5 = sigDiffSymbol.getPerpendicularHeight2();
            int n = mouseEvent.getX() - ((SGSignificantDifferenceElement)SGSignificantDifferenceElement.this).mPressedPoint.x;
            int n2 = mouseEvent.getY() - ((SGSignificantDifferenceElement)SGSignificantDifferenceElement.this).mPressedPoint.y;
            float f6 = f3;
            float f7 = f4;
            float f8 = f5;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            float f12 = f;
            float f13 = f2;
            float f14 = f3;
            float f15 = f4;
            float f16 = f5;
            int n3 = this.mMouseLocation;
            boolean bl = this.mFlippingHorizontalFlag;
            if (n3 == 1) {
                f10 = f7 - (float)n2;
                f11 = f8 - (float)n2;
                f13 = f2 + f7 - f10;
                f15 = f10;
                f16 = f11;
            } else if (n3 == 2 && !bl || n3 == 3 && bl) {
                f9 = f6 - (float)n;
                f12 = f + f6 - f9;
                f14 = f9;
            } else if (n3 == 3 && !bl || n3 == 2 && bl) {
                f14 = f9 = f6 + (float)n;
            } else if (n3 == 5 && !bl || n3 == 7 && bl) {
                f10 = f7 - (float)n2;
                f11 = f8 - (float)n2;
                f9 = f6 - (float)n;
                f12 = f + f6 - f9;
                f13 = f2 + f7 - f10;
                f14 = f9;
                f15 = f10;
                f16 = f11;
            } else if (n3 == 7 && !bl || n3 == 5 && bl) {
                f9 = f6 + (float)n;
                f10 = f7 - (float)n2;
                f11 = f8 - (float)n2;
                f13 = f2 + f8 - f11;
                f14 = f9;
                f15 = f10;
                f16 = f11;
            } else if (n3 == 4 && !bl || n3 == 6 && bl) {
                f9 = f6 - (float)n;
                f10 = f7 + (float)n2;
                f12 = f + f6 - f9;
                f14 = f9;
                f15 = f10;
            } else if (n3 == 6 && !bl || n3 == 4 && bl) {
                f9 = f6 + (float)n;
                f11 = f8 + (float)n2;
                f14 = f9;
                f16 = f11;
            }
            SGSignificantDifferenceElement.this.mPressedPoint.setLocation(SGSignificantDifferenceElement.this.mPressedPoint.getX() + (double)n, SGSignificantDifferenceElement.this.mPressedPoint.getY() + (double)n2);
            this.setLocation(f12, f13);
            this.setSize(f14, f15, f16);
            this.createDrawingElement();
            sigDiffSymbol.setLocation(f12, f13);
            sigDiffSymbol.setSize(f14, f15, f16);
            if (n3 == 4 | n3 == 5 | n3 == 6 | n3 == 7) {
                int n4 = this.getMouseLocation(mouseEvent.getX(), mouseEvent.getY());
                SGSignificantDifferenceElement.this.setMouseCursor(this.getCursor(n4));
            }
            return true;
        }

        private boolean dragOtherPoint(MouseEvent mouseEvent) {
            if (SGSignificantDifferenceElement.this.mPressedPoint != null) {
                int n = mouseEvent.getX() - ((SGSignificantDifferenceElement)SGSignificantDifferenceElement.this).mPressedPoint.x;
                int n2 = mouseEvent.getY() - ((SGSignificantDifferenceElement)SGSignificantDifferenceElement.this).mPressedPoint.y;
                this.translate(n, n2);
                SGSignificantDifferenceElement.this.mPressedPoint = mouseEvent.getPoint();
            }
            return true;
        }

        private boolean setShapeWithAxesValues() {
            float f = SGSignificantDifferenceElement.this.calcLocation(this.mXValue1, this.mXAxis, true);
            float f2 = SGSignificantDifferenceElement.this.calcLocation(this.mXValue2, this.mXAxis, true);
            float f3 = SGSignificantDifferenceElement.this.calcLocation(this.mHorizontalYValue, this.mYAxis, false);
            float f4 = SGSignificantDifferenceElement.this.calcLocation(this.mYValue1, this.mYAxis, false);
            float f5 = SGSignificantDifferenceElement.this.calcLocation(this.mYValue2, this.mYAxis, false);
            this.setNodePointLocation(f, f4, f2, f5, f3);
            this.createDrawingElement();
            return true;
        }

        private boolean setAxisValuesWithShape() {
            double d = SGSignificantDifferenceElement.this.calcValue(this.getX1(), this.mXAxis, true);
            double d2 = SGSignificantDifferenceElement.this.calcValue(this.getY1(), this.mYAxis, false);
            double d3 = SGSignificantDifferenceElement.this.calcValue(this.getX2(), this.mXAxis, true);
            double d4 = SGSignificantDifferenceElement.this.calcValue(this.getY2(), this.mYAxis, false);
            double d5 = SGSignificantDifferenceElement.this.calcValue(this.getY(), this.mYAxis, false);
            this.mXValue1 = SGSignificantDifferenceElement.this.getNumberInRangeOrder(d, this.mXAxis);
            this.mYValue1 = SGSignificantDifferenceElement.this.getNumberInRangeOrder(d2, this.mYAxis);
            this.mXValue2 = SGSignificantDifferenceElement.this.getNumberInRangeOrder(d3, this.mXAxis);
            this.mYValue2 = SGSignificantDifferenceElement.this.getNumberInRangeOrder(d4, this.mYAxis);
            this.mHorizontalYValue = SGSignificantDifferenceElement.this.getNumberInRangeOrder(d5, this.mYAxis);
            return true;
        }

        public boolean initPropertiesHistory() {
            this.addSigDiffSymbolPropertyHistory(this.getProperties());
            return true;
        }

        private boolean addSigDiffSymbolPropertyHistory(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGSignificantDifferenceSymbol.SigDiffProperties)) {
                return false;
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mSigDiffStateCounter; ++i) {
                arrayList.add(this.mSigDiffSymbolPropertyHistoryList.get(i));
            }
            arrayList.add(sGProperties);
            this.mSigDiffSymbolPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mSigDiffStateCounter;
            SGSignificantDifferenceSymbol.SigDiffProperties sigDiffProperties = (SGSignificantDifferenceSymbol.SigDiffProperties)this.mSigDiffSymbolPropertyHistoryList.get(this.mSigDiffStateCounter);
            this.setProperties(sigDiffProperties);
            if (!this.setShapeWithAxesValues()) {
                return false;
            }
            this.createDrawingElement();
            return true;
        }

        public boolean redo() {
            ++this.mSigDiffStateCounter;
            SGSignificantDifferenceSymbol.SigDiffProperties sigDiffProperties = (SGSignificantDifferenceSymbol.SigDiffProperties)this.mSigDiffSymbolPropertyHistoryList.get(this.mSigDiffStateCounter);
            this.setProperties(sigDiffProperties);
            if (!this.setShapeWithAxesValues()) {
                return false;
            }
            this.createDrawingElement();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            if (this.isChanged()) {
                this.updateThisObjectHistory();
                this.setChanged(false);
                this.updateObjectHistory(this);
            }
            return true;
        }

        public boolean updateThisObjectHistory() {
            ++this.mSigDiffStateCounter;
            this.addSigDiffSymbolPropertyHistory(this.getProperties());
            return true;
        }

        public boolean isChanged() {
            return this.mChangedFlag;
        }

        public void setChanged(boolean bl) {
            this.mChangedFlag = bl;
        }

        public void notifyToRoot() {
            SGSignificantDifferenceElement.this.notifyToRootFromFigureElement();
        }
    }

    public static class SigDiffElementProperties
    extends SGProperties {
        ArrayList visibleSigDiffSymbolList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof SigDiffElementProperties)) {
                return false;
            }
            SigDiffElementProperties sigDiffElementProperties = (SigDiffElementProperties)object;
            return sigDiffElementProperties.visibleSigDiffSymbolList.equals(this.visibleSigDiffSymbolList);
        }

        public String toString() {
            String string = new String("[");
            string = string + this.visibleSigDiffSymbolList.toString();
            string = string + new String("]");
            return string;
        }
    }
}

