/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Properties;
import javax.print.PrintService;
import javax.swing.JPanel;
import jp.riken.brain.ni.samuraigraph.application.SGPreviewDialog;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIImageExportManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import org.freehep.graphicsio.cgm.CGMGraphics2D;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.freehep.graphicsio.swf.SWFGraphics2D;
import org.freehep.util.UserProperties;
import org.freehep.util.export.ExportDialog;

public class SGImageExportManager
implements SGIImageExportManager,
SGIConstants {
    public static final String DEFAULT_EXPORT_FILE_NAME = "export";
    public static final String DEFAULT_TITLE_NAME = "Export view as ...";
    private static final String PREFIX = "org.freehep.graphicsio.";
    private static final String BG_SUFFIX = ".Background";
    private static final String BG_COLOR_SUFFIX = ".BackgroundColor";
    private static final String GIF = "gif";
    private static final String JPG = "jpg";
    private static final String PNG = "png";
    private static final String RAW = "raw";
    private static final String PPM = "ppm";
    private static final String[][] BG_KEY_ARRAY = new String[][]{{CGMGraphics2D.BACKGROUND, CGMGraphics2D.BACKGROUND_COLOR}, {PSGraphics2D.BACKGROUND, PSGraphics2D.BACKGROUND_COLOR}, {SWFGraphics2D.BACKGROUND, SWFGraphics2D.BACKGROUND_COLOR}, {PDFGraphics2D.BACKGROUND, PDFGraphics2D.BACKGROUND_COLOR}, {SVGGraphics2D.BACKGROUND, SVGGraphics2D.BACKGROUND_COLOR}, {EMFGraphics2D.BACKGROUND, EMFGraphics2D.BACKGROUND_COLOR}, {"org.freehep.graphicsio.gif.Background", "org.freehep.graphicsio.gif.BackgroundColor"}, {"org.freehep.graphicsio.jpg.Background", "org.freehep.graphicsio.jpg.BackgroundColor"}, {"org.freehep.graphicsio.png.Background", "org.freehep.graphicsio.png.BackgroundColor"}, {"org.freehep.graphicsio.raw.Background", "org.freehep.graphicsio.raw.BackgroundColor"}, {"org.freehep.graphicsio.ppm.Background", "org.freehep.graphicsio.ppm.BackgroundColor"}};
    private static final ExportDialog mExportDialog = new ExportDialog();
    private String mBaseDirectoryName = null;
    private String mExportFileName = "export";
    public static final int OK = 0;
    public static final int CANCEL = 1;

    public boolean export(Component component, Frame frame, int n, int n2) {
        Object object;
        Object object2;
        String string;
        String string2 = "Export as Image";
        if (this.preview(component, frame, n, n2, n, n2, string2, "OK", "Cancel") == 1) {
            return true;
        }
        if (this.mBaseDirectoryName == null) {
            this.mBaseDirectoryName = System.getProperty("user.dir");
        }
        ExportDialog exportDialog = mExportDialog;
        Color color = component.getBackground();
        Properties properties = exportDialog.getUserProperties();
        String string3 = ExportDialog.SAVE_AS_FILE;
        String string4 = this.mBaseDirectoryName;
        String string5 = exportDialog.getUserProperties().getProperty(string3);
        if (string5 != null) {
            string = new File(string5).getParent();
            object2 = string4 + SGIConstants.FILE_SEPARATOR + this.mExportFileName;
            exportDialog.setUserProperty(string3, (String)object2);
        }
        string = string4 + SGIConstants.FILE_SEPARATOR + this.mExportFileName;
        object2 = BG_KEY_ARRAY;
        for (int i = 0; i < ((String[][])object2).length; ++i) {
            object = object2[i];
            UserProperties.setProperty(properties, object[0], true);
            UserProperties.setProperty(properties, object[1], color);
        }
        exportDialog.showExportDialog(frame, DEFAULT_TITLE_NAME, component, string);
        String string6 = properties.getProperty(string3);
        if (string6 != null) {
            object = new File(string6).getParent();
            String string7 = string6.substring(((String)object).length() + 1);
            this.setBaseDirectory((String)object);
            this.mExportFileName = string7;
        }
        return true;
    }

    public void setBaseDirectory(String string) {
        this.mBaseDirectoryName = new String(string);
    }

    public String getBaseDirectory() {
        return this.mBaseDirectoryName;
    }

    private int preview(Component component, Frame frame, int n, int n2, int n3, int n4, String string, String string2, String string3) {
        SGPreviewDialog sGPreviewDialog = this.createPreviewDialog(component, frame, n, n2, n3, n4, string, true);
        sGPreviewDialog.setOKButtonText(string2);
        sGPreviewDialog.setCancelButtonText(string3);
        sGPreviewDialog.setVisible(true);
        int n5 = sGPreviewDialog.getCloseOption();
        if (n5 == 1) {
            return 1;
        }
        return 0;
    }

    public boolean print(Component component, Frame frame, int n, int n2) {
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        if (printServiceArray.length == 0) {
            SGUtility.showMessageDialog(frame, "No printer is available.", "Error", 0);
            return false;
        }
        String string = "Print as Image";
        PrintJob printJob = null;
        printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, "", null, null);
        if (printJob == null) {
            return true;
        }
        Object object = printJob.getPageDimension();
        int n3 = this.preview(component, frame, n, n2, ((Dimension)object).width, ((Dimension)object).height, string, "Print", "Cancel");
        if (n3 != 0 && n3 == 1) {
            return true;
        }
        object = printJob.getGraphics();
        component.printAll((Graphics)object);
        ((Graphics)object).dispose();
        printJob.end();
        return true;
    }

    private SGPreviewDialog createPreviewDialog(Component component, Frame frame, int n, int n2, int n3, int n4, String string, boolean bl) {
        SGPreviewDialog sGPreviewDialog = new SGPreviewDialog(frame, string, bl);
        sGPreviewDialog.pack();
        sGPreviewDialog.setLocation(frame.getLocation());
        sGPreviewDialog.setTargetObject(component, n, n2, n3, n4, component.getBackground());
        return sGPreviewDialog;
    }

    private class ExportTestPanel
    extends JPanel {
        private ExportTestPanel() {
            this.init();
        }

        private void init() {
            this.setSize(800, 800);
            this.setOpaque(false);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = new Rectangle(55, 40, 350, 420);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 1));
            graphics2D.setPaint(Color.BLUE);
            graphics2D.draw(rectangle);
            float[] fArray = new float[]{10.0f, 5.0f};
            BasicStroke basicStroke = new BasicStroke(24.0f, 0, 1, 10.0f, fArray, 0.0f);
            Line2D.Float float_ = new Line2D.Float(30.0f, 40.0f, 230.0f, 500.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setPaint(Color.RED);
            graphics2D.draw(float_);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(2.0f));
            Area area = new Area(rectangle);
            Shape shape = basicStroke.createStrokedShape(float_);
            Area area2 = new Area(shape);
            area2.intersect(area);
            graphics2D.draw(area2);
            graphics2D.setPaint(Color.GREEN);
            graphics2D.fill(area2);
        }
    }
}

