/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingLine;

public class SGTimingLineDialog
extends SGPropertyDialog {
    public static final String TITLE = "Timing Line Properties";
    private JRadioButton mBottomRadioButton;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mCenterLabel;
    private JLabel mColorLabel;
    private JPanel mCommonPanel;
    private JRadioButton mLeftRadioButton;
    private JLabel mLeftSpaceLabel;
    private JButton mLineColorButton;
    private JComboBox mLineTypeComboBox;
    private JLabel mLineTypeLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JRadioButton mRightRadioButton;
    private JLabel mRightSpaceLabel;
    private JLabel mScaleReferenceLabel1;
    private JLabel mScaleReferenceLabel2;
    private JPanel mTimingLinePanel;
    private JLabel mTimingValueLabel;
    private JTextField mTimingValueTextField;
    private JRadioButton mTopRadioButton;
    private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

    public SGTimingLineDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mTimingLinePanel = new JPanel();
        this.mTimingValueLabel = new JLabel();
        this.mLineTypeLabel = new JLabel();
        this.mLineWidthLabel = new JLabel();
        this.mColorLabel = new JLabel();
        this.mTimingValueTextField = new JTextField();
        this.mLineWidthSpinner = new SGSpinner();
        this.mLineColorButton = new JButton();
        this.mLineTypeComboBox = new JComboBox();
        this.mRightSpaceLabel = new JLabel();
        this.mLeftSpaceLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mCommonPanel = new JPanel();
        this.mLeftRadioButton = new JRadioButton();
        this.mBottomRadioButton = new JRadioButton();
        this.mTopRadioButton = new JRadioButton();
        this.mRightRadioButton = new JRadioButton();
        this.mScaleReferenceLabel2 = new JLabel();
        this.mScaleReferenceLabel1 = new JLabel();
        this.mCenterLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SGTimingLineDialog.this.closeDialog(windowEvent);
            }
        });
        this.mTimingLinePanel.setLayout(new GridBagLayout());
        this.mTimingLinePanel.setBorder(new BevelBorder(0));
        this.mTimingLinePanel.setFont(new Font("MS Sans Serif", 0, 10));
        this.mTimingValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mTimingValueLabel.setText("Value");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTimingLinePanel.add((Component)this.mTimingValueLabel, gridBagConstraints);
        this.mLineTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeLabel.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 20, 5, 5);
        this.mTimingLinePanel.add((Component)this.mLineTypeLabel, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTimingLinePanel.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTimingLinePanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mTimingValueTextField.setColumns(6);
        this.mTimingValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mTimingValueTextField.setPreferredSize(new Dimension(72, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTimingLinePanel.add((Component)this.mTimingValueTextField, gridBagConstraints);
        this.mLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        this.mLineWidthSpinner.setMinimumSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTimingLinePanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTimingLinePanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mLineTypeComboBox.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTimingLinePanel.add((Component)this.mLineTypeComboBox, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTimingLinePanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTimingLinePanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mTimingLinePanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLeftRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftRadioButton.setText("Left");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.mCommonPanel.add((Component)this.mLeftRadioButton, gridBagConstraints);
        this.mBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mBottomRadioButton.setText("Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.mCommonPanel.add((Component)this.mBottomRadioButton, gridBagConstraints);
        this.mTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mTopRadioButton.setText("Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        this.mCommonPanel.add((Component)this.mTopRadioButton, gridBagConstraints);
        this.mRightRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightRadioButton.setText("Right");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightRadioButton, gridBagConstraints);
        this.mScaleReferenceLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel2, gridBagConstraints);
        this.mScaleReferenceLabel1.setFont(new Font("Dialog", 1, 12));
        this.mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel1, gridBagConstraints);
        this.mCenterLabel.setFont(new Font("SansSerif", 0, 11));
        this.mCenterLabel.setText("        ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.mCommonPanel.add((Component)this.mCenterLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent windowEvent) {
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        Object object = new String[]{"Solid", "Broken", "Dotted"};
        for (int i = 0; i < ((String[])object).length; ++i) {
            this.mLineTypeComboBox.addItem(object[i]);
        }
        this.pack();
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.mTopRadioButton);
        ((ButtonGroup)object).add(this.mBottomRadioButton);
        ((ButtonGroup)object).add(this.mLeftRadioButton);
        ((ButtonGroup)object).add(this.mRightRadioButton);
        ((ButtonGroup)object).add(this.mNoAxisSelectionRadioButton);
        this.mLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mLineColorButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mLineColorButton;
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        return true;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        this.mPreviewButton.addActionListener(actionListener);
        this.mTimingValueTextField.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        return true;
    }

    public String getTimingValueString() {
        return this.mTimingValueTextField.getText();
    }

    public Number getTimingValue() {
        String string = this.getTimingValueString();
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public boolean setTiminValueString(double d) {
        this.mTimingValueTextField.setText(new Double(d).toString());
        return true;
    }

    public boolean setLineType(int n) {
        String string = SGDrawingElementLine.getLineTypeName(n);
        this.mLineTypeComboBox.setSelectedItem(string);
        return true;
    }

    public int getLineType() {
        String string = (String)this.mLineTypeComboBox.getSelectedItem();
        Integer n = SGDrawingElementLine.getLineTypeFromName(string);
        if (n == null) {
            throw new Error();
        }
        return n;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidthSpinner.setValue(new Double(f));
        return true;
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public boolean setLineColorList(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Color color = (Color)arrayList.get(0);
        this.mLineColorButton.setBackground(color);
        return true;
    }

    public ArrayList getLineColorList() {
        Color color = this.mLineColorButton.getBackground();
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(color);
        return arrayList;
    }

    public String getAxisLocation() {
        String string = null;
        if (this.mTopRadioButton.isSelected()) {
            string = "Top";
        } else if (this.mBottomRadioButton.isSelected()) {
            string = "Bottom";
        } else if (this.mLeftRadioButton.isSelected()) {
            string = "Left";
        } else if (this.mRightRadioButton.isSelected()) {
            string = "Right";
        }
        return string;
    }

    public boolean setAxisRadioButton(int n) {
        switch (n) {
            case 0: {
                this.mBottomRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.mTopRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.mLeftRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.mRightRadioButton.setSelected(true);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean setAxesProperties(ArrayList arrayList) {
        Integer n;
        int n2 = arrayList.size();
        if (n2 == 0) {
            return false;
        }
        Integer n3 = n = (Integer)arrayList.get(0);
        if (n2 > 1) {
            for (int i = 1; i < n2; ++i) {
                Integer n4 = (Integer)arrayList.get(i);
                if (n.equals(n4)) continue;
                n3 = null;
                break;
            }
        }
        if (n3 == null) {
            this.mNoAxisSelectionRadioButton.setSelected(true);
            return false;
        }
        this.setAxisRadioButton(n3);
        return true;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mLineColorButton);
        return arrayList;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        arrayList.add(this.mTimingValueTextField);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = null;
        actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
            this.mCancelButton.removeActionListener(actionListenerArray[i]);
            this.mPreviewButton.removeActionListener(actionListenerArray[i]);
            this.mTimingValueTextField.removeActionListener(actionListenerArray[i]);
            ArrayList arrayList = this.getSpinnerList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGSpinner sGSpinner = (SGSpinner)arrayList.get(j);
                sGSpinner.getFormattedTextField().removeActionListener(actionListenerArray[i]);
            }
        }
        return true;
    }

    public SGTimingLine.TimingLineProperties getTimingLineProperties() {
        SGTimingLine.TimingLineProperties timingLineProperties = new SGTimingLine.TimingLineProperties();
        Number number = this.getLineWidth();
        if (number == null) {
            return null;
        }
        timingLineProperties.setLineWidth(number.floatValue());
        timingLineProperties.setLineType(this.getLineType());
        timingLineProperties.setColorList(this.getLineColorList());
        Number number2 = this.getTimingValue();
        if (number2 == null) {
            return null;
        }
        timingLineProperties.setValue(number2.doubleValue());
        return timingLineProperties;
    }
}

