/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupTickLabel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGGraphElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIPropertySettingListenerSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SGSXYGraphElement
extends SGGraphElement {
    public static final String MSG_NOT_HIDE_ALL_ELEMENTS = "Lines, symbol and bars cannot be hidden at the same time.";

    public SGSXYGraphElement() {
        this.createDataDialog();
    }

    protected boolean createDataDialog() {
        SGPropertyDialogSXYData sGPropertyDialogSXYData = new SGPropertyDialogSXYData(this.mDialogOwner, true);
        mPropertyDialogForData = sGPropertyDialogSXYData;
        return true;
    }

    public boolean addData(SGData sGData) {
        String string = "data" + (this.mGroupSetList.size() + 1);
        this.addData(sGData, string);
        return true;
    }

    public boolean addData(SGData sGData, String string) {
        if (!(sGData instanceof SGSXYData) && !(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        this.mDataList.add(sGData);
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(0);
        SGAxis sGAxis2 = this.mAxisElement.getAxisInPlane(1);
        SGAxis sGAxis3 = this.mAxisElement.getAxisInPlane(2);
        SGAxis sGAxis4 = this.mAxisElement.getAxisInPlane(3);
        SGAxis sGAxis5 = null;
        SGAxis sGAxis6 = null;
        if ("Left-Bottom".equals("Left-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Left-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Right-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis4;
        } else if ("Left-Bottom".equals("Right-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis4;
        } else {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGSXYData) {
            elementGroupSetInGraph = this.createSingleGroupSet((SGSXYData)sGData, sGAxis5, sGAxis6, string);
        } else if (sGData instanceof SGSXYMultipleData) {
            elementGroupSetInGraph = this.createMultipleGroupSet((SGSXYMultipleData)sGData, sGAxis5, sGAxis6, string);
        } else {
            return false;
        }
        elementGroupSetInGraph.initPropertiesHistory();
        this.mGroupSetList.add(elementGroupSetInGraph);
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (!(sGData instanceof SGSXYData) && !(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        this.mDataList.add(sGData);
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(0);
        SGAxis sGAxis2 = this.mAxisElement.getAxisInPlane(1);
        SGAxis sGAxis3 = this.mAxisElement.getAxisInPlane(2);
        SGAxis sGAxis4 = this.mAxisElement.getAxisInPlane(3);
        SGAxis sGAxis5 = null;
        SGAxis sGAxis6 = null;
        if ("Left-Bottom".equals("Left-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Left-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Right-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis4;
        } else if ("Left-Bottom".equals("Right-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis4;
        } else {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGSXYData) {
            elementGroupSetInGraph = this.createSingleGroupSet((SGSXYData)sGData, sGAxis5, sGAxis6, string);
        } else if (sGData instanceof SGSXYMultipleData) {
            elementGroupSetInGraph = this.createMultipleGroupSet((SGSXYMultipleData)sGData, sGAxis5, sGAxis6, string);
        } else {
            return false;
        }
        this.mGroupSetList.add(elementGroupSetInGraph);
        if (!elementGroupSetInGraph.setWholeProperties(sGProperties)) {
            throw new Error();
        }
        elementGroupSetInGraph.setVisible(true);
        elementGroupSetInGraph.setName(string);
        elementGroupSetInGraph.initPropertiesHistory();
        if (!this.setAllDrawingElementsLocation()) {
            return false;
        }
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    private SGGraphElement.ElementGroupSetForMultipleData createMultipleGroupSet(SGSXYMultipleData sGSXYMultipleData, SGAxis sGAxis, SGAxis sGAxis2, String string) {
        ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph = new ElementGroupSetForMultipleDataInSXYGraph();
        elementGroupSetForMultipleDataInSXYGraph.setName(string);
        elementGroupSetForMultipleDataInSXYGraph.setXAxis(sGAxis);
        elementGroupSetForMultipleDataInSXYGraph.setYAxis(sGAxis2);
        SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
        for (int i = 0; i < sGSXYDataArray.length; ++i) {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.createGroupSetSXYInstance(sGSXYDataArray[i], sGAxis, sGAxis2);
            elementGroupSetInSXYGraph.setName(string);
            elementGroupSetInSXYGraph.initPropertiesHistory();
            elementGroupSetForMultipleDataInSXYGraph.mElementGroupSetList.add(elementGroupSetInSXYGraph);
        }
        return elementGroupSetForMultipleDataInSXYGraph;
    }

    private ElementGroupSetInSXYGraph createSingleGroupSet(SGSXYData sGSXYData, SGAxis sGAxis, SGAxis sGAxis2, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.createGroupSetSXYInstance(sGSXYData, sGAxis, sGAxis2);
        elementGroupSetInSXYGraph.setName(string);
        return elementGroupSetInSXYGraph;
    }

    private ElementGroupSetInSXYGraph createGroupSetSXYInstance(SGSXYData sGSXYData, SGAxis sGAxis, SGAxis sGAxis2) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
        elementGroupSetInSXYGraph.setXAxis(sGAxis);
        elementGroupSetInSXYGraph.setYAxis(sGAxis2);
        int n = sGSXYData.getPointsNumber();
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
        for (int i = 0; i < n; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
        }
        ElementGroupSetInSXYGraph.access$002(elementGroupSetInSXYGraph, sGTuple2fArray);
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(0)) {
            throw new Error();
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(1)) {
            throw new Error();
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(2)) {
            throw new Error();
        }
        if (sGSXYData.isErrorValueHolding()) {
            ElementGroupErrorBar elementGroupErrorBar = this.createErrorBar(elementGroupSetInSXYGraph, sGSXYData);
            if (elementGroupErrorBar == null) {
                throw new Error();
            }
            if (!elementGroupErrorBar.setPropertiesOfDrawingElements()) {
                throw new Error();
            }
        }
        if (sGSXYData.isStringArrayHolding() && this.createTickLabels(elementGroupSetInSXYGraph, sGSXYData) == null) {
            throw new Error();
        }
        if (!elementGroupSetInSXYGraph.setDrawingElementsLocation(sGSXYData)) {
            throw new Error();
        }
        elementGroupSetInSXYGraph.setMagnification(this.mMagnification);
        return elementGroupSetInSXYGraph;
    }

    private ElementGroupTickLabelStringElement createTickLabels(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGSXYData sGSXYData) {
        int n;
        ElementGroupTickLabelStringElement elementGroupTickLabelStringElement = new ElementGroupTickLabelStringElement();
        elementGroupSetInSXYGraph.mTickLabels = elementGroupTickLabelStringElement;
        elementGroupTickLabelStringElement.mGroupSet = elementGroupSetInSXYGraph;
        int n2 = sGSXYData.getPointsNumber();
        elementGroupTickLabelStringElement.initDrawingElement(n2);
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n2];
        for (n = 0; n < n2; ++n) {
            sGTuple2fArray[n] = new SGTuple2f();
        }
        ElementGroupTickLabelStringElement.access$202(elementGroupTickLabelStringElement, sGTuple2fArray);
        for (n = 0; n < n2; ++n) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)elementGroupTickLabelStringElement.mDrawingElementArray[n];
            sGDrawingElementString.setString(sGSXYData.getString(n));
        }
        if (!elementGroupTickLabelStringElement.setPropertiesOfDrawingElements()) {
            throw new Error();
        }
        return elementGroupTickLabelStringElement;
    }

    private ElementGroupErrorBar createErrorBar(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGSXYData sGSXYData) {
        ElementGroupErrorBar elementGroupErrorBar = new ElementGroupErrorBar();
        elementGroupSetInSXYGraph.mErrorBarGroup = elementGroupErrorBar;
        elementGroupErrorBar.mGroupSet = elementGroupSetInSXYGraph;
        elementGroupErrorBar.setMagnification(this.mMagnification);
        int n = sGSXYData.getPointsNumber();
        elementGroupErrorBar.initDrawingElement(n);
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
        SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[n];
        for (int i = 0; i < n; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
            sGTuple2fArray2[i] = new SGTuple2f();
        }
        elementGroupErrorBar.mStartArray = sGTuple2fArray;
        elementGroupErrorBar.mEndArray = sGTuple2fArray2;
        return elementGroupErrorBar;
    }

    private JPopupMenu createGroupSetPopupMenu(SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Data --"));
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Move to Front");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Move to Back");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Cut");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Copy");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Paste");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Delete");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Property");
        return jPopupMenu;
    }

    protected boolean synchronizeToLegendElement(SGILegendElement sGILegendElement) {
        boolean bl = super.synchronizeToLegendElement(sGILegendElement);
        if (!bl) {
            return bl;
        }
        for (int i = this.mDataList.size() - 1; i >= 0; --i) {
            String string;
            SGData sGData = (SGData)this.mDataList.get(i);
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSetList.get(i);
            boolean bl2 = false;
            String string2 = sGILegendElement.getDataName(sGData);
            if (!string2.equals(string = elementGroupSetInGraph.getName())) {
                elementGroupSetInGraph.setChanged(true);
            }
            elementGroupSetInGraph.setName(string2);
            boolean bl3 = sGILegendElement.isDataVisible(sGData);
            if (bl3 != elementGroupSetInGraph.isVisible()) {
                this.setChanged(true);
            }
            elementGroupSetInGraph.setVisible(bl3);
        }
        return bl;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        SGElementGroupSet sGElementGroupSet;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (n = 0; n < this.mGroupSetList.size(); ++n) {
            sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(n);
            if (!sGElementGroupSet.isVisible()) continue;
            IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)((Object)sGElementGroupSet);
            iElementGroupSetInSXYGraph.paintDataString(graphics2D);
        }
        if (bl) {
            SGUtilityForFigureElement.clipGraphRect(this, graphics2D);
        }
        for (n = 0; n < this.mGroupSetList.size(); ++n) {
            sGElementGroupSet = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSetList.get(n);
            if (!sGElementGroupSet.isVisible()) continue;
            ((SGGraphElement.ElementGroupSetInGraph)sGElementGroupSet).setClipFlag(bl);
            sGElementGroupSet.paintGraphics2D(graphics2D);
        }
        if (bl) {
            graphics2D.setClip(this.getBounds());
        }
    }

    private ElementGroupLine getGroupLine(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupLine)) continue;
            return (ElementGroupLine)sGElementGroup;
        }
        return null;
    }

    private ElementGroupBar getGroupBar(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupBar)) continue;
            return (ElementGroupBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupSymbol getGroupSymbol(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupSymbol)) continue;
            return (ElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGData sGData;
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSetList.get(i);
            Rectangle2D rectangle2D = ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).getTickLabelsBoundingBox(sGData = this.getData(elementGroupSetInGraph));
            if (rectangle2D == null) {
                return false;
            }
            if (rectangle2D.getWidth() < Double.MIN_VALUE || rectangle2D.getHeight() < Double.MIN_VALUE) continue;
            arrayList.add(rectangle2D);
        }
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        float f = this.mGraphRectY - (float)rectangle2D.getY();
        float f2 = -(this.mGraphRectY + this.mGraphRectHeight) + (float)(rectangle2D.getY() + rectangle2D.getHeight());
        float f3 = this.mGraphRectX - (float)rectangle2D.getX();
        float f4 = -(this.mGraphRectX + this.mGraphRectWidth) + (float)(rectangle2D.getX() + rectangle2D.getWidth());
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    protected boolean setAllDrawingElementsLocation() {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGData sGData;
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSetList.get(i);
            if (!elementGroupSetInGraph.isVisible() || ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).setDrawingElementsLocation(sGData = (SGData)this.mDataList.get(i))) continue;
            return false;
        }
        return true;
    }

    protected SGGraphElement.ElementGroupSetInGraph getGroupSetNewInstance(SGData sGData) {
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGSXYData) {
            elementGroupSetInGraph = new ElementGroupSetInSXYGraph();
        } else if (sGData instanceof SGSXYMultipleData) {
            elementGroupSetInGraph = new ElementGroupSetForMultipleDataInSXYGraph();
        }
        return elementGroupSetInGraph;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (!(sGData instanceof SGSXYData) && !(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        if (!super.createDataObject(element, sGData)) {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = this.getGroupSetNewInstance(sGData);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        this.mGroupSetList.add(elementGroupSetInGraph);
        int n = this.setProperty(element, elementGroupSetInGraph);
        return n != 1;
    }

    private int setProperty(Element element, SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
        SGData sGData = this.getData(elementGroupSetInGraph);
        int n = 1;
        if (sGData instanceof SGSXYData) {
            SGSXYData sGSXYData = (SGSXYData)sGData;
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)elementGroupSetInGraph;
            n = this.setPropertyOfElementGroupSetInSXYGraph(element, elementGroupSetInSXYGraph, sGSXYData);
        } else if (sGData instanceof SGSXYMultipleData) {
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
            ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph = (ElementGroupSetForMultipleDataInSXYGraph)elementGroupSetInGraph;
            n = this.setPropertyOfElementGroupSetForMultipleDataInSXYGraph(element, elementGroupSetForMultipleDataInSXYGraph, sGSXYMultipleData);
        }
        return n;
    }

    private int setPropertyOfElementGroupSetForMultipleDataInSXYGraph(Element element, ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph, SGSXYMultipleData sGSXYMultipleData) {
        elementGroupSetForMultipleDataInSXYGraph.mDrawingElementGroupList.clear();
        SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
        int n = this.setPropertyOfElementGroupSetInSXYGraph(element, elementGroupSetInSXYGraph, sGSXYDataArray[0]);
        if (n == 1) {
            return n;
        }
        SGProperties sGProperties = elementGroupSetInSXYGraph.getProperties();
        SGProperties sGProperties2 = elementGroupSetInSXYGraph.getWholeProperties();
        ArrayList<ElementGroupSetInSXYGraph> arrayList = new ArrayList<ElementGroupSetInSXYGraph>();
        for (int i = 0; i < sGSXYDataArray.length; ++i) {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph2 = new ElementGroupSetInSXYGraph();
            if (!elementGroupSetInSXYGraph2.setProperties(sGProperties)) {
                return 1;
            }
            int n2 = sGSXYDataArray[i].getPointsNumber();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n2];
            for (int j = 0; j < n2; ++j) {
                sGTuple2fArray[j] = new SGTuple2f();
            }
            ElementGroupSetInSXYGraph.access$002(elementGroupSetInSXYGraph2, sGTuple2fArray);
            elementGroupSetInSXYGraph2.setDrawingElementsLocation(sGSXYDataArray[i]);
            elementGroupSetInSXYGraph2.addDrawingElementGroup(0);
            elementGroupSetInSXYGraph2.addDrawingElementGroup(1);
            elementGroupSetInSXYGraph2.addDrawingElementGroup(2);
            if (!elementGroupSetInSXYGraph2.setWholeProperties(sGProperties2)) {
                return 1;
            }
            elementGroupSetInSXYGraph2.initPropertiesHistory();
            arrayList.add(elementGroupSetInSXYGraph2);
        }
        elementGroupSetForMultipleDataInSXYGraph.mElementGroupSetList = new ArrayList(arrayList);
        elementGroupSetForMultipleDataInSXYGraph.mName = new String(elementGroupSetInSXYGraph.getName());
        elementGroupSetForMultipleDataInSXYGraph.initPropertiesHistory();
        return 0;
    }

    private int setPropertyOfElementGroupSetInSXYGraph(Element element, ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGSXYData sGSXYData) {
        SGElementGroup sGElementGroup;
        Object object;
        String string = null;
        string = element.getAttribute("Name");
        if (string.length() == 0) {
            return 1;
        }
        String string2 = string;
        elementGroupSetInSXYGraph.setName(string2);
        string = element.getAttribute("XAxisPosition");
        if (string.length() == 0) {
            return 1;
        }
        int n = this.mAxisElement.getConfigurationInCube(string);
        string = element.getAttribute("YAxisPosition");
        if (string.length() == 0) {
            return 1;
        }
        int n2 = this.mAxisElement.getConfigurationInCube(string);
        elementGroupSetInSXYGraph.mXAxis = this.mAxisElement.getAxisInCube(n);
        elementGroupSetInSXYGraph.mYAxis = this.mAxisElement.getAxisInCube(n2);
        string = element.getAttribute("VisibleInLegend");
        if (string.length() == 0) {
            return 1;
        }
        Boolean bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return 1;
        }
        boolean bl2 = bl;
        elementGroupSetInSXYGraph.setVisibleInLegend(bl2);
        int n3 = sGSXYData.getPointsNumber();
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n3];
        for (int i = 0; i < n3; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
        }
        ElementGroupSetInSXYGraph.access$002(elementGroupSetInSXYGraph, sGTuple2fArray);
        SGElementGroup sGElementGroup2 = null;
        NodeList nodeList = null;
        nodeList = element.getElementsByTagName("Line");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(0)) {
            return 1;
        }
        Element element2 = (Element)nodeList.item(0);
        sGElementGroup2 = (SGElementGroup)elementGroupSetInSXYGraph.getLineGroups().get(0);
        if (!sGElementGroup2.readProperty(element2)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("Symbol");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(1)) {
            return 1;
        }
        Element element3 = (Element)nodeList.item(0);
        sGElementGroup2 = (SGElementGroup)elementGroupSetInSXYGraph.getSymbolGroups().get(0);
        if (!sGElementGroup2.readProperty(element3)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("Bar");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(2)) {
            return 1;
        }
        Element element4 = (Element)nodeList.item(0);
        sGElementGroup2 = (SGElementGroup)elementGroupSetInSXYGraph.getBarGroups().get(0);
        if (!sGElementGroup2.readProperty(element4)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("ErrorBar");
        if (nodeList.getLength() == 1) {
            object = (Element)nodeList.item(0);
            if (sGSXYData.isErrorValueHolding()) {
                sGElementGroup = this.createErrorBar(elementGroupSetInSXYGraph, sGSXYData);
                if (!sGElementGroup.readProperty((Element)object)) {
                    return 1;
                }
                if (!((SGElementGroupErrorBar)sGElementGroup).setPropertiesOfDrawingElements()) {
                    return 1;
                }
                ((SGElementGroupArrow)sGElementGroup).setLocation(((ElementGroupErrorBar)sGElementGroup).mStartArray, ((ElementGroupErrorBar)sGElementGroup).mEndArray);
            } else {
                sGElementGroup = new ElementGroupErrorBar();
                if (!sGElementGroup.readProperty((Element)object)) {
                    return 1;
                }
            }
        } else if (nodeList.getLength() == 0) {
            if (sGSXYData.isErrorValueHolding()) {
                object = this.createErrorBar(elementGroupSetInSXYGraph, sGSXYData);
                if (object == null) {
                    return 1;
                }
                if (!((SGElementGroupErrorBar)object).setPropertiesOfDrawingElements()) {
                    return 1;
                }
            }
        } else {
            return 1;
        }
        nodeList = element.getElementsByTagName("TickLabels");
        if (nodeList.getLength() == 1) {
            object = (Element)nodeList.item(0);
            if (sGSXYData.isStringArrayHolding()) {
                sGElementGroup = this.createTickLabels(elementGroupSetInSXYGraph, sGSXYData);
                if (!sGElementGroup.readProperty((Element)object)) {
                    return 1;
                }
                if (!((SGElementGroupString)sGElementGroup).setPropertiesOfDrawingElements()) {
                    return 1;
                }
                ((ElementGroupTickLabelStringElement)sGElementGroup).setLocation(((ElementGroupTickLabelStringElement)sGElementGroup).mPointsArray);
            } else {
                sGElementGroup = new ElementGroupTickLabelStringElement();
                if (!sGElementGroup.readProperty((Element)object)) {
                    return 1;
                }
            }
        } else if (nodeList.getLength() == 0) {
            if (sGSXYData.isStringArrayHolding()) {
                object = this.createTickLabels(elementGroupSetInSXYGraph, sGSXYData);
                if (object == null) {
                    return 1;
                }
                if (!((SGElementGroupString)object).setPropertiesOfDrawingElements()) {
                    return 1;
                }
            }
        } else {
            return 1;
        }
        elementGroupSetInSXYGraph.initPropertiesHistory();
        return 0;
    }

    public static class TickLabelStringElement
    extends SGDrawingElementString2DExtended {
        protected TickLabelStringElement() {
        }
    }

    class ElementGroupTickLabelStringElement
    extends SGElementGroupTickLabel {
        private SGTuple2f[] mPointsArray = null;

        protected ElementGroupTickLabelStringElement() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setFont("Serif", SGUtilityText.getFontStyle("Plain"), 16.0f);
            Float f = SGElementGroupTickLabel.getTickLabelAngleFromName("Horizontal");
            if (f == null) {
                return false;
            }
            this.setAngle(f.floatValue());
            this.setColor(SGDefaultValues.TICK_LABEL_COLOR);
            return true;
        }

        private boolean drawStringBounds(SGDrawingElementString2DExtended sGDrawingElementString2DExtended, Graphics2D graphics2D) {
            Color color = Color.BLACK;
            graphics2D.setPaint(color);
            graphics2D.setStroke(new BasicStroke(1.0f));
            Rectangle2D rectangle2D = sGDrawingElementString2DExtended.getElementBounds();
            graphics2D.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            return true;
        }

        protected SGElementGroup.ElementGroupProperties getPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGElementGroupString.StringProperties stringProperties = new SGElementGroupString.StringProperties();
            stringProperties.setVisible(sGPropertyDialogSXYData.getTickLabelVisible());
            stringProperties.setColorList(sGPropertyDialogSXYData.getTickLabelColorList());
            stringProperties.setFontName(sGPropertyDialogSXYData.getTickLabelFontName());
            Number number = sGPropertyDialogSXYData.getTickLabelFontSize();
            if (number == null) {
                SGUtility.showIllegalInputErrorMessageDialog(SGSXYGraphElement.this.mDialogOwner);
                return null;
            }
            stringProperties.setFontSize(number.floatValue());
            Integer n = sGPropertyDialogSXYData.getTickLabelFontStyle();
            if (n == null) {
                SGUtility.showIllegalInputErrorMessageDialog(SGSXYGraphElement.this.mDialogOwner);
                return null;
            }
            stringProperties.setFontStyle(n);
            Number number2 = sGPropertyDialogSXYData.getTickLabelAngle();
            if (number2 == null) {
                SGUtility.showIllegalInputErrorMessageDialog(SGSXYGraphElement.this.mDialogOwner);
                return null;
            }
            stringProperties.setAngle(number2.floatValue());
            return stringProperties;
        }

        protected boolean setDialogProperty() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setTickLabelVisible(this.isVisible());
            sGPropertyDialogSXYData.setTickLabelFontName(this.mFontName);
            sGPropertyDialogSXYData.setTickLabelFontSize(new Float(this.mFontSize));
            sGPropertyDialogSXYData.setTickLabelFontStyle(new Integer(this.mFontStyle));
            sGPropertyDialogSXYData.setTickLabelAngle(new Float(this.mAngle));
            sGPropertyDialogSXYData.setTickLabelColorList(this.mColorList);
            return true;
        }

        protected boolean initDrawingElement(int n) {
            TickLabelStringElement[] tickLabelStringElementArray = new TickLabelStringElement[n];
            for (int i = 0; i < n; ++i) {
                tickLabelStringElementArray[i] = new TickLabelStringElement();
            }
            this.mDrawingElementArray = tickLabelStringElementArray;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean calcTickLabelLocation(SGSXYData sGSXYData, SGAxis sGAxis, SGTuple2f[] sGTuple2fArray) {
            float f = SGSXYGraphElement.this.mGraphRectX;
            float f2 = SGSXYGraphElement.this.mGraphRectY;
            float f3 = SGSXYGraphElement.this.mGraphRectWidth;
            float f4 = SGSXYGraphElement.this.mGraphRectHeight;
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(sGAxis);
            float f5 = this.getAngle();
            float f6 = SGSXYGraphElement.this.mAxisElement.getSpaceAxisLineAndNumber();
            int n2 = sGSXYData.getPointsNumber();
            for (int i = 0; i < n2; ++i) {
                TickLabelStringElement tickLabelStringElement = (TickLabelStringElement)this.mDrawingElementArray[i];
                double d = sGSXYData.getXValue(i);
                float f7 = SGSXYGraphElement.this.calcLocation(d, sGAxis, true);
                Rectangle2D rectangle2D = tickLabelStringElement.getElementBounds();
                float f8 = (float)rectangle2D.getWidth();
                float f9 = (float)rectangle2D.getHeight();
                Rectangle2D rectangle2D2 = tickLabelStringElement.getStringRect();
                float f10 = (float)rectangle2D2.getWidth();
                float f11 = (float)rectangle2D2.getHeight();
                float f12 = 0.0f;
                float f13 = 0.0f;
                float f14 = 0.0f;
                if (f5 == 0.0f) {
                    f12 = f7 - 0.5f * f8;
                } else {
                    if (f5 != 0.5235988f) throw new Error();
                    if (n == 0) {
                        f12 = f7 - f10 * (float)Math.cos(f5);
                    } else {
                        if (n != 1) throw new Error();
                        f12 = f7 - f11 * (float)Math.sin(f5);
                    }
                }
                if (n == 0) {
                    f14 = f2 + f4 + f6;
                } else {
                    if (n != 1) throw new Error();
                    f14 = f2 - f6 - f9;
                }
                tickLabelStringElement.setLocation(f12, f14);
                float f15 = (float)tickLabelStringElement.getElementBounds().getY();
                f13 = f14 + (f14 - f15);
                sGTuple2fArray[i].setValues(f12, f13);
            }
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            super.setLocation(sGTuple2fArray);
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            SGAxis sGAxis = elementGroupSetInSXYGraph.mXAxis;
            SGSXYData sGSXYData = (SGSXYData)SGSXYGraphElement.this.getData(elementGroupSetInSXYGraph);
            for (int i = 0; i < sGTuple2fArray.length; ++i) {
                double d = sGSXYData.getXValue(i);
                TickLabelStringElement tickLabelStringElement = (TickLabelStringElement)this.mDrawingElementArray[i];
                tickLabelStringElement.setVisible(sGAxis.insideRange(d));
            }
            return true;
        }

        public String getTagName() {
            return "TickLabels";
        }

        static /* synthetic */ SGTuple2f[] access$202(ElementGroupTickLabelStringElement elementGroupTickLabelStringElement, SGTuple2f[] sGTuple2fArray) {
            elementGroupTickLabelStringElement.mPointsArray = sGTuple2fArray;
            return sGTuple2fArray;
        }
    }

    class ElementGroupErrorBar
    extends SGElementGroupErrorBar {
        protected SGTuple2f[] mStartArray = null;
        protected SGTuple2f[] mEndArray = null;

        protected ElementGroupErrorBar() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            this.setLineType(1);
            this.setHeadSize(7.0866146f);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Transverse Line");
            if (n == null) {
                return false;
            }
            this.setStartHeadType(n);
            this.setEndHeadType(n);
            this.setHeadEdgeLineWidth(1.0f);
            Integer n2 = ElementGroupErrorBar.getErrorBarStyleFromName("Bothsides");
            if (n2 == null) {
                return false;
            }
            this.mErrorBarStyle = n2;
            this.setColor(SGDefaultValues.ERROR_BAR_COLOR);
            return true;
        }

        private boolean calcErrorBarLocation(SGSXYData sGSXYData, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
            double d;
            int n;
            int n2 = sGSXYData.getPointsNumber();
            SGTuple2d[] sGTuple2dArray = new SGTuple2d[n2];
            SGTuple2d[] sGTuple2dArray2 = new SGTuple2d[n2];
            for (n = 0; n < n2; ++n) {
                sGTuple2dArray[n] = new SGTuple2d();
                sGTuple2dArray2[n] = new SGTuple2d();
                sGTuple2dArray[n].x = d = sGSXYData.getXValue(n).doubleValue();
                sGTuple2dArray2[n].x = d;
            }
            if (this.mErrorBarStyle == 0) {
                for (n = 0; n < n2; ++n) {
                    d = sGSXYData.getYValue(n);
                    double d2 = sGSXYData.getLowerErrorValue(n);
                    double d3 = sGSXYData.getUpperErrorValue(n);
                    sGTuple2dArray[n].y = d + d2;
                    sGTuple2dArray2[n].y = d + d3;
                }
            } else if (this.mErrorBarStyle == 1) {
                for (n = 0; n < n2; ++n) {
                    d = sGSXYData.getYValue(n);
                    double d4 = sGSXYData.getUpperErrorValue(n);
                    sGTuple2dArray[n].y = d;
                    sGTuple2dArray2[n].y = d + d4;
                }
            } else if (this.mErrorBarStyle == 2) {
                for (n = 0; n < n2; ++n) {
                    d = sGSXYData.getYValue(n);
                    double d5 = sGSXYData.getLowerErrorValue(n);
                    sGTuple2dArray[n].y = d + d5;
                    sGTuple2dArray2[n].y = d;
                }
            } else {
                throw new Error();
            }
            SGSXYGraphElement.this.calcLocationOfVXYData(sGTuple2dArray, sGTuple2dArray2, sGAxis, sGAxis2, sGTuple2fArray, sGTuple2fArray2);
            return true;
        }

        protected boolean setDialogProperty() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setErrorBarVisible(this.isVisible());
            String string = null;
            if (this.mErrorBarStyle == 0 || this.mErrorBarStyle == 2) {
                string = ElementGroupErrorBar.getSymbolTypeName(this.mStartHeadType);
            } else if (this.mErrorBarStyle == 1) {
                string = ElementGroupErrorBar.getSymbolTypeName(this.mEndHeadType);
            }
            sGPropertyDialogSXYData.setErrorBarType(string);
            sGPropertyDialogSXYData.setErrorBarSymbolSize(new Float(this.mHeadSize * 0.035277776f));
            sGPropertyDialogSXYData.setErrorBarLineWidth(new Float(this.mLineWidth));
            sGPropertyDialogSXYData.setErrorBarColorList(this.mColorList);
            sGPropertyDialogSXYData.setErrorBarStyle(new Integer(this.mErrorBarStyle));
            return true;
        }

        protected SGElementGroup.ElementGroupProperties getPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGElementGroupErrorBar.ErrorBarProperties errorBarProperties = sGPropertyDialogSXYData.getErrorBarProperties();
            return errorBarProperties;
        }
    }

    class ElementGroupSymbol
    extends SGElementGroupSymbol
    implements SGGraphElement.IElementGroupInGraph {
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupSymbol() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Circle");
            if (n == null) {
                return false;
            }
            this.setType(n);
            this.setSize(8.503938f);
            this.setColor(SGDefaultValues.SYMBOL_BODY_COLOR);
            this.setLineWidth(1.0f);
            this.setLineColor(SGDefaultValues.SYMBOL_LINE_COLOR);
            return true;
        }

        private boolean drawRectangle(Shape shape, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            graphics2D.setPaint(Color.black);
            graphics2D.setStroke(new BasicStroke(1.0f));
            int n = (int)rectangle2D.getX();
            int n2 = (int)rectangle2D.getY();
            int n3 = (int)rectangle2D.getWidth();
            int n4 = (int)rectangle2D.getHeight();
            graphics2D.drawRect(n, n2, n3, n4);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            block4: {
                super.paintElement(graphics2D, rectangle2D);
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
                SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
                if (!this.isFocused() || !SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects || elementGroupSetInSXYGraph.isBarVisible()) break block4;
                int n = sGDrawingElementArray.length;
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[i];
                        this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[n3];
                        this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        private boolean emphasisSymbol(SGDrawingElementSymbol2D sGDrawingElementSymbol2D, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = sGDrawingElementSymbol2D.getElementBounds();
            Point2D.Float float_ = new Point2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY());
            Point2D.Float float_2 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)rectangle2D.getY());
            Point2D.Float float_3 = new Point2D.Float((float)rectangle2D.getX(), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            Point2D.Float float_4 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_2, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_3, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_4, graphics2D);
            return true;
        }

        protected boolean setDialogProperty() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setSymbolVisible(this.isVisible());
            sGPropertyDialogSXYData.setSymbolType(new Integer(this.mSymbolType));
            sGPropertyDialogSXYData.setSymbolSize(new Float(this.mSymbolSize * 0.035277776f));
            sGPropertyDialogSXYData.setSymbolLineWidth(new Float(this.mLineWidth));
            sGPropertyDialogSXYData.setSymbolColorList(this.mColorList);
            sGPropertyDialogSXYData.setSymbolLineColor(this.mLineColor);
            return true;
        }

        protected SGElementGroup.ElementGroupProperties getPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGElementGroupSymbol.SymbolProperties symbolProperties = sGPropertyDialogSXYData.getSymbolProperties();
            return symbolProperties;
        }
    }

    class ElementGroupBar
    extends SGElementGroupBar
    implements SGGraphElement.IElementGroupInGraph {
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupBar() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setBaselineValue(0.0);
            this.setRectangleWidth(14.173229f);
            this.setColor(SGDefaultValues.BAR_COLOR);
            this.setEdgeLineWidth(0.5f);
            this.setEdgeLineColor(SGDefaultValues.BAR_LINE_COLOR);
            return true;
        }

        private float getBaselineLocation(double d) {
            SGAxis sGAxis = ((ElementGroupSetInSXYGraph)this.mGroupSet).getYAxis();
            return SGSXYGraphElement.this.calcLocation(d, sGAxis, false);
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            if (this.mDrawingElementArray == null) {
                return true;
            }
            float f = SGSXYGraphElement.this.mGraphRectX;
            float f2 = SGSXYGraphElement.this.mGraphRectY;
            float f3 = SGSXYGraphElement.this.mGraphRectWidth;
            float f4 = SGSXYGraphElement.this.mGraphRectHeight;
            float f5 = this.getBaselineLocation(this.mBaselineValue);
            boolean bl = true;
            if (Float.isInfinite(f5) || Float.isNaN(f5)) {
                bl = false;
            }
            float f6 = this.mMagnification * this.mRectangleWidth;
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementArray[i];
                float f7 = f5;
                SGTuple2f sGTuple2f = sGTuple2fArray[i];
                float f8 = sGTuple2f.y;
                if (Float.isInfinite(f8) || Float.isNaN(f8)) {
                    if (bl) {
                        f8 = f5;
                        f7 = f2 + f4;
                        continue;
                    }
                    sGDrawingElementBar2D.setVisible(false);
                    continue;
                }
                if (!bl) {
                    f7 = f2 + f4;
                }
                float f9 = sGTuple2f.x - 0.5f * f6;
                float f10 = 0.0f;
                float f11 = 0.0f;
                if (f8 <= f7) {
                    f10 = f8;
                    f11 = f7 - f8;
                } else {
                    f10 = f7;
                    f11 = f8 - f7;
                }
                sGDrawingElementBar2D.setVisible(true);
                sGDrawingElementBar2D.setBounds(f9, f10, f6, f11);
            }
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            block4: {
                super.paintElement(graphics2D, rectangle2D);
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSet;
                SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
                if (!this.isFocused() || !SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects) break block4;
                int n = sGDrawingElementArray.length;
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                        this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[n3];
                        this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        private boolean emphasisBar(SGDrawingElementBar2D sGDrawingElementBar2D, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = sGDrawingElementBar2D.getElementBounds();
            Point2D.Float float_ = new Point2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY());
            Point2D.Float float_2 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)rectangle2D.getY());
            Point2D.Float float_3 = new Point2D.Float((float)rectangle2D.getX(), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            Point2D.Float float_4 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_2, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_3, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_4, graphics2D);
            return true;
        }

        protected boolean setDialogProperty() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setBarVisible(this.isVisible());
            sGPropertyDialogSXYData.setBarWidth(new Float(this.mRectangleWidth * 0.035277776f));
            sGPropertyDialogSXYData.setBarEdgeLineWidth(new Float(this.mEdgeLineWidth));
            sGPropertyDialogSXYData.setBarBaselineValue(new Double(this.mBaselineValue));
            sGPropertyDialogSXYData.setBarInnerColorList(this.mColorList);
            sGPropertyDialogSXYData.setBarEdgeLineColor(this.mEdgeLineColor);
            return true;
        }

        protected SGElementGroup.ElementGroupProperties getPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGElementGroupBar.BarProperties barProperties = sGPropertyDialogSXYData.getBarProperties();
            return barProperties;
        }
    }

    class ElementGroupLine
    extends SGElementGroupLine
    implements SGGraphElement.IElementGroupInGraph {
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupLine() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            Integer n = SGDrawingElementLine.getLineTypeFromName("Solid");
            if (n == null) {
                return false;
            }
            this.setLineType(n);
            this.setColor(SGDefaultValues.LINE_COLOR);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            return this.setLocation_(sGTuple2fArray, false);
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            super.paintElement(graphics2D, rectangle2D);
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            if (this.isFocused() && SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects && !elementGroupSetInSXYGraph.isSymbolVisible() && !elementGroupSetInSXYGraph.isBarVisible()) {
                ArrayList arrayList = this.mConnectedPathList;
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n;
                    GeneralPath generalPath = (GeneralPath)arrayList.get(i);
                    int n2 = 0;
                    ArrayList<Point2D.Float> arrayList2 = new ArrayList<Point2D.Float>();
                    PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
                    float[] fArray = new float[6];
                    pathIterator.currentSegment(fArray);
                    Point2D.Float float_ = new Point2D.Float(fArray[0], fArray[1]);
                    pathIterator.next();
                    while (!pathIterator.isDone()) {
                        pathIterator.currentSegment(fArray);
                        Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                        ((Point2D)float_2).setLocation((((Point2D)float_).getX() + ((Point2D)float_2).getX()) / 2.0, (((Point2D)float_).getY() + ((Point2D)float_2).getY()) / 2.0);
                        ((Point2D)float_).setLocation(fArray[0], fArray[1]);
                        arrayList2.add(float_2);
                        pathIterator.next();
                        ++n2;
                    }
                    if (n2 <= 8) {
                        for (n = 0; n < n2; ++n) {
                            Point2D point2D = (Point2D)arrayList2.get(n);
                            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(point2D, graphics2D);
                        }
                        continue;
                    }
                    n = n2 / 8;
                    int n3 = 0;
                    do {
                        Point2D point2D = (Point2D)arrayList2.get(n3);
                        SGSXYGraphElement.this.drawAnchorsForFocusedObjects(point2D, graphics2D);
                    } while ((n3 += n) < n2);
                }
            }
            return true;
        }

        protected boolean setDialogProperty() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setLineVisible(this.isVisible());
            sGPropertyDialogSXYData.setLineWidth(new Float(this.mLineWidth));
            sGPropertyDialogSXYData.setLineType(new Integer(this.mLineType));
            sGPropertyDialogSXYData.setLineColorList(this.mColorList);
            return true;
        }

        protected SGElementGroup.ElementGroupProperties getPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGElementGroupLine.LineProperties lineProperties = sGPropertyDialogSXYData.getLineProperties();
            return lineProperties;
        }
    }

    class ElementGroupSetInSXYGraph
    extends SGGraphElement.ElementGroupSetInGraph
    implements IElementGroupSetInSXYGraph,
    SGIPropertySettingListenerSXYData {
        private ElementGroupErrorBar mErrorBarGroup = null;
        private ElementGroupTickLabelStringElement mTickLabels = null;
        private SGTuple2f[] mPointsArray = null;

        protected ElementGroupSetInSXYGraph() {
            this.mPopupMenu = SGSXYGraphElement.this.createGroupSetPopupMenu(this);
        }

        public String getDataClassName() {
            return "SXY";
        }

        public boolean contains(int n, int n2) {
            if (super.contains(n, n2)) {
                return true;
            }
            if (this.mErrorBarGroup != null && this.mErrorBarGroup.contains(n, n2)) {
                return true;
            }
            return this.mTickLabels != null && this.mTickLabels.contains(n, n2);
        }

        public boolean zoom(float f) {
            super.zoom(f);
            ElementGroupErrorBar elementGroupErrorBar = this.mErrorBarGroup;
            if (elementGroupErrorBar != null) {
                elementGroupErrorBar.zoom(f);
            }
            if (this.mTickLabels != null) {
                this.mTickLabels.zoom(f);
            }
            return true;
        }

        public ArrayList getLineGroups() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                Object e = this.mDrawingElementGroupList.get(i);
                if (!(e instanceof SGElementGroupLine)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }

        public ArrayList getSymbolGroups() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                Object e = this.mDrawingElementGroupList.get(i);
                if (!(e instanceof SGElementGroupSymbol)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }

        public ArrayList getBarGroups() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                Object e = this.mDrawingElementGroupList.get(i);
                if (!(e instanceof SGElementGroupBar)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }

        public ArrayList getErrorBarGroups() {
            ArrayList<ElementGroupErrorBar> arrayList = new ArrayList<ElementGroupErrorBar>();
            if (this.mErrorBarGroup != null) {
                arrayList.add(this.mErrorBarGroup);
            }
            return arrayList;
        }

        public ArrayList getTickLabelGroups() {
            ArrayList<ElementGroupTickLabelStringElement> arrayList = new ArrayList<ElementGroupTickLabelStringElement>();
            if (this.mTickLabels != null) {
                arrayList.add(this.mTickLabels);
            }
            return arrayList;
        }

        public boolean setLineProperties(SGProperties sGProperties) {
            return this.setProperties(this.getLineGroups(), sGProperties);
        }

        public boolean setSymbolProperties(SGProperties sGProperties) {
            return this.setProperties(this.getSymbolGroups(), sGProperties);
        }

        public boolean setBarProperties(SGProperties sGProperties) {
            return this.setProperties(this.getBarGroups(), sGProperties);
        }

        public boolean setErrorBarProperties(SGProperties sGProperties) {
            return this.setProperties(this.getErrorBarGroups(), sGProperties);
        }

        public boolean setTickLabelProperties(SGProperties sGProperties) {
            return this.setProperties(this.getTickLabelGroups(), sGProperties);
        }

        private boolean setProperties(ArrayList arrayList, SGProperties sGProperties) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (sGElementGroup.setProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        public int getXAxisConfiguration() {
            return SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.mXAxis);
        }

        public int getYAxisConfiguration() {
            return SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.mYAxis);
        }

        public boolean addDrawingElementGroup(int n) {
            SGElementGroupSXY sGElementGroupSXY = null;
            if (n == 0) {
                sGElementGroupSXY = new ElementGroupLine();
            } else if (n == 2) {
                sGElementGroupSXY = new ElementGroupBar();
            } else if (n == 1) {
                sGElementGroupSXY = new ElementGroupSymbol();
            } else {
                throw new Error("");
            }
            if (!this.checkGroupType(sGElementGroupSXY)) {
                return false;
            }
            this.addElementGroup(sGElementGroupSXY);
            return true;
        }

        public boolean addDrawingElementGroup(SGDrawingElement sGDrawingElement) {
            SGElementGroupSXY sGElementGroupSXY = null;
            if (sGDrawingElement instanceof SGDrawingElementLine) {
                sGElementGroupSXY = new ElementGroupLine();
            } else if (sGDrawingElement instanceof SGDrawingElementRectangle) {
                sGElementGroupSXY = new ElementGroupBar();
            } else if (sGDrawingElement instanceof SGDrawingElementSymbol) {
                sGElementGroupSXY = new ElementGroupSymbol();
            } else {
                throw new Error("");
            }
            if (!this.checkGroupType(sGElementGroupSXY)) {
                return false;
            }
            sGElementGroupSXY.setProperty(sGDrawingElement);
            sGElementGroupSXY.setMagnification(this.mMagnification);
            this.addElementGroup(sGElementGroupSXY);
            return true;
        }

        private boolean checkGroupType(SGElementGroup sGElementGroup) {
            Class<?> clazz = sGElementGroup.getClass();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup2 = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                Class<?> clazz2 = sGElementGroup2.getClass();
                if (!clazz.equals(clazz2)) continue;
                System.out.println("\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\uff01");
                return false;
            }
            return true;
        }

        protected boolean isLineVisible() {
            ArrayList arrayList = this.getLineGroups();
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(0);
            return sGElementGroup.isVisible();
        }

        protected boolean isSymbolVisible() {
            ArrayList arrayList = this.getSymbolGroups();
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(0);
            return sGElementGroup.isVisible();
        }

        protected boolean isBarVisible() {
            ArrayList arrayList = this.getBarGroups();
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(0);
            return sGElementGroup.isVisible();
        }

        public boolean setDrawingElementsLocation(SGData sGData) {
            SGTuple2f[] sGTuple2fArray;
            if (!(sGData instanceof SGSXYData)) {
                return false;
            }
            SGSXYData sGSXYData = (SGSXYData)sGData;
            int n = sGSXYData.getPointsNumber();
            if (!SGSXYGraphElement.this.calcLocationOfSXYData(sGSXYData, this.mXAxis, this.mYAxis, this.mPointsArray)) {
                return false;
            }
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                sGTuple2fArray = (SGTuple2f[])this.mDrawingElementGroupList.get(i);
                if (!sGTuple2fArray.isVisible() || sGTuple2fArray.setLocation(this.mPointsArray)) continue;
                return false;
            }
            if (this.mErrorBarGroup != null && this.mErrorBarGroup.isVisible()) {
                SGTuple2f[] sGTuple2fArray2 = this.mErrorBarGroup.mStartArray;
                sGTuple2fArray = this.mErrorBarGroup.mEndArray;
                if (!this.mErrorBarGroup.calcErrorBarLocation(sGSXYData, this.mXAxis, this.mYAxis, sGTuple2fArray2, sGTuple2fArray)) {
                    return false;
                }
                if (!this.mErrorBarGroup.setLocation(sGTuple2fArray2, sGTuple2fArray)) {
                    return false;
                }
            }
            if (this.mTickLabels != null && this.mTickLabels.isVisible()) {
                SGTuple2f[] sGTuple2fArray3 = this.mTickLabels.mPointsArray;
                if (!this.mTickLabels.calcTickLabelLocation(sGSXYData, this.mXAxis, sGTuple2fArray3)) {
                    return false;
                }
                if (!this.mTickLabels.setLocation(sGTuple2fArray3)) {
                    return false;
                }
            }
            return true;
        }

        protected boolean createDrawingElements() {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroupSXY sGElementGroupSXY = (SGElementGroupSXY)arrayList.get(i);
                if (!sGElementGroupSXY.isVisible()) continue;
                sGElementGroupSXY.setLocation(this.mPointsArray);
            }
            SGSXYData sGSXYData = (SGSXYData)SGSXYGraphElement.this.getData(this);
            if (this.mErrorBarGroup != null && this.mErrorBarGroup.mVisibleFlag) {
                this.mErrorBarGroup.setLocation(this.mErrorBarGroup.mStartArray, this.mErrorBarGroup.mEndArray);
            }
            if (this.mTickLabels != null && this.mTickLabels.mVisibleFlag) {
                this.mTickLabels.setLocation(this.mTickLabels.mPointsArray);
            }
            return true;
        }

        private boolean addElementGroup(SGElementGroupSXY sGElementGroupSXY) {
            sGElementGroupSXY.mGroupSet = this;
            if (!sGElementGroupSXY.initDrawingElement(this.mPointsArray)) {
                throw new Error();
            }
            if (!sGElementGroupSXY.setPropertiesOfDrawingElements()) {
                return false;
            }
            this.mDrawingElementGroupList.add(sGElementGroupSXY);
            return true;
        }

        public Rectangle2D getTickLabelsBoundingBox(SGData sGData) {
            if (!(sGData instanceof SGSXYData)) {
                return null;
            }
            SGSXYData sGSXYData = (SGSXYData)sGData;
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            ElementGroupTickLabelStringElement elementGroupTickLabelStringElement = this.mTickLabels;
            if (elementGroupTickLabelStringElement == null) {
                return new Rectangle2D.Float();
            }
            if (!elementGroupTickLabelStringElement.isVisible()) {
                return new Rectangle2D.Float();
            }
            ArrayList<SGDrawingElement> arrayList2 = new ArrayList<SGDrawingElement>();
            SGDrawingElement[] sGDrawingElementArray = elementGroupTickLabelStringElement.mDrawingElementArray;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                if (!sGDrawingElementArray[i].isVisible()) continue;
                arrayList2.add(sGDrawingElementArray[i]);
            }
            Rectangle2D rectangle2D = SGUtilityJava2D.getBoundingBox(arrayList2);
            arrayList.add(rectangle2D);
            Rectangle2D rectangle2D2 = SGUtility.createUnion(arrayList);
            return rectangle2D2;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ElementGroupSymbol elementGroupSymbol;
            ElementGroupLine elementGroupLine;
            ElementGroupErrorBar elementGroupErrorBar;
            ElementGroupBar elementGroupBar;
            Rectangle2D rectangle2D = null;
            if (!this.getClipFlag()) {
                rectangle2D = SGSXYGraphElement.this.getGraphRect();
            }
            if ((elementGroupBar = SGSXYGraphElement.this.getGroupBar(this)) != null && elementGroupBar.isVisible()) {
                elementGroupBar.paintElement(graphics2D, rectangle2D);
            }
            if ((elementGroupErrorBar = this.mErrorBarGroup) != null && elementGroupErrorBar.isVisible()) {
                elementGroupErrorBar.paintElement(graphics2D, rectangle2D);
            }
            if ((elementGroupLine = SGSXYGraphElement.this.getGroupLine(this)) != null && elementGroupLine.isVisible()) {
                elementGroupLine.paintElement(graphics2D, rectangle2D);
            }
            if ((elementGroupSymbol = SGSXYGraphElement.this.getGroupSymbol(this)) != null && elementGroupSymbol.isVisible()) {
                elementGroupSymbol.paintElement(graphics2D, rectangle2D);
            }
        }

        public boolean paintDataString(Graphics2D graphics2D) {
            Rectangle2D rectangle2D = SGSXYGraphElement.this.getGraphRect();
            ElementGroupTickLabelStringElement elementGroupTickLabelStringElement = this.mTickLabels;
            if (elementGroupTickLabelStringElement != null && elementGroupTickLabelStringElement.isVisible()) {
                elementGroupTickLabelStringElement.paintElement(graphics2D);
            }
            return true;
        }

        public boolean setPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            if (!(sGPropertyDialogSXYData.getLineVisible() || sGPropertyDialogSXYData.getBarVisible() || sGPropertyDialogSXYData.getSymbolVisible())) {
                JOptionPane.showMessageDialog(sGPropertyDialogSXYData, SGSXYGraphElement.MSG_NOT_HIDE_ALL_ELEMENTS);
                return false;
            }
            return this.setPropertyWithDialog_();
        }

        private boolean setPropertyWithDialog_() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            this.setAxisPropertyWithDialog();
            this.setVisibleInLegend();
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroupLine sGElementGroupLine = (SGElementGroupLine)arrayList.get(i);
                if (!sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getLinePanel()) || sGPropertyDialogSXYData.setLineProperties(sGElementGroupLine)) continue;
                return false;
            }
            ArrayList arrayList2 = this.getSymbolGroups();
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroupSymbol sGElementGroupSymbol = (SGElementGroupSymbol)arrayList2.get(i);
                if (!sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getSymbolPanel()) || sGPropertyDialogSXYData.setSymbolProperties(sGElementGroupSymbol)) continue;
                return false;
            }
            ArrayList arrayList3 = this.getBarGroups();
            for (int i = 0; i < arrayList3.size(); ++i) {
                SGElementGroupBar sGElementGroupBar = (SGElementGroupBar)arrayList3.get(i);
                if (!sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getBarPanel()) || sGPropertyDialogSXYData.setBarProperties(sGElementGroupBar)) continue;
                return false;
            }
            if (this.mErrorBarGroup != null && sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getErrorBarPanel()) && !sGPropertyDialogSXYData.setErrorBarProperties(this.mErrorBarGroup)) {
                return false;
            }
            return this.mTickLabels == null || !sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getTickLabelPanel()) || sGPropertyDialogSXYData.setTickLabelProperties(this.mTickLabels);
        }

        private boolean setAxisPropertyWithDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGAxis sGAxis = SGSXYGraphElement.this.mAxisElement.getAxisInPlane(0);
            SGAxis sGAxis2 = SGSXYGraphElement.this.mAxisElement.getAxisInPlane(1);
            SGAxis sGAxis3 = SGSXYGraphElement.this.mAxisElement.getAxisInPlane(2);
            SGAxis sGAxis4 = SGSXYGraphElement.this.mAxisElement.getAxisInPlane(3);
            if (sGPropertyDialogSXYData.isLeftBottomSelected()) {
                this.mXAxis = sGAxis;
                this.mYAxis = sGAxis3;
            } else if (sGPropertyDialogSXYData.isLeftTopSelected()) {
                this.mXAxis = sGAxis2;
                this.mYAxis = sGAxis3;
            } else if (sGPropertyDialogSXYData.isRightBottomSelected()) {
                this.mXAxis = sGAxis;
                this.mYAxis = sGAxis4;
            } else if (sGPropertyDialogSXYData.isRightTopSelected()) {
                this.mXAxis = sGAxis2;
                this.mYAxis = sGAxis4;
            }
            return true;
        }

        private boolean setVisibleInLegend() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            Boolean bl = sGPropertyDialogSXYData.getLegendVisible();
            if (bl != null) {
                this.setVisibleInLegend(bl);
            }
            return true;
        }

        public boolean createTemporaryPropertyObject() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public Element createElement(Document document) {
            Element element;
            String string;
            Element element2 = super.createElement(document);
            if (element2 == null) {
                return null;
            }
            if (this.mErrorBarGroup != null) {
                string = this.mErrorBarGroup.getTagName();
                element = document.createElement(string);
                if (!this.mErrorBarGroup.writeProperty(element)) {
                    return null;
                }
                element2.appendChild(element);
            }
            if (this.mTickLabels != null) {
                string = this.mTickLabels.getTagName();
                element = document.createElement(string);
                if (!this.mTickLabels.writeProperty(element)) {
                    return null;
                }
                element2.appendChild(element);
            }
            return element2;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.mXAxis);
            int n2 = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.mYAxis);
            String string = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n);
            String string2 = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n2);
            element.setAttribute("XAxisPosition", string);
            element.setAttribute("YAxisPosition", string2);
            return true;
        }

        public SGProperties getProperties() {
            ElementGroupSetInSXYGraphProperties elementGroupSetInSXYGraphProperties = new ElementGroupSetInSXYGraphProperties();
            if (!this.getProperties(elementGroupSetInSXYGraphProperties)) {
                return null;
            }
            return elementGroupSetInSXYGraphProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetInSXYGraphProperties)) {
                return false;
            }
            super.getProperties(sGProperties);
            ElementGroupSetInSXYGraphProperties elementGroupSetInSXYGraphProperties = (ElementGroupSetInSXYGraphProperties)sGProperties;
            if (this.mErrorBarGroup != null) {
                elementGroupSetInSXYGraphProperties.errorBarProperties = this.mErrorBarGroup.getProperties();
            }
            if (this.mTickLabels != null) {
                elementGroupSetInSXYGraphProperties.tickLabelsProperties = this.mTickLabels.getProperties();
            }
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGGraphElement.ElementGroupSetInGraph.ElementGroupSetInGraphProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            ElementGroupSetInSXYGraphProperties elementGroupSetInSXYGraphProperties = (ElementGroupSetInSXYGraphProperties)sGProperties;
            if (this.mErrorBarGroup != null) {
                this.mErrorBarGroup.setProperties(elementGroupSetInSXYGraphProperties.errorBarProperties);
            }
            if (this.mTickLabels != null) {
                this.mTickLabels.setProperties(elementGroupSetInSXYGraphProperties.tickLabelsProperties);
            }
            return true;
        }

        static /* synthetic */ SGTuple2f[] access$002(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGTuple2f[] sGTuple2fArray) {
            elementGroupSetInSXYGraph.mPointsArray = sGTuple2fArray;
            return sGTuple2fArray;
        }

        class ElementGroupSetInSXYGraphProperties
        extends SGGraphElement.ElementGroupSetInGraph.ElementGroupSetInGraphProperties {
            SGProperties errorBarProperties;
            SGProperties tickLabelsProperties;

            ElementGroupSetInSXYGraphProperties() {
            }

            public boolean equals(Object object) {
                if (!(object instanceof ElementGroupSetInSXYGraphProperties)) {
                    return false;
                }
                if (!super.equals(object)) {
                    return false;
                }
                ElementGroupSetInSXYGraphProperties elementGroupSetInSXYGraphProperties = (ElementGroupSetInSXYGraphProperties)object;
                if (elementGroupSetInSXYGraphProperties.errorBarProperties == null ? this.errorBarProperties != null : !elementGroupSetInSXYGraphProperties.errorBarProperties.equals(this.errorBarProperties)) {
                    return false;
                }
                return !(elementGroupSetInSXYGraphProperties.tickLabelsProperties == null ? this.tickLabelsProperties != null : !elementGroupSetInSXYGraphProperties.tickLabelsProperties.equals(this.tickLabelsProperties));
            }

            public String toString() {
                String string = new String("[");
                string = string + super.toString();
                string = this.errorBarProperties != null ? string + this.errorBarProperties.toString() : string + "ErrorBars_empty, ";
                string = this.tickLabelsProperties != null ? string + this.tickLabelsProperties.toString() : string + "TickLabels_empty, ";
                string = string + new String("]");
                return string;
            }
        }
    }

    class ElementGroupSetForMultipleDataInSXYGraph
    extends SGGraphElement.ElementGroupSetForMultipleData
    implements ActionListener,
    IElementGroupSetInSXYGraph,
    SGIPropertySettingListenerSXYData {
        protected ElementGroupSetForMultipleDataInSXYGraph() {
            this.mPopupMenu = SGSXYGraphElement.this.createGroupSetPopupMenu(this);
        }

        public String getDataClassName() {
            SGData sGData = SGSXYGraphElement.this.getData(this);
            String string = null;
            string = sGData instanceof SGSXYSamplingData ? "SXY_SAMPLING" : "SXY_MULTIPLE";
            return string;
        }

        protected boolean createDrawingElements() {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                if (elementGroupSetInGraph.createDrawingElements()) continue;
                return false;
            }
            return true;
        }

        public boolean setDrawingElementsLocation(SGData sGData) {
            if (!(sGData instanceof SGSXYMultipleData)) {
                return false;
            }
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
            SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                if (iElementGroupSetInSXYGraph.setDrawingElementsLocation(sGSXYDataArray[i])) continue;
                return false;
            }
            return true;
        }

        public Rectangle2D getTickLabelsBoundingBox(SGData sGData) {
            if (!(sGData instanceof SGSXYMultipleData)) {
                return null;
            }
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
            SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                Rectangle2D rectangle2D = iElementGroupSetInSXYGraph.getTickLabelsBoundingBox(sGSXYDataArray[i]);
                if (rectangle2D == null) {
                    return null;
                }
                arrayList.add(rectangle2D);
            }
            Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
            return rectangle2D;
        }

        public boolean paintDataString(Graphics2D graphics2D) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                iElementGroupSetInSXYGraph.paintDataString(graphics2D);
            }
            return true;
        }

        public boolean createTemporaryPropertyObject() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public boolean setPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            if (!(sGPropertyDialogSXYData.getLineVisible() || sGPropertyDialogSXYData.getBarVisible() || sGPropertyDialogSXYData.getSymbolVisible())) {
                JOptionPane.showMessageDialog(sGPropertyDialogSXYData, SGSXYGraphElement.MSG_NOT_HIDE_ALL_ELEMENTS);
                return false;
            }
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                if (elementGroupSetInSXYGraph.setPropertyWithDialog_()) continue;
                return false;
            }
            return true;
        }

        protected boolean recover() {
            return this.setWholeProperties(this.mTemporaryProperties);
        }

        protected boolean clickDrawingElements(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (!this.contains(n2, n = mouseEvent.getY())) {
                return false;
            }
            if ((!SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() != 1) && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                this.showPropertyDialog();
            }
            return true;
        }

        public SGProperties getProperties() {
            ElementGroupSetPropertiesForSamplingDataInSXYGraph elementGroupSetPropertiesForSamplingDataInSXYGraph = new ElementGroupSetPropertiesForSamplingDataInSXYGraph();
            if (!this.getProperties(elementGroupSetPropertiesForSamplingDataInSXYGraph)) {
                return null;
            }
            return elementGroupSetPropertiesForSamplingDataInSXYGraph;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetPropertiesForSamplingDataInSXYGraph)) {
                return false;
            }
            ElementGroupSetPropertiesForSamplingDataInSXYGraph elementGroupSetPropertiesForSamplingDataInSXYGraph = (ElementGroupSetPropertiesForSamplingDataInSXYGraph)sGProperties;
            elementGroupSetPropertiesForSamplingDataInSXYGraph.samplingRate = this.getSamplingRate();
            return true;
        }

        public double getSamplingRate() {
            SGData sGData = SGSXYGraphElement.this.getData(this);
            SGSXYSamplingData sGSXYSamplingData = (SGSXYSamplingData)sGData;
            return sGSXYSamplingData.getSamplingRate();
        }

        public SGProperties getWholeProperties() {
            SGElementGroupSet.WholeProperties wholeProperties;
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(0);
            if (!elementGroupSetInSXYGraph.getWholeProperties(wholeProperties = new SGElementGroupSet.WholeProperties())) {
                return null;
            }
            return wholeProperties;
        }

        public boolean setWholeProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSet.WholeProperties)) {
                return false;
            }
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)sGProperties;
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                if (elementGroupSetInSXYGraph.setWholeProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(0);
            ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                Element element2 = sGElementGroup.createElement(document);
                if (element2 == null) {
                    return null;
                }
                element.appendChild(element2);
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)SGSXYGraphElement.this.getData(this);
            if (!super.writeProperty(element)) {
                return false;
            }
            if (sGSXYMultipleData instanceof SGSXYSamplingData) {
                double d = this.getSamplingRate();
                element.setAttribute("SamplingRate", Double.toString(d));
            }
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.mXAxis);
            int n2 = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.mYAxis);
            String string = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n);
            String string2 = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n2);
            element.setAttribute("XAxisPosition", string);
            element.setAttribute("YAxisPosition", string2);
            return true;
        }

        public ArrayList getLineGroups() {
            return this.getFirst().getLineGroups();
        }

        public ArrayList getSymbolGroups() {
            return this.getFirst().getSymbolGroups();
        }

        public ArrayList getBarGroups() {
            return this.getFirst().getBarGroups();
        }

        public ArrayList getErrorBarGroups() {
            return this.getFirst().getErrorBarGroups();
        }

        public ArrayList getTickLabelGroups() {
            return this.getFirst().getTickLabelGroups();
        }

        private ElementGroupSetInSXYGraph getFirst() {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(0);
            return elementGroupSetInSXYGraph;
        }

        public boolean setLineProperties(SGProperties sGProperties) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getLineGroups());
            }
            return this.setProperties(arrayList, sGProperties);
        }

        public boolean setSymbolProperties(SGProperties sGProperties) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getSymbolGroups());
            }
            return this.setProperties(arrayList, sGProperties);
        }

        public boolean setBarProperties(SGProperties sGProperties) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getBarGroups());
            }
            return this.setProperties(arrayList, sGProperties);
        }

        public boolean setErrorBarProperties(SGProperties sGProperties) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getErrorBarGroups());
            }
            return this.setProperties(arrayList, sGProperties);
        }

        public boolean setTickLabelProperties(SGProperties sGProperties) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getTickLabelGroups());
            }
            return this.setProperties(arrayList, sGProperties);
        }

        private boolean setProperties(ArrayList arrayList, SGProperties sGProperties) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (sGElementGroup.setProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public int getXAxisConfiguration() {
            return SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.mXAxis);
        }

        public int getYAxisConfiguration() {
            return SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.mYAxis);
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        class ElementGroupSetPropertiesForSamplingDataInSXYGraph
        extends SGGraphElement.ElementGroupSetInGraph.ElementGroupSetInGraphProperties {
            double samplingRate;

            ElementGroupSetPropertiesForSamplingDataInSXYGraph() {
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (!(object instanceof ElementGroupSetPropertiesForSamplingDataInSXYGraph)) {
                    return false;
                }
                ElementGroupSetPropertiesForSamplingDataInSXYGraph elementGroupSetPropertiesForSamplingDataInSXYGraph = (ElementGroupSetPropertiesForSamplingDataInSXYGraph)object;
                return elementGroupSetPropertiesForSamplingDataInSXYGraph.samplingRate == this.samplingRate;
            }
        }
    }

    public static interface IElementGroupSetInSXYGraph {
        public Rectangle2D getTickLabelsBoundingBox(SGData var1);

        public boolean setDrawingElementsLocation(SGData var1);

        public boolean paintDataString(Graphics2D var1);
    }
}

