/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.riken.brain.ni.samuraigraph.base.SGColorDialog;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertySettingListener;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;

public abstract class SGPropertyDialog
extends SGDialog
implements ChangeListener {
    protected ArrayList mPropertySettingListenerList = new ArrayList();
    private Icon mColorSelectionButtonEmphasisIcon = null;
    protected SGColorDialog mColorDialog = null;
    protected JButton mFocusedColorSetButton = null;
    public static final double LINE_WIDTH_MIN_VALUE = 0.25;
    public static final double LINE_WIDTH_MAX_VALUE = 6.0;
    public static final double LINE_WIDTH_STEP_SIZE = 0.25;
    public static final double FONT_SIZE_MIN_VALUE = 8.0;
    public static final double FONT_SIZE_MAX_VALUE = 96.0;
    public static final double FONT_SIZE_STEP_VALUE = 1.0;

    public SGPropertyDialog() {
        this.initialize();
    }

    public SGPropertyDialog(Dialog dialog) {
        super(dialog);
        this.initialize();
    }

    public SGPropertyDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initialize();
    }

    public SGPropertyDialog(Dialog dialog, String string) {
        super(dialog, string);
        this.initialize();
    }

    public SGPropertyDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.initialize();
    }

    public SGPropertyDialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(dialog, string, bl, graphicsConfiguration);
        this.initialize();
    }

    public SGPropertyDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    public SGPropertyDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initialize();
    }

    public SGPropertyDialog(Frame frame, String string) {
        super(frame, string);
        this.initialize();
    }

    public SGPropertyDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.initialize();
    }

    public SGPropertyDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, string, bl, graphicsConfiguration);
        this.initialize();
    }

    private boolean initialize() {
        this.mColorDialog = new SGColorDialog(this, "Color Dialog", false);
        this.mColorDialog.pack();
        this.mColorDialog.setResizable(false);
        JColorChooser jColorChooser = this.mColorDialog.getColorChooser();
        ColorSelectionModel colorSelectionModel = jColorChooser.getSelectionModel();
        colorSelectionModel.addChangeListener(this);
        this.mColorSelectionButtonEmphasisIcon = this.createIcon("/resources/Lines.gif");
        return true;
    }

    private ImageIcon createIcon(String string) {
        if (string == null) {
            return null;
        }
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource(string);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    protected String getString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("res", Locale.JAPAN);
        String string2 = resourceBundle.getString(string);
        return string2;
    }

    public boolean setActionListener(ActionListener actionListener) {
        return true;
    }

    public boolean removeActionListener() {
        return true;
    }

    public SGColorDialog getColorDialog() {
        return this.mColorDialog;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (this.mFocusedColorSetButton != null && object instanceof ColorSelectionModel) {
            Color color = this.mColorDialog.getColorChooser().getColor();
            this.mFocusedColorSetButton.setBackground(color);
            this.mColorDialog.getColorChooser().getSelectionModel().setSelectedColor(null);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.mColorDialog.setVisible(false);
        }
    }

    public abstract ArrayList getColorSelectionComponentList();

    public abstract ArrayList getActiveComponentList();

    public abstract ArrayList getSpinnerList();

    protected ArrayList getActiveComponentListFromSpinners() {
        ArrayList<JFormattedTextField> arrayList = new ArrayList<JFormattedTextField>();
        ArrayList arrayList2 = this.getSpinnerList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList2.get(i);
            arrayList.add(sGSpinner.getFormattedTextField());
        }
        return arrayList;
    }

    public boolean setColorButtonBorder(JButton jButton, boolean bl) {
        ArrayList arrayList = this.getColorSelectionComponentList();
        for (int i = 0; i < arrayList.size(); ++i) {
            JComponent jComponent = (JComponent)arrayList.get(i);
            if (jComponent.equals(jButton) && bl) {
                MatteBorder matteBorder = new MatteBorder(this.mColorSelectionButtonEmphasisIcon);
                jButton.setBorder(matteBorder);
                continue;
            }
            jComponent.setBorder(new LineBorder(Color.BLACK, 1));
        }
        return true;
    }

    public boolean setColorButtonBorder(boolean bl) {
        this.setColorButtonBorder(this.mFocusedColorSetButton, bl);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (this.getColorSelectionComponentList().contains(object)) {
            serializable = (JButton)object;
            this.mFocusedColorSetButton = serializable;
            this.setColorButtonBorder(true);
            this.mColorDialog.setVisible(true);
        }
        serializable = this.getActiveComponentList();
        if (string.equals("OK") || ((ArrayList)serializable).contains(object)) {
            this.onOK();
        } else if (string.equals("Cancel")) {
            this.onCanceled();
        } else if (string.equals("Preview")) {
            this.onPreviewed();
        }
    }

    public SpinnerNumberModel getLineWidthSpinnerNumberModel() {
        return new SpinnerNumberModel(0.25, 0.25, 6.0, 0.25);
    }

    public SpinnerNumberModel getFontSizeSpinnerNumberModel() {
        return new SpinnerNumberModel(8.0, 8.0, 96.0, 1.0);
    }

    public boolean addPropertySettingListener(SGIPropertySettingListener sGIPropertySettingListener) {
        this.mPropertySettingListenerList.add(sGIPropertySettingListener);
        return true;
    }

    public boolean removePropertySettingListener(SGIPropertySettingListener sGIPropertySettingListener) {
        return this.mPropertySettingListenerList.remove(sGIPropertySettingListener);
    }

    public boolean removeAllPropertySettingListeners() {
        this.mPropertySettingListenerList.clear();
        return true;
    }

    public boolean removeAllWindowListener() {
        WindowListener[] windowListenerArray = this.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            this.removeWindowListener(windowListenerArray[i]);
        }
        return true;
    }

    protected boolean onOK() {
        if (!this.commit()) {
            return false;
        }
        this.setCloseOption(0);
        this.removeAllPropertySettingListeners();
        this.setVisible(false);
        this.clearAllSpinners();
        return true;
    }

    protected boolean onCanceled() {
        if (!this.cancel()) {
            return false;
        }
        this.setCloseOption(1);
        this.removeAllPropertySettingListeners();
        this.setVisible(false);
        this.clearAllSpinners();
        return true;
    }

    protected boolean onPreviewed() {
        return this.preview();
    }

    protected void clearAllSpinners() {
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.clearTemporaryValues();
        }
    }

    public boolean commit() {
        for (int i = 0; i < this.mPropertySettingListenerList.size(); ++i) {
            SGIPropertySettingListener sGIPropertySettingListener = (SGIPropertySettingListener)this.mPropertySettingListenerList.get(i);
            if (sGIPropertySettingListener.commit()) continue;
            return false;
        }
        this.setVisible(false);
        return true;
    }

    public boolean cancel() {
        for (int i = 0; i < this.mPropertySettingListenerList.size(); ++i) {
            SGIPropertySettingListener sGIPropertySettingListener = (SGIPropertySettingListener)this.mPropertySettingListenerList.get(i);
            if (sGIPropertySettingListener.cancel()) continue;
            return false;
        }
        return true;
    }

    protected boolean preview() {
        for (int i = 0; i < this.mPropertySettingListenerList.size(); ++i) {
            SGIPropertySettingListener sGIPropertySettingListener = (SGIPropertySettingListener)this.mPropertySettingListenerList.get(i);
            if (sGIPropertySettingListener.preview()) continue;
            return false;
        }
        return true;
    }

    public boolean setDialogProperty() {
        return true;
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.onCanceled();
    }
}

