/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jp.riken.brain.ni.samuraigraph.application.SGAboutDialog;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGChangeLogDialog;
import jp.riken.brain.ni.samuraigraph.application.SGDataCreator;
import jp.riken.brain.ni.samuraigraph.application.SGFigureIDSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationCommandConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIPreferencesConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIPropertyFileConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIUpgradeConstants;
import jp.riken.brain.ni.samuraigraph.application.SGImageExportManager;
import jp.riken.brain.ni.samuraigraph.application.SGMultiDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGProgressMonitorDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileCreator;
import jp.riken.brain.ni.samuraigraph.application.SGProxySettingDialog;
import jp.riken.brain.ni.samuraigraph.application.SGScrollPaneDialog;
import jp.riken.brain.ni.samuraigraph.application.SGSingleDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGSplashWindow;
import jp.riken.brain.ni.samuraigraph.application.SGUpgradeConfirmDialog;
import jp.riken.brain.ni.samuraigraph.application.SGUpgradeDialog;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGXYDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGSXYFigure;
import jp.riken.brain.ni.samuraigraph.figure.SGVXYFigure;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SGDrawingServer {
    public static String LOOK_AND_FEEL = null;
    public static int PORT_NUMBER = -1;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$figure$SGSXYFigure;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$figure$SGVXYFigure;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGVXYData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData;

    public static void main(String[] stringArray) {
        SGDrawingServer.interpretCommands(stringArray);
        Main main = new Main();
        if (PORT_NUMBER != -1) {
            try {
                main.join();
                ServerSocket serverSocket = new ServerSocket(PORT_NUMBER);
                Connect connect = new Connect(main, serverSocket);
            }
            catch (Exception exception) {
                JOptionPane.showOptionDialog(null, "Failed to start up Samurai Graph.", "Error", -1, 2, null, null, null);
            }
        }
    }

    private static void interpretCommands(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equals("-p")) {
                if (i + 1 >= stringArray.length || (object = SGUtilityText.getInteger(stringArray[i + 1])) == null) continue;
                PORT_NUMBER = (Integer)object;
                continue;
            }
            object = SGDrawingServer.getLookAndFeelClassName(stringArray[i].toLowerCase());
            if (object == null) continue;
            LOOK_AND_FEEL = object;
        }
    }

    private static String getLookAndFeelClassName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name==null");
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            String string2 = lookAndFeelInfoArray[i].getName().toLowerCase();
            if (!string2.equals(string.toLowerCase())) continue;
            LOOK_AND_FEEL = lookAndFeelInfoArray[i].getClassName();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Main
    extends Thread
    implements ActionListener,
    WindowListener,
    DropTargetListener,
    SGIConstants,
    SGIUpgradeConstants,
    SGIApplicationCommandConstants,
    SGIApplicationConstants,
    SGIPropertyFileConstants,
    SGIPreferencesConstants,
    SGIApplicationTextConstants {
        private Class mClassOfAxisElement = null;
        private Class mClassOfSXYGraphElement = null;
        private Class mClassOfVXYGraphElement = null;
        private Class mClassOfLegendElement = null;
        private Class mClassOfStringElement = null;
        private Class mClassOfAxisBreakElement = null;
        private Class mClassOfSignificantDifferenceElement = null;
        private Class mClassOfTimingLineElement = null;
        private Class mClassOfGridElement = null;
        private TreeMap mWndMap = new TreeMap();
        private SGImageExportManager mImageFileCreator;
        private SGPropertyFileCreator mPropertyFileCreator;
        private ProxyManager mProxyManager;
        private UpgradeManager mUpgradeManager;
        private SGDataCreator mDataCreator;
        public static final int MAX_WINDOW_ID = 256;
        private SGFigureIDSelectionWizardDialog mFigureIDSelectionWizardDialog = null;
        private SGMultiDataFileChooserWizardDialog mMultiDataFileChooserWizardDialog = null;
        private SGSingleDataFileChooserWizardDialog mSingleDataFileChooserWizardDilaog = null;
        private SGXYDataTypeSelectionWizardDialog mXYDataTypeSelectionWizardDialog = null;
        private SGXYDataTypeSelectionWizardDialog mXYDataTypeSelectionWizardDialogFromCLorDD = null;
        private SGPropertyFileChooserWizardDialog mPropertyFileChooserWizardDilaog = null;
        private String mCurrentDataFileName = null;
        private String mCurrentPropertyFileName = null;
        public static final String TAG_NAME_FOCUSED_FIGURES = "FocusedFigures";
        private ArrayList mCopiedObjectsBuffer = new ArrayList();
        private ArrayList mCopiedDataObjectBuffer = new ArrayList();
        private ArrayList mCopiedDataNameBuffer = new ArrayList();
        private ArrayList mCopiedDataPropertiesBuffer = new ArrayList();
        private ArrayList mCopiedDataPropertiesForLegendBuffer = new ArrayList();
        private WindowInfo mWindowInfo;
        private SGChangeLogDialog mChangeLogDialog = null;
        public static final String TITLE_FILE_CHECK = "Check the file";
        public static final int FILE_TYPE_DATA = 0;
        public static final int FILE_TYPE_PROPERTY = 1;
        public static final int FILE_TYPE_IMAGE = 2;
        private Document mPropertyFileDocument = null;
        private SGMultiDataFileChooserWizardDialog mMultiDataFileChooserWizardDialogDD = null;

        public Main() {
            this.start();
        }

        public void run() {
            LockFileManager lockFileManager = new LockFileManager(this);
            this.removeTemporaryFiles();
            SGSplashWindow sGSplashWindow = this.createSplashWindow();
            if (sGSplashWindow == null) {
                return;
            }
            sGSplashWindow.setVisible(true);
            try {
                if (LOOK_AND_FEEL == null) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                } else {
                    UIManager.setLookAndFeel(LOOK_AND_FEEL);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mDataCreator = new SGDataCreator();
            this.mPropertyFileCreator = new SGPropertyFileCreator();
            this.mImageFileCreator = new SGImageExportManager();
            this.mProxyManager = new ProxyManager();
            this.mUpgradeManager = new UpgradeManager(this.mProxyManager);
            try {
                if (!this.loadFigureElementClass()) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Failed to create instances of SGFigureElement classes.", "Error", 0);
                this.exit(0);
            }
            SGDrawingWindow sGDrawingWindow = this.createNewWindow();
            if (sGDrawingWindow == null) {
                JOptionPane.showMessageDialog(null, "Failed to create a window.", "Error", 0);
                return;
            }
            sGDrawingWindow.setVisible(true);
            sGSplashWindow.setVisible(false);
            this.updatePreferences();
            if (this.checkDate() && !this.mUpgradeManager.upgradeOnStartup(sGDrawingWindow)) {
                return;
            }
        }

        private void removeTemporaryFiles() {
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + "SamuraiGraphTemp");
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                return;
            }
            if (file.exists()) {
                SGApplicationUtility.deleteRecursively(file);
            }
        }

        private void updatePreferences() {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt("Upgrade Cycle", -1);
            if (n == -1) {
                preferences.putInt("Upgrade Cycle", 3);
            }
            String string = preferences.get("Date", null);
            int n2 = preferences.getInt("Major Version", -1);
            int n3 = preferences.getInt("Minor Version", -1);
            int n4 = preferences.getInt("Micro Version", -1);
            boolean bl = false;
            bl = string == null || n2 == -1 || n3 == -1 || n4 == -1 ? true : Utility.compareVersionNumber(n2, n3, n4, 0, 5, 1);
            if (bl) {
                preferences.putLong("Date", System.currentTimeMillis());
                preferences.putInt("Major Version", 0);
                preferences.putInt("Minor Version", 5);
                preferences.putInt("Micro Version", 1);
            }
        }

        private boolean checkDate() {
            boolean bl;
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            long l = preferences.getLong("Date", 0L);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            int n = preferences.getInt("Upgrade Cycle", 1);
            switch (n) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = l3 > 86400000L;
                    break;
                }
                case 3: {
                    bl = l3 > 604800000L;
                    break;
                }
                case 4: {
                    bl = l3 > 2592000000L;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadFigureElementClass() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(new File("ListOfFigureElement.txt"));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.mClassOfAxisElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisElement");
                    this.mClassOfSXYGraphElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGSXYGraphElement");
                    this.mClassOfVXYGraphElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGVXYGraphElement");
                    this.mClassOfStringElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGStringElement");
                    this.mClassOfLegendElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendElement");
                    this.mClassOfAxisBreakElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakElement");
                    this.mClassOfSignificantDifferenceElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGSignificantDifferenceElement");
                    this.mClassOfTimingLineElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingLineElement");
                    this.mClassOfGridElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGGridElement");
                    boolean bl = true;
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    return bl;
                }
                Properties properties = new Properties();
                properties.load(fileInputStream);
                Class clazz = null;
                clazz = this.getClassObject(properties, "SGAxisElement", class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIAxisElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfAxisElement = clazz;
                clazz = this.getClassObject(properties, "SGSXYGraphElement", class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIGraphElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfSXYGraphElement = clazz;
                clazz = this.getClassObject(properties, "SGVXYGraphElement", class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIGraphElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfVXYGraphElement = clazz;
                clazz = this.getClassObject(properties, "SGLegendElement", class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGILegendElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfLegendElement = clazz;
                clazz = this.getClassObject(properties, "SGStringElement", class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIStringElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfStringElement = clazz;
                clazz = this.getClassObject(properties, "SGAxisBreakElement", class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfAxisBreakElement = clazz;
                clazz = this.getClassObject(properties, "SGSignificantDifferenceElement", class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfSignificantDifferenceElement = clazz;
                clazz = this.getClassObject(properties, "SGTimingLineElement", class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfTimingLineElement = clazz;
                clazz = this.getClassObject(properties, "SGGridElement", class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIGridElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfGridElement = clazz;
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            return true;
        }

        private Class getClassObject(Properties properties, String string, Class clazz) throws ClassNotFoundException {
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                return null;
            }
            Class<?> clazz2 = Class.forName(string2);
            if (!clazz.isAssignableFrom(clazz2)) {
                return null;
            }
            return clazz2;
        }

        private boolean executeCommand(String[] stringArray) {
            boolean bl = true;
            if ("wopen".equals(stringArray[0])) {
                bl = this.wopen(stringArray);
            } else if ("addData".equals(stringArray[0])) {
                bl = this.addDataByCommandLine(stringArray);
            } else if ("readProperty".equals(stringArray[0])) {
                bl = this.readWindowProperty(stringArray);
            } else {
                System.out.println("\u30b3\u30de\u30f3\u30c9\u540d\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                return false;
            }
            return bl;
        }

        private boolean wopen(String[] stringArray) {
            int n;
            Object object;
            if (stringArray.length < 1) {
                return false;
            }
            if (stringArray.length > 1) {
                object = stringArray[1];
                Integer n2 = this.getWindowIDFromString((String)object);
                if (n2 == null) {
                    return false;
                }
                n = n2;
            } else {
                n = this.getCurrentWindowID();
            }
            object = this.getWindow(n);
            if (object != null) {
                System.out.println("\u305d\u306e\u30a6\u30a4\u30f3\u30c9\u30a6\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002");
                return false;
            }
            object = this.createWindow(n);
            if (object == null) {
                return false;
            }
            ((SGDrawingWindow)object).initPropertiesHistory();
            ((Window)object).setVisible(true);
            return true;
        }

        private SGDrawingWindow getWindowForCommand(int n) {
            SGDrawingWindow sGDrawingWindow = this.getWindow(n);
            if (sGDrawingWindow == null) {
                System.out.println("\u6307\u5b9a\u3055\u308c\u305f\u30a6\u30a4\u30f3\u30c9\u30a6\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
                System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u3092\u65b0\u898f\u4f5c\u6210\u3057\u307e\u3059\u3002");
                sGDrawingWindow = this.createWindow(n);
                if (sGDrawingWindow == null) {
                    System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    return null;
                }
                sGDrawingWindow.initPropertiesHistory();
            }
            return sGDrawingWindow;
        }

        private Integer getWindowIDFromString(String string) {
            Integer n;
            try {
                n = Integer.valueOf(string);
            }
            catch (Exception exception) {
                System.out.println("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                return null;
            }
            int n2 = n;
            if (n2 < 1) {
                System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u756a\u53f7\u306f\u6b63\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002");
                return null;
            }
            if (n2 > 256) {
                System.out.println("\u30a6\u30a4\u30f3\u30c9\u30a6\u756a\u53f7\u304c\u5927\u304d\u904e\u304e\u307e\u3059\u3002");
                return null;
            }
            return n;
        }

        private boolean addDataByCommandLine(String[] stringArray) {
            int n;
            int n2;
            Object object;
            int n3;
            Object object2;
            if (stringArray.length < 2) {
                System.out.println("\u30b3\u30de\u30f3\u30c9\u5f15\u6570\u304c\u8db3\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
            String string = stringArray[1];
            if (stringArray.length > 2) {
                object2 = stringArray[2];
                Integer n4 = this.getWindowIDFromString((String)object2);
                if (n4 == null) {
                    return false;
                }
                n3 = n4;
            } else {
                n3 = this.getCurrentWindowID();
            }
            object2 = this.getWindowForCommand(n3);
            if (object2 == null) {
                return false;
            }
            if (stringArray.length > 3) {
                object = stringArray[3];
                n2 = Integer.valueOf((String)object);
            } else {
                n2 = ((SGDrawingWindow)object2).getCurrentFigureId();
            }
            this.mXYDataTypeSelectionWizardDialogFromCLorDD = new SGXYDataTypeSelectionWizardDialog((Frame)object2, true);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.addActionListener(this);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.mPreviousButton.setEnabled(false);
            object = new ArrayList();
            try {
                n = this.createDataFromFile(string, (ArrayList)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                SGUtility.showFileNotFoundMessageDialog((Component)object2);
                return false;
            }
            if (n == -1) {
                return false;
            }
            SGData sGData = (SGData)((ArrayList)object).get(0);
            if (sGData == null) {
                System.out.println("\u30c7\u30fc\u30bf\u306e\u69cb\u7bc9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                return false;
            }
            SGFigure sGFigure = ((SGDrawingWindow)object2).getFigure(n2);
            String string2 = this.getNewDataName(sGFigure, string);
            if (string2 == null) {
                return false;
            }
            if (sGFigure == null || sGFigure != null && !sGFigure.isVisible()) {
                if (this.createNewFigure((SGDrawingWindow)object2, n2, sGData, new Point(), string2) == null) {
                    return false;
                }
            } else if (!sGFigure.addData(sGData)) {
                System.out.println("\u30c7\u30fc\u30bf\u306e\u578b\u304c\u30d5\u30a3\u30ae\u30e5\u30a2\u306b\u5408\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
            return true;
        }

        private boolean readWindowProperty(String[] stringArray) {
            return true;
        }

        private boolean readFigureProperty(String[] stringArray) {
            return true;
        }

        private String getSimpleFileName(String string) {
            String string2 = SGIConstants.FILE_SEPARATOR;
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string3 == null) {
                throw new Error();
            }
            String string4 = null;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, Character.toString('.'));
            if (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
            }
            if (string4 == null) {
                string4 = string3;
            }
            return string4;
        }

        private String getNewDataName(SGFigure sGFigure, String string) {
            String string2 = this.getSimpleFileName(string);
            if (string2 == null) {
                return null;
            }
            ArrayList arrayList = sGFigure.getVisibleDataList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGData sGData = (SGData)arrayList.get(i);
                String string3 = sGFigure.getDataName(sGData);
                arrayList2.add(string3);
            }
            string2 = SGUtilityText.getSerialName(arrayList2, string2);
            return string2;
        }

        private boolean setWindowLocation(SGDrawingWindow sGDrawingWindow) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (int)(dimension.getWidth() - (double)sGDrawingWindow.getWidth()) / 2;
            int n2 = (int)(dimension.getHeight() - (double)sGDrawingWindow.getHeight()) / 2;
            sGDrawingWindow.setLocation(n, n2);
            return true;
        }

        public SGDrawingWindow getWindow(int n) {
            return (SGDrawingWindow)this.mWndMap.get(new Integer(n));
        }

        public int getWindowNumber() {
            return this.mWndMap.size();
        }

        private SGFigure createFigure(int n, SGDrawingWindow sGDrawingWindow, SGData sGData) {
            SGFigure sGFigure = null;
            if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
                sGFigure = new SGSXYFigure(sGDrawingWindow);
            } else if (sGData instanceof SGVXYData) {
                sGFigure = new SGVXYFigure(sGDrawingWindow);
            } else {
                return null;
            }
            sGFigure.setVisible(false);
            sGFigure.setID(n);
            if (!this.createFigureElements(sGFigure, sGData)) {
                return null;
            }
            float f = 425.19687f;
            float f2 = f / SGIConstants.GOLDEN_RATIO;
            sGFigure.setGraphRectSize(f, f2);
            return sGFigure;
        }

        private boolean createFigureElements(SGFigure sGFigure, SGData sGData) {
            try {
                SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
                SGIAxisElement sGIAxisElement = (SGIAxisElement)this.setIElement(this.mClassOfAxisElement, 50, sGFigure, sGDrawingWindow);
                sGFigure.setAxisElement(sGIAxisElement);
                Class clazz = null;
                if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
                    clazz = this.mClassOfSXYGraphElement;
                } else if (sGData instanceof SGVXYData) {
                    clazz = this.mClassOfVXYGraphElement;
                } else {
                    return false;
                }
                SGIGraphElement sGIGraphElement = (SGIGraphElement)this.setIElement(clazz, 30, sGFigure, sGDrawingWindow);
                sGFigure.setGraphElement(sGIGraphElement);
                SGILegendElement sGILegendElement = (SGILegendElement)this.setIElement(this.mClassOfLegendElement, 70, sGFigure, sGDrawingWindow);
                sGFigure.setLegendElement(sGILegendElement);
                SGIStringElement sGIStringElement = (SGIStringElement)this.setIElement(this.mClassOfStringElement, 80, sGFigure, sGDrawingWindow);
                sGFigure.setStringElement(sGIStringElement);
                SGIAxisBreakElement sGIAxisBreakElement = (SGIAxisBreakElement)this.setIElement(this.mClassOfAxisBreakElement, 60, sGFigure, sGDrawingWindow);
                sGFigure.setAxisBreakElement(sGIAxisBreakElement);
                SGISignificantDifferenceElement sGISignificantDifferenceElement = (SGISignificantDifferenceElement)this.setIElement(this.mClassOfSignificantDifferenceElement, 40, sGFigure, sGDrawingWindow);
                sGFigure.setSignificantDifferenceElement(sGISignificantDifferenceElement);
                SGITimingLineElement sGITimingLineElement = (SGITimingLineElement)this.setIElement(this.mClassOfTimingLineElement, 20, sGFigure, sGDrawingWindow);
                sGFigure.setTimingLineElement(sGITimingLineElement);
                SGIGridElement sGIGridElement = (SGIGridElement)this.setIElement(this.mClassOfGridElement, 10, sGFigure, sGDrawingWindow);
                sGFigure.setGridElement(sGIGridElement);
                this.setRelationOfFigureElements(sGFigure);
                SGIFigureElement[] sGIFigureElementArray = new SGIFigureElement[]{sGIAxisElement, sGIGraphElement, sGILegendElement, sGIStringElement, sGISignificantDifferenceElement, sGIAxisBreakElement, sGITimingLineElement, sGIGridElement};
                sGFigure.setFigureElementArray(sGIFigureElementArray);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        private void setRelationOfFigureElements(SGFigure sGFigure) {
            SGIAxisElement sGIAxisElement = sGFigure.getAxisElement();
            SGIGraphElement sGIGraphElement = sGFigure.getGraphElement();
            SGILegendElement sGILegendElement = sGFigure.getLegendElement();
            SGIStringElement sGIStringElement = sGFigure.getStringElement();
            SGIAxisBreakElement sGIAxisBreakElement = sGFigure.getAxisBreakElement();
            SGISignificantDifferenceElement sGISignificantDifferenceElement = sGFigure.getSignigicantDifferenceElement();
            SGITimingLineElement sGITimingLineElement = sGFigure.getTimingLineElement();
            SGIGridElement sGIGridElement = sGFigure.getGridElement();
            sGIGraphElement.setAxisElement(sGIAxisElement);
            sGILegendElement.setAxisElement(sGIAxisElement);
            sGILegendElement.setGraphElement(sGIGraphElement);
            sGIAxisBreakElement.setAxisElement(sGIAxisElement);
            sGISignificantDifferenceElement.setAxisElement(sGIAxisElement);
            sGITimingLineElement.setAxisElement(sGIAxisElement);
            sGIGridElement.setAxisElement(sGIAxisElement);
            sGIAxisElement.setTimingLineElement(sGITimingLineElement);
            sGIStringElement.setAxisElement(sGIAxisElement);
        }

        private SGIFigureElement setIElement(Class clazz, int n, SGFigure sGFigure, Frame frame) {
            Object var5_5 = null;
            try {
                var5_5 = clazz.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
            JComponent jComponent = var5_5;
            jComponent.setBounds(0, 0, sGFigure.getWidth(), sGFigure.getHeight());
            jComponent.setVisible(true);
            jComponent.setOpaque(false);
            sGFigure.add(jComponent);
            sGFigure.setLayer(jComponent, n);
            SGIFigureElement sGIFigureElement = var5_5;
            sGIFigureElement.addActionListener(sGFigure);
            sGIFigureElement.setDialogOwner(frame);
            return sGIFigureElement;
        }

        private int createDataFromFile(String string, ArrayList arrayList) throws FileNotFoundException {
            ArrayList arrayList2 = new ArrayList();
            int n = this.readFile(string, arrayList2);
            if (n != 0) {
                return n;
            }
            SGData sGData = this.mDataCreator.create(string, arrayList2);
            if (sGData == null) {
                return -1;
            }
            arrayList.add(sGData);
            return 0;
        }

        private boolean createAllWizardDialogsForDataAdditionFromToolBar(SGDrawingWindow sGDrawingWindow) {
            int n = sGDrawingWindow.getID();
            this.mFigureIDSelectionWizardDialog = new SGFigureIDSelectionWizardDialog((Frame)sGDrawingWindow, true);
            this.mFigureIDSelectionWizardDialog.getOKButton().setVisible(false);
            this.mFigureIDSelectionWizardDialog.getPreviousButton().setVisible(false);
            this.mFigureIDSelectionWizardDialog.pack();
            this.mSingleDataFileChooserWizardDilaog = new SGSingleDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mSingleDataFileChooserWizardDilaog.getOKButton().setVisible(false);
            this.mSingleDataFileChooserWizardDilaog.pack();
            String string = this.getCurrentFileDirectory();
            this.mSingleDataFileChooserWizardDilaog.setFile(string, this.mCurrentDataFileName);
            this.mXYDataTypeSelectionWizardDialog = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
            this.mXYDataTypeSelectionWizardDialog.getNextButton().setVisible(false);
            this.mXYDataTypeSelectionWizardDialog.pack();
            this.mFigureIDSelectionWizardDialog.setNext(this.mSingleDataFileChooserWizardDilaog);
            this.mSingleDataFileChooserWizardDilaog.setPrevious(this.mFigureIDSelectionWizardDialog);
            this.mSingleDataFileChooserWizardDilaog.setNext(this.mXYDataTypeSelectionWizardDialog);
            this.mXYDataTypeSelectionWizardDialog.setPrevious(this.mSingleDataFileChooserWizardDilaog);
            this.mFigureIDSelectionWizardDialog.addActionListener(this);
            this.mSingleDataFileChooserWizardDilaog.addActionListener(this);
            this.mXYDataTypeSelectionWizardDialog.addActionListener(this);
            return true;
        }

        private String getCurrentFileDirectory() {
            Object object;
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            Object object2 = preferences.get("Current Directory", null);
            boolean bl = false;
            if (object2 == null) {
                bl = true;
            } else {
                object = new File((String)object2);
                if (!((File)object).exists()) {
                    bl = true;
                }
            }
            if (bl) {
                object = SGIConstants.USER_HOME;
                if (SGUtility.identifyOS("windows")) {
                    object = (String)object + SGIConstants.FILE_SEPARATOR + "My Documents";
                }
                this.setCurrentFileDirectory((String)object);
                object2 = object;
            }
            return object2;
        }

        private void setCurrentFileDirectory(String string) {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            preferences.put("Current Directory", string);
        }

        private boolean createAllWizardDialogsToLoadPropertyFromToolBar(SGDrawingWindow sGDrawingWindow) {
            this.mPropertyFileChooserWizardDilaog = new SGPropertyFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mPropertyFileChooserWizardDilaog.getPreviousButton().setVisible(false);
            this.mPropertyFileChooserWizardDilaog.getOKButton().setVisible(false);
            this.mPropertyFileChooserWizardDilaog.pack();
            this.mMultiDataFileChooserWizardDialog = new SGMultiDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mMultiDataFileChooserWizardDialog.getNextButton().setVisible(false);
            this.mMultiDataFileChooserWizardDialog.pack();
            SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
            sGExtensionFileFilter.setDescription("Samurai Graph Property File");
            sGExtensionFileFilter.addExtension("sgp");
            this.mPropertyFileChooserWizardDilaog.setFileFilter(sGExtensionFileFilter);
            String string = this.getCurrentFileDirectory();
            this.mPropertyFileChooserWizardDilaog.setFile(string, this.mCurrentPropertyFileName);
            this.mMultiDataFileChooserWizardDialog.setFile(string, this.mCurrentDataFileName);
            this.mPropertyFileChooserWizardDilaog.setNext(this.mMultiDataFileChooserWizardDialog);
            this.mMultiDataFileChooserWizardDialog.setPrevious(this.mPropertyFileChooserWizardDilaog);
            this.mPropertyFileChooserWizardDilaog.addActionListener(this);
            this.mMultiDataFileChooserWizardDialog.addActionListener(this);
            return true;
        }

        private int readFile(String string, ArrayList arrayList) {
            Window window = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getOwner();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            try {
                if (!this.mDataCreator.getFileTypeCandidateList(string, arrayList2, arrayList3)) {
                    return -1;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return -1;
            }
            if (arrayList2.size() == 0) {
                return -1;
            }
            String string2 = null;
            if (!this.mXYDataTypeSelectionWizardDialogFromCLorDD.setEffectiveDataType(arrayList2)) {
                return -1;
            }
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.setCenter(window);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.setVisible(true);
            int n = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getCloseOption();
            if (n == 1) {
                return 1;
            }
            string2 = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getSelectedDataType();
            if (string2 == null) {
                return -1;
            }
            arrayList.add(string2);
            if (string2.equals("SXY_SAMPLING")) {
                Double d = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getSamplingRate();
                if (d == null) {
                    return -1;
                }
                arrayList.add(d);
            }
            return 0;
        }

        private boolean readFile2(String string, ArrayList arrayList) {
            String string2 = this.mXYDataTypeSelectionWizardDialog.getSelectedDataType();
            if (string2 == null) {
                return false;
            }
            arrayList.add(string2);
            if (string2.equals("SXY_SAMPLING")) {
                Double d = this.mXYDataTypeSelectionWizardDialog.getSamplingRate();
                if (d == null) {
                    return false;
                }
                arrayList.add(d);
            }
            return true;
        }

        public SGDrawingWindow createNewWindow() {
            SGDrawingWindow sGDrawingWindow = this.createWindow();
            if (sGDrawingWindow == null) {
                return null;
            }
            sGDrawingWindow.initPropertiesHistory();
            return sGDrawingWindow;
        }

        private SGDrawingWindow createWindow() {
            int n = this.getCurrentWindowID();
            SGDrawingWindow sGDrawingWindow = this.createWindow(n);
            return sGDrawingWindow;
        }

        private SGDrawingWindow createWindow(int n) {
            SGDrawingWindow sGDrawingWindow = new SGDrawingWindow();
            sGDrawingWindow.setID(n);
            this.mWndMap.put(new Integer(n), sGDrawingWindow);
            sGDrawingWindow.setDefaultCloseOperation(2);
            String string = "Samurai Graph - Window : " + sGDrawingWindow.getID();
            sGDrawingWindow.setTitle(string);
            sGDrawingWindow.addActionListener(this);
            sGDrawingWindow.addWindowListener(this);
            DropTarget dropTarget = new DropTarget(sGDrawingWindow, 3, this, true);
            sGDrawingWindow.setDropTarget(dropTarget);
            sGDrawingWindow.setImageFileCreator(this.mImageFileCreator);
            sGDrawingWindow.setLocation(100, 100);
            if (!sGDrawingWindow.init()) {
                return null;
            }
            this.setPasteMenuEnabled();
            return sGDrawingWindow;
        }

        private int getCurrentWindowID() {
            int n = this.mWndMap.size() == 0 ? 1 : (Integer)this.mWndMap.lastKey() + 1;
            return n;
        }

        private int createWindowFromPropertyFile(SGDrawingWindow sGDrawingWindow, Element element, TreeMap treeMap) {
            String string = null;
            Float f = null;
            Boolean bl = null;
            Color color = null;
            string = element.getAttribute("PaperWidth");
            if (string.length() == 0) {
                return 1;
            }
            f = SGUtilityText.getFloat(string, "cm");
            if (f == null) {
                return 1;
            }
            float f2 = ((Number)f).floatValue() / 0.035277776f;
            string = element.getAttribute("PaperHeight");
            if (string.length() == 0) {
                return 1;
            }
            f = SGUtilityText.getFloat(string, "cm");
            if (f == null) {
                return 1;
            }
            float f3 = ((Number)f).floatValue() / 0.035277776f;
            string = element.getAttribute("GridVisible");
            if (string.length() == 0) {
                return 1;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return 1;
            }
            boolean bl2 = bl;
            string = element.getAttribute("GridInterval");
            if (string.length() == 0) {
                return 1;
            }
            f = SGUtilityText.getFloat(string, "cm");
            if (f == null) {
                return 1;
            }
            float f4 = ((Number)f).floatValue() / 0.035277776f;
            string = element.getAttribute("GridLineWidth");
            if (string.length() == 0) {
                return 1;
            }
            f = SGUtilityText.getFloat(string, "cm");
            if (f == null) {
                return 1;
            }
            float f5 = ((Number)f).floatValue();
            string = element.getAttribute("BackgroundColor");
            if (string.length() == 0) {
                return 1;
            }
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return 1;
            }
            Color color2 = color;
            string = element.getAttribute("GridLineColor");
            if (string.length() == 0) {
                return 1;
            }
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return 1;
            }
            Color color3 = color;
            sGDrawingWindow.setPaperSize(f2, f3);
            sGDrawingWindow.setBackgroundColor(color2);
            sGDrawingWindow.setGridVisible(bl2);
            sGDrawingWindow.setGridInterval(f4);
            sGDrawingWindow.setGridLineWidth(f5);
            sGDrawingWindow.setGridLineColor(color3);
            int n = this.createFiguresFromPropertyFile(element, sGDrawingWindow, treeMap);
            if (n != 0) {
                return n;
            }
            n = 0;
            sGDrawingWindow.initPropertiesHistory();
            return n;
        }

        public SGDrawingWindow createWindowFromPropertyFile(Document document, TreeMap treeMap) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Window");
            if (nodeList.getLength() == 0) {
                return null;
            }
            Element element2 = (Element)nodeList.item(0);
            SGDrawingWindow sGDrawingWindow = this.createWindow();
            int n = this.createWindowFromPropertyFile(sGDrawingWindow, element2, treeMap);
            String string = null;
            if (n == 0) {
                string = "Successful completion.";
            } else if (n == 3) {
                string = "Data number shortage.";
            } else if (n == 4) {
                string = "Data number excess.";
            } else if (n == 5) {
                string = "Cannot open the selected file.";
            } else if (n == 1) {
                string = "The property file is invalid.";
            } else if (n == 2) {
                string = "Data type is incorrect.";
            } else {
                throw new Error();
            }
            if (string != "Successful completion.") {
                SGUtility.showMessageDialog(sGDrawingWindow, string, "Property file has read.", 0);
            }
            if (n == 1) {
                this.removeWindow(sGDrawingWindow);
            }
            sGDrawingWindow.setVisible(true);
            return sGDrawingWindow;
        }

        private int createFiguresFromPropertyFile(Element element, SGDrawingWindow sGDrawingWindow, Map map) {
            Set set = map.keySet();
            ArrayList arrayList = new ArrayList(map.values());
            NodeList nodeList = element.getElementsByTagName("Figure");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                int n2;
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element2 = (Element)node;
                ArrayList arrayList2 = (ArrayList)arrayList.get(i);
                if (arrayList2.contains("NO_DATA")) {
                    arrayList2 = new ArrayList();
                }
                if ((n2 = this.createSingleFigureFromPropertyFile(element2, sGDrawingWindow, arrayList2)) == 0) continue;
                return n2;
            }
            return 0;
        }

        private int createSingleFigureFromPropertyFile(Element element, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
            String string;
            String string2 = null;
            Float f = null;
            Boolean bl = null;
            Color color = null;
            string2 = element.getAttribute("Type");
            if (string2.length() == 0) {
                return 1;
            }
            if (string2.equals("SXY")) {
                string = (class$jp$riken$brain$ni$samuraigraph$figure$SGSXYFigure == null ? (class$jp$riken$brain$ni$samuraigraph$figure$SGSXYFigure = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.figure.SGSXYFigure")) : class$jp$riken$brain$ni$samuraigraph$figure$SGSXYFigure).getName();
            } else if (string2.equals("VXY")) {
                string = (class$jp$riken$brain$ni$samuraigraph$figure$SGVXYFigure == null ? (class$jp$riken$brain$ni$samuraigraph$figure$SGVXYFigure = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.figure.SGVXYFigure")) : class$jp$riken$brain$ni$samuraigraph$figure$SGVXYFigure).getName();
            } else {
                return 1;
            }
            SGFigure sGFigure = null;
            try {
                Class<?> clazz = Class.forName(string);
                sGFigure = (SGFigure)clazz.newInstance();
            }
            catch (Exception exception) {
                return 1;
            }
            sGFigure.setWindow(sGDrawingWindow);
            int n = sGDrawingWindow.getCurrentFigureId();
            sGFigure.setID(n);
            string2 = element.getAttribute("X");
            if (string2.length() == 0) {
                return 1;
            }
            f = SGUtilityText.getFloat(string2, "cm");
            if (f == null) {
                return 1;
            }
            float f2 = ((Number)f).floatValue() / 0.035277776f;
            string2 = element.getAttribute("Y");
            if (string2.length() == 0) {
                return 1;
            }
            f = SGUtilityText.getFloat(string2, "cm");
            if (f == null) {
                return 1;
            }
            float f3 = ((Number)f).floatValue() / 0.035277776f;
            string2 = element.getAttribute("Width");
            if (string2.length() == 0) {
                return 1;
            }
            f = SGUtilityText.getFloat(string2, "cm");
            if (f == null) {
                return 1;
            }
            float f4 = ((Number)f).floatValue() / 0.035277776f;
            string2 = element.getAttribute("Height");
            if (string2.length() == 0) {
                return 1;
            }
            f = SGUtilityText.getFloat(string2, "cm");
            if (f == null) {
                return 1;
            }
            float f5 = ((Number)f).floatValue() / 0.035277776f;
            string2 = element.getAttribute("SpaceAxisLineAndNumber");
            if (string2.length() == 0) {
                return 1;
            }
            f = SGUtilityText.getFloat(string2, "cm");
            if (f == null) {
                return 1;
            }
            float f6 = ((Number)f).floatValue() / 0.035277776f;
            string2 = element.getAttribute("SpaceNumberAndTitle");
            if (string2.length() == 0) {
                return 1;
            }
            f = SGUtilityText.getFloat(string2, "cm");
            if (f == null) {
                return 1;
            }
            float f7 = ((Number)f).floatValue() / 0.035277776f;
            string2 = element.getAttribute("BackgroundColor");
            if (string2.length() == 0) {
                return 1;
            }
            color = SGUtilityText.getColorFromString(string2);
            if (color == null) {
                return 1;
            }
            sGFigure.setBackgroundColor(color);
            string2 = element.getAttribute("BackgroundTransparent");
            if (string2.length() == 0) {
                return 1;
            }
            bl = SGUtilityText.getBoolean(string2);
            if (bl == null) {
                return 1;
            }
            boolean bl2 = bl;
            sGFigure.setTransparent(bl2);
            Rectangle2D rectangle2D = sGDrawingWindow.getClientRect();
            float f8 = f2 + (float)rectangle2D.getX();
            float f9 = f3 + (float)rectangle2D.getY();
            sGFigure.setGraphRectLocation(f8, f9);
            sGFigure.setGraphRectSize(f4, f5);
            if (this.createFigureElementFromPropertyFile(sGFigure, element) == 1) {
                return 1;
            }
            SGIAxisElement sGIAxisElement = sGFigure.getAxisElement();
            sGIAxisElement.setSpaceAxisLineAndNumber(f6);
            sGIAxisElement.setSpaceNumberAndTitle(f7);
            int n2 = this.createDataObjectsFromPropertyFile(element, sGFigure, arrayList);
            if (n2 != 0) {
                return n2;
            }
            int n3 = sGDrawingWindow.getCurrentFigureId();
            sGDrawingWindow.addFigure(n3, sGFigure);
            sGFigure.notifyFigureElement(sGFigure.getAxisElement());
            sGFigure.notifyFigureElement(sGFigure.getGraphElement());
            sGFigure.initPropertiesHistory();
            sGDrawingWindow.moveToFront(sGFigure);
            return 0;
        }

        public int createFigureElementFromPropertyFile(SGFigure sGFigure, Element element) {
            Class clazz;
            NodeList nodeList = null;
            Element element2 = null;
            SGIFigureElement sGIFigureElement = null;
            SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
            Rectangle2D rectangle2D = sGFigure.getGraphRect();
            sGIFigureElement = this.setIElement(this.mClassOfAxisElement, 50, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGIAxisElement sGIAxisElement = (SGIAxisElement)sGIFigureElement;
            sGFigure.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("Axes");
            element2 = (Element)nodeList.item(0);
            if (!sGIFigureElement.readProperty(element2)) {
                return 1;
            }
            nodeList = element.getElementsByTagName("Graph");
            element2 = (Element)nodeList.item(0);
            if (sGFigure instanceof SGSXYFigure) {
                clazz = this.mClassOfSXYGraphElement;
            } else if (sGFigure instanceof SGVXYFigure) {
                clazz = this.mClassOfVXYGraphElement;
            } else {
                throw new Error();
            }
            sGIFigureElement = this.setIElement(clazz, 30, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGIGraphElement sGIGraphElement = (SGIGraphElement)sGIFigureElement;
            sGFigure.setGraphElement(sGIGraphElement);
            sGIFigureElement = this.setIElement(this.mClassOfLegendElement, 70, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGILegendElement sGILegendElement = (SGILegendElement)sGIFigureElement;
            sGFigure.setLegendElement(sGILegendElement);
            sGILegendElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("Legend");
            element2 = (Element)nodeList.item(0);
            if (!sGIFigureElement.readProperty(element2)) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfStringElement, 80, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGIStringElement sGIStringElement = (SGIStringElement)sGIFigureElement;
            sGFigure.setStringElement(sGIStringElement);
            sGIStringElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("Labels");
            element2 = (Element)nodeList.item(0);
            if (!sGIFigureElement.readProperty(element2)) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfAxisBreakElement, 60, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGIAxisBreakElement sGIAxisBreakElement = (SGIAxisBreakElement)sGIFigureElement;
            sGFigure.setAxisBreakElement(sGIAxisBreakElement);
            sGIAxisBreakElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("AxisBreakSymbols");
            element2 = (Element)nodeList.item(0);
            if (!sGIFigureElement.readProperty(element2)) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfSignificantDifferenceElement, 40, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGISignificantDifferenceElement sGISignificantDifferenceElement = (SGISignificantDifferenceElement)sGIFigureElement;
            sGFigure.setSignificantDifferenceElement(sGISignificantDifferenceElement);
            sGISignificantDifferenceElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("SignificantDifferenceSymbols");
            element2 = (Element)nodeList.item(0);
            if (!sGIFigureElement.readProperty(element2)) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfTimingLineElement, 20, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGITimingLineElement sGITimingLineElement = (SGITimingLineElement)sGIFigureElement;
            sGFigure.setTimingLineElement(sGITimingLineElement);
            sGITimingLineElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("TimingLines");
            element2 = (Element)nodeList.item(0);
            if (!sGIFigureElement.readProperty(element2)) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfGridElement, 10, sGFigure, sGDrawingWindow);
            if (sGIFigureElement != null) {
                // empty if block
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGIGridElement sGIGridElement = (SGIGridElement)sGIFigureElement;
            sGFigure.setGridElement(sGIGridElement);
            sGIGridElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("Grid");
            int n = nodeList.getLength();
            if (n != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
                return 1;
            }
            this.setRelationOfFigureElements(sGFigure);
            SGIFigureElement[] sGIFigureElementArray = new SGIFigureElement[]{sGIAxisElement, sGIGraphElement, sGILegendElement, sGIStringElement, sGISignificantDifferenceElement, sGIAxisBreakElement, sGITimingLineElement, sGIGridElement};
            sGFigure.setFigureElementArray(sGIFigureElementArray);
            return 0;
        }

        private int createDataObjectsFromPropertyFile(Element element, SGFigure sGFigure, ArrayList arrayList) {
            NodeList nodeList = element.getElementsByTagName("Data");
            if (nodeList.getLength() != arrayList.size()) {
                return 1;
            }
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Element element2;
                block31: {
                    Object object2;
                    Object object3;
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element)) continue;
                    element2 = (Element)node;
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    String string = element2.getAttribute("Type");
                    if (string == null) {
                        return 1;
                    }
                    arrayList2.add(string);
                    String string2 = null;
                    if (string.equals("SXY")) {
                        string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYData).getName();
                    } else if (string.equals("VXY")) {
                        string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGVXYData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGVXYData") : class$jp$riken$brain$ni$samuraigraph$data$SGVXYData).getName();
                    } else if (string.equals("SXY_MULTIPLE")) {
                        string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData).getName();
                    } else if (string.equals("SXY_SAMPLING")) {
                        string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData).getName();
                        object3 = element2.getAttribute("SamplingRate");
                        if (((String)object3).length() == 0) {
                            return 1;
                        }
                        object = SGUtilityText.getDouble((String)object3);
                        if (object == null) {
                            return 1;
                        }
                        arrayList2.add(object);
                    } else {
                        return 1;
                    }
                    object3 = null;
                    try {
                        object3 = Class.forName(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return 1;
                    }
                    if (object3 == null) {
                        return 1;
                    }
                    object = null;
                    try {
                        object = (SGData)((Class)object3).newInstance();
                    }
                    catch (Exception exception) {
                        return 1;
                    }
                    if (object == null) {
                        return 1;
                    }
                    if (arrayList.size() == 0) {
                        return 3;
                    }
                    Object e = arrayList.get(i);
                    if (e instanceof String) {
                        object2 = (String)e;
                        ArrayList arrayList3 = new ArrayList();
                        ArrayList arrayList4 = new ArrayList();
                        SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
                        try {
                            if (!this.mDataCreator.getFileTypeCandidateList((String)object2, arrayList3, arrayList4)) {
                                return 1;
                            }
                            if (arrayList3.size() == 0 || !arrayList3.contains(string)) {
                                return 2;
                            }
                            SGData sGData = this.mDataCreator.create((String)object2, arrayList2);
                            if (sGData == null) {
                                return 5;
                            }
                            if (!((SGData)object).setData(sGData)) {
                                return 2;
                            }
                            break block31;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return 5;
                        }
                    }
                    if (e instanceof SGData) {
                        object2 = (SGData)e;
                        if (!((SGData)object).setData((SGData)object2)) {
                            return 1;
                        }
                    } else {
                        return 1;
                    }
                }
                if (sGFigure.createDataObjectFromPropertyFile(element2, (SGData)object)) continue;
                return 1;
            }
            SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
            for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                sGIFigureElementArray[i].initPropertiesHistory();
            }
            return 0;
        }

        private boolean fromWindow(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)object;
            if (string.equals("open a new window")) {
                SGDrawingWindow sGDrawingWindow2 = this.createNewWindow();
                if (sGDrawingWindow2 == null) {
                    return false;
                }
                sGDrawingWindow2.setVisible(true);
            } else if (string.equals("exit")) {
                this.exit(0);
            } else if (string.equals("add new data")) {
                this.createAllWizardDialogsForDataAdditionFromToolBar(sGDrawingWindow);
                this.mFigureIDSelectionWizardDialog.setCenter(sGDrawingWindow);
                this.mFigureIDSelectionWizardDialog.setVisible(true);
                File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFile();
                if (file != null) {
                    this.updateCurrentFile(file, 0);
                }
            } else if (string.equals("save property")) {
                this.mPropertyFileCreator.setFile(this.getCurrentFileDirectory(), this.mCurrentPropertyFileName);
                this.mPropertyFileCreator.create(sGDrawingWindow);
                File file = this.mPropertyFileCreator.getSelectedFile();
                if (file != null) {
                    this.updateCurrentFile(file, 1);
                }
            } else if (string.equals("load property")) {
                this.createAllWizardDialogsToLoadPropertyFromToolBar(sGDrawingWindow);
                this.mPropertyFileChooserWizardDilaog.setCenter(sGDrawingWindow);
                this.mPropertyFileChooserWizardDilaog.setVisible(true);
                File file = this.mPropertyFileChooserWizardDilaog.getSelectedFile();
                File file2 = this.mMultiDataFileChooserWizardDialog.getSelectedFile();
                long l = this.mPropertyFileChooserWizardDilaog.lastUsed();
                long l2 = this.mMultiDataFileChooserWizardDialog.lastUsed();
                if (file != null & file2 != null) {
                    if (l < l2) {
                        this.updateCurrentFile(file2, 0);
                    } else {
                        this.updateCurrentFile(file, 1);
                    }
                } else if (file != null) {
                    this.updateCurrentFile(file, 1);
                } else if (file2 != null) {
                    this.updateCurrentFile(file2, 0);
                }
            } else if (string.equals("cut")) {
                this.cutAndCopy(sGDrawingWindow, false);
            } else if (string.equals("copy")) {
                this.cutAndCopy(sGDrawingWindow, true);
            } else if (string.equals("paste")) {
                this.pasteToWindow(sGDrawingWindow);
            } else if (string.equals("duplicate")) {
                if (!this.duplicateFocusedFigures(sGDrawingWindow)) {
                    return false;
                }
            } else if (string.equals("export as image")) {
                this.mImageFileCreator.setBaseDirectory(this.getCurrentFileDirectory());
                sGDrawingWindow.exportAsImage();
                this.setCurrentFileDirectory(this.mImageFileCreator.getBaseDirectory());
            } else if (string.equals("print")) {
                sGDrawingWindow.printImage();
            } else if (string.equals("upgrade the latest version")) {
                this.mUpgradeManager.showUpgradeDialog(sGDrawingWindow);
            } else {
                if (string.equals("show the change log")) {
                    return this.showChangeLogDialog(sGDrawingWindow);
                }
                if (string.equals("set proxy")) {
                    return this.mProxyManager.showProxySettingDialog(sGDrawingWindow);
                }
                if (string.equals("show about dialog")) {
                    this.showAboutDialog(sGDrawingWindow);
                }
            }
            return true;
        }

        private boolean cutAndCopy(SGDrawingWindow sGDrawingWindow, boolean bl) {
            this.mCopiedObjectsBuffer.clear();
            this.mCopiedDataObjectBuffer.clear();
            this.mCopiedDataNameBuffer.clear();
            this.mCopiedDataPropertiesBuffer.clear();
            ArrayList arrayList = sGDrawingWindow.getCopiedObjectsList();
            this.mCopiedObjectsBuffer.addAll(arrayList);
            ArrayList arrayList2 = sGDrawingWindow.getCopiedObjectsDataList();
            this.mCopiedDataObjectBuffer.addAll(arrayList2);
            ArrayList arrayList3 = sGDrawingWindow.getCopiedDataNameList();
            this.mCopiedDataNameBuffer.addAll(arrayList3);
            ArrayList arrayList4 = sGDrawingWindow.getCopiedDataPropertiesMapList();
            this.mCopiedDataPropertiesBuffer.addAll(arrayList4);
            WindowInfo windowInfo = new WindowInfo();
            if (bl ? !this.copyFocusedFigures(sGDrawingWindow, windowInfo) : !this.cutFocusedFigures(sGDrawingWindow, windowInfo)) {
                return false;
            }
            this.mWindowInfo = windowInfo;
            this.setPasteMenuEnabled();
            return true;
        }

        private void setPasteMenuEnabled() {
            int n;
            Object object;
            boolean bl = this.mCopiedObjectsBuffer.size() != 0;
            boolean bl2 = this.mCopiedDataObjectBuffer.size() != 0;
            boolean bl3 = false;
            if (this.mWindowInfo != null) {
                Document document = this.mWindowInfo.mDocument;
                object = document.getElementsByTagName("Figure");
                n = object.getLength();
                bl3 = n != 0;
            }
            boolean bl4 = bl | bl2 | bl3;
            object = new ArrayList(this.mWndMap.values());
            for (n = 0; n < ((ArrayList)object).size(); ++n) {
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)((ArrayList)object).get(n);
                sGDrawingWindow.setPasteMenuEnabled(bl4);
            }
        }

        private boolean pasteToWindow(SGDrawingWindow sGDrawingWindow) {
            sGDrawingWindow.pasteToFigures(this.mCopiedObjectsBuffer, this.mCopiedDataObjectBuffer, this.mCopiedDataNameBuffer, this.mCopiedDataPropertiesBuffer);
            WindowInfo windowInfo = this.mWindowInfo;
            if (windowInfo == null) {
                return false;
            }
            Map map = windowInfo.mDataListMap;
            Element element = windowInfo.mDocument.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Window");
            if (nodeList.getLength() == 0) {
                return false;
            }
            Element element2 = (Element)nodeList.item(0);
            int n = sGDrawingWindow.getFigureMap().size();
            int n2 = this.createFiguresFromPropertyFile(element2, sGDrawingWindow, map);
            if (n2 != 0) {
                return false;
            }
            int n3 = sGDrawingWindow.getFigureMap().size();
            sGDrawingWindow.setChanged(n != n3);
            return true;
        }

        private void showAboutDialog(SGDrawingWindow sGDrawingWindow) {
            SGAboutDialog sGAboutDialog = new SGAboutDialog((Frame)sGDrawingWindow, true);
            int n = sGAboutDialog.getWidth();
            int n2 = sGAboutDialog.getHeight();
            int n3 = sGDrawingWindow.getX() + sGDrawingWindow.getWidth() / 2 - n / 2;
            int n4 = sGDrawingWindow.getY() + sGDrawingWindow.getHeight() / 2 - n2 / 2;
            sGAboutDialog.setLocation(n3, n4);
            sGAboutDialog.setVisible(true);
            sGAboutDialog.terminate();
            System.gc();
        }

        private boolean duplicateFocusedFigures(SGDrawingWindow sGDrawingWindow) {
            Object object;
            Object object2;
            DOMImplementation dOMImplementation = SGApplicationUtility.getDOMImplementation();
            if (dOMImplementation == null) {
                return false;
            }
            Document document = dOMImplementation.createDocument("", TAG_NAME_FOCUSED_FIGURES, null);
            if (!sGDrawingWindow.createDOMTree(document, 3)) {
                return false;
            }
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            ArrayList arrayList = sGDrawingWindow.getFocusedObjectsList();
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (SGFigure)arrayList.get(i);
                object = ((SGFigure)object2).getVisibleDataList();
                object = (ArrayList)((ArrayList)object).clone();
                treeMap.put(Integer.toString(((SGFigure)object2).getID()), object);
            }
            Element element = document.getDocumentElement();
            object2 = element.getElementsByTagName("Window");
            if (object2.getLength() == 0) {
                return false;
            }
            object = (Element)object2.item(0);
            int n = sGDrawingWindow.getFigureMap().size();
            int n2 = this.createFiguresFromPropertyFile((Element)object, sGDrawingWindow, treeMap);
            if (n2 != 0) {
                return false;
            }
            int n3 = sGDrawingWindow.getFigureMap().size();
            sGDrawingWindow.setChanged(n != n3);
            return true;
        }

        private boolean cutFocusedFigures(SGDrawingWindow sGDrawingWindow, WindowInfo windowInfo) {
            if (!this.copyFocusedFigures(sGDrawingWindow, windowInfo)) {
                return false;
            }
            if (windowInfo.mDataListMap.size() != 0) {
                sGDrawingWindow.hideSelectedObjects();
            }
            return true;
        }

        private boolean copyFocusedFigures(SGDrawingWindow sGDrawingWindow, WindowInfo windowInfo) {
            DOMImplementation dOMImplementation = SGApplicationUtility.getDOMImplementation();
            if (dOMImplementation == null) {
                return false;
            }
            Document document = dOMImplementation.createDocument("", TAG_NAME_FOCUSED_FIGURES, null);
            if (!sGDrawingWindow.createDOMTree(document, 3)) {
                return false;
            }
            TreeMap<String, ArrayList> treeMap = new TreeMap<String, ArrayList>();
            ArrayList arrayList = sGDrawingWindow.getCopiedFiguresList();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                ArrayList arrayList2 = sGFigure.getVisibleDataList();
                arrayList2 = (ArrayList)arrayList2.clone();
                String string = Integer.toString(sGFigure.getID());
                treeMap.put(string, arrayList2);
            }
            windowInfo.mDocument = document;
            windowInfo.mDataListMap = treeMap;
            return true;
        }

        private Document createChangeLogDocument() {
            Class<?> clazz = this.getClass();
            URL uRL = clazz.getResource("/resources/ChangeLog.xml");
            if (uRL == null) {
                return null;
            }
            Document document = SGUtilityText.getDocument(uRL.toString());
            return document;
        }

        private boolean showChangeLogDialog(Frame frame) {
            this.mChangeLogDialog = new SGChangeLogDialog(frame, true);
            this.mChangeLogDialog.addActionListener(this);
            this.mChangeLogDialog.setCenter(frame);
            String string = "Change Log of Samurai Graph.";
            this.mChangeLogDialog.setMessage(string);
            Class<?> clazz = this.getClass();
            URL uRL = clazz.getResource("/resources/ChangeLog.html");
            if (uRL == null) {
                JOptionPane.showMessageDialog(frame, "Failed to get log information.");
                return false;
            }
            this.mChangeLogDialog.setPage(uRL);
            this.mChangeLogDialog.pack();
            this.mChangeLogDialog.setVisible(true);
            return true;
        }

        private boolean fromCLorDDWizardDialog(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            return true;
        }

        private boolean addDataByToolBar(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            SGWizardDialog sGWizardDialog2 = sGWizardDialog.getPrevious();
            SGWizardDialog sGWizardDialog3 = sGWizardDialog.getNext();
            String string = actionEvent.getActionCommand();
            Window window = sGWizardDialog.getOwner();
            if (string.equals("Cancel")) {
                sGWizardDialog.setVisible(false);
                return true;
            }
            if (string.equals("<Prev")) {
                sGWizardDialog.showPrevious();
                return true;
            }
            if (object.equals(this.mFigureIDSelectionWizardDialog)) {
                if (string.equals("Next>")) {
                    sGWizardDialog.showNext();
                }
            } else if (object.equals(this.mSingleDataFileChooserWizardDilaog)) {
                if (string.equals("Next>")) {
                    File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFileFromTextField();
                    if (!file.exists()) {
                        SGUtility.showFileNotFoundMessageDialog(this.mSingleDataFileChooserWizardDilaog);
                        return false;
                    }
                    String string2 = file.getPath();
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    ArrayList arrayList3 = new ArrayList();
                    try {
                        if (!this.mDataCreator.getFileTypeCandidateList(string2, arrayList2, arrayList3)) {
                            SGUtility.showMessageDialog(window, "Data file is invalid.", "Error", 2);
                            return false;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        SGUtility.showFileNotFoundMessageDialog(window);
                        return false;
                    }
                    if (arrayList2.size() == 0) {
                        SGUtility.showMessageDialog(window, "Data file is invalid.", "Error", 2);
                        return false;
                    }
                    if (!this.mXYDataTypeSelectionWizardDialog.setEffectiveDataType(arrayList2)) {
                        SGUtility.showMessageDialog(window, "Data file is invalid.", "Error", 2);
                        return false;
                    }
                    this.mSingleDataFileChooserWizardDilaog.setSelectedFile(file);
                    sGWizardDialog.showNext();
                }
            } else if (object.equals(this.mXYDataTypeSelectionWizardDialog) && string.equals("OK")) {
                Object object2;
                sGWizardDialog.setVisible(false);
                SGDrawingWindow sGDrawingWindow = sGWizardDialog.getOwnerWindow();
                int n = sGDrawingWindow.getID();
                int n2 = this.mFigureIDSelectionWizardDialog.getFigureID();
                File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFile();
                String string3 = file.getPath();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                String string4 = this.mXYDataTypeSelectionWizardDialog.getSelectedDataType();
                if (string4 == null) {
                    SGUtility.showMessageDialog(window, "Failed to get the data type.", "Error", 2);
                    return false;
                }
                arrayList.add(string4);
                if (string4.equals("SXY_SAMPLING")) {
                    object2 = this.mXYDataTypeSelectionWizardDialog.getSamplingRate();
                    if (object2 == null) {
                        SGUtility.showMessageDialog(window, "Failed to get the sampling rate.", "Error", 2);
                        return false;
                    }
                    arrayList.add(object2);
                }
                if (arrayList.size() == 0) {
                    return false;
                }
                try {
                    object2 = this.mDataCreator.create(string3, arrayList);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    SGUtility.showFileNotFoundMessageDialog(sGDrawingWindow);
                    return false;
                }
                if (object2 == null) {
                    SGUtility.showMessageDialog(window, "Failed to create a data object.", "Error", 2);
                    return false;
                }
                SGFigure sGFigure = sGDrawingWindow.getFigure(n2);
                if (sGFigure == null || sGFigure != null & !sGFigure.isVisible()) {
                    String string5 = this.getSimpleFileName(string3);
                    if (string5 == null) {
                        return false;
                    }
                    if (this.createNewFigure(sGDrawingWindow, n2, (SGData)object2, new Point(), string5) == null) {
                        SGUtility.showMessageDialog(window, "Failed to create a new figure.", "Error", 2);
                        return false;
                    }
                } else {
                    String string6 = this.getNewDataName(sGFigure, string3);
                    if (string6 == null) {
                        return false;
                    }
                    if (!sGFigure.addData((SGData)object2, string6)) {
                        SGUtility.showMessageDialog(window, "Data file is invalid.", "Error", 2);
                        return false;
                    }
                }
                sGWizardDialog.setVisible(false);
            }
            return true;
        }

        private boolean getDataInfoFromPropertyFile(Document document, ArrayList arrayList, ArrayList arrayList2) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Window");
            if (nodeList.getLength() == 0) {
                return false;
            }
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Figure");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (!(node instanceof Element)) continue;
                Element element3 = (Element)node;
                NodeList nodeList3 = element3.getElementsByTagName("Data");
                int n = nodeList3.getLength();
                if (n == 0) {
                    arrayList.add(null);
                    arrayList2.add(null);
                    continue;
                }
                for (int j = 0; j < n; ++j) {
                    Node node2 = nodeList3.item(j);
                    if (!(node2 instanceof Element)) continue;
                    Element element4 = (Element)node2;
                    String string = element4.getAttribute("Name");
                    arrayList.add(string);
                    String string2 = element4.getAttribute("Type");
                    arrayList2.add(string2);
                }
            }
            return true;
        }

        private boolean loadProperty(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            if (object instanceof SGPropertyFileChooserWizardDialog) {
                SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog = (SGPropertyFileChooserWizardDialog)sGWizardDialog;
                File file = sGPropertyFileChooserWizardDialog.getSelectedFile();
                if (file != null) {
                    this.updateCurrentFile(file, 1);
                    this.mMultiDataFileChooserWizardDialog.setFile(this.getCurrentFileDirectory(), this.mCurrentDataFileName);
                }
                if (!this.fromPropertyFileChooserDialog(actionEvent, sGWizardDialog)) {
                    return false;
                }
            } else if (object instanceof SGMultiDataFileChooserWizardDialog) {
                SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog;
                File file = sGMultiDataFileChooserWizardDialog.getSelectedFile();
                if (file != null) {
                    this.updateCurrentFile(file, 0);
                    if (object.equals(this.mMultiDataFileChooserWizardDialog)) {
                        this.mPropertyFileChooserWizardDilaog.setFile(this.getCurrentFileDirectory(), this.mCurrentPropertyFileName);
                    }
                }
                if (!this.fromMultiDataFileChooser(actionEvent)) {
                    return false;
                }
            }
            if (string.equals("Cancel")) {
                sGWizardDialog.setVisible(false);
            } else if (string.equals("<Prev")) {
                sGWizardDialog.showPrevious();
            }
            return true;
        }

        private void updateCurrentFile(File file, int n) {
            String string = file.getPath();
            String string2 = file.getParent();
            this.setCurrentFileDirectory(string2);
            String string3 = string.substring(string2.length() + 1);
            if (n == 0) {
                this.mCurrentDataFileName = string3;
            } else if (n == 1) {
                this.mCurrentPropertyFileName = string3;
            }
        }

        private boolean fromPropertyFileChooserDialog(ActionEvent actionEvent, SGWizardDialog sGWizardDialog) {
            String string = actionEvent.getActionCommand();
            Window window = sGWizardDialog.getOwner();
            SGWizardDialog sGWizardDialog2 = sGWizardDialog.getNext();
            if (!(sGWizardDialog instanceof SGPropertyFileChooserWizardDialog)) {
                return false;
            }
            if (!(sGWizardDialog2 instanceof SGMultiDataFileChooserWizardDialog)) {
                return false;
            }
            SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog = (SGPropertyFileChooserWizardDialog)sGWizardDialog;
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog2;
            return !string.equals("Next>") || this.fromPropertyFileChooserDialogNext(sGPropertyFileChooserWizardDialog, sGMultiDataFileChooserWizardDialog);
        }

        private boolean fromPropertyFileChooserDialogNext(SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog, SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog) {
            File file = sGPropertyFileChooserWizardDialog.getSelectedFileFromTextField();
            if (!file.exists()) {
                SGUtility.showFileNotFoundMessageDialog(sGPropertyFileChooserWizardDialog);
                return false;
            }
            sGPropertyFileChooserWizardDialog.setSelectedFile(file);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            if (!this.getInfoFromPropertyFile(file, sGPropertyFileChooserWizardDialog, arrayList, arrayList2, arrayList3)) {
                return false;
            }
            sGMultiDataFileChooserWizardDialog.init(arrayList.size());
            if (!this.setMultiDataFileChooser(arrayList, arrayList2, arrayList3, sGMultiDataFileChooserWizardDialog)) {
                return false;
            }
            sGPropertyFileChooserWizardDialog.showNext();
            return true;
        }

        private boolean getInfoFromPropertyFile(File file, Component component, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
            String string = SGUtility.getCanonicalPath(file.getPath());
            if (string == null) {
                SGUtility.showMessageDialog(component, "Cannot open the selected file.", TITLE_FILE_CHECK, 0);
                return false;
            }
            URL uRL = null;
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
            Document document = SGUtilityText.getDocument(uRL);
            if (document == null) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", TITLE_FILE_CHECK, 0);
                return false;
            }
            this.mPropertyFileDocument = document;
            NodeList nodeList = document.getElementsByTagName("Figure");
            if (nodeList.getLength() == 0) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", TITLE_FILE_CHECK, 0);
                return false;
            }
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                NodeList nodeList2 = element.getElementsByTagName("Data");
                int n2 = i + 1;
                int n3 = nodeList2.getLength();
                if (n3 == 0) {
                    arrayList.add(new Integer(n2));
                    continue;
                }
                for (int j = 0; j < n3; ++j) {
                    arrayList.add(new Integer(n2));
                }
            }
            if (!this.getDataInfoFromPropertyFile(document, arrayList2, arrayList3)) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", TITLE_FILE_CHECK, 0);
                return false;
            }
            if (arrayList3.size() != arrayList.size()) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", TITLE_FILE_CHECK, 0);
                return false;
            }
            return true;
        }

        private boolean setMultiDataFileChooser(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog) {
            int n = arrayList3.size();
            sGMultiDataFileChooserWizardDialog.setFileNumber(n);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((Integer)arrayList.get(i)).toString();
            }
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                Object object = arrayList2.get(i);
                if (object == null) {
                    object = "NO_DATA";
                    arrayList4.add(new Integer(i));
                }
                stringArray2[i] = (String)object;
            }
            String[] stringArray3 = new String[n];
            for (int i = 0; i < n; ++i) {
                Object object = arrayList3.get(i);
                if (arrayList4.contains(new Integer(i))) {
                    object = "NO_DATA";
                }
                stringArray3[i] = (String)object;
            }
            String[] stringArray4 = new String[n];
            for (int i = 0; i < n; ++i) {
                if (!arrayList4.contains(new Integer(i))) continue;
                stringArray4[i] = "NO_DATA";
            }
            sGMultiDataFileChooserWizardDialog.setFigureIDArray(stringArray);
            sGMultiDataFileChooserWizardDialog.setDataNameArray(stringArray2);
            sGMultiDataFileChooserWizardDialog.setDataTypeArray(stringArray3);
            sGMultiDataFileChooserWizardDialog.setFileNameArray(stringArray4);
            return true;
        }

        private boolean fromMultiDataFileChooser(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog;
            if (string.equals("OK")) {
                TreeMap treeMap = sGMultiDataFileChooserWizardDialog.getSelectedFilePathListMap();
                SGDrawingWindow sGDrawingWindow = this.createWindowFromPropertyFile(this.mPropertyFileDocument, treeMap);
                if (sGDrawingWindow == null) {
                    return false;
                }
                sGWizardDialog.setVisible(false);
            } else if (string.equals("Cancel")) {
                sGWizardDialog.setVisible(false);
            }
            return true;
        }

        private boolean fromWizardDialog(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            if (object.equals(this.mXYDataTypeSelectionWizardDialogFromCLorDD)) {
                return this.fromCLorDDWizardDialog(actionEvent);
            }
            if (object.equals(this.mFigureIDSelectionWizardDialog) || object.equals(this.mSingleDataFileChooserWizardDilaog) || object.equals(this.mXYDataTypeSelectionWizardDialog)) {
                return this.addDataByToolBar(actionEvent);
            }
            if (object.equals(this.mPropertyFileChooserWizardDilaog) || object.equals(this.mMultiDataFileChooserWizardDialog) || object.equals(this.mMultiDataFileChooserWizardDialogDD)) {
                return this.loadProperty(actionEvent);
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (object instanceof SGDrawingWindow) {
                this.fromWindow(actionEvent);
            } else if (object instanceof SGWizardDialog) {
                this.fromWizardDialog(actionEvent);
            }
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof SGDrawingWindow) {
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)windowEvent.getSource();
                this.removeWindow(sGDrawingWindow);
                System.gc();
                if (this.mWndMap.size() == 0) {
                    this.exit(0);
                }
            }
        }

        public void exit(int n) {
            System.exit(n);
        }

        public boolean removeWindow(SGDrawingWindow sGDrawingWindow) {
            if (sGDrawingWindow == null) {
                return false;
            }
            int n = sGDrawingWindow.getID();
            this.mWndMap.remove(new Integer(n));
            sGDrawingWindow.removeWindowListener(this);
            sGDrawingWindow.removeActionListener(this);
            return true;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(3);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
            Component component = dropTarget.getComponent();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)component;
            dropTargetDropEvent.acceptDrop(3);
            try {
                if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    DropEventHandler dropEventHandler = new DropEventHandler(this, dropTargetDropEvent, list);
                }
            }
            catch (Exception exception) {
            }
            finally {
                dropTargetDropEvent.dropComplete(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean fromDragAndDrop(int n, int n2, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
            sGDrawingWindow.setEnabled(false);
            try {
                int n3;
                ArrayList<File> arrayList2 = new ArrayList<File>();
                File file = null;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    File file2 = (File)arrayList.get(n3);
                    String string = file2.getAbsolutePath();
                    if (string.endsWith("sgp")) {
                        if (file == null) {
                            file = file2;
                            continue;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    arrayList2.add(file2);
                }
                if (file == null) {
                    if (!this.addDataByDragAndDrop(n, n2, sGDrawingWindow, arrayList2)) {
                        n3 = 0;
                        return n3 != 0;
                    }
                } else if (!this.fromDragAndDropPropertyFile(file, arrayList2, sGDrawingWindow)) {
                    n3 = 0;
                    return n3 != 0;
                }
            }
            finally {
                sGDrawingWindow.setEnabled(true);
            }
            return true;
        }

        private boolean fromDragAndDropPropertyFile(File file, ArrayList arrayList, Frame frame) {
            if (!file.exists()) {
                SGUtility.showMessageDialog(frame, "Cannot open the selected file.", TITLE_FILE_CHECK, 0);
                return false;
            }
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = this.mMultiDataFileChooserWizardDialogDD = new SGMultiDataFileChooserWizardDialog(frame, true);
            sGMultiDataFileChooserWizardDialog.getPreviousButton().setVisible(false);
            sGMultiDataFileChooserWizardDialog.getNextButton().setVisible(false);
            sGMultiDataFileChooserWizardDialog.pack();
            sGMultiDataFileChooserWizardDialog.addActionListener(this);
            this.mMultiDataFileChooserWizardDialogDD.setFile(this.getCurrentFileDirectory(), this.mCurrentDataFileName);
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList arrayList4 = new ArrayList();
            if (!this.getInfoFromPropertyFile(file, frame, arrayList2, arrayList3, arrayList4)) {
                return false;
            }
            sGMultiDataFileChooserWizardDialog.init(arrayList2.size());
            if (!this.setMultiDataFileChooser(arrayList2, arrayList3, arrayList4, sGMultiDataFileChooserWizardDialog)) {
                return false;
            }
            sGMultiDataFileChooserWizardDialog.setCenter(frame);
            sGMultiDataFileChooserWizardDialog.setVisible(true);
            return true;
        }

        private boolean addDataByDragAndDrop(int n, int n2, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
            this.mXYDataTypeSelectionWizardDialogFromCLorDD = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.addActionListener(this);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.mPreviousButton.setVisible(false);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.mNextButton.setVisible(false);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.pack();
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                int n3;
                File file = (File)arrayList.get(i);
                ArrayList arrayList2 = new ArrayList();
                try {
                    n3 = this.createDataFromFile(file.getPath(), arrayList2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    SGUtility.showFileNotFoundMessageDialog(sGDrawingWindow);
                    return false;
                }
                if (n3 == -1) {
                    SGUtility.showMessageDialog(sGDrawingWindow, "Data file is invalid.", "Error", 2);
                    return false;
                }
                if (n3 == 1) {
                    return true;
                }
                if (arrayList2.size() == 0) {
                    return false;
                }
                SGData sGData = (SGData)arrayList2.get(0);
                String string = file.getAbsolutePath();
                Component component = sGDrawingWindow.getComponent(n, n2);
                if (component instanceof SGDrawingWindow) {
                    String string2;
                    int n4 = sGDrawingWindow.getCurrentFigureId();
                    object = sGDrawingWindow.getFigure(n4);
                    if (object == null) {
                        string2 = this.getSimpleFileName(string);
                        if (string2 == null) {
                            return false;
                        }
                        Point point = new Point(n, n2);
                        object = this.createNewFigure(sGDrawingWindow, n4, sGData, point, string2);
                        if (object != null) continue;
                        return false;
                    }
                    string2 = this.getNewDataName((SGFigure)object, string);
                    if (string2 == null) {
                        return false;
                    }
                    if (((SGFigure)object).addData(sGData, string2)) continue;
                    return false;
                }
                if (component instanceof SGFigure) {
                    SGFigure sGFigure = (SGFigure)component;
                    object = this.getNewDataName(sGFigure, string);
                    if (object == null) {
                        return false;
                    }
                    if (sGFigure.addData(sGData, (String)object)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private SGFigure createNewFigure(SGDrawingWindow sGDrawingWindow, int n, SGData sGData, Point point, String string) {
            SGFigure sGFigure = this.createFigure(n, sGDrawingWindow, sGData);
            if (sGFigure == null) {
                return null;
            }
            TreeMap treeMap = sGDrawingWindow.getFigureMap();
            if (!treeMap.containsValue(sGFigure)) {
                sGDrawingWindow.addFigure(n, sGFigure, point);
            }
            if (!sGFigure.addData(sGData, string)) {
                return null;
            }
            SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
            for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                if (sGIFigureElementArray[i].initPropertiesHistory()) continue;
                return null;
            }
            sGDrawingWindow.drawBackFigure(sGFigure);
            sGFigure.initPropertiesHistory();
            sGFigure.setVisible(true);
            sGDrawingWindow.setChanged(true);
            sGDrawingWindow.notifyToRoot();
            sGDrawingWindow.setVisible(true);
            sGDrawingWindow.updateItemsByFigureNumbers();
            return sGFigure;
        }

        private SGSplashWindow createSplashWindow() {
            Class<?> clazz = this.getClass();
            String string = "/resources/About.png";
            URL uRL = clazz.getResource(string);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            SGSplashWindow sGSplashWindow = new SGSplashWindow(image);
            return sGSplashWindow;
        }

        private class WindowInfo {
            private Document mDocument;
            private Map mDataListMap = new TreeMap();

            private WindowInfo() {
            }
        }
    }

    private static class DropEventHandler
    extends Thread {
        private Main mMain;
        private DropTargetDropEvent mDropTargetDropEvent = null;
        private ArrayList mDroppedFileList = null;

        private DropEventHandler(Main main, DropTargetDropEvent dropTargetDropEvent, List list) {
            this.mMain = main;
            this.mDropTargetDropEvent = dropTargetDropEvent;
            this.mDroppedFileList = new ArrayList(list);
            this.start();
        }

        public void run() {
            DropTargetDropEvent dropTargetDropEvent = this.mDropTargetDropEvent;
            DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
            Component component = dropTarget.getComponent();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)component;
            Point point = dropTargetDropEvent.getLocation();
            this.mMain.fromDragAndDrop(point.x, point.y, sGDrawingWindow, this.mDroppedFileList);
            sGDrawingWindow.getContentPane().repaint();
            this.mDropTargetDropEvent = null;
            this.mDroppedFileList = null;
        }
    }

    private static class Connect
    extends Thread {
        private ServerSocket mServerSocket = null;
        private Main mMain;

        private Connect(Main main, ServerSocket serverSocket) {
            this.mMain = main;
            this.mServerSocket = serverSocket;
            this.start();
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        String string;
                        Socket socket = this.mServerSocket.accept();
                        PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        ArrayList<String> arrayList = new ArrayList<String>();
                        while ((string = bufferedReader.readLine()) != null) {
                            arrayList.add(new String(string));
                        }
                        if (arrayList.size() == 0) {
                            System.out.println("\u5165\u529b\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                            continue;
                        }
                        String[] stringArray = new String[arrayList.size()];
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = (String)arrayList.get(i);
                        }
                        if (!this.mMain.executeCommand(stringArray)) continue;
                        bufferedReader.close();
                        printWriter.close();
                        socket.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private static class Utility {
        private Utility() {
        }

        public static boolean compareVersionNumber(int n, int n2, int n3, int n4, int n5, int n6) {
            boolean bl = n < n4 ? true : (n == n4 ? (n2 < n5 ? true : (n2 == n5 ? n3 < n6 : false)) : false);
            return bl;
        }
    }

    private static class UpgradeManager
    implements ActionListener,
    SGIConstants,
    SGIUpgradeConstants,
    SGIApplicationConstants,
    SGIPreferencesConstants {
        private JFileChooser mUpgradeFileChooser;
        private SGUpgradeDialog mUpgradeDialog;
        private ProxyManager mProxyManager;

        private UpgradeManager(ProxyManager proxyManager) {
            this.mProxyManager = proxyManager;
            this.mUpgradeFileChooser = new SGFileChooser();
            this.mUpgradeFileChooser.setCurrentDirectory(new File(SGIConstants.USER_HOME));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SGUpgradeDialog sGUpgradeDialog;
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                int n;
                String string2 = this.mUpgradeDialog.getUpgradeCycle();
                if (string2.equals("No Upgrade")) {
                    n = 0;
                } else if (string2.equals("Every Time")) {
                    n = 1;
                } else if (string2.equals("Every Day")) {
                    n = 2;
                } else if (string2.equals("Every Week")) {
                    n = 3;
                } else if (string2.equals("Every Month")) {
                    n = 4;
                } else {
                    throw new Error();
                }
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                preferences.putInt("Upgrade Cycle", n);
            } else if (string.equals("Check for Update Now") && !this.upgradeByCommand(sGUpgradeDialog = (SGUpgradeDialog)object)) {
                return;
            }
        }

        private boolean showUpgradeDialog(Frame frame) {
            this.mUpgradeDialog = new SGUpgradeDialog(frame, true);
            this.mUpgradeDialog.addActionListener(this);
            this.mUpgradeDialog.setCenter(frame);
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt("Upgrade Cycle", 0);
            String string = null;
            switch (n) {
                case 0: {
                    string = "No Upgrade";
                    break;
                }
                case 1: {
                    string = "Every Time";
                    break;
                }
                case 2: {
                    string = "Every Day";
                    break;
                }
                case 3: {
                    string = "Every Week";
                    break;
                }
                case 4: {
                    string = "Every Month";
                    break;
                }
                default: {
                    string = "No Upgrade";
                }
            }
            this.mUpgradeDialog.setUpgradeCycle(string);
            this.mUpgradeDialog.setVisible(true);
            return true;
        }

        private boolean upgradeOnStartup(Window window) {
            return this.upgrade(window, true);
        }

        private boolean upgradeByCommand(Window window) {
            return this.upgrade(window, false);
        }

        private boolean upgrade(Window window, boolean bl) {
            Object object;
            boolean bl2 = this.mProxyManager.isDirectAccess();
            String string = this.mProxyManager.getProxyHostName();
            int n = this.mProxyManager.getProxyPortNumber();
            URL uRL = null;
            try {
                uRL = bl2 ? new URL("http://samurai-graph.sourceforge.jp/product.xml") : new URL("http", string, n, "http://samurai-graph.sourceforge.jp/product.xml");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(window, "URL is invalid.");
                return false;
            }
            Document document = SGUtilityText.getDocument(uRL);
            if (document == null) {
                JOptionPane.showMessageDialog(window, "Failed to get information of the latest version.");
                return false;
            }
            if (bl) {
                object = Preferences.userNodeForPackage(this.getClass());
                ((Preferences)object).putLong("Date", System.currentTimeMillis());
            }
            if (this.compareVersion((Element)(object = document.getDocumentElement()))) {
                if (!this.installLatestVersion((Element)object, window, bl)) {
                    return false;
                }
            } else if (!bl) {
                String string2 = "The latest version is already installed.";
                JOptionPane.showMessageDialog(window, string2);
            }
            return true;
        }

        private boolean compareVersion(Element element) {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt("Major Version", -1);
            int n2 = preferences.getInt("Minor Version", -1);
            int n3 = preferences.getInt("Micro Version", -1);
            int n4 = this.getVersion(element, "majorver");
            int n5 = this.getVersion(element, "minorver");
            int n6 = this.getVersion(element, "microver");
            boolean bl = Utility.compareVersionNumber(n, n2, n3, n4, n5, n6);
            return bl;
        }

        private int getVersion(Element element, String string) {
            Element element2 = (Element)element.getElementsByTagName(string).item(0);
            String string2 = element2.getFirstChild().getNodeValue();
            int n = Integer.parseInt(string2);
            return n;
        }

        private boolean installLatestVersion(Element element, Window window, boolean bl) {
            Object object;
            Element element2;
            Object object2;
            Object object3;
            int n;
            NodeList nodeList = element.getElementsByTagName("release");
            Element element3 = null;
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (n = 0; n < nodeList.getLength(); ++n) {
                int n2;
                int n3;
                int n4;
                Element element4 = (Element)nodeList.item(n);
                String string = element4.getAttribute("latest");
                if (Boolean.TRUE.toString().equals(string)) {
                    element3 = element4;
                }
                if (!Utility.compareVersionNumber(0, 5, 1, n4 = this.getVersion(element4, "majorver"), n3 = this.getVersion(element4, "minorver"), n2 = this.getVersion(element4, "microver"))) continue;
                arrayList.add(element4);
            }
            if (element3 == null) {
                JOptionPane.showMessageDialog(window, "Statement in the XML file is wrong.");
                return false;
            }
            n = this.getVersion(element3, "majorver");
            int n5 = this.getVersion(element3, "minorver");
            int n6 = this.getVersion(element3, "microver");
            String string = new Integer(n).toString();
            String string2 = new Integer(n5).toString();
            String string3 = new Integer(n6).toString();
            String string4 = "Samurai Graph Ver." + string + "." + string2 + "." + string3 + " is found.\n" + "Download now?\n";
            StringBuffer stringBuffer = new StringBuffer("<html><head></head><body>-- New Features --");
            String string5 = "<font size=\"3\">";
            stringBuffer.append(string5);
            for (int i = 0; i < arrayList.size(); ++i) {
                object3 = (Element)arrayList.get(i);
                object2 = new StringBuffer();
                NodeList nodeList2 = object3.getElementsByTagName("releaseinfo");
                element2 = (Element)nodeList2.item(0);
                object = element2.getElementsByTagName("changelog");
                Element element5 = (Element)object.item(0);
                this.printNode(element5, (StringBuffer)object2);
                stringBuffer.append((StringBuffer)object2);
            }
            SGScrollPaneDialog sGScrollPaneDialog = null;
            if (window instanceof Frame) {
                sGScrollPaneDialog = new SGUpgradeConfirmDialog((Frame)window, true);
            } else if (window instanceof Dialog) {
                sGScrollPaneDialog = new SGUpgradeConfirmDialog((Dialog)window, true);
            }
            sGScrollPaneDialog.setMessage(string4);
            ((SGUpgradeConfirmDialog)sGScrollPaneDialog).setPage(new String(stringBuffer));
            sGScrollPaneDialog.pack();
            sGScrollPaneDialog.setCenter(window);
            sGScrollPaneDialog.setVisible(true);
            if (sGScrollPaneDialog.isCanceled()) {
                return true;
            }
            object3 = null;
            object3 = SGUtility.identifyOS("windows") ? "win32" : (SGUtility.identifyOS("mac os x") ? "macosx" : "other");
            object2 = element3.getElementsByTagName("package");
            for (int i = 0; i < object2.getLength(); ++i) {
                element2 = (Element)object2.item(i);
                object = element2.getAttribute("category");
                if (((String)object).equals("win32")) {
                    if (!((String)object3).equals("win32")) continue;
                    if (this.forWin32(element2, string, string2, string3, window, bl)) break;
                    return false;
                }
                if (((String)object).equals("macosx")) {
                    if (!((String)object3).equals("macosx")) continue;
                    if (this.forMacOSX(element2, string, string2, string3, window, bl)) break;
                    return false;
                }
                if (((String)object).equals("bin")) {
                    if (!((String)object3).equals("other")) continue;
                    if (this.forOtherPlatform(element2, string, string2, string3, window, bl)) break;
                    return false;
                }
                if (!((String)object).equals("src")) continue;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean forWin32(Element element, String string, String string2, String string3, Window window, boolean bl) {
            Object object;
            Object object2;
            String string4;
            int n;
            if (!(bl || (n = JOptionPane.showOptionDialog(window, string4 = "This application will be terminated.\nPresent work will be lost.", (String)(object2 = "Warning"), -1, 2, null, object = new Object[]{"OK", "Cancel"}, object[0])) != 1 && n != -1)) {
                return true;
            }
            string4 = System.getProperty("java.class.path");
            object2 = new StringTokenizer(string4, SGIConstants.PATH_SEPARATOR);
            object = null;
            while (((StringTokenizer)object2).hasMoreTokens()) {
                String string5 = ((StringTokenizer)object2).nextToken();
                if (!string5.endsWith("samurai-graph.jar")) continue;
                object = new File(string5).getParent();
                break;
            }
            if (object == null) {
                JOptionPane.showMessageDialog(window, "Upgrade is failed for some reason.");
                return false;
            }
            File file = new File((String)object + SGIConstants.FILE_SEPARATOR + "lib" + SGIConstants.FILE_SEPARATOR + "upgrade-helper.jar");
            if (!file.exists()) {
                JOptionPane.showMessageDialog(window, "Upgrade is failed for some reason.");
                return false;
            }
            File file2 = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + "SamuraiGraphTemp");
            if (!file2.mkdir()) {
                JOptionPane.showMessageDialog(window, "Upgrade is failed for some reason.");
                return false;
            }
            File file3 = new File(file2.getAbsolutePath() + SGIConstants.FILE_SEPARATOR + "upgrade-helper.jar");
            try {
                SGApplicationUtility.copyBinaryFile(file, file3);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(window, "Upgrade is failed for some reason.");
                return false;
            }
            File file4 = null;
            try {
                file4 = File.createTempFile("tmp_", ".exe");
            }
            catch (IOException iOException) {
                boolean bl2 = false;
                return bl2;
            }
            finally {
                if (file4 != null) {
                    file4.delete();
                }
            }
            if (!this.download(element, window, file4)) {
                JOptionPane.showMessageDialog(window, "Upgrade is failed for some reason.");
                file4.delete();
                return false;
            }
            String string6 = new File((String)object).getParent();
            String string7 = file4.getAbsolutePath();
            String string8 = string + "." + string2 + "." + string3;
            Object object3 = object;
            String[] stringArray = new String[]{System.getProperty("java.home") + SGIConstants.FILE_SEPARATOR + "bin" + SGIConstants.FILE_SEPARATOR + "javaw.exe", "-jar", file3.getAbsolutePath(), object, string7, object3};
            if (!file3.exists()) {
                JOptionPane.showMessageDialog(window, "Upgrade is failed for some reason.");
                return false;
            }
            try {
                Runtime.getRuntime().exec(stringArray, null, new File(string6));
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(window, "Upgrade is failed for some reason.");
                return false;
            }
            return true;
        }

        private boolean forOtherPlatform(Element element, String string, String string2, String string3, Window window, boolean bl) {
            return this.downloadWithFileChooser(element, string, string2, string3, window, bl, "samurai-graph-bin", "zip", "Zip Archive");
        }

        private boolean forMacOSX(Element element, String string, String string2, String string3, Window window, boolean bl) {
            return this.downloadWithFileChooser(element, string, string2, string3, window, bl, "samurai-graph-mac", "dmg.gz", "Compressed Disk Image");
        }

        private boolean downloadWithFileChooser(Element element, String string, String string2, String string3, Window window, boolean bl, String string4, String string5, String string6) {
            File file;
            JFileChooser jFileChooser = this.mUpgradeFileChooser;
            SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
            sGExtensionFileFilter.setDescription(string5);
            sGExtensionFileFilter.addExtension(string6);
            jFileChooser.setFileFilter(sGExtensionFileFilter);
            String string7 = string4 + "-" + string + "." + string2 + "." + string3 + "." + string5;
            jFileChooser.setSelectedFile(new File(string7));
            int n = jFileChooser.showSaveDialog(window);
            File file2 = null;
            switch (n) {
                case 0: {
                    file2 = jFileChooser.getSelectedFile();
                    break;
                }
                case 1: {
                    return true;
                }
                case -1: {
                    throw new Error();
                }
            }
            String string8 = file2.getAbsolutePath();
            if (!string8.endsWith(string5) && !string8.endsWith(string5.toUpperCase())) {
                string8 = string8 + "." + string5;
            }
            return this.download(element, window, file = new File(string8));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean download(Element var1_1, Window var2_2, File var3_3) {
            block32: {
                block29: {
                    block27: {
                        block28: {
                            var4_4 = null;
                            var5_5 = null;
                            var6_6 = null;
                            var7_7 = false;
                            try {
                                try {
                                    var4_4 = new BufferedOutputStream(new FileOutputStream(var3_3));
                                    var8_8 = var1_1.getElementsByTagName("url");
                                    for (var9_10 = 0; var9_10 < var8_8.getLength(); ++var9_10) {
                                        var10_12 = (Element)var8_8.item(var9_10);
                                        var11_13 = var10_12.getFirstChild().getNodeValue();
                                        var12_14 = null;
                                        try {
                                            var12_14 = new URL(var11_13);
                                        }
                                        catch (MalformedURLException var13_16) {
                                            continue;
                                        }
                                        var13_15 = null;
                                        try {
                                            var13_15 = var12_14.openConnection();
                                            var5_5 = new BufferedInputStream(var13_15.getInputStream());
                                        }
                                        catch (IOException var14_17) {
                                            continue;
                                        }
                                        var14_18 = var3_3.getAbsolutePath();
                                        var15_19 = var13_15.getContentLength();
                                        var16_20 = true;
                                        if (var2_2 instanceof Dialog) {
                                            var6_6 = new SGProgressMonitorDialog((Dialog)var2_2, var16_20);
                                        } else if (var2_2 instanceof JFrame) {
                                            var6_6 = new SGProgressMonitorDialog((Frame)var2_2, var16_20);
                                        }
                                        var17_21 = var6_6.getProgressBar();
                                        var17_21.setMinimum(0);
                                        var17_21.setMaximum(var15_19);
                                        var17_21.setStringPainted(true);
                                        var6_6.setInputSize(var15_19);
                                        var6_6.setInputStream(var5_5);
                                        var6_6.setOutputStream(var4_4);
                                        var6_6.setLabel(var14_18);
                                        var6_6.pack();
                                        var6_6.setCenter(var2_2);
                                        var2_2.setCursor(Cursor.getPredefinedCursor(3));
                                        var18_22 = new Thread(var6_6);
                                        var18_22.start();
                                        var6_6.setVisible(true);
                                        if (var6_6.isCanceled()) {
                                            var19_23 = false;
                                            var21_24 = null;
                                            var2_2.setCursor(Cursor.getDefaultCursor());
                                            var6_6.setInputStream(null);
                                            var6_6.setOutputStream(null);
                                            if (var5_5 == null) break block27;
                                            break block28;
                                        }
                                        var7_7 = true;
                                        break block29;
                                    }
                                    break block29;
                                }
                                catch (FileNotFoundException var8_9) {
                                    JOptionPane.showMessageDialog(var2_2, "Local file is missing.");
                                    var9_11 = false;
                                    var21_26 = null;
                                    var2_2.setCursor(Cursor.getDefaultCursor());
                                    var6_6.setInputStream(null);
                                    var6_6.setOutputStream(null);
                                    if (var5_5 != null) {
                                        try {
                                            var5_5.close();
                                        }
                                        catch (IOException var22_30) {
                                            // empty catch block
                                        }
                                    }
                                    if (var4_4 == null) return var9_11;
                                    try {
                                        var4_4.close();
                                        return var9_11;
                                    }
                                    catch (IOException var22_30) {
                                        // empty catch block
                                    }
                                    return var9_11;
                                }
                            }
                            catch (Throwable var20_32) {
                                block31: {
                                    var21_27 = null;
                                    var2_2.setCursor(Cursor.getDefaultCursor());
                                    var6_6.setInputStream(null);
                                    var6_6.setOutputStream(null);
                                    if (var5_5 != null) {
                                        ** try [egrp 4[TRYBLOCK] [8 : 381->389)] { 
lbl89:
                                        // 1 sources

                                        var5_5.close();
                                        break block31;
lbl91:
                                        // 1 sources

                                        catch (IOException var22_31) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (var4_4 == null) throw var20_32;
                                ** try [egrp 5[TRYBLOCK] [9 : 396->404)] { 
lbl96:
                                // 1 sources

                                var4_4.close();
                                throw var20_32;
lbl98:
                                // 1 sources

                                catch (IOException var22_31) {
                                    // empty catch block
                                }
                                throw var20_32;
                            }
                        }
                        ** try [egrp 4[TRYBLOCK] [8 : 381->389)] { 
lbl103:
                        // 1 sources

                        var5_5.close();
                        break block27;
lbl105:
                        // 1 sources

                        catch (IOException var22_28) {
                            // empty catch block
                        }
                    }
                    if (var4_4 == null) return var19_23;
                    ** try [egrp 5[TRYBLOCK] [9 : 396->404)] { 
lbl110:
                    // 1 sources

                    var4_4.close();
                    return var19_23;
lbl112:
                    // 1 sources

                    catch (IOException var22_28) {
                        // empty catch block
                    }
                    return var19_23;
                }
                var21_25 = null;
                var2_2.setCursor(Cursor.getDefaultCursor());
                var6_6.setInputStream(null);
                var6_6.setOutputStream(null);
                if (var5_5 != null) {
                    ** try [egrp 4[TRYBLOCK] [8 : 381->389)] { 
lbl122:
                    // 1 sources

                    var5_5.close();
                    break block32;
lbl124:
                    // 1 sources

                    catch (IOException var22_29) {
                        // empty catch block
                    }
                }
            }
            if (var4_4 != null) {
                try {}
                catch (IOException var22_29) {}
                var4_4.close();
            }
            if (var7_7 != false) return true;
            JOptionPane.showMessageDialog(var2_2, "Connection failed.");
            return false;
        }

        private void printNode(Element element, StringBuffer stringBuffer) {
            this.printNodeRecursively(element, stringBuffer, -1);
        }

        private void printNodeRecursively(Element element, StringBuffer stringBuffer, int n) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node instanceof Element) {
                    Element element2 = (Element)node;
                    String string = element2.getTagName();
                    if (string.equals("item")) {
                        NodeList nodeList2 = element2.getChildNodes();
                        int n2 = nodeList2.getLength();
                        if (n2 == 1) {
                            stringBuffer.append("<li>");
                            this.printFirstChild(element2, stringBuffer, n);
                            stringBuffer.append("</li>");
                            continue;
                        }
                        if (n2 <= 1) continue;
                        stringBuffer.append("<li>");
                        this.printFirstChild(element2, stringBuffer, n);
                        stringBuffer.append("<ul>");
                        for (int j = 0; j < n2; ++j) {
                            Node node2 = nodeList2.item(j);
                            if (!(node2 instanceof Element)) continue;
                            Element element3 = (Element)node2;
                            this.printNodeRecursively(element3, stringBuffer, n + 1);
                        }
                        stringBuffer.append("</ul>");
                        stringBuffer.append("</li>");
                        continue;
                    }
                    if (!string.equals("itemize")) continue;
                    stringBuffer.append("<ul>");
                    this.printNodeRecursively(element2, stringBuffer, n + 1);
                    stringBuffer.append("</ul>");
                    continue;
                }
                if (!(node instanceof Text)) continue;
            }
        }

        private void printFirstChild(Node node, StringBuffer stringBuffer, int n) {
            Node node2 = node.getFirstChild();
            this.printText(node2, stringBuffer, n);
        }

        private void printText(Node node, StringBuffer stringBuffer, int n) {
            String string = node.toString();
            String string2 = this.tokenize(string);
            if (string2.length() != 0) {
                stringBuffer.append(string2);
            }
        }

        private String tokenize(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            String string2 = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                string2 = string2 + string3;
                if (i == arrayList.size() - 1) continue;
                string2 = string2 + " ";
            }
            return string2;
        }
    }

    private static class ProxyManager
    implements ActionListener,
    SGIPreferencesConstants {
        private boolean mDirectAccessFlag = true;
        private String mProxyHostName = null;
        private int mProxyPortNumber = -1;

        private ProxyManager() {
            this.setProxyOnStartUp();
        }

        private boolean setProxyOnStartUp() {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            boolean bl = preferences.getBoolean("Direct Access", true);
            String string = preferences.get("Proxy Host Name", "");
            int n = preferences.getInt("Proxy Port Number", -1);
            this.mDirectAccessFlag = bl;
            if (!string.equals("")) {
                this.mProxyHostName = string;
            }
            if (n != -1) {
                this.mProxyPortNumber = n;
            }
            return true;
        }

        public boolean isDirectAccess() {
            return this.mDirectAccessFlag;
        }

        public void setDirectAccess(boolean bl) {
            this.mDirectAccessFlag = bl;
        }

        public String getProxyHostName() {
            return this.mProxyHostName;
        }

        public int getProxyPortNumber() {
            return this.mProxyPortNumber;
        }

        public void setProxyHostName(String string) {
            this.mProxyHostName = string;
        }

        public void setProxyPortNumber(int n) {
            this.mProxyPortNumber = n;
        }

        private boolean showProxySettingDialog(Frame frame) {
            SGProxySettingDialog sGProxySettingDialog = new SGProxySettingDialog(frame, true);
            sGProxySettingDialog.addActionListener(this);
            sGProxySettingDialog.setCenter(frame);
            sGProxySettingDialog.setDirectAccess(this.mDirectAccessFlag);
            sGProxySettingDialog.setHostName(this.mProxyHostName);
            sGProxySettingDialog.setPortNumber(this.mProxyPortNumber);
            sGProxySettingDialog.setVisible(true);
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGProxySettingDialog sGProxySettingDialog = (SGProxySettingDialog)object;
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                this.mDirectAccessFlag = sGProxySettingDialog.isDirectAccess();
                this.mProxyHostName = sGProxySettingDialog.getHostName();
                this.mProxyPortNumber = sGProxySettingDialog.getPortNumber();
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                preferences.putBoolean("Direct Access", this.mDirectAccessFlag);
                preferences.put("Proxy Host Name", this.mProxyHostName);
                preferences.putInt("Proxy Port Number", this.mProxyPortNumber);
            }
        }
    }

    private static class LockFileManager
    extends Thread
    implements SGIConstants,
    SGIApplicationConstants {
        public static final String LOCK_FILE_NAME_EXTENSION = "lock";
        public static final int CYCLE = 1000;
        private Main mConnect = null;

        private LockFileManager(Main main) {
            this.mConnect = main;
            this.start();
        }

        public void run() {
            String string = "samurai-graph-0.5.1.lock";
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + string);
            Main main = this.mConnect;
            try {
                long l;
                if (file.exists() && (l = System.currentTimeMillis() - file.lastModified()) < 2000L) {
                    file.delete();
                    System.exit(0);
                }
                while (true) {
                    int n;
                    if (!file.exists() && (n = main.getWindowNumber()) != 0) {
                        SGDrawingWindow sGDrawingWindow = main.createNewWindow();
                        sGDrawingWindow.setVisible(true);
                    }
                    file.delete();
                    file.createNewFile();
                    file.deleteOnExit();
                    file.setReadOnly();
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

